/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.entity;

import games.stendhal.client.ClientSingletonRepository;
import games.stendhal.client.entity.InvisibleEntity;
import games.stendhal.client.sound.facade.AudibleCircleArea;
import games.stendhal.client.sound.facade.SoundFileType;
import games.stendhal.client.sound.facade.SoundGroup;
import games.stendhal.client.sound.facade.SoundHandle;
import games.stendhal.client.sound.facade.Time;
import games.stendhal.common.constants.SoundLayer;
import games.stendhal.common.math.Algebra;
import games.stendhal.common.math.Numeric;
import marauroa.common.game.RPObject;

public class LoopedSoundSource
extends InvisibleEntity {
    private String soundName = null;
    private SoundHandle sound = null;
    private SoundGroup group = null;
    private final Time fadingDuration = new Time();
    private int radius;
    private float volume;

    @Override
    public void onChangedAdded(RPObject rPObject, RPObject rPObject2) {
        ClientSingletonRepository.getSound().stop(this.sound, this.fadingDuration);
        super.onChangedAdded(rPObject, rPObject2);
        this.update(rPObject2);
        this.play();
    }

    private void update(RPObject rPObject) {
        boolean bl = false;
        if (rPObject.has("radius")) {
            this.radius = rPObject.getInt("radius");
        }
        if (rPObject.has("volume")) {
            this.volume = Numeric.intToFloat(rPObject.getInt("volume"), 100.0f);
        }
        if (rPObject.has("layer")) {
            SoundLayer soundLayer;
            int n = rPObject.getInt("layer");
            if (n < SoundLayer.values().length) {
                soundLayer = SoundLayer.values()[n];
                this.group = ClientSingletonRepository.getSound().getGroup(soundLayer.groupName);
            } else {
                soundLayer = null;
                this.group = null;
            }
            this.fadingDuration.set(100L, Time.Unit.MILLI);
            if (soundLayer == SoundLayer.BACKGROUND_MUSIC) {
                bl = true;
                this.fadingDuration.set(3L, Time.Unit.SEC);
                this.group.enableStreaming();
            }
        }
        if (rPObject.has("sound")) {
            this.soundName = rPObject.get("sound");
            this.group.loadSound(this.soundName, this.soundName + ".ogg", SoundFileType.OGG, bl);
        }
    }

    private void play() {
        AudibleCircleArea audibleCircleArea = new AudibleCircleArea(Algebra.vecf((float)this.x, (float)this.y), (float)this.radius / 2.0f, this.radius);
        this.sound = this.group.play(this.soundName, this.volume, 0, audibleCircleArea, this.fadingDuration, true, true);
    }

    @Override
    public void release() {
        super.release();
        ClientSingletonRepository.getSound().stop(this.sound, this.fadingDuration);
    }
}

