/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.events;

import games.stendhal.client.entity.RPEntity;
import games.stendhal.client.events.Event;
import games.stendhal.client.gui.progress.ProgressLogController;
import org.apache.log4j.Logger;

class ProgressStatusEvent
extends Event<RPEntity> {
    private static Logger logger = Logger.getLogger(ProgressStatusEvent.class);

    ProgressStatusEvent() {
    }

    @Override
    public void execute() {
        try {
            if (!this.event.has("progress_type")) {
                ProgressLogController.get().showCategories(this.event.getList("data"));
            } else if (!this.event.has("item")) {
                if (this.event.get("progress_type").equals("repeatable")) {
                    ProgressLogController.get().setRepeatable(this.event.getList("data"));
                } else {
                    ProgressLogController.get().showCategorySummary(this.event.get("progress_type"), this.event.getList("data"));
                }
            } else {
                ProgressLogController.get().showDescription(this.event.get("progress_type"), this.event.get("item"), this.event.get("description"), this.event.get("information"), this.event.getList("data"));
            }
        }
        catch (RuntimeException runtimeException) {
            logger.error((Object)("Failed to process progress status. Event: " + this.event), (Throwable)runtimeException);
        }
    }
}

