/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui;

import games.stendhal.client.gui.InternalWindow;
import games.stendhal.client.gui.ManagedWindow;
import games.stendhal.client.gui.styled.cursor.CursorRepository;
import games.stendhal.client.gui.styled.cursor.StendhalCursor;
import games.stendhal.client.gui.wt.core.WtWindowManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;

public class InternalManagedWindow
extends InternalWindow
implements ManagedWindow {
    private static final long serialVersionUID = -3389618500246332016L;
    private static CursorRepository cursorRepository = new CursorRepository();
    private final List<WindowDragListener> dragListeners = new ArrayList<WindowDragListener>(1);
    private Point dragStart;
    private boolean movable = true;

    public InternalManagedWindow(String string, String string2) {
        super(string2);
        this.setName(string);
        this.setFocusable(false);
        ClickListener clickListener = new ClickListener();
        DragListener dragListener = new DragListener();
        this.getTitlebar().addMouseListener(clickListener);
        this.getTitlebar().addMouseMotionListener(dragListener);
        this.addMouseListener(clickListener);
        this.addMouseMotionListener(dragListener);
        this.setCursor(cursorRepository.get(StendhalCursor.NORMAL));
    }

    @Override
    public boolean moveTo(int n, int n2) {
        this.setLocation(n, n2);
        return true;
    }

    @Override
    public void setMinimized(boolean bl) {
        super.setMinimized(bl);
        this.setSize(this.getPreferredSize());
        this.relocate(this.getLocation());
        WtWindowManager.getInstance().setMinimized(this, bl);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        WtWindowManager.getInstance().formatWindow(this);
    }

    void raise() {
        Container container = this.getParent();
        if (container instanceof JLayeredPane) {
            ((JLayeredPane)container).moveToFront(this);
        }
    }

    public void setMovable(boolean bl) {
        this.movable = bl;
    }

    protected void center() {
        Container container = this.getParent();
        Dimension dimension = this.getPreferredSize();
        this.setBounds((container.getWidth() - dimension.width) / 2, (container.getHeight() - dimension.height) / 2, dimension.width, dimension.height);
    }

    private void relocate(Point point) {
        Container container = this.getParent();
        point = new Point(point);
        Insets insets = container.getInsets();
        point.x = Math.min(point.x, container.getWidth() - this.getWidth() - insets.right);
        point.x = Math.max(point.x, insets.left);
        point.y = Math.min(point.y, container.getHeight() - this.getHeight() - insets.bottom);
        point.y = Math.max(point.y, insets.top);
        this.setLocation(point);
        WtWindowManager.getInstance().moveTo(this, this.getX(), this.getY());
    }

    private void startDrag(Point point) {
        if (this.movable) {
            this.dragStart = point;
            for (WindowDragListener windowDragListener : this.dragListeners) {
                windowDragListener.startDrag(this);
            }
        }
    }

    private void endDrag() {
        this.dragStart = null;
        for (WindowDragListener windowDragListener : this.dragListeners) {
            windowDragListener.endDrag(this);
        }
    }

    private void drag(Point point) {
        if (this.dragStart != null) {
            Container container = this.getParent();
            point = SwingUtilities.convertPoint(this, point, container);
            point.x -= this.dragStart.x;
            point.y -= this.dragStart.y;
            this.relocate(point);
            for (WindowDragListener windowDragListener : this.dragListeners) {
                windowDragListener.windowDragged(this, point);
            }
        }
    }

    public void addWindowDragListener(WindowDragListener windowDragListener) {
        this.dragListeners.add(windowDragListener);
    }

    public static interface WindowDragListener {
        public void startDrag(Component var1);

        public void endDrag(Component var1);

        public void windowDragged(Component var1, Point var2);
    }

    private class DragListener
    extends MouseMotionAdapter {
        private DragListener() {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            InternalManagedWindow.this.drag(mouseEvent.getPoint());
        }
    }

    private class ClickListener
    extends MouseAdapter {
        private ClickListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1) {
                InternalManagedWindow.this.startDrag(mouseEvent.getPoint());
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1 && InternalManagedWindow.this.dragStart != null) {
                InternalManagedWindow.this.endDrag();
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1) {
                InternalManagedWindow.this.raise();
            }
        }
    }
}

