/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui;

import games.stendhal.client.gui.KTextEdit;
import games.stendhal.client.gui.chatlog.EventLine;
import games.stendhal.client.gui.wt.core.WtWindowManager;
import games.stendhal.common.NotificationType;
import java.util.EnumSet;
import java.util.Set;
import org.apache.log4j.Logger;

class NotificationChannel {
    private static final Logger logger = Logger.getLogger(NotificationChannel.class);
    private final String name;
    private final KTextEdit channel;
    private final Set<NotificationType> eventTypes;

    NotificationChannel(String string, KTextEdit kTextEdit, boolean bl, String string2) {
        this.name = string;
        this.channel = kTextEdit;
        this.eventTypes = bl ? EnumSet.allOf(NotificationType.class) : EnumSet.noneOf(NotificationType.class);
        WtWindowManager wtWindowManager = WtWindowManager.getInstance();
        String string3 = wtWindowManager.getProperty("ui.channel." + this.name, string2);
        for (String string4 : string3.split(",")) {
            if ("".equals(string4)) continue;
            try {
                NotificationType notificationType = NotificationType.valueOf(string4);
                this.setTypeFiltering(notificationType, !bl);
            }
            catch (RuntimeException runtimeException) {
                logger.error((Object)("Unrecognized notification type '" + string4 + "'"), (Throwable)runtimeException);
            }
        }
    }

    String getName() {
        return this.name;
    }

    final void setTypeFiltering(NotificationType notificationType, boolean bl) {
        if (bl) {
            this.eventTypes.add(notificationType);
        } else {
            this.eventTypes.remove((Object)notificationType);
        }
    }

    boolean addEventLine(EventLine eventLine) {
        if (this.eventTypes.contains((Object)eventLine.getType())) {
            this.channel.addLine(eventLine);
            return true;
        }
        return false;
    }

    void clear() {
        this.channel.clear();
    }
}

