/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui;

import games.stendhal.client.OutfitStore;
import games.stendhal.client.StendhalClient;
import games.stendhal.client.gui.AbstractColorSelector;
import games.stendhal.client.gui.ColorSelector;
import games.stendhal.client.gui.OutfitColor;
import games.stendhal.client.gui.SkinColorSelector;
import games.stendhal.client.gui.WindowUtils;
import games.stendhal.client.gui.layout.SBoxLayout;
import games.stendhal.client.gui.layout.SLayout;
import games.stendhal.client.gui.styled.Style;
import games.stendhal.client.gui.styled.StyleUtil;
import games.stendhal.client.sprite.Sprite;
import games.stendhal.client.sprite.SpriteStore;
import games.stendhal.common.constants.Testing;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import marauroa.common.game.RPAction;
import org.apache.log4j.Logger;

class OutfitDialog
extends JDialog {
    private static final Logger LOGGER = Logger.getLogger(OutfitDialog.class);
    private static final int PLAYER_WIDTH = 48;
    private static final int PLAYER_HEIGHT = 64;
    private static final int SLIDER_WIDTH = 80;
    private final SelectorModel hair = new SelectorModel(44);
    private final SelectorModel eyes = new SelectorModel(10);
    private final SelectorModel mouth = new SelectorModel(4);
    private final SelectorModel head = new SelectorModel(21);
    private final SelectorModel body = new SelectorModel(15);
    private final SelectorModel dress = new SelectorModel(58);
    private final OutfitColor outfitColor;
    private int direction = 2;
    private final SpriteStore store = SpriteStore.get();
    private final OutfitStore ostore = OutfitStore.get();
    private final List<ResetListener> resetListeners = new ArrayList<ResetListener>();
    private OutfitLabel hairLabel;
    private OutfitLabel eyesLabel;
    private OutfitLabel mouthLabel;
    private OutfitLabel headLabel;
    private OutfitLabel bodyLabel;
    private OutfitLabel dressLabel;
    private OutfitLabel outfitLabel;
    private JSlider directionSlider;

    OutfitDialog(Frame frame, String string, int n, OutfitColor outfitColor) {
        super(frame, false);
        this.outfitColor = outfitColor;
        this.initComponents();
        this.applyStyle();
        this.setTitle(string);
        this.hair.addListener(this.hairLabel);
        this.hair.addListener(this.outfitLabel);
        this.head.addListener(this.headLabel);
        this.head.addListener(this.outfitLabel);
        this.body.addListener(this.bodyLabel);
        this.body.addListener(this.outfitLabel);
        this.dress.addListener(this.dressLabel);
        this.dress.addListener(this.outfitLabel);
        int n2 = n % 100;
        int n3 = (n /= 100) % 100;
        int n4 = (n /= 100) % 100;
        int n5 = (n /= 100) % 100;
        n5 = this.checkIndex(n5, this.hair);
        n4 = this.checkIndex(n4, this.head);
        n2 = this.checkIndex(n2, this.body);
        n3 = this.checkIndex(n3, this.dress);
        this.hair.setIndex(n5);
        this.head.setIndex(n4);
        this.body.setIndex(n2);
        this.dress.setIndex(n3);
        this.pack();
        WindowUtils.closeOnEscape(this);
        WindowUtils.trackLocation(this, "outfit", false);
    }

    OutfitDialog(Frame frame, String string, long l, OutfitColor outfitColor) {
        this(frame, string, (int)(l / 10000L), outfitColor);
        this.eyes.addListener(this.eyesLabel);
        this.eyes.addListener(this.outfitLabel);
        this.mouth.addListener(this.mouthLabel);
        this.mouth.addListener(this.outfitLabel);
        int n = (int)(l % 100L);
        int n2 = (int)((l /= 100L) % 100L);
        n = this.checkIndex(n, this.mouth);
        n2 = this.checkIndex(n2, this.eyes);
        this.eyes.setIndex(n2);
        this.mouth.setIndex(n);
        this.pack();
    }

    private int checkIndex(int n, SelectorModel selectorModel) {
        if (!selectorModel.isAllowed(n)) {
            return 0;
        }
        return n;
    }

    private void initComponents() {
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        int n = 5;
        JComponent jComponent = SBoxLayout.createContainer(true, n);
        JComponent jComponent2 = (JComponent)this.getContentPane();
        jComponent2.setBorder(BorderFactory.createCompoundBorder(jComponent2.getBorder(), BorderFactory.createEmptyBorder(n, n, n, n)));
        jComponent2.setLayout(new SBoxLayout(false, n));
        this.add(jComponent);
        JComponent jComponent3 = SBoxLayout.createContainer(false, n);
        jComponent.add(jComponent3);
        SpriteRetriever spriteRetriever = new SpriteRetriever(){

            @Override
            public Sprite getSprite() {
                return OutfitDialog.this.getHairSprite();
            }
        };
        this.hairLabel = new OutfitLabel(spriteRetriever);
        jComponent3.add(this.createSelector(this.hair, this.hairLabel));
        SpriteRetriever spriteRetriever2 = null;
        SpriteRetriever spriteRetriever3 = null;
        if (Testing.OUTFITS) {
            spriteRetriever2 = new SpriteRetriever(){

                @Override
                public Sprite getSprite() {
                    return OutfitDialog.this.getEyesSprite();
                }
            };
            this.eyesLabel = new OutfitLabel(spriteRetriever2);
            jComponent3.add(this.createSelector(this.eyes, this.eyesLabel));
            spriteRetriever3 = new SpriteRetriever(){

                @Override
                public Sprite getSprite() {
                    return OutfitDialog.this.getMouthSprite();
                }
            };
            this.mouthLabel = new OutfitLabel(spriteRetriever3);
            jComponent3.add(this.createSelector(this.mouth, this.mouthLabel));
        }
        SpriteRetriever spriteRetriever4 = new SpriteRetriever(){

            @Override
            public Sprite getSprite() {
                return OutfitDialog.this.getHeadSprite();
            }
        };
        this.headLabel = new OutfitLabel(spriteRetriever4);
        jComponent3.add(this.createSelector(this.head, this.headLabel));
        SpriteRetriever spriteRetriever5 = new SpriteRetriever(){

            @Override
            public Sprite getSprite() {
                return OutfitDialog.this.getBodySprite();
            }
        };
        this.bodyLabel = new OutfitLabel(spriteRetriever5);
        jComponent3.add(this.createSelector(this.body, this.bodyLabel));
        SpriteRetriever spriteRetriever6 = new SpriteRetriever(){

            @Override
            public Sprite getSprite() {
                return OutfitDialog.this.getDressSprite();
            }
        };
        this.dressLabel = new OutfitLabel(spriteRetriever6);
        jComponent3.add(this.createSelector(this.dress, this.dressLabel));
        JComponent jComponent4 = SBoxLayout.createContainer(false);
        jComponent.add((Component)jComponent4, (Object)SLayout.EXPAND_Y);
        JComponent jComponent5 = this.createColorSelector("Hair", "hair", this.hairLabel);
        jComponent5.setAlignmentX(0.5f);
        jComponent4.add(jComponent5);
        if (Testing.OUTFITS) {
            jComponent5 = this.createColorSelector("Eyes", "eyes", this.eyesLabel);
            jComponent5.setAlignmentX(0.5f);
            jComponent4.add(jComponent5);
            jComponent5 = this.createColorSelector("Skin", "skin", true, this.bodyLabel, this.headLabel);
            jComponent5.setAlignmentX(0.5f);
            jComponent4.add(jComponent5);
        }
        jComponent5 = this.createColorSelector("Dress", "dress", this.dressLabel);
        jComponent5.setAlignmentX(0.5f);
        jComponent4.add(jComponent5);
        SBoxLayout.addSpring(jComponent4);
        jComponent4 = SBoxLayout.createContainer(false, n);
        jComponent4.setAlignmentY(0.5f);
        jComponent.add(jComponent4);
        this.outfitLabel = Testing.OUTFITS ? new OutfitLabel(spriteRetriever5, spriteRetriever6, spriteRetriever4, spriteRetriever3, spriteRetriever2, spriteRetriever) : new OutfitLabel(spriteRetriever5, spriteRetriever6, spriteRetriever4, spriteRetriever);
        this.outfitLabel.setAlignmentX(0.5f);
        jComponent4.add(this.outfitLabel);
        this.directionSlider = new JSlider();
        this.directionSlider.setMaximum(3);
        this.directionSlider.setSnapToTicks(true);
        this.directionSlider.setValue(2);
        this.directionSlider.setInverted(true);
        Dimension dimension = this.directionSlider.getPreferredSize();
        dimension.width = 80;
        this.directionSlider.setPreferredSize(dimension);
        this.directionSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                OutfitDialog.this.sliderDirectionStateChanged();
            }
        });
        jComponent4.add(this.directionSlider);
        JComponent jComponent6 = SBoxLayout.createContainer(true, n);
        jComponent6.setAlignmentX(1.0f);
        JButton jButton = new JButton("Cancel");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OutfitDialog.this.dispatchEvent(new WindowEvent(OutfitDialog.this, 201));
            }
        });
        jButton.setMnemonic(67);
        jComponent6.add(jButton);
        JButton jButton2 = new JButton("Change Outfit");
        jButton2.setMnemonic(65);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OutfitDialog.this.okActionPerformed();
            }
        });
        jComponent6.add(jButton2);
        this.add(jComponent6);
    }

    private JComponent createSelector(final SelectorModel selectorModel, OutfitLabel outfitLabel) {
        JComponent jComponent = SBoxLayout.createContainer(true, 5);
        JButton jButton = new JButton("<");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                selectorModel.scrollDown();
            }
        });
        jComponent.add(jButton);
        jComponent.add(outfitLabel);
        jButton = new JButton(">");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                selectorModel.scrollUp();
            }
        });
        jComponent.add(jButton);
        return jComponent;
    }

    private void sliderDirectionStateChanged() {
        this.direction = this.directionSlider.getValue();
        this.outfitLabel.changed();
        this.hairLabel.changed();
        if (Testing.OUTFITS) {
            this.eyesLabel.changed();
        }
        this.headLabel.changed();
        this.bodyLabel.changed();
        this.dressLabel.changed();
    }

    private Sprite getHairSprite() {
        return this.store.getTile(this.ostore.getHairSprite(this.hair.getIndex(), this.outfitColor), 48, this.direction * 64, 48, 64);
    }

    private Sprite getEyesSprite() {
        return this.store.getTile(this.ostore.getEyesSprite(this.eyes.getIndex(), this.outfitColor), 48, this.direction * 64, 48, 64);
    }

    private Sprite getMouthSprite() {
        return this.store.getTile(this.ostore.getMouthSprite(this.mouth.getIndex()), 48, this.direction * 64, 48, 64);
    }

    private Sprite getHeadSprite() {
        return this.store.getTile(this.ostore.getHeadSprite(this.head.getIndex(), this.outfitColor), 48, this.direction * 64, 48, 64);
    }

    private Sprite getBodySprite() {
        return this.store.getTile(this.ostore.getBodySprite(this.body.getIndex(), this.outfitColor), 48, this.direction * 64, 48, 64);
    }

    private Sprite getDressSprite() {
        return this.store.getTile(this.ostore.getDressSprite(this.dress.getIndex(), this.outfitColor), 48, this.direction * 64, 48, 64);
    }

    private JComponent createColorSelector(String string, String string2, OutfitLabel ... outfitLabelArray) {
        return this.createColorSelector(string, string2, false, outfitLabelArray);
    }

    private JComponent createColorSelector(String string, final String string2, boolean bl, OutfitLabel ... outfitLabelArray) {
        JComponent jComponent = SBoxLayout.createContainer(false);
        final JCheckBox jCheckBox = new JCheckBox(string + " color");
        jComponent.add(jCheckBox);
        boolean bl2 = this.outfitColor.getColor(string2) != null;
        jCheckBox.setSelected(bl2);
        AbstractColorSelector abstractColorSelector = bl ? new SkinColorSelector() : new ColorSelector();
        abstractColorSelector.setEnabled(bl2);
        abstractColorSelector.setAlignmentX(0.5f);
        jComponent.add(abstractColorSelector);
        Object t = abstractColorSelector.getSelectionModel();
        t.setSelectedColor(this.outfitColor.getColor(string2));
        t.addChangeListener(new ChangeListener((ColorSelectionModel)t, outfitLabelArray){
            final /* synthetic */ ColorSelectionModel val$model;
            final /* synthetic */ OutfitLabel[] val$labels;
            {
                this.val$model = colorSelectionModel;
                this.val$labels = outfitLabelArray;
            }

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                OutfitDialog.this.outfitColor.setColor(string2, this.val$model.getSelectedColor());
                for (OutfitLabel outfitLabel : this.val$labels) {
                    outfitLabel.changed();
                }
                OutfitDialog.this.outfitLabel.changed();
            }
        });
        jCheckBox.addActionListener(new ActionListener((ColorSelectionModel)t, abstractColorSelector, outfitLabelArray){
            final /* synthetic */ ColorSelectionModel val$model;
            final /* synthetic */ AbstractColorSelector val$selector;
            final /* synthetic */ OutfitLabel[] val$labels;
            {
                this.val$model = colorSelectionModel;
                this.val$selector = abstractColorSelector;
                this.val$labels = outfitLabelArray;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (jCheckBox.isSelected()) {
                    OutfitDialog.this.outfitColor.setColor(string2, this.val$model.getSelectedColor());
                } else {
                    OutfitDialog.this.outfitColor.setColor(string2, null);
                }
                this.val$selector.setEnabled(jCheckBox.isSelected());
                for (OutfitLabel outfitLabel : this.val$labels) {
                    outfitLabel.changed();
                }
                OutfitDialog.this.outfitLabel.changed();
            }
        });
        this.resetListeners.add(new ResetListener((ColorSelectionModel)t, abstractColorSelector, jCheckBox){
            final /* synthetic */ ColorSelectionModel val$model;
            final /* synthetic */ AbstractColorSelector val$selector;
            final /* synthetic */ JCheckBox val$enableToggle;
            {
                this.val$model = colorSelectionModel;
                this.val$selector = abstractColorSelector;
                this.val$enableToggle = jCheckBox;
            }

            @Override
            public void reset() {
                boolean bl;
                Color color = OutfitDialog.this.outfitColor.getColor(string2);
                boolean bl2 = bl = color != null;
                if (bl) {
                    this.val$model.setSelectedColor(color);
                }
                this.val$selector.setEnabled(bl);
                this.val$enableToggle.setSelected(bl);
            }
        });
        return jComponent;
    }

    private void okActionPerformed() {
        this.sendAction();
        this.dispose();
    }

    private void sendAction() {
        StendhalClient stendhalClient = StendhalClient.get();
        RPAction rPAction = new RPAction();
        if (Testing.OUTFITS) {
            rPAction.put("type", "outfit_extended");
            long l = this.body.getIndex() + this.dress.getIndex() * 100 + this.head.getIndex() * (int)Math.pow(100.0, 2.0) + this.hair.getIndex() * (int)Math.pow(100.0, 3.0) + this.mouth.getIndex() * (int)Math.pow(100.0, 5.0) + this.eyes.getIndex() * (int)Math.pow(100.0, 6.0);
            rPAction.put("value", l);
        } else {
            rPAction.put("type", "outfit");
            rPAction.put("value", this.body.getIndex() + this.dress.getIndex() * 100 + this.head.getIndex() * 100 * 100 + this.hair.getIndex() * 100 * 100 * 100);
        }
        Color color = this.outfitColor.getColor("hair");
        if (color != null) {
            rPAction.put("hair", color.getRGB());
        }
        if ((color = this.outfitColor.getColor("skin")) != null) {
            rPAction.put("skin", color.getRGB());
        }
        if ((color = this.outfitColor.getColor("dress")) != null) {
            rPAction.put("dress", color.getRGB());
        }
        if (Testing.OUTFITS && (color = this.outfitColor.getColor("eyes")) != null) {
            rPAction.put("eyes", color.getRGB());
        }
        stendhalClient.send(rPAction);
    }

    private void applyStyle() {
        Style style = StyleUtil.getStyle();
        if (style != null) {
            this.bodyLabel.setBorder(style.getBorderDown());
            this.dressLabel.setBorder(style.getBorderDown());
            this.outfitLabel.setBorder(style.getBorderDown());
            this.hairLabel.setBorder(style.getBorderDown());
            if (Testing.OUTFITS) {
                this.eyesLabel.setBorder(style.getBorderDown());
                this.mouthLabel.setBorder(style.getBorderDown());
            }
            this.headLabel.setBorder(style.getBorderDown());
        }
    }

    void setState(int n, OutfitColor outfitColor) {
        this.outfitColor.setColor("dress", outfitColor.getColor("dress"));
        this.outfitColor.setColor("hair", outfitColor.getColor("hair"));
        if (Testing.OUTFITS) {
            this.outfitColor.setColor("skin", outfitColor.getColor("skin"));
        }
        int n2 = n % 100;
        int n3 = (n /= 100) % 100;
        int n4 = (n /= 100) % 100;
        int n5 = (n /= 100) % 100;
        this.body.setIndex(n2);
        this.dress.setIndex(n3);
        this.head.setIndex(n4);
        this.hair.setIndex(n5);
        for (ResetListener resetListener : this.resetListeners) {
            resetListener.reset();
        }
    }

    void setState(long l, OutfitColor outfitColor) {
        int n = (int)(l % 100L);
        int n2 = (int)((l /= 100L) % 100L);
        this.mouth.setIndex(n);
        this.eyes.setIndex(n2);
        this.setState((int)(l /= 100L), outfitColor);
    }

    private static interface IndexChangeListener {
        public void changed();
    }

    private static interface SpriteRetriever {
        public Sprite getSprite();
    }

    private static class SelectorModel {
        final int n;
        int index;
        final List<IndexChangeListener> listeners = new ArrayList<IndexChangeListener>();

        SelectorModel(int n) {
            if (n <= 0) {
                throw new IllegalArgumentException("Can not create a model with " + n + " elements");
            }
            this.n = n;
        }

        void addListener(IndexChangeListener indexChangeListener) {
            this.listeners.add(indexChangeListener);
        }

        void setIndex(int n) {
            if (!this.isAllowed(n)) {
                LOGGER.warn((Object)("Index out of allowed range [0-" + this.n + "]: " + n), new Throwable());
                n = 0;
            }
            this.index = n;
            this.fire();
        }

        void scrollDown() {
            this.index += this.n - 1;
            this.index %= this.n;
            this.fire();
        }

        void scrollUp() {
            ++this.index;
            this.index %= this.n;
            this.fire();
        }

        int getIndex() {
            return this.index;
        }

        boolean isAllowed(int n) {
            return n >= 0 && n < this.n;
        }

        private void fire() {
            for (IndexChangeListener indexChangeListener : this.listeners) {
                indexChangeListener.changed();
            }
        }
    }

    private static class OutfitLabel
    extends JLabel
    implements IndexChangeListener {
        final SpriteRetriever[] retrievers;

        OutfitLabel(SpriteRetriever ... spriteRetrieverArray) {
            this.setOpaque(true);
            this.retrievers = spriteRetrieverArray;
        }

        @Override
        public void changed() {
            BufferedImage bufferedImage = this.getGraphicsConfiguration().createCompatibleImage(48, 64);
            Graphics graphics = bufferedImage.getGraphics();
            graphics.setColor(Color.WHITE);
            graphics.fillRect(0, 0, 48, 64);
            for (SpriteRetriever spriteRetriever : this.retrievers) {
                spriteRetriever.getSprite().draw(graphics, 0, 0);
            }
            graphics.dispose();
            ImageIcon imageIcon = new ImageIcon(bufferedImage);
            this.setIcon(imageIcon);
        }
    }

    private static interface ResetListener {
        public void reset();
    }
}

