/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.Timer;
import org.apache.log4j.Logger;

class ScrollerPanel
extends JComponent {
    private static final long serialVersionUID = -9047582023793318785L;
    private static final Logger logger = Logger.getLogger(ScrollerPanel.class);
    private final List<String> text;
    private final Font font;
    private int textPos;
    private final Timer t;
    private final int lineSpacing;
    private final Color textColor;
    private final Color backgroundColor;
    private Dimension prefferedSize;
    private int lineHeight;
    private boolean scrollingStarted;
    private GradientPaint gp;

    ScrollerPanel(List<String> list, Font font, int n, Color color, Color color2, int n2) {
        this.text = list;
        this.font = font;
        this.lineSpacing = n;
        this.textColor = color;
        this.backgroundColor = color2;
        this.t = new Timer((int)(1.0 / (double)n2 * 1000.0), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScrollerPanel.this.moveText();
            }
        });
        logger.debug((Object)"Created a new scrolling panel");
        this.calculateSizes();
        this.eventHandling();
    }

    private void eventHandling() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                ScrollerPanel.this.gp = null;
                if (!ScrollerPanel.this.t.isRunning()) {
                    ScrollerPanel.this.resetTextPos();
                    ScrollerPanel.this.scrollingStarted = true;
                    ScrollerPanel.this.t.start();
                    logger.debug((Object)"start scrolling");
                }
            }
        });
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (this.scrollingStarted) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setBackground(this.backgroundColor);
            graphics2D.clearRect(0, 0, this.getWidth(), this.getHeight());
            if (this.gp == null) {
                this.gp = new GradientPaint(0.0f, 0.0f, this.backgroundColor, 0.0f, (float)this.getHeight() / 2.0f, this.textColor, true);
            }
            graphics2D.setPaint(this.gp);
            graphics2D.setFont(this.font);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            int n = 0;
            for (String string : this.text) {
                int n2 = fontMetrics.stringWidth(string);
                int n3 = fontMetrics.getHeight();
                int n4 = this.textPos + (n3 + this.lineSpacing) * n;
                if (n4 - n3 > this.getHeight()) break;
                if (n4 >= 0) {
                    graphics2D.drawString(string, this.getWidth() / 2 - n2 / 2, n4);
                }
                ++n;
            }
        }
    }

    private void moveText() {
        if (this.textPos >= -((this.lineHeight + this.lineSpacing) * this.text.size())) {
            --this.textPos;
        } else {
            this.resetTextPos();
        }
        this.repaint(0, 0, this.getWidth(), this.getHeight());
    }

    private void resetTextPos() {
        this.textPos = this.getHeight() - (this.lineSpacing + this.lineHeight) * 2;
    }

    void stop() {
        this.t.stop();
        logger.debug((Object)"stop scrolling");
    }

    private void calculateSizes() {
        this.prefferedSize = new Dimension();
        BufferedImage bufferedImage = new BufferedImage(100, 100, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setFont(this.font);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        this.lineHeight = fontMetrics.getHeight();
        this.prefferedSize.height = this.lineHeight * 8;
        for (String string : this.text) {
            this.prefferedSize.width = Math.max(this.prefferedSize.width, fontMetrics.stringWidth(string));
        }
        this.prefferedSize.width += 6 * fontMetrics.stringWidth(" ");
    }

    @Override
    public Dimension getPreferredSize() {
        return this.prefferedSize;
    }
}

