/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui;

import games.stendhal.client.ClientSingletonRepository;
import games.stendhal.client.GameLoop;
import games.stendhal.client.GameObjects;
import games.stendhal.client.GameScreen;
import games.stendhal.client.PerceptionListenerImpl;
import games.stendhal.client.StendhalClient;
import games.stendhal.client.UserContext;
import games.stendhal.client.WeatherSoundManager;
import games.stendhal.client.World;
import games.stendhal.client.Zone;
import games.stendhal.client.actions.SlashActionRepository;
import games.stendhal.client.entity.User;
import games.stendhal.client.entity.factory.EntityMap;
import games.stendhal.client.gui.Character;
import games.stendhal.client.gui.ContainerPanel;
import games.stendhal.client.gui.DragLayer;
import games.stendhal.client.gui.GameKeyHandler;
import games.stendhal.client.gui.Initializer;
import games.stendhal.client.gui.InternalManagedWindow;
import games.stendhal.client.gui.KTextEdit;
import games.stendhal.client.gui.KeyRing;
import games.stendhal.client.gui.MainFrame;
import games.stendhal.client.gui.ManagedWindow;
import games.stendhal.client.gui.NotificationChannel;
import games.stendhal.client.gui.NotificationChannelManager;
import games.stendhal.client.gui.OutfitColor;
import games.stendhal.client.gui.OutfitDialog;
import games.stendhal.client.gui.QuitDialog;
import games.stendhal.client.gui.ScreenController;
import games.stendhal.client.gui.ScrolledViewport;
import games.stendhal.client.gui.SettingsPanel;
import games.stendhal.client.gui.SlotWindow;
import games.stendhal.client.gui.TransparencyMode;
import games.stendhal.client.gui.UserInterface;
import games.stendhal.client.gui.WindowUtils;
import games.stendhal.client.gui.buddies.BuddyPanelController;
import games.stendhal.client.gui.chatlog.EventLine;
import games.stendhal.client.gui.chatlog.HeaderLessEventLine;
import games.stendhal.client.gui.chattext.CharacterMap;
import games.stendhal.client.gui.chattext.ChatCompletionHelper;
import games.stendhal.client.gui.chattext.ChatTextController;
import games.stendhal.client.gui.group.GroupPanelController;
import games.stendhal.client.gui.layout.FreePlacementLayout;
import games.stendhal.client.gui.layout.SBoxLayout;
import games.stendhal.client.gui.layout.SLayout;
import games.stendhal.client.gui.map.MapPanelController;
import games.stendhal.client.gui.spells.Spells;
import games.stendhal.client.gui.stats.StatsPanelController;
import games.stendhal.client.gui.styled.Style;
import games.stendhal.client.gui.styled.StyleUtil;
import games.stendhal.client.gui.styled.StyledTabbedPaneUI;
import games.stendhal.client.gui.wt.core.SettingChangeAdapter;
import games.stendhal.client.gui.wt.core.WtWindowManager;
import games.stendhal.client.listener.PositionChangeMulticaster;
import games.stendhal.client.sound.facade.SoundFileType;
import games.stendhal.client.sound.facade.SoundGroup;
import games.stendhal.client.sound.facade.SoundSystemFacade;
import games.stendhal.client.sound.nosound.NoSoundFacade;
import games.stendhal.client.sound.sound.SoundSystemFacadeImpl;
import games.stendhal.client.sprite.DataLoader;
import games.stendhal.client.stendhal;
import games.stendhal.common.Debug;
import games.stendhal.common.MathHelper;
import games.stendhal.common.NotificationType;
import games.stendhal.common.constants.SoundLayer;
import games.stendhal.common.constants.Testing;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.TabbedPaneUI;
import marauroa.client.net.IPerceptionListener;
import marauroa.common.game.RPObject;
import org.apache.log4j.Logger;

public class j2DClient
implements UserInterface {
    private static final int SCROLLING_SPEED = 8;
    private static final String PRIVATE_TAB_COLOR = "0xdcdcff";
    private static final String SCALE_PREFERENCE_PROPERTY = "ui.scale_screen";
    private static j2DClient sharedUI;
    private static final Logger logger;
    private JFrame frame;
    private final Dimension frameDefaultSize;
    private QuitDialog quitDialog;
    private GameScreen screen;
    private final ScreenController screenController;
    private JLayeredPane pane;
    private NotificationChannelManager channelManager;
    private ContainerPanel containerPanel;
    private boolean gameRunning;
    private final ChatTextController chatText = new ChatTextController();
    private Character character;
    private KeyRing keyring;
    private MapPanelController minimap;
    private SlotWindow inventory;
    private Spells spells;
    private User lastuser;
    private boolean offline;
    private OutfitDialog outfitDialog;
    private final PositionChangeMulticaster positionChangeListener = new PositionChangeMulticaster();
    private UserContext userContext;
    private GameKeyHandler gameKeyHandler;
    private final IPerceptionListener perceptionListener = new PerceptionListenerImpl(){
        int times;

        @Override
        public void onSynced() {
            j2DClient.this.setOffline(false);
            this.times = 0;
            logger.debug((Object)"Synced with server state.");
            j2DClient.this.addEventLine(new HeaderLessEventLine("Synchronized", NotificationType.CLIENT));
        }

        @Override
        public void onUnsynced() {
            ++this.times;
            if (this.times > 3) {
                logger.debug((Object)"Request resync");
                j2DClient.this.addEventLine(new HeaderLessEventLine("Unsynced: Resynchronizing...", NotificationType.CLIENT));
            }
        }
    };
    private StendhalClient client;
    private SoundSystemFacade soundSystemFacade;
    private int paintCounter;

    public static j2DClient get() {
        return sharedUI;
    }

    private static void setDefault(j2DClient j2DClient2) {
        sharedUI = j2DClient2;
        ClientSingletonRepository.setUserInterface(j2DClient2);
    }

    public j2DClient() {
        j2DClient.setDefault(this);
        this.screenController = null;
        this.frameDefaultSize = null;
    }

    public j2DClient(final StendhalClient stendhalClient, UserContext userContext, JFrame jFrame) {
        this.client = stendhalClient;
        this.userContext = userContext;
        j2DClient.setDefault(this);
        final Dimension dimension = stendhal.getDisplaySize();
        this.pane = new JLayeredPane();
        this.pane.setLayout(new FreePlacementLayout());
        this.screen = new GameScreen(stendhalClient);
        this.screenController = new ScreenController(this.screen);
        GameScreen.setDefaultScreen(this.screen);
        this.pane.add(this.screen, Float.valueOf(0.0f), JLayeredPane.DEFAULT_LAYER);
        stendhalClient.addZoneChangeListener(this.screen);
        stendhalClient.addZoneChangeListener(new WeatherSoundManager());
        stendhalClient.addZoneChangeListener(new StendhalClient.ZoneChangeListener(){

            @Override
            public void onZoneUpdate(Zone zone) {
            }

            @Override
            public void onZoneChangeCompleted(Zone zone) {
                j2DClient.this.containerPanel.setAnimated(true);
            }

            @Override
            public void onZoneChange(Zone zone) {
                j2DClient.this.containerPanel.setAnimated(false);
            }
        });
        this.positionChangeListener.add(this.screenController);
        SlashActionRepository.register();
        ChatCompletionHelper chatCompletionHelper = new ChatCompletionHelper(this.chatText, World.get().getPlayerList().getNamesList(), SlashActionRepository.getCommandNames());
        this.chatText.addKeyListener(chatCompletionHelper);
        this.screen.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                j2DClient.this.chatText.getPlayerChatText().requestFocus();
            }
        });
        this.chatText.getPlayerChatText().addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (Testing.MOVEMENT) {
                    stendhalClient.clearPressedKeys();
                }
            }
        });
        this.quitDialog = new QuitDialog();
        this.pane.add(this.quitDialog.getQuitDialog(), JLayeredPane.MODAL_LAYER);
        JTabbedPane jTabbedPane = this.createLogArea();
        jTabbedPane.setPreferredSize(new Dimension(this.screen.getWidth(), 171));
        this.gameKeyHandler = new GameKeyHandler(stendhalClient, this.screen);
        this.chatText.addKeyListener(this.gameKeyHandler);
        this.screen.addKeyListener(this.gameKeyHandler);
        if (Debug.PRE_RELEASE_VERSION != null) {
            this.addEventLine(new HeaderLessEventLine("This is a pre release test client: 1.26 - " + Debug.PRE_RELEASE_VERSION, NotificationType.CLIENT));
        }
        WtWindowManager wtWindowManager = WtWindowManager.getInstance();
        wtWindowManager.setDefaultProperties("corpse", false, 0, 190);
        wtWindowManager.setDefaultProperties("chest", false, 100, 190);
        this.frame = MainFrame.prepare(jFrame);
        DragLayer dragLayer = DragLayer.get();
        this.frame.setGlassPane(dragLayer);
        dragLayer.setVisible(true);
        InputMap inputMap = jTabbedPane.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke("control PAGE_UP"), "navigatePrevious");
        inputMap.put(KeyStroke.getKeyStroke("control PAGE_DOWN"), "navigateNext");
        JComponent jComponent = this.createLeftPanel();
        stendhalClient.addZoneChangeListener(this.minimap);
        this.chatText.getPlayerChatText().setMaximumSize(new Dimension(dimension.width, Integer.MAX_VALUE));
        JComponent jComponent2 = SBoxLayout.createContainer(true);
        jComponent2.add((Component)this.chatText.getPlayerChatText(), (Object)SLayout.EXPAND_X);
        if (Testing.CHAT) {
            jComponent2.add(new CharacterMap(this.chatText.getPlayerChatText()));
        }
        JPanel jPanel = new JPanel();
        jPanel.setBorder(null);
        jPanel.setLayout(new SBoxLayout(false));
        jPanel.add((Component)jComponent2, (Object)SLayout.EXPAND_X);
        jPanel.add((Component)jTabbedPane, SBoxLayout.constraint(SLayout.EXPAND_X, SLayout.EXPAND_Y));
        final JSplitPane jSplitPane = new JSplitPane(0, this.pane, jPanel);
        jSplitPane.setBorder(null);
        this.pane.addComponentListener(new SplitPaneResizeListener(this.screen));
        this.containerPanel = this.createContainerPanel();
        JComponent jComponent3 = SBoxLayout.createContainer(true);
        this.frame.setContentPane(jComponent3);
        jComponent.setMinimumSize(new Dimension());
        this.containerPanel.setMinimumSize(this.containerPanel.getPreferredSize());
        final JSplitPane jSplitPane2 = new JSplitPane(1, jComponent, jSplitPane);
        jSplitPane2.addComponentListener(new ComponentAdapter(){
            private int oldWidth = Integer.MAX_VALUE;

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (j2DClient.this.screen.isScaled()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            double d = (double)j2DClient.this.screen.getWidth() / (double)dimension.width;
                            int n = (int)(d * (double)dimension.height);
                            jSplitPane.setDividerLocation(n);
                        }
                    });
                } else {
                    int n = jSplitPane2.getDividerLocation();
                    int n2 = jSplitPane2.getWidth();
                    int n3 = this.oldWidth - n;
                    int n4 = n2 - this.oldWidth;
                    int n5 = n4 + n;
                    if (n5 < 0) {
                        n3 = this.oldWidth - jSplitPane2.getLastDividerLocation();
                    }
                    n = MathHelper.clamp(n2 - n3, jSplitPane2.getMinimumDividerLocation(), jSplitPane2.getMaximumDividerLocation());
                    jSplitPane2.setDividerLocation(n);
                    this.oldWidth = jSplitPane2.getWidth();
                }
            }
        });
        final int n = jSplitPane.getDividerSize();
        this.pane.setPreferredSize(new Dimension(dimension.width + n, dimension.height));
        jSplitPane2.setBorder(null);
        jComponent3.add((Component)jSplitPane2, SBoxLayout.constraint(SLayout.EXPAND_Y, SLayout.EXPAND_X));
        JComponent jComponent4 = SBoxLayout.createContainer(false);
        SettingsPanel settingsPanel = new SettingsPanel();
        jComponent4.add((Component)settingsPanel, (Object)SLayout.EXPAND_X);
        jComponent4.add((Component)this.containerPanel, SBoxLayout.constraint(SLayout.EXPAND_Y, SLayout.EXPAND_X));
        jComponent3.add((Component)jComponent4, (Object)SLayout.EXPAND_Y);
        wtWindowManager.registerSettingChangeListener(SCALE_PREFERENCE_PROPERTY, new SettingChangeAdapter(SCALE_PREFERENCE_PROPERTY, "true"){

            @Override
            public void changed(String string) {
                boolean bl = Boolean.parseBoolean(string);
                j2DClient.this.screen.setUseScaling(bl);
                if (bl) {
                    jSplitPane.setMaximumSize(null);
                    j2DClient.this.pane.setMaximumSize(null);
                } else {
                    jSplitPane.setMaximumSize(new Dimension(dimension.width + n, Integer.MAX_VALUE));
                    j2DClient.this.pane.setMaximumSize(dimension);
                    int n2 = jSplitPane2.getWidth() - jSplitPane2.getDividerLocation() - dimension.width - n;
                    if (n2 > 0) {
                        jSplitPane2.setDividerLocation(jSplitPane2.getDividerLocation() + n2);
                    }
                    if (jSplitPane.getDividerLocation() > dimension.height) {
                        jSplitPane.setDividerLocation(dimension.height);
                    }
                }
            }
        });
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                j2DClient.this.chatText.getPlayerChatText().requestFocus();
            }

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                j2DClient.this.chatText.getPlayerChatText().requestFocus();
            }

            @Override
            public void windowGainedFocus(WindowEvent windowEvent) {
                j2DClient.this.chatText.getPlayerChatText().requestFocus();
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                j2DClient.this.requestQuit();
            }
        });
        this.frame.pack();
        jSplitPane2.setDividerLocation(jComponent.getPreferredSize().width);
        this.setInitialWindowStates();
        this.frame.setVisible(true);
        Rectangle rectangle = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        Dimension dimension2 = this.frame.getSize();
        this.frame.setSize(Math.min(dimension2.width, rectangle.width), Math.min(dimension2.height, rectangle.height));
        this.frameDefaultSize = this.frame.getSize();
        jSplitPane.setDividerLocation(Math.min(dimension.height, rectangle.height - 80));
        this.checkAndComplainAboutJavaImplementation();
        this.positionChangeListener.add(this.getSoundSystemFacade());
        WindowUtils.watchFontSize(this.frame);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Point point = j2DClient.this.frame.getLocation();
                j2DClient.this.frame.setLocation(point.x + 1, point.y);
                j2DClient.this.frame.setLocation(point.x, point.y);
                j2DClient.this.frame.setEnabled(true);
                j2DClient.this.chatText.getPlayerChatText().requestFocus();
            }
        });
        WindowUtils.restoreSize(this.frame);
    }

    private JComponent createLeftPanel() {
        this.minimap = new MapPanelController(this.client);
        this.positionChangeListener.add(this.minimap);
        StatsPanelController statsPanelController = StatsPanelController.get();
        BuddyPanelController buddyPanelController = BuddyPanelController.get();
        ScrolledViewport scrolledViewport = new ScrolledViewport((JComponent)buddyPanelController.getComponent());
        scrolledViewport.setScrollingSpeed(8);
        JComponent jComponent = scrolledViewport.getComponent();
        jComponent.setBorder(null);
        JComponent jComponent2 = SBoxLayout.createContainer(false);
        jComponent2.add((Component)this.minimap.getComponent(), (Object)SLayout.EXPAND_X);
        jComponent2.add((Component)statsPanelController.getComponent(), (Object)SLayout.EXPAND_X);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(null);
        jPanel.setLayout(new SBoxLayout(false));
        JTabbedPane jTabbedPane = new JTabbedPane(3);
        TabbedPaneUI tabbedPaneUI = jTabbedPane.getUI();
        if (tabbedPaneUI instanceof StyledTabbedPaneUI) {
            ((StyledTabbedPaneUI)tabbedPaneUI).setTabLabelMargins(1);
        }
        jTabbedPane.setFocusable(false);
        jTabbedPane.add("Friends", jComponent);
        jTabbedPane.add("Group", GroupPanelController.get().getComponent());
        jPanel.add((Component)jTabbedPane, SBoxLayout.constraint(SLayout.EXPAND_X, SLayout.EXPAND_Y));
        jComponent2.add((Component)jPanel, SBoxLayout.constraint(SLayout.EXPAND_X, SLayout.EXPAND_Y));
        return jComponent2;
    }

    private ContainerPanel createContainerPanel() {
        ContainerPanel containerPanel = new ContainerPanel();
        containerPanel.setAnimated(false);
        containerPanel.setMinimumSize(new Dimension(0, 0));
        this.character = new Character();
        containerPanel.addRepaintable(this.character);
        this.inventory = new SlotWindow("bag", 3, 4);
        this.inventory.setAcceptedTypes(EntityMap.getClass("item", null, null));
        this.inventory.setCloseable(false);
        containerPanel.addRepaintable(this.inventory);
        this.keyring = new KeyRing();
        this.keyring.setAcceptedTypes(EntityMap.getClass("item", null, null));
        containerPanel.addRepaintable(this.keyring);
        this.userContext.addFeatureChangeListener(this.keyring);
        this.spells = new Spells();
        this.spells.setAcceptedTypes(EntityMap.getClass("spell", null, null));
        containerPanel.addRepaintable(this.spells);
        this.userContext.addFeatureChangeListener(this.spells);
        return containerPanel;
    }

    private void setInitialWindowStates() {
        this.quitDialog.getQuitDialog().setVisible(false);
        this.character.setVisible(true);
        this.inventory.setVisible(true);
        this.keyring.setVisible(false);
        this.spells.setVisible(false);
    }

    private void checkAndComplainAboutJavaImplementation() {
        String string = System.getProperty("java.vm.name", "unknown").toLowerCase(Locale.ENGLISH);
        if (string.indexOf("hotspot") < 0 && string.indexOf("openjdk") < 0) {
            String string2 = "Stendhal is developed and tested on Sun Java and OpenJDK. You are using " + System.getProperty("java.vm.vendor", "unknown") + " " + System.getProperty("java.vm.name", "unknown") + " so there may be some problems like a black or grey screen.\n" + " If you have coding experience with your JDK, we are looking for help.";
            this.addEventLine(new HeaderLessEventLine(string2, NotificationType.ERROR));
        }
    }

    private void cleanup() {
        this.chatText.saveCache();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                logger.warn((Object)"Forced exit, sound system likely locked up");
                System.exit(1);
            }
        };
        Executors.newSingleThreadScheduledExecutor().schedule(runnable, 3L, TimeUnit.SECONDS);
        this.getSoundSystemFacade().exit();
        logger.debug((Object)"Exit");
        System.exit(0);
    }

    private void addDialog(Component component) {
        this.pane.add(component, JLayeredPane.PALETTE_LAYER);
    }

    public void startGameLoop() {
        Object object;
        try {
            object = this.initSoundSystem();
            object.play("harp-1", 0, null, null, false, true);
        }
        catch (RuntimeException runtimeException) {
            logger.error((Object)runtimeException, (Throwable)runtimeException);
        }
        object = GameLoop.get();
        final GameObjects gameObjects = this.client.getGameObjects();
        ((GameLoop)object).runAllways(new GameLoop.PersistentTask(){

            @Override
            public void run(int n) {
                j2DClient.this.gameLoop(n, gameObjects);
            }
        });
        ((GameLoop)object).runAtQuit(new Runnable(){

            @Override
            public void run() {
                j2DClient.this.cleanup();
            }
        });
        this.gameRunning = true;
        ((GameLoop)object).start();
    }

    private void gameLoop(int n, GameObjects gameObjects) {
        if (!this.gameRunning) {
            logger.info((Object)"Request logout");
            try {
                if (this.offline || this.client.logout()) {
                    GameLoop.get().stop();
                } else {
                    logger.warn((Object)"You can't logout now.");
                    this.gameRunning = true;
                }
            }
            catch (Exception exception) {
                logger.error((Object)exception, (Throwable)exception);
                GameLoop.get().stop();
            }
        }
        this.setOffline(!this.client.getConnectionState());
        this.screenController.nextFrame();
        logger.debug((Object)"Move objects");
        gameObjects.update(n);
        User user = User.get();
        if (user != null && user != this.lastuser) {
            this.character.setPlayer(user);
            this.keyring.setSlot(user, "keyring");
            this.spells.setSlot(user, "spells");
            this.inventory.setSlot(user, "bag");
            this.lastuser = user;
        }
        this.triggerPainting();
        logger.debug((Object)"Query network");
        this.client.loop(0);
        this.gameKeyHandler.processDelayedDirectionRelease();
    }

    private void triggerPainting() {
        if (this.frame.getState() != 1) {
            ++this.paintCounter;
            if (this.frame.isActive() || System.getProperty("stendhal.skip.inactive", "false").equals("false") || this.paintCounter >= 20) {
                this.paintCounter = 0;
                logger.debug((Object)"Draw screen");
                this.minimap.refresh();
                this.containerPanel.repaintChildren();
                this.screen.repaint();
            }
        }
    }

    private SoundGroup initSoundSystem() {
        SoundGroup soundGroup = this.getSoundSystemFacade().getGroup(SoundLayer.USER_INTERFACE.groupName);
        soundGroup.loadSound("harp-1", "harp-1.ogg", SoundFileType.OGG, false);
        soundGroup.loadSound("click-4", "click-4.ogg", SoundFileType.OGG, false);
        soundGroup.loadSound("click-5", "click-5.ogg", SoundFileType.OGG, false);
        soundGroup.loadSound("click-6", "click-6.ogg", SoundFileType.OGG, false);
        soundGroup.loadSound("click-8", "click-8.ogg", SoundFileType.OGG, false);
        soundGroup.loadSound("click-10", "click-10.ogg", SoundFileType.OGG, false);
        return soundGroup;
    }

    void shutdown() {
        this.gameRunning = false;
        WtWindowManager.getInstance().save();
    }

    public void addWindow(ManagedWindow managedWindow) {
        if (!(managedWindow instanceof InternalManagedWindow)) {
            throw new IllegalArgumentException("Unsupport ManagedWindow type: " + managedWindow.getClass().getName());
        }
        this.addDialog((InternalManagedWindow)managedWindow);
    }

    @Override
    public void addEventLine(EventLine eventLine) {
        this.channelManager.addEventLine(eventLine);
    }

    @Override
    public void addGameScreenText(double d, double d2, String string, NotificationType notificationType, boolean bl) {
        this.screenController.addText(d, d2, string, notificationType, bl);
    }

    @Override
    public void addAchievementBox(String string, String string2, String string3) {
        this.screen.addAchievementBox(string, string2, string3);
    }

    public void chooseOutfit() {
        RPObject rPObject = this.userContext.getPlayer();
        int n = rPObject.has("outfit_org") ? rPObject.getInt("outfit_org") : rPObject.getInt("outfit");
        if (this.outfitDialog == null) {
            this.outfitDialog = new OutfitDialog((Frame)this.frame, "Set outfit", n, new OutfitColor(rPObject));
            this.outfitDialog.setVisible(true);
        } else {
            this.outfitDialog.setState(n, OutfitColor.get(rPObject));
            this.outfitDialog.setVisible(true);
            this.outfitDialog.toFront();
        }
    }

    private JTabbedPane createLogArea() {
        final JTabbedPane jTabbedPane = new JTabbedPane(3);
        jTabbedPane.setFocusable(false);
        final Timer timer = new Timer(100, null);
        List<JComponent> list = this.createNotificationChannels();
        final BitSet bitSet = new BitSet(list.size());
        jTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n = jTabbedPane.getSelectedIndex();
                NotificationChannel notificationChannel = j2DClient.this.channelManager.getChannels().get(n);
                j2DClient.this.channelManager.setVisibleChannel(notificationChannel);
                if (bitSet.get(n)) {
                    bitSet.set(n, false);
                    jTabbedPane.setBackgroundAt(n, null);
                    if (bitSet.isEmpty()) {
                        timer.stop();
                    }
                }
            }
        });
        Iterator<NotificationChannel> iterator = this.channelManager.getChannels().iterator();
        for (JComponent jComponent : list) {
            jTabbedPane.add(iterator.next().getName(), jComponent);
        }
        this.channelManager.addHiddenChannelListener(new NotificationChannelManager.HiddenChannelListener(){

            @Override
            public void channelModified(int n) {
                if (!bitSet.get(n)) {
                    bitSet.set(n);
                    if (!timer.isRunning()) {
                        timer.start();
                    }
                }
            }
        });
        timer.addActionListener(new ActionListener(){
            private static final int STEPS = 10;
            private final Color[] colors = new Color[10];
            private int colorIndex;
            private int change = 1;
            {
                Color color;
                Style style = StyleUtil.getStyle();
                if (style != null) {
                    this.colors[0] = style.getHighLightColor();
                    color = style.getPlainColor();
                } else {
                    this.colors[0] = Color.BLUE;
                    color = Color.DARK_GRAY;
                }
                int n = this.colors[0].getRed();
                int n2 = this.colors[0].getGreen();
                int n3 = this.colors[0].getBlue();
                int n4 = 255;
                int n5 = n - color.getRed();
                int n6 = n2 - color.getGreen();
                int n7 = n3 - color.getBlue();
                int n8 = TransparencyMode.TRANSPARENCY == 3 ? 25 : 0;
                for (int i = 1; i < 10; ++i) {
                    this.colors[i] = new Color(n - i * n5 / 10, n2 - i * n6 / 10, n3 - i * n7 / 10, n4 -= n8);
                }
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.colorIndex += this.change;
                if (this.colorIndex >= this.colors.length || this.colorIndex < 0) {
                    this.change = -this.change;
                    this.colorIndex += this.change;
                }
                int n = bitSet.nextSetBit(0);
                while (n >= 0) {
                    jTabbedPane.setBackgroundAt(n, this.colors[this.colorIndex]);
                    n = bitSet.nextSetBit(n + 1);
                }
            }
        });
        return jTabbedPane;
    }

    private List<JComponent> createNotificationChannels() {
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>();
        this.channelManager = new NotificationChannelManager();
        KTextEdit kTextEdit = new KTextEdit();
        arrayList.add(kTextEdit);
        WtWindowManager wtWindowManager = WtWindowManager.getInstance();
        final NotificationChannel notificationChannel = new NotificationChannel("Main", kTextEdit, true, "");
        wtWindowManager.registerSettingChangeListener("ui.healingmessage", new SettingChangeAdapter("ui.healingmessage", "false"){

            @Override
            public void changed(String string) {
                notificationChannel.setTypeFiltering(NotificationType.HEAL, Boolean.parseBoolean(string));
            }
        });
        wtWindowManager.registerSettingChangeListener("ui.poisonmessage", new SettingChangeAdapter("ui.poisonmessage", "false"){

            @Override
            public void changed(String string) {
                notificationChannel.setTypeFiltering(NotificationType.POISON, Boolean.parseBoolean(string));
            }
        });
        this.channelManager.addChannel(notificationChannel);
        kTextEdit = new KTextEdit();
        kTextEdit.setChannelName("Personal");
        kTextEdit.setDefaultBackground(Color.decode(PRIVATE_TAB_COLOR));
        arrayList.add(kTextEdit);
        String string = NotificationType.PRIVMSG.toString() + "," + (Object)((Object)NotificationType.CLIENT) + "," + (Object)((Object)NotificationType.GROUP) + "," + (Object)((Object)NotificationType.TUTORIAL) + "," + (Object)((Object)NotificationType.SUPPORT);
        this.channelManager.addChannel(new NotificationChannel("Personal", kTextEdit, false, string));
        return arrayList;
    }

    public Frame getMainFrame() {
        return this.frame;
    }

    public Dimension getFrameDefaultSize() {
        return this.frameDefaultSize;
    }

    public void setChatLine(String string) {
        this.chatText.setChatLine(string);
    }

    public void clearGameLog() {
        this.channelManager.getVisibleChannel().clear();
    }

    public void setPosition(double d, double d2) {
        this.positionChangeListener.positionChanged(d, d2);
    }

    public void setOffline(boolean bl) {
        this.screenController.setOffline(bl);
        this.offline = bl;
    }

    public void requestQuit() {
        if (this.client.getConnectionState() || !this.offline) {
            this.quitDialog.requestQuit(this.lastuser);
        } else {
            System.exit(0);
        }
    }

    public IPerceptionListener getPerceptionListener() {
        return this.perceptionListener;
    }

    public StendhalClient getClient() {
        return this.client;
    }

    @Override
    public final SoundSystemFacade getSoundSystemFacade() {
        if (this.soundSystemFacade == null) {
            try {
                this.soundSystemFacade = DataLoader.getResource("data/sound/harp-1.ogg") != null || DataLoader.getResource("data/music/the_old_tavern.ogg") != null ? new SoundSystemFacadeImpl() : new NoSoundFacade();
            }
            catch (RuntimeException runtimeException) {
                this.soundSystemFacade = new NoSoundFacade();
                logger.error((Object)runtimeException, (Throwable)runtimeException);
            }
        }
        return this.soundSystemFacade;
    }

    public void switchToSpellState(RPObject rPObject) {
        this.screen.switchToSpellCastingState(rPObject);
    }

    static {
        Initializer.init();
        logger = Logger.getLogger(j2DClient.class);
    }

    private static class SplitPaneResizeListener
    extends ComponentAdapter {
        private final Component child;

        public SplitPaneResizeListener(Component component) {
            this.child = component;
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            this.child.setSize(componentEvent.getComponent().getSize());
        }
    }
}

