/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.j2d;

import games.stendhal.client.sprite.Sprite;
import java.awt.Graphics;
import java.awt.Rectangle;

public class RemovableSprite
implements Comparable<RemovableSprite> {
    public static final long STANDARD_PERSISTENCE_TIME = 5000L;
    private final int x;
    private final int y;
    private final Sprite sprite;
    private long removeTime;
    private int priority;

    public RemovableSprite(Sprite sprite, int n, int n2, long l) {
        this.sprite = sprite;
        this.x = n;
        this.y = n2;
        this.removeTime = l == 0L ? System.currentTimeMillis() + 5000L : System.currentTimeMillis() + l;
    }

    public void draw(Graphics graphics) {
        this.sprite.draw(graphics, this.x, this.y);
    }

    public Rectangle getArea() {
        return new Rectangle(this.x, this.y, this.sprite.getWidth(), this.sprite.getHeight());
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void setPriority(int n) {
        this.priority = n;
    }

    public boolean shouldBeRemoved() {
        return System.currentTimeMillis() >= this.removeTime;
    }

    @Override
    public int compareTo(RemovableSprite removableSprite) {
        return this.priority - removableSprite.priority;
    }
}

