/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.j2d;

import games.stendhal.client.gui.TransparencyMode;
import games.stendhal.client.gui.j2d.BackgroundPainter;
import games.stendhal.client.gui.textformat.AttributedStringBuilder;
import games.stendhal.client.gui.textformat.StringFormatter;
import games.stendhal.client.gui.textformat.TextAttributeSet;
import games.stendhal.client.sprite.ImageSprite;
import games.stendhal.client.sprite.Sprite;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.BreakIterator;
import java.text.CharacterIterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class TextBoxFactory {
    private static final Graphics graphics = new BufferedImage(1, 1, 1).getGraphics();
    private static final int MARGIN_WIDTH = 3;
    private static final int LINE_HEIGHT = graphics.getFontMetrics().getHeight();
    private static final int LINE_ASCENT = graphics.getFontMetrics().getAscent();
    private static final int BUBBLE_OFFSET = 10;
    private static final int ARC_DIAMETER = 8;
    private static final int MAX_LINES = 6;
    private final StringFormatter<Map<TextAttribute, Object>, TextAttributeSet> formatter = new StringFormatter();

    public TextBoxFactory() {
        TextAttributeSet textAttributeSet = new TextAttributeSet();
        textAttributeSet.setAttribute(TextAttribute.FOREGROUND, Color.blue);
        textAttributeSet.setAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        this.formatter.addStyle(Character.valueOf('#'), textAttributeSet);
        textAttributeSet = new TextAttributeSet();
        textAttributeSet.setAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        this.formatter.addStyle(Character.valueOf('\u00a7'), textAttributeSet);
    }

    public Sprite createTextBox(String string, int n, Color color, Color color2, boolean bl) {
        List<AttributedCharacterIterator> list = this.createFormattedLines(string, color, n);
        int n2 = this.getMaxPixelWidth(list);
        int n3 = list.size();
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        int n4 = n2 + 10 < n ? n2 + 10 + 8 : n + 10 + 8;
        int n5 = LINE_HEIGHT * n3 + 6;
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n4, n5, TransparencyMode.TRANSPARENCY);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (color2 != null) {
            if (bl) {
                this.drawBubble(graphics2D, color2, color, n4 - 10, n5);
            } else {
                this.drawRectangle(graphics2D, color2, color, n4 - 10, n5);
            }
        }
        this.drawTextLines(graphics2D, list, color, 13, 3);
        graphics2D.dispose();
        return new ImageSprite(bufferedImage);
    }

    public Sprite createFancyTextBox(String string, Color color, int n, int n2, int n3, int n4, int n5, BackgroundPainter backgroundPainter) {
        List<AttributedCharacterIterator> list = this.createFormattedLines(string, color, n);
        int n6 = this.getMaxPixelWidth(list) + n2 + n3;
        int n7 = LINE_HEIGHT * list.size() + n4 + n5;
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n6, n7, TransparencyMode.TRANSPARENCY);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setComposite(AlphaComposite.Src);
        backgroundPainter.paint(graphics2D, n6, n7);
        graphics2D.setComposite(AlphaComposite.SrcOver);
        this.drawTextLines(graphics2D, list, color, n2, n4);
        graphics2D.dispose();
        return new ImageSprite(bufferedImage);
    }

    private List<AttributedCharacterIterator> createFormattedLines(String string, Color color, int n) {
        AttributedString attributedString = this.formatLine(string.trim(), color);
        return this.splitFormatted(attributedString, n);
    }

    private void drawBubble(Graphics2D graphics2D, Color color, Color color2, int n, int n2) {
        graphics2D.setColor(color2);
        graphics2D.fillRoundRect(10, 0, n, n2, 8, 8);
        graphics2D.setColor(color);
        graphics2D.fillRoundRect(11, 1, n - 2, n2 - 2, 8, 8);
        Polygon polygon = new Polygon();
        polygon.addPoint(11, 4);
        polygon.addPoint(0, LINE_HEIGHT);
        polygon.addPoint(11, LINE_HEIGHT / 2 + 3);
        graphics2D.fillPolygon(polygon);
        graphics2D.setColor(color2);
        graphics2D.drawLine(0, LINE_HEIGHT, 10, 4);
        graphics2D.drawLine(0, LINE_HEIGHT, 10, LINE_HEIGHT / 2 + 3);
    }

    private void drawRectangle(Graphics2D graphics2D, Color color, Color color2, int n, int n2) {
        graphics2D.setColor(color2);
        graphics2D.fillRect(10, 0, n, n2);
        graphics2D.setColor(color);
        graphics2D.fillRect(11, 1, n - 2, n2 - 2);
    }

    private AttributedString formatLine(String string, Color color) {
        try {
            TextAttributeSet textAttributeSet = new TextAttributeSet();
            textAttributeSet.setAttribute(TextAttribute.FOREGROUND, color);
            AttributedStringBuilder attributedStringBuilder = new AttributedStringBuilder();
            this.formatter.format(string, textAttributeSet, attributedStringBuilder);
            return attributedStringBuilder.toAttributedString();
        }
        catch (Exception exception) {
            Logger.getLogger(TextBoxFactory.class).error((Object)exception, (Throwable)exception);
            return null;
        }
    }

    private List<AttributedCharacterIterator> splitFormatted(AttributedString attributedString, int n) {
        LinkedList<AttributedCharacterIterator> linkedList = new LinkedList<AttributedCharacterIterator>();
        BreakIterator breakIterator = BreakIterator.getLineInstance();
        breakIterator.setText(attributedString.getIterator());
        int n2 = breakIterator.first();
        CharacterIterator characterIterator = null;
        while (breakIterator.next() != -1) {
            CharacterIterator characterIterator2;
            AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator(null, n2, breakIterator.current());
            if (this.getPixelWidth(attributedCharacterIterator) <= n) {
                characterIterator2 = breakIterator.getText();
                if (this.isHardLineBreak(characterIterator2)) {
                    linkedList.add(attributedCharacterIterator);
                    n2 = breakIterator.current();
                    characterIterator = null;
                    continue;
                }
                characterIterator = attributedCharacterIterator;
                continue;
            }
            if (characterIterator == null) {
                characterIterator = this.splitAggressively(attributedCharacterIterator, n);
                n2 += characterIterator.getEndIndex() - characterIterator.getBeginIndex();
            } else {
                n2 = characterIterator.getEndIndex();
                char c = characterIterator.last();
                int n3 = n2;
                while (Character.isWhitespace(c) && c != '\uffff') {
                    n3 = characterIterator.getIndex();
                    c = characterIterator.previous();
                }
                characterIterator = attributedString.getIterator(null, characterIterator.getBeginIndex(), n3);
            }
            linkedList.add((AttributedCharacterIterator)characterIterator);
            characterIterator2 = breakIterator.getText();
            if (this.isHardLineBreak(characterIterator2)) {
                linkedList.add(attributedString.getIterator(null, n2, breakIterator.current()));
                n2 = breakIterator.current();
            }
            if (breakIterator.current() > n2 + 1) {
                breakIterator.previous();
            }
            characterIterator = null;
            if (linkedList.size() <= 6) continue;
            linkedList.remove(linkedList.size() - 1);
            linkedList.remove(linkedList.size() - 1);
            linkedList.add(new AttributedString("...").getIterator());
            return linkedList;
        }
        if (n2 < breakIterator.last()) {
            linkedList.add(attributedString.getIterator(null, n2, breakIterator.last()));
        }
        return linkedList;
    }

    private AttributedCharacterIterator splitAggressively(AttributedCharacterIterator attributedCharacterIterator, int n) {
        int n2 = attributedCharacterIterator.getBeginIndex();
        BreakIterator breakIterator = BreakIterator.getWordInstance();
        AttributedString attributedString = new AttributedString(attributedCharacterIterator);
        AttributedCharacterIterator attributedCharacterIterator2 = attributedCharacterIterator;
        breakIterator.setText(attributedCharacterIterator);
        while (breakIterator.next() != -1) {
            AttributedCharacterIterator attributedCharacterIterator3 = attributedString.getIterator(null, attributedString.getIterator().getBeginIndex(), breakIterator.current() - n2);
            if (this.getPixelWidth(attributedCharacterIterator3) <= n) {
                attributedCharacterIterator2 = attributedCharacterIterator3;
                continue;
            }
            return attributedCharacterIterator2;
        }
        return attributedCharacterIterator2;
    }

    private int getMaxPixelWidth(List<AttributedCharacterIterator> list) {
        int n = 0;
        for (AttributedCharacterIterator attributedCharacterIterator : list) {
            int n2 = this.getPixelWidth(attributedCharacterIterator);
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    private int getPixelWidth(AttributedCharacterIterator attributedCharacterIterator) {
        return (int)graphics.getFontMetrics().getStringBounds(attributedCharacterIterator, attributedCharacterIterator.getBeginIndex(), attributedCharacterIterator.getEndIndex(), graphics).getWidth();
    }

    private void drawTextLines(Graphics2D graphics2D, List<AttributedCharacterIterator> list, Color color, int n, int n2) {
        int n3 = n2 + LINE_ASCENT;
        for (AttributedCharacterIterator attributedCharacterIterator : list) {
            if (color == null) {
                graphics2D.setColor(Color.black);
            }
            graphics2D.setColor(color);
            graphics2D.drawString(attributedCharacterIterator, n, n3);
            n3 += LINE_HEIGHT;
        }
    }

    private boolean isHardLineBreak(CharacterIterator characterIterator) {
        int n = characterIterator.getIndex();
        char c = characterIterator.previous();
        while (c != '\uffff' && !Character.isLetterOrDigit(c)) {
            if (c == '\n') {
                characterIterator.setIndex(n);
                return true;
            }
            c = characterIterator.previous();
        }
        characterIterator.setIndex(n);
        return false;
    }
}

