/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.j2d.entity;

import games.stendhal.client.ZoneInfo;
import games.stendhal.client.entity.ActionType;
import games.stendhal.client.entity.Chest;
import games.stendhal.client.entity.Inspector;
import games.stendhal.client.gui.InternalWindow;
import games.stendhal.client.gui.SlotWindow;
import games.stendhal.client.gui.j2d.entity.StateEntity2DView;
import games.stendhal.client.gui.styled.cursor.StendhalCursor;
import games.stendhal.client.sprite.Sprite;
import games.stendhal.client.sprite.SpriteStore;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

class Chest2DView
extends StateEntity2DView<Chest> {
    private static final String STATE_CLOSED = "close";
    private static final String STATE_OPEN = "open";
    private volatile boolean openChanged = false;
    private Inspector inspector;
    private boolean requestOpen = false;
    private SlotWindow slotWindow;

    @Override
    protected void buildSprites(Chest chest, Map<Object, Sprite> map) {
        SpriteStore spriteStore = SpriteStore.get();
        ZoneInfo zoneInfo = ZoneInfo.get();
        Sprite sprite = spriteStore.getModifiedSprite(this.translate(chest.getType()), zoneInfo.getZoneColor(), zoneInfo.getColorMethod());
        map.put(STATE_CLOSED, spriteStore.getTile(sprite, 0, 0, 32, 32));
        map.put(STATE_OPEN, spriteStore.getTile(sprite, 0, 32, 32, 32));
    }

    @Override
    protected Object getState(Chest chest) {
        if (chest.isOpen()) {
            return STATE_OPEN;
        }
        return STATE_CLOSED;
    }

    @Override
    protected void buildActions(List<String> list) {
        super.buildActions(list);
        Chest chest = (Chest)this.entity;
        if (chest != null && chest.isOpen()) {
            list.add(ActionType.INSPECT.getRepresentation());
            list.add(ActionType.CLOSE.getRepresentation());
        } else {
            list.add(ActionType.OPEN.getRepresentation());
        }
    }

    @Override
    public int getZIndex() {
        return 5000;
    }

    @Override
    public void setInspector(Inspector inspector) {
        this.inspector = inspector;
    }

    @Override
    protected void update() {
        super.update();
        if (this.openChanged) {
            this.openChanged = false;
            if (((Chest)this.entity).isOpen()) {
                if (this.requestOpen) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Chest2DView.this.showWindow();
                        }
                    });
                }
            } else if (this.slotWindow != null) {
                this.slotWindow.close();
            }
            this.requestOpen = false;
        }
    }

    @Override
    public void entityChanged(Object object) {
        super.entityChanged(object);
        if (object == Chest.PROP_OPEN) {
            this.proceedChangedState(this.entity);
            this.openChanged = true;
        }
    }

    @Override
    public void onAction(ActionType actionType) {
        if (this.isReleased()) {
            return;
        }
        switch (actionType) {
            case INSPECT: {
                this.showWindow();
                break;
            }
            case OPEN: {
                if (!((Chest)this.entity).isOpen()) {
                    this.requestOpen = true;
                }
                actionType.send(actionType.fillTargetInfo(this.entity));
                break;
            }
            case CLOSE: {
                actionType.send(actionType.fillTargetInfo(this.entity));
                break;
            }
            default: {
                super.onAction(actionType);
            }
        }
    }

    @Override
    public void onAction() {
        if (((Chest)this.entity).isOpen()) {
            this.onAction(ActionType.INSPECT);
        } else {
            this.onAction(ActionType.OPEN);
        }
    }

    @Override
    public void release() {
        final SlotWindow slotWindow = this.slotWindow;
        if (slotWindow != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    slotWindow.close();
                }
            });
        }
        super.release();
    }

    @Override
    public StendhalCursor getCursor() {
        return StendhalCursor.BAG;
    }

    private void showWindow() {
        boolean bl = this.slotWindow == null;
        this.slotWindow = this.inspector.inspectMe(this.entity, ((Chest)this.entity).getContent(), this.slotWindow, 5, 6);
        if (bl && this.slotWindow != null) {
            this.slotWindow.addCloseListener(new InternalWindow.CloseListener(){

                @Override
                public void windowClosed(InternalWindow internalWindow) {
                    Chest2DView.this.slotWindow = null;
                }
            });
        }
    }
}

