/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.j2d.entity;

import games.stendhal.client.ZoneInfo;
import games.stendhal.client.entity.ActionType;
import games.stendhal.client.entity.ContentChangeListener;
import games.stendhal.client.entity.Corpse;
import games.stendhal.client.entity.Entity;
import games.stendhal.client.entity.IEntity;
import games.stendhal.client.entity.Inspector;
import games.stendhal.client.entity.User;
import games.stendhal.client.gui.InternalWindow;
import games.stendhal.client.gui.SlotWindow;
import games.stendhal.client.gui.j2d.entity.Entity2DView;
import games.stendhal.client.gui.styled.cursor.StendhalCursor;
import games.stendhal.client.gui.wt.core.WtWindowManager;
import games.stendhal.client.sprite.Sprite;
import games.stendhal.client.sprite.SpriteStore;
import java.awt.Graphics2D;
import java.util.List;
import javax.swing.SwingUtilities;
import marauroa.common.game.RPSlot;

class Corpse2DView<T extends Corpse>
extends Entity2DView<T> {
    private int height = 32;
    private int width = 32;
    private Inspector inspector;
    private volatile SlotWindow slotWindow;
    private boolean autoOpenedAlready = false;

    @Override
    protected void buildActions(List<String> list) {
        list.add(ActionType.INSPECT.getRepresentation());
        super.buildActions(list);
    }

    @Override
    protected void buildRepresentation(T t) {
        String string = ((Entity)t).getRPObject().get("image");
        String string2 = ((Entity)t).getRPObject().get("harmless_image");
        Sprite sprite = null;
        ZoneInfo zoneInfo = ZoneInfo.get();
        boolean bl = Boolean.parseBoolean(WtWindowManager.getInstance().getProperty("gamescreen.blood", "true"));
        sprite = bl ? SpriteStore.get().getModifiedSprite(this.translate("corpse/" + string), zoneInfo.getZoneColor(), zoneInfo.getColorMethod()) : SpriteStore.get().getModifiedSprite(this.translate("corpse/" + string2), zoneInfo.getZoneColor(), zoneInfo.getColorMethod());
        this.width = sprite.getWidth();
        this.height = sprite.getHeight();
        this.setSprite(sprite);
        this.calculateOffset(t, this.width, this.height);
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getZIndex() {
        return 5500;
    }

    @Override
    public void setInspector(Inspector inspector) {
        this.inspector = inspector;
    }

    @Override
    void entityChanged(Object object) {
        super.entityChanged(object);
        if (object == IEntity.PROP_CLASS) {
            this.representationChanged = true;
        }
    }

    @Override
    public boolean isMovable() {
        return true;
    }

    @Override
    public void onAction() {
        this.onAction(ActionType.INSPECT);
    }

    @Override
    public void onAction(ActionType actionType) {
        if (this.isReleased()) {
            return;
        }
        switch (actionType) {
            case INSPECT: {
                boolean bl = this.slotWindow == null;
                RPSlot rPSlot = ((Corpse)this.entity).getContent();
                SlotWindow slotWindow = this.slotWindow = this.inspector.inspectMe(this.entity, rPSlot, this.slotWindow, 2, 2);
                if (slotWindow != null) {
                    slotWindow.setTitle(((Corpse)this.entity).getTitle());
                    slotWindow.setMinimizable(false);
                    this.prepareInspectAutoClose(slotWindow, this.entity, rPSlot);
                }
                if (bl && slotWindow != null) {
                    slotWindow.addCloseListener(new InternalWindow.CloseListener(){

                        @Override
                        public void windowClosed(InternalWindow internalWindow) {
                            Corpse2DView.this.slotWindow = null;
                        }
                    });
                }
                if (!this.isReleased() || slotWindow == null) break;
                slotWindow.close();
                break;
            }
            default: {
                super.onAction(actionType);
            }
        }
    }

    private void prepareInspectAutoClose(final SlotWindow slotWindow, IEntity iEntity, final RPSlot rPSlot) {
        iEntity.addContentChangeListener(new ContentChangeListener(){

            @Override
            public void contentAdded(RPSlot rPSlot2) {
            }

            @Override
            public void contentRemoved(RPSlot rPSlot2) {
                if (rPSlot.size() == rPSlot2.size()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            slotWindow.close();
                        }
                    });
                }
            }
        });
    }

    @Override
    public void release() {
        final SlotWindow slotWindow = this.slotWindow;
        if (slotWindow != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    slotWindow.close();
                }
            });
        }
        super.release();
    }

    @Override
    public StendhalCursor getCursor() {
        StendhalCursor stendhalCursor = super.getCursor();
        Corpse corpse = (Corpse)this.entity;
        if (stendhalCursor != StendhalCursor.UNKNOWN || corpse == null) {
            return stendhalCursor;
        }
        if (corpse.getContent().size() == 0) {
            return StendhalCursor.EMPTY_BAG;
        }
        if (corpse.getCorpseOwner() == null || corpse.getCorpseOwner().equals(User.getCharacterName())) {
            return StendhalCursor.BAG;
        }
        if (User.isGroupSharingLoot() && User.isPlayerInGroup(corpse.getCorpseOwner())) {
            return StendhalCursor.BAG;
        }
        return StendhalCursor.LOCKED_BAG;
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        super.draw(graphics2D);
        this.autoRaiseWindowIfDesired();
    }

    private void autoRaiseWindowIfDesired() {
        if (!this.autoOpenedAlready && this.inspector != null) {
            this.autoOpenedAlready = true;
            boolean bl = Boolean.parseBoolean(WtWindowManager.getInstance().getProperty("gamescreen.autoinspectcorpses", "true"));
            if (bl && ((Corpse)this.entity).getCorpseOwner() != null && ((Corpse)this.entity).getCorpseOwner().equals(User.getCharacterName()) && !((Corpse)this.entity).isEmpty()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Corpse2DView.this.onAction(ActionType.INSPECT);
                    }
                });
            }
        }
    }
}

