/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.j2d.entity;

import games.stendhal.client.ZoneInfo;
import games.stendhal.client.entity.ActionType;
import games.stendhal.client.entity.IEntity;
import games.stendhal.client.gui.j2d.entity.Entity2DView;
import games.stendhal.client.sprite.Sprite;
import games.stendhal.client.sprite.SpriteCache;
import games.stendhal.client.sprite.SpriteStore;
import java.awt.Graphics2D;
import java.util.HashMap;
import java.util.List;
import marauroa.common.game.RPObject;
import org.apache.log4j.Logger;

class Gate2DView
extends Entity2DView<IEntity> {
    private static final HashMap<String, Sprite[]> sprites = new HashMap();
    private Sprite openSprite;
    private Sprite closedSprite;

    Gate2DView() {
    }

    private Sprite getModifiedSprite(Sprite sprite) {
        ZoneInfo zoneInfo = ZoneInfo.get();
        if (zoneInfo.getColorMethod() == null || zoneInfo.getZoneColor() == null) {
            return sprite;
        }
        SpriteStore spriteStore = SpriteStore.get();
        String string = spriteStore.createModifiedRef(sprite.getReference().toString(), zoneInfo.getZoneColor(), zoneInfo.getColorMethod());
        Sprite sprite2 = SpriteCache.get().get(string);
        if (sprite2 == null) {
            sprite2 = spriteStore.modifySprite(sprite, zoneInfo.getZoneColor(), zoneInfo.getColorMethod(), string);
        }
        return sprite2;
    }

    @Override
    protected void buildActions(List<String> list) {
        list.add(ActionType.USE.getRepresentation());
    }

    @Override
    protected void buildRepresentation(IEntity iEntity) {
        RPObject rPObject = iEntity.getRPObject();
        String string = rPObject.get("image");
        String string2 = rPObject.get("orientation");
        SpriteStore spriteStore = SpriteStore.get();
        String string3 = "data/sprites/doors/" + string + "_" + string2 + ".png";
        Sprite[] spriteArray = sprites.get(string3);
        if (spriteArray == null) {
            Sprite sprite = spriteStore.getSprite(string3);
            spriteArray = new Sprite[]{sprite.createRegion(0, 0, 96, 96, string3 + "[0]"), sprite.createRegion(0, 96, 96, 96, string3 + "[1]")};
            sprites.put(string3, spriteArray);
        }
        this.openSprite = this.getModifiedSprite(spriteArray[0]);
        this.closedSprite = this.getModifiedSprite(spriteArray[1]);
    }

    @Override
    public void onAction() {
        this.onAction(ActionType.USE);
    }

    @Override
    public void onAction(ActionType actionType) {
        if (this.isReleased()) {
            Logger.getLogger(Gate2DView.class).debug((Object)("View already released - action not processed: " + (Object)((Object)actionType)));
            return;
        }
        switch (actionType) {
            case USE: {
                actionType.send(actionType.fillTargetInfo(this.entity));
                break;
            }
            default: {
                super.onAction(actionType);
            }
        }
    }

    private boolean isOpen() {
        return this.entity.getResistance() == 0;
    }

    @Override
    protected void drawEntity(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        if (this.isOpen()) {
            this.openSprite.draw(graphics2D, n - 32, n2 - 32);
        } else {
            this.closedSprite.draw(graphics2D, n - 32, n2 - 32);
        }
    }

    @Override
    public int getZIndex() {
        return 5000;
    }
}

