/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.j2d.entity;

import games.stendhal.client.OutfitStore;
import games.stendhal.client.ZoneInfo;
import games.stendhal.client.entity.ActionType;
import games.stendhal.client.entity.IEntity;
import games.stendhal.client.entity.NPC;
import games.stendhal.client.entity.RPEntity;
import games.stendhal.client.entity.User;
import games.stendhal.client.gui.OutfitColor;
import games.stendhal.client.gui.j2d.entity.RPEntity2DView;
import games.stendhal.client.gui.j2d.entity.helpers.HorizontalAlignment;
import games.stendhal.client.gui.j2d.entity.helpers.VerticalAlignment;
import games.stendhal.client.gui.styled.cursor.StendhalCursor;
import games.stendhal.client.sprite.Sprite;
import games.stendhal.client.sprite.SpriteStore;
import java.util.List;
import marauroa.common.game.RPAction;
import org.apache.log4j.Logger;

class NPC2DView<T extends NPC>
extends RPEntity2DView<T> {
    private static final Logger logger = Logger.getLogger(NPC2DView.class);
    private volatile boolean ideaChanged = true;
    private Sprite ideaSprite;

    NPC2DView() {
    }

    @Override
    protected Sprite getAnimationSprite() {
        SpriteStore spriteStore = SpriteStore.get();
        ZoneInfo zoneInfo = ZoneInfo.get();
        try {
            int n = ((RPEntity)this.entity).getOutfit();
            if (n != -1) {
                return OutfitStore.get().getAdjustedOutfit(n, OutfitColor.PLAIN, zoneInfo.getZoneColor(), zoneInfo.getColorMethod());
            }
            return spriteStore.getModifiedSprite(this.translate("npc/" + ((NPC)this.entity).getEntityClass()), zoneInfo.getZoneColor(), zoneInfo.getColorMethod());
        }
        catch (Exception exception) {
            logger.error((Object)"Cannot build animations", (Throwable)exception);
            return spriteStore.getModifiedSprite(this.translate(((NPC)this.entity).getEntityClass()), zoneInfo.getZoneColor(), zoneInfo.getColorMethod());
        }
    }

    @Override
    void entityChanged(Object object) {
        super.entityChanged(object);
        if (object == IEntity.PROP_CLASS) {
            this.representationChanged = true;
        } else if (object == NPC.PROP_IDEA) {
            this.ideaChanged = true;
        }
    }

    @Override
    protected void buildActions(List<String> list) {
        super.buildActions(list);
        list.remove(ActionType.PUSH.getRepresentation());
        if (User.isAdmin()) {
            list.add(ActionType.ADMIN_VIEW_NPC_TRANSITIONS.getRepresentation());
        }
    }

    @Override
    protected void update() {
        super.update();
        if (this.ideaChanged) {
            this.ideaChanged = false;
            this.detachSprite(this.ideaSprite);
            this.ideaSprite = this.getIdeaSprite();
            if (this.ideaSprite != null) {
                this.attachSprite(this.ideaSprite, HorizontalAlignment.RIGHT, VerticalAlignment.TOP, 8, -8);
            }
        }
    }

    private Sprite getIdeaSprite() {
        String string = ((NPC)this.entity).getIdea();
        if (string == null) {
            return null;
        }
        return SpriteStore.get().getSprite("data/sprites/ideas/" + string + ".png");
    }

    @Override
    public void onAction(ActionType actionType) {
        switch (actionType) {
            case ADMIN_VIEW_NPC_TRANSITIONS: {
                RPAction rPAction = new RPAction();
                rPAction.put("type", "script");
                rPAction.put("target", "DumpTransitionsEx.class");
                rPAction.put("args", ((NPC)this.getEntity()).getTitle());
                actionType.send(rPAction);
                break;
            }
            default: {
                super.onAction(actionType);
            }
        }
    }

    @Override
    public StendhalCursor getCursor() {
        return StendhalCursor.LOOK;
    }
}

