/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.j2d.entity;

import games.stendhal.client.entity.ActionType;
import games.stendhal.client.entity.Portal;
import games.stendhal.client.gui.j2d.entity.InvisibleEntity2DView;
import games.stendhal.client.gui.styled.cursor.StendhalCursor;
import java.util.List;

class Portal2DView<T extends Portal>
extends InvisibleEntity2DView<T> {
    Portal2DView() {
    }

    @Override
    protected void buildActions(List<String> list) {
        Portal portal = (Portal)this.entity;
        if (portal != null && !portal.isHidden()) {
            list.add(ActionType.USE.getRepresentation());
            super.buildActions(list);
            list.remove(ActionType.LOOK.getRepresentation());
        }
    }

    @Override
    public void onAction() {
        if (!((Portal)this.entity).isHidden()) {
            this.onAction(ActionType.USE);
        }
    }

    @Override
    public void onAction(ActionType actionType) {
        if (this.isReleased()) {
            return;
        }
        switch (actionType) {
            case USE: {
                actionType.send(actionType.fillTargetInfo(this.entity));
                break;
            }
            default: {
                super.onAction(actionType);
            }
        }
    }

    @Override
    public boolean isInteractive() {
        return ((Portal)this.entity).isUseable();
    }

    @Override
    public StendhalCursor getCursor() {
        if (this.isInteractive()) {
            return StendhalCursor.ACTIVITY;
        }
        return StendhalCursor.PORTAL;
    }
}

