/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.layout;

import games.stendhal.client.gui.layout.SLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.swing.JComponent;

public class SBoxLayout
implements LayoutManager2 {
    public static final boolean VERTICAL = false;
    public static final boolean HORIZONTAL = true;
    public static final int COMMON_PADDING = 5;
    private static final Direction horizontalDirection = new HDirection();
    private static final Direction verticalDirection = new VDirection();
    private final Map<Component, EnumSet<SLayout>> constraints = new IdentityHashMap<Component, EnumSet<SLayout>>();
    private final Direction d;
    private Dimension cachedMinimum;
    private Dimension cachedMaximum;
    private Dimension cachedPreferred;
    private int expandable;
    private int padding = 0;

    public static Object constraint(SLayout ... sLayoutArray) {
        EnumSet<SLayout> enumSet = EnumSet.noneOf(SLayout.class);
        for (SLayout sLayout : sLayoutArray) {
            enumSet.add(sLayout);
        }
        return enumSet;
    }

    public SBoxLayout(boolean bl) {
        this.d = !bl ? verticalDirection : horizontalDirection;
    }

    public SBoxLayout(boolean bl, int n) {
        this(bl);
        this.setPadding(n);
    }

    public final void setPadding(int n) {
        this.padding = n;
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
        EnumSet<SLayout> enumSet = EnumSet.noneOf(SLayout.class);
        if (object != null) {
            if (object instanceof SLayout) {
                enumSet.add(this.d.translate((SLayout)((Object)object)));
            } else if (object instanceof EnumSet || object instanceof SLayout) {
                EnumSet enumSet2 = (EnumSet)object;
                for (SLayout sLayout : SLayout.values()) {
                    if (!enumSet2.contains((Object)sLayout)) continue;
                    sLayout = this.d.translate(sLayout);
                    enumSet.add(sLayout);
                }
            } else {
                throw new IllegalArgumentException("Invalid flags: " + object);
            }
            if (enumSet.contains((Object)SLayout.EXPAND_AXIAL)) {
                ++this.expandable;
            }
        }
        this.constraints.put(component, enumSet);
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    private void addToPrimary(Dimension dimension, int n) {
        this.d.setPrimary(dimension, this.d.getPrimary(dimension) + n);
    }

    private void expand(Dimension dimension, Dimension dimension2) {
        dimension.width = Math.max(dimension.width, dimension2.width);
        dimension.height = Math.max(dimension.height, dimension2.height);
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        return 0.0f;
    }

    private Dimension getPreferred(Component component) {
        Dimension dimension = component.getPreferredSize();
        this.expand(dimension, component.getMinimumSize());
        this.shrink(dimension, component.getMaximumSize());
        return dimension;
    }

    @Override
    public void invalidateLayout(Container container) {
        this.cachedMinimum = null;
        this.cachedMaximum = null;
        this.cachedPreferred = null;
    }

    @Override
    public void layoutContainer(Container container) {
        Dimension dimension = container.getSize();
        Insets insets = container.getInsets();
        Dimension dimension2 = this.preferredLayoutSize(container);
        int n = this.d.getPrimary(dimension) - this.d.getPrimary(dimension2);
        dimension.width -= insets.left + insets.right;
        dimension.height -= insets.top + insets.bottom;
        Dimension dimension3 = new Dimension(insets.left, insets.top);
        if (n >= 0) {
            this.layoutSufficientSpace(container, dimension, dimension3, n);
        } else {
            Dimension dimension4 = this.minimumLayoutSize(container);
            dimension4.width -= insets.left + insets.right;
            dimension4.height -= insets.top + insets.bottom;
            int n2 = this.d.getPrimary(dimension) - this.d.getPrimary(dimension4);
            if (n2 < 0) {
                this.layoutUnderMinimumSpace(container, dimension, dimension3);
            } else {
                this.layoutWithSqueeze(container, dimension, dimension3, n);
            }
        }
    }

    private void layoutSufficientSpace(Container container, Dimension dimension, Dimension dimension2, int n) {
        int n2 = n;
        int n3 = this.expandable;
        for (Component component : container.getComponents()) {
            if (!component.isVisible()) continue;
            Dimension dimension3 = this.getPreferred(component);
            this.shrink(dimension3, dimension);
            int n4 = 0;
            int n5 = 0;
            EnumSet<SLayout> enumSet = this.constraints.get(component);
            if (enumSet.contains((Object)SLayout.EXPAND_PERPENDICULAR)) {
                this.d.setSecondary(dimension3, this.d.getSecondary(dimension));
            } else {
                n4 = this.getXAlignment(component, dimension);
                n5 = this.getYAlignment(component, dimension);
            }
            if (n2 > 0 && enumSet.contains((Object)SLayout.EXPAND_AXIAL)) {
                int n6 = Math.max(1, n2 / n3);
                this.addToPrimary(dimension3, n6);
                n2 -= n6;
                --n3;
            }
            component.setBounds(dimension2.width + n4, dimension2.height + n5, dimension3.width, dimension3.height);
            this.shiftByPrimary(dimension2, dimension3);
            this.addToPrimary(dimension2, this.padding);
        }
    }

    private void layoutUnderMinimumSpace(Container container, Dimension dimension, Dimension dimension2) {
        for (Component component : container.getComponents()) {
            if (!component.isVisible()) continue;
            Dimension dimension3 = component.getMinimumSize();
            this.shrink(dimension3, dimension);
            int n = 0;
            int n2 = 0;
            EnumSet<SLayout> enumSet = this.constraints.get(component);
            if (enumSet.contains((Object)SLayout.EXPAND_PERPENDICULAR)) {
                this.d.setSecondary(dimension3, this.d.getSecondary(dimension));
            } else {
                n = this.getXAlignment(component, dimension);
                n2 = this.getYAlignment(component, dimension);
            }
            int n3 = this.d.getPrimary(dimension) - this.d.getPrimary(dimension3) - this.d.getPrimary(dimension2);
            if (n3 < 0) {
                n3 = Math.max(-this.d.getPrimary(dimension3), n3);
                this.addToPrimary(dimension3, n3);
            }
            component.setBounds(dimension2.width + n, dimension2.height + n2, dimension3.width, dimension3.height);
            this.shiftByPrimary(dimension2, dimension3);
            this.addToPrimary(dimension2, this.padding);
        }
    }

    private void layoutWithSqueeze(Container container, Dimension dimension, Dimension dimension2, int n) {
        int n2;
        int n3;
        int[] nArray;
        int n4 = container.getComponents().length;
        boolean[] blArray = new boolean[n4];
        int n5 = 0;
        int n6 = 0;
        for (Component component : container.getComponents()) {
            if (!component.isVisible()) continue;
            ++n6;
        }
        do {
            nArray = new int[n4];
            int n7 = n6;
            boolean[] blArray2 = blArray;
            int n8 = blArray2.length;
            for (int i = 0; i < n8; ++i) {
                boolean bl = blArray2[i];
                if (!bl) continue;
                --n7;
            }
            n3 = -n;
            n5 = 0;
            for (n8 = 0; n8 < n4; ++n8) {
                Component component = container.getComponents()[n8];
                if (component.isVisible()) {
                    Dimension dimension3 = this.getPreferred(component);
                    n2 = 0;
                    if (n3 > 0 && !blArray[n8]) {
                        n2 = Math.max(1, n3 / n7);
                        n3 -= n2;
                        --n7;
                    }
                    nArray[n8] = this.d.getPrimary(dimension3) - n2;
                    if (nArray[n8] >= this.d.getPrimary(component.getMinimumSize())) continue;
                    blArray[n8] = true;
                    ++n5;
                    continue;
                }
                nArray[n8] = 0;
            }
        } while (n5 != 0);
        for (n3 = 0; n3 < n4; ++n3) {
            Component component = container.getComponents()[n3];
            if (!component.isVisible()) continue;
            Dimension dimension4 = this.getPreferred(component);
            this.shrink(dimension4, dimension);
            int n9 = 0;
            n2 = 0;
            EnumSet<SLayout> enumSet = this.constraints.get(component);
            if (enumSet.contains((Object)SLayout.EXPAND_PERPENDICULAR)) {
                this.d.setSecondary(dimension4, this.d.getSecondary(dimension));
            } else {
                n9 = this.getXAlignment(component, dimension);
                n2 = this.getYAlignment(component, dimension);
            }
            this.d.setPrimary(dimension4, nArray[n3]);
            component.setBounds(dimension2.width + n9, dimension2.height + n2, dimension4.width, dimension4.height);
            this.shiftByPrimary(dimension2, dimension4);
            this.addToPrimary(dimension2, this.padding);
        }
    }

    private int getXAlignment(Component component, Dimension dimension) {
        if (this.d == horizontalDirection) {
            return 0;
        }
        return this.getPerpendicularAlignment(component, dimension);
    }

    private int getYAlignment(Component component, Dimension dimension) {
        if (this.d == horizontalDirection) {
            return this.getPerpendicularAlignment(component, dimension);
        }
        return 0;
    }

    private int getPerpendicularAlignment(Component component, Dimension dimension) {
        int n = 0;
        int n2 = this.d.getSecondary(dimension) - this.d.getSecondary(component.getPreferredSize());
        if (n2 > 0) {
            n = (int)((float)n2 * this.d.getComponentAlignment(component));
        }
        return n;
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        if (this.cachedMaximum != null) {
            return new Dimension(this.cachedMaximum);
        }
        Dimension dimension = new Dimension();
        int n = 0;
        for (Component component : container.getComponents()) {
            if (!component.isVisible()) continue;
            ++n;
            this.d.addComponentDimensions(dimension, component.getMaximumSize());
        }
        if (n > 1) {
            this.d.setPrimary(dimension, SBoxLayout.safeAdd(this.d.getPrimary(dimension), (n - 1) * this.padding));
        }
        Insets insets = container.getInsets();
        dimension.width = SBoxLayout.safeAdd(dimension.width, insets.left + insets.right);
        dimension.height = SBoxLayout.safeAdd(dimension.height, insets.top + insets.bottom);
        this.cachedMaximum = dimension;
        return dimension;
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        if (this.cachedMinimum != null) {
            return new Dimension(this.cachedMinimum);
        }
        Dimension dimension = new Dimension();
        int n = 0;
        for (Component component : container.getComponents()) {
            if (!component.isVisible()) continue;
            ++n;
            this.d.addComponentDimensions(dimension, component.getMinimumSize());
        }
        if (n > 1) {
            this.d.setPrimary(dimension, SBoxLayout.safeAdd(this.d.getPrimary(dimension), (n - 1) * this.padding));
        }
        Insets insets = container.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        this.cachedMinimum = dimension;
        return dimension;
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        if (this.cachedPreferred != null) {
            return new Dimension(this.cachedPreferred);
        }
        Dimension dimension = new Dimension();
        int n = 0;
        for (Component component : container.getComponents()) {
            if (!component.isVisible()) continue;
            ++n;
            this.d.addComponentDimensions(dimension, this.getPreferred(component));
        }
        if (n > 1) {
            this.d.setPrimary(dimension, SBoxLayout.safeAdd(this.d.getPrimary(dimension), (n - 1) * this.padding));
        }
        Insets insets = container.getInsets();
        dimension.width = SBoxLayout.safeAdd(dimension.width, insets.left + insets.right);
        dimension.height = SBoxLayout.safeAdd(dimension.height, insets.top + insets.bottom);
        Dimension dimension2 = container.getMaximumSize();
        Dimension dimension3 = container.getMinimumSize();
        this.expand(dimension, dimension3);
        this.shrink(dimension, dimension2);
        this.cachedPreferred = dimension;
        return dimension;
    }

    @Override
    public void removeLayoutComponent(Component component) {
        EnumSet<SLayout> enumSet = this.constraints.get(component);
        if (enumSet.contains((Object)SLayout.EXPAND_AXIAL)) {
            --this.expandable;
        }
        this.constraints.remove(component);
    }

    private void shiftByPrimary(Dimension dimension, Dimension dimension2) {
        this.addToPrimary(dimension, this.d.getPrimary(dimension2));
    }

    private void shrink(Dimension dimension, Dimension dimension2) {
        dimension.width = Math.min(dimension.width, dimension2.width);
        dimension.height = Math.min(dimension.height, dimension2.height);
    }

    private static int safeAdd(int n, int n2) {
        int n3 = n + n2;
        if (n3 >= 0) {
            return n3;
        }
        return Integer.MAX_VALUE;
    }

    public static JComponent addSpring(Container container) {
        Spring spring = new Spring();
        container.add((Component)spring, (Object)SLayout.EXPAND_AXIAL);
        return spring;
    }

    public static JComponent createContainer(boolean bl) {
        Spring spring = new Spring();
        spring.setLayout(new SBoxLayout(bl));
        return spring;
    }

    public static JComponent createContainer(boolean bl, int n) {
        Spring spring = new Spring();
        spring.setLayout(new SBoxLayout(bl, n));
        return spring;
    }

    private static class Spring
    extends JComponent {
        private static final long serialVersionUID = -6405699460017588727L;

        private Spring() {
        }
    }

    private static class VDirection
    implements Direction {
        private VDirection() {
        }

        @Override
        public SLayout translate(SLayout sLayout) {
            if (sLayout == SLayout.EXPAND_X) {
                sLayout = SLayout.EXPAND_PERPENDICULAR;
            } else if (sLayout == SLayout.EXPAND_Y) {
                sLayout = SLayout.EXPAND_AXIAL;
            }
            return sLayout;
        }

        @Override
        public void addComponentDimensions(Dimension dimension, Dimension dimension2) {
            dimension.width = Math.max(dimension.width, dimension2.width);
            dimension.height = SBoxLayout.safeAdd(dimension.height, dimension2.height);
        }

        @Override
        public int getPrimary(Dimension dimension) {
            return dimension.height;
        }

        @Override
        public int getSecondary(Dimension dimension) {
            return dimension.width;
        }

        @Override
        public void setPrimary(Dimension dimension, int n) {
            dimension.height = n;
        }

        @Override
        public void setSecondary(Dimension dimension, int n) {
            dimension.width = n;
        }

        @Override
        public float getComponentAlignment(Component component) {
            return component.getAlignmentX();
        }
    }

    private static class HDirection
    implements Direction {
        private HDirection() {
        }

        @Override
        public SLayout translate(SLayout sLayout) {
            if (sLayout == SLayout.EXPAND_X) {
                sLayout = SLayout.EXPAND_AXIAL;
            } else if (sLayout == SLayout.EXPAND_Y) {
                sLayout = SLayout.EXPAND_PERPENDICULAR;
            }
            return sLayout;
        }

        @Override
        public void addComponentDimensions(Dimension dimension, Dimension dimension2) {
            dimension.width = SBoxLayout.safeAdd(dimension.width, dimension2.width);
            dimension.height = Math.max(dimension.height, dimension2.height);
        }

        @Override
        public int getPrimary(Dimension dimension) {
            return dimension.width;
        }

        @Override
        public int getSecondary(Dimension dimension) {
            return dimension.height;
        }

        @Override
        public void setPrimary(Dimension dimension, int n) {
            dimension.width = n;
        }

        @Override
        public void setSecondary(Dimension dimension, int n) {
            dimension.height = n;
        }

        @Override
        public float getComponentAlignment(Component component) {
            return component.getAlignmentY();
        }
    }

    private static interface Direction {
        public SLayout translate(SLayout var1);

        public float getComponentAlignment(Component var1);

        public void addComponentDimensions(Dimension var1, Dimension var2);

        public void setPrimary(Dimension var1, int var2);

        public void setSecondary(Dimension var1, int var2);

        public int getPrimary(Dimension var1);

        public int getSecondary(Dimension var1);
    }
}

