/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.map;

import games.stendhal.client.entity.EntityChangeListener;
import games.stendhal.client.entity.IEntity;
import games.stendhal.client.entity.Player;
import games.stendhal.client.entity.RPEntity;
import games.stendhal.client.entity.User;
import games.stendhal.client.gui.map.RPEntityMapObject;
import java.awt.Color;
import java.awt.Graphics;

class PlayerMapObject
extends RPEntityMapObject {
    private static final Color COLOR_USER = Color.BLUE;
    private static final Color COLOR_PLAYER = Color.WHITE;
    private static final Color COLOR_GROUP = new Color(99, 61, 139);
    private static final Color COLOR_GHOST = Color.GRAY;

    PlayerMapObject(IEntity iEntity) {
        super(iEntity);
        if (iEntity instanceof User) {
            this.drawColor = COLOR_USER;
        } else if (iEntity instanceof Player) {
            final Player player = (Player)iEntity;
            this.choosePlayerColor(player);
            iEntity.addChangeListener(new EntityChangeListener<IEntity>(){

                @Override
                public void entityChanged(IEntity iEntity, Object object) {
                    if (object == RPEntity.PROP_GHOSTMODE || object == RPEntity.PROP_GROUP_MEMBERSHIP) {
                        PlayerMapObject.this.choosePlayerColor(player);
                    }
                }
            });
        }
    }

    @Override
    void draw(Graphics graphics, int n) {
        if (this.drawColor != COLOR_GHOST || User.isAdmin()) {
            super.draw(graphics, n);
        }
    }

    private void choosePlayerColor(Player player) {
        this.drawColor = player.isGhostMode() ? COLOR_GHOST : (User.isPlayerInGroup(player.getName()) ? COLOR_GROUP : COLOR_PLAYER);
    }

    @Override
    void draw(Graphics graphics, int n, Color color) {
        int n2 = this.worldToCanvas(this.x, n);
        int n3 = this.worldToCanvas(this.y, n);
        int n4 = n / 2;
        int n5 = n4 + 2;
        graphics.setColor(color);
        graphics.drawLine((n2 += n4) - n5, n3 += n4, n2 + n5, n3);
        graphics.drawLine(n2, n3 - n5, n2, n3 + n5);
    }
}

