/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.progress;

import games.stendhal.client.gui.WindowUtils;
import games.stendhal.client.gui.j2DClient;
import games.stendhal.client.gui.j2d.BackgroundPainter;
import games.stendhal.client.gui.layout.SBoxLayout;
import games.stendhal.client.gui.layout.SLayout;
import games.stendhal.client.gui.progress.ProgressStatusQuery;
import games.stendhal.client.gui.textformat.HtmlPreprocessor;
import games.stendhal.client.gui.wt.core.SettingChangeAdapter;
import games.stendhal.client.gui.wt.core.WtWindowManager;
import games.stendhal.client.sprite.DataLoader;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;

class ProgressLog {
    private static final int PAGE_WIDTH = 450;
    private static final int PAGE_HEIGHT = 300;
    private static final int INDEX_WIDTH = 180;
    private static final String BACKGROUND_IMAGE = "data/gui/scroll_background.png";
    private static final String FONT_NAME = "BlackChancery";
    private static final String IMAGE = "<img border=\"0\" style=\"border-style: none\" src='" + DataLoader.getResource("data/gui/rp.png").toString() + "'/>";
    private JDialog window;
    private final JTabbedPane tabs;
    private final List<Page> pages = new ArrayList<Page>();
    private String fontName;
    private Collection<String> repeatable = Collections.emptySet();

    ProgressLog(String string) {
        this.window = new JDialog(j2DClient.get().getMainFrame(), string);
        this.tabs = new JTabbedPane();
        this.tabs.setPreferredSize(new Dimension(450, 300));
        this.tabs.addChangeListener(new TabChangeListener());
        WindowUtils.closeOnEscape(this.window);
        this.window.setDefaultCloseOperation(2);
        this.window.add(this.tabs);
        this.window.pack();
        WindowUtils.watchFontSize(this.window);
        WindowUtils.trackLocation(this.window, "travel_log", true);
        WtWindowManager.getInstance().registerSettingChangeListener("ui.logfont", new SettingChangeAdapter("ui.logfont", FONT_NAME){

            @Override
            public void changed(String string) {
                ProgressLog.this.fontName = string;
                for (Page page : ProgressLog.this.pages) {
                    page.setFontName(string);
                }
            }
        });
    }

    void setPages(List<String> list, ProgressStatusQuery progressStatusQuery) {
        this.tabs.removeAll();
        this.pages.clear();
        for (String string : list) {
            Page page = new Page();
            page.setFontName(this.fontName);
            page.setIndexQuery(progressStatusQuery, string);
            this.tabs.add(string, page);
            this.pages.add(page);
        }
    }

    void setPageIndex(String string, List<String> list, ProgressStatusQuery progressStatusQuery) {
        Component component;
        int n = this.tabs.indexOfTab(string);
        if (n != -1 && (component = this.tabs.getComponent(n)) instanceof Page) {
            ((Page)component).setIndex(list, progressStatusQuery, this.repeatable);
        }
    }

    void setPageContent(String string, String string2, String string3, String string4, List<String> list) {
        Component component;
        int n = this.tabs.indexOfTab(string);
        if (n != -1 && (component = this.tabs.getComponent(n)) instanceof Page) {
            boolean bl = this.repeatable.contains(string2);
            ((Page)component).setContent(string2, string3, string4, list, bl);
        }
    }

    void setRepeatable(Collection<String> collection) {
        this.repeatable = collection;
    }

    Window getWindow() {
        return this.window;
    }

    private static class PrettyEditorPane
    extends JEditorPane {
        private final BackgroundPainter background = new BackgroundPainter("data/gui/scroll_background.png");

        public PrettyEditorPane() {
            this.setOpaque(false);
            this.setContentType("text/html");
            this.setEditable(false);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            this.background.paint(graphics, this.getWidth(), this.getHeight());
            super.paintComponent(graphics);
        }
    }

    private class Page
    extends JComponent
    implements HyperlinkListener {
        private final JEditorPane indexArea;
        private final JEditorPane contentArea;
        private final JScrollPane indexScrollPane;
        private final JScrollPane contentScrollPane;
        private ProgressStatusQuery indexQuery;
        private String indexQueryData;
        private ProgressStatusQuery contentQuery;
        private String contentQueryData;
        private String fontName;

        Page() {
            this.setLayout(new SBoxLayout(false));
            JComponent jComponent = SBoxLayout.createContainer(true, 5);
            this.add((Component)jComponent, SBoxLayout.constraint(SLayout.EXPAND_X, SLayout.EXPAND_Y));
            this.indexArea = new PrettyEditorPane();
            this.indexArea.addHyperlinkListener(this);
            this.indexScrollPane = new JScrollPane(this.indexArea);
            this.indexScrollPane.setMaximumSize(new Dimension(180, Integer.MAX_VALUE));
            this.indexScrollPane.setMinimumSize(new Dimension(180, 0));
            Caret caret = this.indexArea.getCaret();
            if (caret instanceof DefaultCaret) {
                ((DefaultCaret)caret).setUpdatePolicy(1);
            }
            jComponent.add((Component)this.indexScrollPane, (Object)SLayout.EXPAND_Y);
            this.contentArea = new PrettyEditorPane();
            this.contentScrollPane = new JScrollPane(this.contentArea);
            jComponent.add((Component)this.contentScrollPane, SBoxLayout.constraint(SLayout.EXPAND_X, SLayout.EXPAND_Y));
            JComponent jComponent2 = SBoxLayout.createContainer(true, 5);
            jComponent2.setAlignmentX(1.0f);
            jComponent2.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 5));
            this.add(jComponent2);
            JButton jButton = new JButton("Update");
            jButton.setMnemonic(85);
            jButton.setAlignmentX(1.0f);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Page.this.update();
                }
            });
            jComponent2.add(jButton);
            JButton jButton2 = new JButton("Close");
            jButton2.setMnemonic(67);
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ProgressLog.this.getWindow().dispose();
                }
            });
            jComponent2.add(jButton2);
        }

        void update() {
            if (this.indexQuery != null) {
                this.indexQuery.fire(this.indexQueryData);
            }
            if (this.contentQuery != null && this.contentQueryData != null) {
                this.contentQuery.fire(this.contentQueryData);
            }
        }

        void setIndexQuery(ProgressStatusQuery progressStatusQuery, String string) {
            this.indexQuery = progressStatusQuery;
            this.indexQueryData = string;
        }

        void setFontName(String string) {
            this.fontName = string;
            this.updateOnFontChange();
        }

        @Override
        public void setFont(Font font) {
            super.setFont(font);
            this.updateOnFontChange();
        }

        private void updateOnFontChange() {
            Container container = this.getTopLevelAncestor();
            if (container != null && container.isVisible()) {
                this.update();
            }
        }

        void setIndex(List<String> list, ProgressStatusQuery progressStatusQuery, Collection<String> collection) {
            Collections.sort(list);
            StringBuilder stringBuilder = new StringBuilder("<html>");
            stringBuilder.append(this.createStyleDefinition());
            for (String string : list) {
                stringBuilder.append("<p>");
                if (progressStatusQuery != null) {
                    stringBuilder.append("<a href=\"");
                    stringBuilder.append(string);
                    stringBuilder.append("\">");
                    stringBuilder.append(string);
                    if (collection.contains(string)) {
                        stringBuilder.append(IMAGE);
                    }
                    stringBuilder.append("</a>");
                    continue;
                }
                stringBuilder.append(string);
                if (!collection.contains(string)) continue;
                stringBuilder.append(IMAGE);
            }
            stringBuilder.append("</html>");
            this.contentQuery = progressStatusQuery;
            this.indexArea.setText(stringBuilder.toString());
        }

        private String createStyleDefinition() {
            int n = this.getFont().getSize() + 2;
            return "<style type=\"text/css\">body {font-family:" + this.fontName + "; font-size:" + n + "; margin:12px} p {margin:4px 0px} a {color:#a00000} li, ul {margin-left:10px}</style>";
        }

        void setContent(String string, String string2, String string3, List<String> list, boolean bl) {
            StringBuilder stringBuilder = new StringBuilder("<html>");
            stringBuilder.append(this.createStyleDefinition());
            if (string != null) {
                stringBuilder.append("<h2>");
                stringBuilder.append(string);
                stringBuilder.append("</h2>");
            }
            if (bl) {
                stringBuilder.append("<p style=\"font-family:arial; color: #000080\"><b>");
                stringBuilder.append(IMAGE);
                stringBuilder.append("I can do this quest again.");
                stringBuilder.append("</b></p>");
            }
            if (string3 != null && !string3.trim().equals("")) {
                stringBuilder.append("<p style=\"font-family:arial; color: #FF0000\"><b>");
                stringBuilder.append(string3);
                stringBuilder.append("</b></p>");
            }
            if (string2 != null) {
                stringBuilder.append("<p><i>");
                stringBuilder.append(string2);
                stringBuilder.append("</i></p>");
            }
            HtmlPreprocessor htmlPreprocessor = new HtmlPreprocessor();
            if (!list.isEmpty()) {
                stringBuilder.append("<ul>");
                for (String string4 : list) {
                    stringBuilder.append("<li>");
                    stringBuilder.append(htmlPreprocessor.preprocess(string4));
                    stringBuilder.append("</li>");
                }
                stringBuilder.append("</ul>");
            }
            stringBuilder.append("</html>");
            this.contentArea.setText(stringBuilder.toString());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Page.this.contentScrollPane.getVerticalScrollBar().setValue(0);
                }
            });
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                this.contentQueryData = hyperlinkEvent.getDescription();
                if (this.contentQuery != null) {
                    this.contentQuery.fire(this.contentQueryData);
                }
            }
        }
    }

    private class TabChangeListener
    implements ChangeListener {
        private TabChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            Component component = ProgressLog.this.tabs.getSelectedComponent();
            if (component instanceof Page) {
                ((Page)component).update();
            }
        }
    }
}

