/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.styled;

import games.stendhal.client.gui.styled.Style;
import games.stendhal.client.gui.styled.StyleUtil;
import games.stendhal.client.gui.styled.StyledArrowButton;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.plaf.basic.BasicComboBoxUI;

public class StyledComboBoxUI
extends BasicComboBoxUI {
    private final Style style;

    public static ComponentUI createUI(JComponent jComponent) {
        return new StyledComboBoxUI(StyleUtil.getStyle());
    }

    public StyledComboBoxUI(Style style) {
        this.style = style;
    }

    @Override
    protected JButton createArrowButton() {
        return new StyledArrowButton(5, this.style);
    }

    protected ListCellRenderer<?> createRenderer() {
        return new StyledComboBoxRenderer();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.setBorder(this.style.getBorderDown());
        this.listBox.setSelectionBackground(this.style.getShadowColor());
        this.listBox.setSelectionForeground(this.style.getForeground());
    }

    private static class StyledComboBoxRenderer
    extends BasicComboBoxRenderer {
        private StyledComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (component instanceof JComponent) {
                JComponent jComponent = (JComponent)component;
                jComponent.setOpaque(true);
            }
            return component;
        }
    }
}

