/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.styled;

import games.stendhal.client.gui.styled.Style;
import games.stendhal.client.gui.styled.StyleUtil;
import games.stendhal.client.gui.styled.StyledArrowButton;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class StyledScrollBarUI
extends BasicScrollBarUI {
    private final Style style;

    public static ComponentUI createUI(JComponent jComponent) {
        return new StyledScrollBarUI(StyleUtil.getStyle());
    }

    public StyledScrollBarUI(Style style) {
        this.style = style;
    }

    @Override
    protected void paintTrack(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        graphics.setColor(this.style.getHighLightColor());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(this.style.getShadowColor());
        int n = rectangle.width;
        int n2 = rectangle.height;
        if (this.scrollbar.getOrientation() == 0) {
            --n2;
        } else {
            --n;
        }
        graphics.drawRect(rectangle.x, rectangle.y, n, n2);
    }

    @Override
    protected void paintThumb(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        StyleUtil.fillBackground(this.style, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.style.getBorder().paintBorder(jComponent, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    protected JButton createDecreaseButton(int n) {
        return new StyledArrowButton(n, this.style);
    }

    @Override
    protected JButton createIncreaseButton(int n) {
        return new StyledArrowButton(n, this.style);
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.setForeground(this.style.getForeground());
    }
}

