/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.textformat;

import games.stendhal.client.gui.textformat.AttributedTextSink;
import games.stendhal.client.gui.textformat.TextAttributeSet;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AttributedStringBuilder
implements AttributedTextSink<TextAttributeSet> {
    private final StringBuilder stringBuilder = new StringBuilder();
    private final List<AttributeDefinition> attributeList = new ArrayList<AttributeDefinition>();

    public String toString() {
        return this.stringBuilder.toString();
    }

    @Override
    public void append(String string, TextAttributeSet textAttributeSet) {
        int n = this.stringBuilder.length();
        int n2 = n + string.length();
        this.stringBuilder.append(string);
        this.attributeList.add(new AttributeDefinition(textAttributeSet, n, n2));
    }

    public AttributedString toAttributedString() {
        AttributedString attributedString = new AttributedString(this.toString());
        for (AttributeDefinition attributeDefinition : this.attributeList) {
            attributeDefinition.apply(attributedString);
        }
        return attributedString;
    }

    private static class AttributeDefinition {
        private final TextAttributeSet attrs;
        private final int beginIndex;
        private final int endIndex;

        AttributeDefinition(TextAttributeSet textAttributeSet, int n, int n2) {
            this.attrs = textAttributeSet;
            this.beginIndex = n;
            this.endIndex = n2;
        }

        void apply(AttributedString attributedString) {
            attributedString.addAttributes((Map<? extends AttributedCharacterIterator.Attribute, ?>)this.attrs.contents(), this.beginIndex, this.endIndex);
        }
    }
}

