/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.scripting;

import games.stendhal.client.entity.User;
import games.stendhal.client.gui.chatlog.StandardEventLine;
import games.stendhal.client.gui.j2DClient;
import java.io.IOException;
import java.io.PrintStream;

public class ScriptRecorder {
    private final String classname;
    private final String filename;
    private final PrintStream ps;
    private long lastTimestamp;

    public ScriptRecorder(String string) throws IOException {
        this.classname = string;
        this.filename = System.getProperty("java.io.tmpdir") + "/" + string + ".java";
        j2DClient.get().addEventLine(new StandardEventLine("Starting recoding to " + this.filename));
        this.lastTimestamp = 0L;
        this.ps = new PrintStream(this.filename, "UTF-8");
    }

    public void start() {
        this.ps.println("package games.stendhal.client.script;");
        this.ps.println("import games.stendhal.client.scripting.*;");
        this.ps.println("/**");
        this.ps.println(" * TODO: write documentation");
        this.ps.println(" * ");
        this.ps.println(" * @author recorded by " + User.get().getName());
        this.ps.println(" */");
        this.ps.println("public class " + this.classname + " extends ClientScriptImpl {");
        this.ps.println("");
        this.ps.println("\t@Override");
        this.ps.println("\tpublic void run(String args) {");
        this.lastTimestamp = System.currentTimeMillis();
    }

    public void recordChatLine(String string) {
        if (string.startsWith("/record")) {
            return;
        }
        long l = System.currentTimeMillis();
        long l2 = l - this.lastTimestamp;
        if (l2 > 5000L) {
            this.ps.println("");
            if (l2 > 60000L) {
                this.ps.println("\t\t// -----------------------------------");
            }
            this.ps.println("\t\tcsi.sleepSeconds(" + l2 / 1000L + ");");
        } else if (l2 > 0L) {
            this.ps.println("\t\tcsi.sleepMillis(" + l2 + ");");
        }
        this.ps.println("\t\tcsi.invoke(\"" + string.replace("\"", "\\\"") + "\");");
        this.lastTimestamp = l + 300L;
    }

    public void end() {
        this.ps.println("\t}");
        this.ps.println("}");
        this.ps.close();
        j2DClient.get().addEventLine(new StandardEventLine("Stopping recoding to " + this.filename));
    }
}

