/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.scripting;

import games.stendhal.client.actions.SlashActionRepository;
import games.stendhal.client.scripting.SlashActionCommand;
import games.stendhal.common.CommandlineParser;

class SlashActionParser
extends CommandlineParser {
    private SlashActionParser(String string) {
        super(string);
    }

    private SlashActionCommand extractCommand() {
        SlashActionCommand slashActionCommand = new SlashActionCommand();
        char c = this.ci.current();
        if (c == '\uffff') {
            slashActionCommand.setError("Missing slash command");
            return slashActionCommand;
        }
        if (Character.isWhitespace(c)) {
            slashActionCommand.setError("Unexpected space after slash character");
            return slashActionCommand;
        }
        if (Character.isLetterOrDigit(c)) {
            StringBuilder stringBuilder = new StringBuilder();
            while (c != '\uffff' && !Character.isWhitespace(c)) {
                stringBuilder.append(c);
                c = this.ci.next();
            }
            slashActionCommand.setName(stringBuilder.toString());
        } else {
            slashActionCommand.setName(String.valueOf(c));
            this.ci.next();
        }
        return slashActionCommand;
    }

    static SlashActionCommand parse(String string) {
        int n;
        int n2;
        SlashActionParser slashActionParser = new SlashActionParser(string);
        SlashActionCommand slashActionCommand = slashActionParser.extractCommand();
        if (slashActionCommand.hasError()) {
            return slashActionCommand;
        }
        slashActionCommand.setAction(SlashActionRepository.get(slashActionCommand.getName()));
        if (slashActionCommand.getAction() != null) {
            n2 = slashActionCommand.getAction().getMinimumParameters();
            n = slashActionCommand.getAction().getMaximumParameters();
        } else {
            n2 = 0;
            n = 1;
        }
        slashActionCommand.setParams(new String[n]);
        slashActionParser.extractParameters(slashActionCommand, n2, n);
        slashActionCommand.setRemainder(slashActionParser.getRemainingText());
        return slashActionCommand;
    }

    private String getRemainingText() {
        this.skipWhitespace();
        StringBuilder stringBuilder = new StringBuilder(this.ci.getEndIndex() - this.ci.getIndex() + 1);
        while (this.ci.current() != '\uffff') {
            stringBuilder.append(this.ci.current());
            this.ci.next();
        }
        return stringBuilder.toString();
    }

    private boolean extractParameters(SlashActionCommand slashActionCommand, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.skipWhitespace();
            if (this.ci.current() == '\uffff') {
                if (i >= n) break;
                slashActionCommand.setError("Missing command parameter for '" + slashActionCommand.getName() + "'");
                return false;
            }
            slashActionCommand.getParams()[i] = this.getNextParameter(slashActionCommand);
            if (!slashActionCommand.hasError()) continue;
            return false;
        }
        return true;
    }
}

