/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.sound.facade;

import games.stendhal.client.sound.facade.AudibleArea;
import games.stendhal.common.math.Algebra;
import games.stendhal.common.math.Geometry;

public class AudibleCapsuleArea
implements AudibleArea {
    private float[] mStartPoint;
    private float[] mEndPoint;
    private float mInnerRadius;
    private float mOuterRadius;

    public AudibleCapsuleArea(float[] fArray, float[] fArray2, float f, float f2) {
        this.mStartPoint = (float[])fArray.clone();
        this.mEndPoint = (float[])fArray2.clone();
        this.mInnerRadius = f;
        this.mOuterRadius = f2;
    }

    public void setArea(float f, float f2) {
        this.mInnerRadius = f;
        this.mOuterRadius = f2;
    }

    public void setStartPoint(float[] fArray) {
        Algebra.mov_Vecf(this.mStartPoint, fArray);
    }

    public void setEndPoint(float[] fArray) {
        Algebra.mov_Vecf(this.mEndPoint, fArray);
    }

    public void getStartPoint(float[] fArray) {
        Algebra.mov_Vecf(fArray, this.mStartPoint);
    }

    public void getEndPoint(float[] fArray) {
        Algebra.mov_Vecf(fArray, this.mEndPoint);
    }

    public float getInnerRadius() {
        return this.mInnerRadius;
    }

    public float getOuterRadius() {
        return this.mOuterRadius;
    }

    @Override
    public float getHearingIntensity(float[] fArray) {
        float f = Geometry.distanceSqrt_LinePointf(this.mStartPoint, this.mEndPoint, fArray);
        if (f > this.mOuterRadius * this.mOuterRadius) {
            return 0.0f;
        }
        if (f < this.mInnerRadius * this.mInnerRadius) {
            return 1.0f;
        }
        f = (float)Math.sqrt(f) - this.mInnerRadius;
        return 1.0f - f / (this.mOuterRadius - this.mInnerRadius);
    }

    @Override
    public void getClosestPoint(float[] fArray, float[] fArray2) {
        Geometry.closestPoint_CapsulePointf(fArray, this.mStartPoint, this.mEndPoint, this.mInnerRadius, fArray2);
    }
}

