/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.sound.sound;

import games.stendhal.client.sound.facade.SoundGroup;
import games.stendhal.client.sound.facade.SoundHandle;
import games.stendhal.client.sound.facade.SoundSystemFacade;
import games.stendhal.client.sound.facade.Time;
import games.stendhal.client.sound.manager.DeviceEvaluator;
import games.stendhal.client.sound.manager.SoundManagerNG;
import games.stendhal.client.sound.sound.ExtendedSoundManager;
import games.stendhal.common.math.Algebra;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class SoundSystemFacadeImpl
implements SoundSystemFacade {
    private static Logger logger = Logger.getLogger(SoundSystemFacadeImpl.class);
    private ExtendedSoundManager manager = new ExtendedSoundManager();

    @Override
    public void positionChanged(double d, double d2) {
        try {
            float[] fArray = Algebra.vecf((float)d, (float)d2);
            this.manager.setHearerPosition(fArray);
            this.manager.update();
        }
        catch (RuntimeException runtimeException) {
            logger.error((Object)runtimeException, (Throwable)runtimeException);
        }
    }

    @Override
    public void exit() {
        try {
            this.manager.exit();
        }
        catch (RuntimeException runtimeException) {
            logger.error((Object)runtimeException, (Throwable)runtimeException);
        }
    }

    @Override
    public SoundGroup getGroup(String string) {
        return this.manager.getGroup(string);
    }

    @Override
    public void update() {
        try {
            this.manager.update();
        }
        catch (RuntimeException runtimeException) {
            logger.error((Object)runtimeException, (Throwable)runtimeException);
        }
    }

    @Override
    public void stop(SoundHandle soundHandle, Time time) {
        if (soundHandle != null) {
            try {
                if (soundHandle instanceof SoundManagerNG.Sound) {
                    this.manager.stop((SoundManagerNG.Sound)soundHandle, time);
                } else {
                    logger.error((Object)("sound handle not instance of Sound but " + soundHandle), new Throwable());
                }
            }
            catch (RuntimeException runtimeException) {
                logger.error((Object)runtimeException, (Throwable)runtimeException);
            }
        }
    }

    @Override
    public void mute(boolean bl, boolean bl2, Time time) {
        this.manager.mute(bl, bl2, time);
    }

    @Override
    public float getVolume() {
        return this.manager.getVolume();
    }

    @Override
    public Collection<String> getGroupNames() {
        return this.manager.getGroupNames();
    }

    @Override
    public void changeVolume(float f) {
        this.manager.changeVolume(f);
    }

    @Override
    public List<String> getDeviceNames() {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (DeviceEvaluator.Device device : this.manager.getDevices()) {
            linkedList.add(device.getName());
        }
        return linkedList;
    }
}

