/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.sound.system.processors;

import games.stendhal.client.sound.system.SignalProcessor;
import games.stendhal.common.memory.Field;

public class Recorder
extends SignalProcessor {
    private float[] mData = null;
    private int mNumChannels = 1;
    private int mSampleRate = 0;
    private int mNumSamplesBuffered = 0;

    public Player createPlayer(int n) {
        return new Player(n);
    }

    public synchronized void clear() {
        this.mNumSamplesBuffered = 0;
        this.mData = null;
    }

    public synchronized int getNumChannels() {
        return this.mNumChannels;
    }

    public synchronized int getSampleRate() {
        return this.mSampleRate;
    }

    public synchronized int getNumSamples() {
        return this.mNumSamplesBuffered / this.mNumChannels;
    }

    public synchronized void trim() {
        if (this.mData.length != this.mNumSamplesBuffered) {
            float[] fArray = new float[this.mNumSamplesBuffered];
            System.arraycopy(this.mData, 0, fArray, 0, this.mNumSamplesBuffered);
            this.mData = fArray;
        }
    }

    @Override
    protected void finished() {
        this.trim();
        super.quit();
    }

    @Override
    protected synchronized void modify(float[] fArray, int n, int n2, int n3) {
        if (fArray == null || n == 0) {
            return;
        }
        if (this.mData == null) {
            this.mData = new float[n * n2 * 3];
            this.mNumChannels = n2;
            this.mSampleRate = n3;
        }
        assert (this.mNumChannels == n2 && this.mSampleRate == n3);
        int n4 = this.mData.length - this.mNumSamplesBuffered;
        int n5 = n * n2;
        if (n4 < n5) {
            this.mData = Field.expand(this.mData, (this.mNumSamplesBuffered + n5) * 2, true);
        }
        System.arraycopy(fArray, 0, this.mData, this.mNumSamplesBuffered, n5);
        this.mNumSamplesBuffered += n5;
        super.propagate(fArray, n, n2, n3);
    }

    public class Player
    extends SignalProcessor {
        private float[] mOutputBuffer;
        private int mNumSamplesRead = 0;

        private Player(int n) {
            this.mOutputBuffer = new float[n * Recorder.this.mNumChannels];
        }

        public synchronized void restart() {
            this.mNumSamplesRead = 0;
        }

        public synchronized boolean reachedEndOfStream() {
            return this.mNumSamplesRead >= Recorder.this.mNumSamplesBuffered;
        }

        public synchronized int getNumChannels() {
            return Recorder.this.mNumChannels;
        }

        public synchronized int getSampleRate() {
            return Recorder.this.mSampleRate;
        }

        public synchronized int getNumSamples() {
            return Recorder.this.mNumSamplesBuffered / Recorder.this.mNumChannels;
        }

        @Override
        protected synchronized boolean generate() {
            if (this.reachedEndOfStream()) {
                super.quit();
                return false;
            }
            int n = this.mOutputBuffer.length;
            int n2 = Recorder.this.mNumSamplesBuffered - this.mNumSamplesRead;
            int n3 = Math.min(n, n2);
            System.arraycopy(Recorder.this.mData, this.mNumSamplesRead, this.mOutputBuffer, 0, n3);
            this.mNumSamplesRead += n3;
            super.propagate(this.mOutputBuffer, n3 / Recorder.this.mNumChannels, Recorder.this.mNumChannels, Recorder.this.mSampleRate);
            return true;
        }
    }
}

