/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.sprite;

import games.stendhal.client.gui.TransparencyMode;
import games.stendhal.client.sprite.EmptySprite;
import games.stendhal.client.sprite.Sprite;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class ImageSprite
implements Sprite {
    private Image image;
    private Object reference;

    public ImageSprite(Image image) {
        this(image, null);
    }

    public ImageSprite(Image image, Object object) {
        this.image = image;
        this.reference = object;
    }

    public ImageSprite(Sprite sprite) {
        this(sprite, null);
    }

    private ImageSprite(Sprite sprite, Object object) {
        this.reference = object;
        this.image = ImageSprite.getGC().createCompatibleImage(sprite.getWidth(), sprite.getHeight(), TransparencyMode.TRANSPARENCY);
        sprite.draw(this.image.getGraphics(), 0, 0);
    }

    protected static GraphicsConfiguration getGC() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    public Graphics getGraphics() {
        return this.image.getGraphics();
    }

    @Override
    public Sprite createRegion(int n, int n2, int n3, int n4, Object object) {
        int n5 = this.getWidth();
        int n6 = this.getHeight();
        if (n >= n5 || n2 >= n6) {
            return new EmptySprite(n3, n4, object);
        }
        n3 = Math.min(n3, n5);
        n4 = Math.min(n4, n6);
        GraphicsConfiguration graphicsConfiguration = ImageSprite.getGC();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n3, n4, TransparencyMode.TRANSPARENCY);
        this.draw(((Image)bufferedImage).getGraphics(), 0, 0, n, n2, n3, n4);
        return new ImageSprite(bufferedImage, object);
    }

    @Override
    public void draw(Graphics graphics, int n, int n2) {
        graphics.drawImage(this.image, n, n2, null);
    }

    @Override
    public void draw(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.drawImage(this.image, n, n2, n + n5, n2 + n6, n3, n4, n3 + n5, n4 + n6, null);
    }

    @Override
    public int getHeight() {
        return this.image.getHeight(null);
    }

    @Override
    public Object getReference() {
        return this.reference;
    }

    @Override
    public int getWidth() {
        return this.image.getWidth(null);
    }
}

