/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.common;

import org.apache.log4j.Logger;

public class Level {
    private static final Logger logger;
    private static final int LEVELS = 598;
    private static int[] xp;
    private static double[] wisdom;

    public static void main(String[] stringArray) {
        for (int i = 0; i < 598; ++i) {
            System.out.println("<tr><td>" + i + "</td><td>" + xp[i] + "</td></tr>");
        }
    }

    public static int maxLevel() {
        return 597;
    }

    public static int getLevel(int n) {
        int n2 = 0;
        int n3 = 597;
        if (n <= xp[n2]) {
            return n2;
        }
        if (n >= xp[n3]) {
            return n3;
        }
        while (n3 - n2 > 1) {
            int n4 = n2 + (n3 - n2) / 2;
            if (n < xp[n4]) {
                n3 = n4;
                continue;
            }
            n2 = n4;
        }
        return n2;
    }

    public static int getXP(int n) {
        if (n >= 0 && n < xp.length) {
            return xp[n];
        }
        return -1;
    }

    public static int changeLevel(int n, int n2) {
        int n3;
        for (n3 = 0; n3 < 598 && n >= xp[n3]; ++n3) {
        }
        for (int i = n3; i <= 598; ++i) {
            if (n + n2 >= xp[i]) continue;
            return i - n3;
        }
        return 0;
    }

    public static double getWisdom(int n) {
        if (n > 598) {
            return wisdom[598];
        }
        return wisdom[n];
    }

    static {
        int n;
        logger = Logger.getLogger(Level.class);
        xp = new int[599];
        Level.xp[0] = 0;
        Level.xp[1] = 50;
        Level.xp[2] = 100;
        Level.xp[3] = 200;
        Level.xp[4] = 400;
        Level.xp[5] = 800;
        for (n = 5; n < 598; ++n) {
            int n2;
            Level.xp[n + 1] = n2 = (n * 16 + n * n * 5 + n * n * n * 10 + 300) / 100 * 100;
        }
        if (logger.isDebugEnabled()) {
            for (n = 0; n < 598; ++n) {
                logger.debug((Object)("Level " + n + ": " + xp[n] + " xp"));
            }
        }
        wisdom = new double[598];
        for (n = 0; n < 598; ++n) {
            Level.wisdom[n] = 1.0 - 1.0 / Math.pow(1.01, n);
        }
        if (logger.isDebugEnabled()) {
            for (n = 0; n < 598; ++n) {
                logger.debug((Object)("Level " + n + ": " + (int)(wisdom[n] * 100.0 + 0.5) + " wisdom"));
            }
        }
    }
}

