/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.common.math;

import games.stendhal.common.math.Algebra;

public class Geometry {
    public static float halfSpaceTest_PlanePointf(float[] fArray, float f, float[] fArray2) {
        return Algebra.dot_Vecf(fArray2, fArray) + f;
    }

    public static float halfSpaceTest_PlanePointf(float[] fArray, float[] fArray2, float[] fArray3) {
        float[] fArray4 = new float[fArray3.length];
        Algebra.sub_Vecf(fArray4, fArray3, fArray2);
        return Algebra.dot_Vecf(fArray4, fArray);
    }

    public static boolean closestPoint_RayPointf(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4) {
        Algebra.sub_Vecf(fArray, fArray4, fArray2);
        float f = Algebra.dot_Vecf(fArray3, fArray) / Algebra.dot_Vecf(fArray3, fArray3);
        Algebra.mul_Vecf(fArray, fArray3, f);
        Algebra.add_Vecf(fArray, fArray, fArray2);
        return !Algebra.isEqual_Vecf(fArray, fArray4);
    }

    public static boolean closestPoint_SpherePointf(float[] fArray, float[] fArray2, float f, float[] fArray3) {
        if (Algebra.isEqual_Vecf(fArray2, fArray3)) {
            return false;
        }
        Algebra.sub_Vecf(fArray, fArray3, fArray2);
        Algebra.normalize_Vecf(fArray, fArray);
        Algebra.mul_Vecf(fArray, fArray, f);
        Algebra.add_Vecf(fArray, fArray, fArray2);
        return true;
    }

    public static boolean closestPoint_CapsulePointf(float[] fArray, float[] fArray2, float[] fArray3, float f, float[] fArray4) {
        float[] fArray5 = new float[fArray4.length];
        Algebra.sub_Vecf(fArray5, fArray3, fArray2);
        if (Geometry.halfSpaceTest_PlanePointf(fArray5, fArray2, fArray4) > 0.0f) {
            if (Geometry.halfSpaceTest_PlanePointf(fArray5, fArray3, fArray4) < 0.0f) {
                if (!Geometry.closestPoint_RayPointf(fArray, fArray2, fArray5, fArray4)) {
                    return false;
                }
                Algebra.sub_Vecf(fArray5, fArray4, fArray);
                Algebra.normalize_Vecf(fArray5, fArray5);
                Algebra.mul_Vecf(fArray5, fArray5, f);
                Algebra.add_Vecf(fArray, fArray, fArray5);
                return true;
            }
            return Geometry.closestPoint_SpherePointf(fArray, fArray3, f, fArray4);
        }
        return Geometry.closestPoint_SpherePointf(fArray, fArray2, f, fArray4);
    }

    public static float distanceSqrt_LinePointf(float[] fArray, float[] fArray2, float[] fArray3) {
        float[] fArray4 = new float[fArray3.length];
        Algebra.sub_Vecf(fArray4, fArray2, fArray);
        if (Geometry.halfSpaceTest_PlanePointf(fArray4, fArray, fArray3) > 0.0f) {
            if (Geometry.halfSpaceTest_PlanePointf(fArray4, fArray2, fArray3) < 0.0f) {
                float[] fArray5 = new float[fArray3.length];
                Geometry.closestPoint_RayPointf(fArray5, fArray, fArray4, fArray3);
                return Algebra.distanceSqrt_Vecf(fArray3, fArray5);
            }
            return Algebra.distanceSqrt_Vecf(fArray3, fArray2);
        }
        return Algebra.distanceSqrt_Vecf(fArray, fArray3);
    }

    public static float distance_LinePointf(float[] fArray, float[] fArray2, float[] fArray3) {
        return (float)Math.sqrt(Geometry.distanceSqrt_LinePointf(fArray, fArray2, fArray3));
    }
}

