/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import java.io.Serializable;
import mikera.tyrant.Being;
import mikera.tyrant.Event;
import mikera.tyrant.Game;
import mikera.tyrant.Item;
import mikera.tyrant.Lib;
import mikera.tyrant.Map;
import mikera.tyrant.Missile;
import mikera.tyrant.Movement;
import mikera.tyrant.RPG;
import mikera.tyrant.RangedWeapon;
import mikera.tyrant.Script;
import mikera.tyrant.Spell;
import mikera.tyrant.Thing;
import mikera.tyrant.Tile;

public class AI
implements Serializable {
    private static final long serialVersionUID = 4051043086123415608L;
    public static final String STATE_HOSTILE = "Attack";
    public static final String STATE_FOLLOWER = "Follow";
    public static final String STATE_INHABITANT = "Wander";
    public static final int EVENT_ATTACKED = 1;
    public static final int EVENT_VISIBLE = 2;
    public static final int EVENT_MORALECHECK = 3;
    public static final int EVENT_FEARCHECK = 4;
    public static final int EVENT_ALARM = 5;
    public static final int EVENT_THEFT = 6;

    public static void setNeutral(Thing thing) {
        thing.set("IsHostile", 0);
        thing.set("IsNeutral", 1);
        thing.set("IsInhabitant", 1);
    }

    public static boolean isHostile(Thing thing, Thing thing2) {
        if (thing2 == thing) {
            return false;
        }
        boolean bl = thing.getFlag("IsHostile");
        boolean bl2 = thing2.getFlag("IsHostile");
        if (bl && bl2) {
            return false;
        }
        if (thing.isHero() && bl2) {
            return true;
        }
        if (thing2.isHero()) {
            if (bl) {
                return true;
            }
            if (thing2.getStat("CH") < 0) {
                return true;
            }
        }
        if (thing.getFlag("IsInsane") || thing2.getFlag("IsInsane")) {
            return true;
        }
        if (thing.name().equals(thing2.name())) {
            return false;
        }
        if (thing.getFlag("IsInhabitant") && thing2.getFlag("IsInhabitant")) {
            return false;
        }
        if (thing.getFlag("IsNeutral") || thing2.getFlag("IsNeutral")) {
            return false;
        }
        if (bl && !bl2) {
            return true;
        }
        return bl2 && !bl;
    }

    public static void turnNasty(Thing thing) {
        if (thing.isHero()) {
            throw new Error("AI.turnNasty(): Trying to affect hero!!!");
        }
        thing.set("IsHostile", 1);
        if (thing.getFlag("IsInhabitant")) {
            thing.getMap().setAngry(true);
        }
    }

    public static void reTarget(Thing thing, Thing thing2) {
        thing.set("CurrentFoe", thing2);
    }

    public static int notifyAttack(Thing thing, Thing thing2) {
        AI.notify(thing, 1, 0, thing2);
        return 0;
    }

    public static int notify(Thing thing, int n, int n2, Object object) {
        Thing thing2 = (Thing)object;
        Map map = thing.getMap();
        if (map == null) {
            return 0;
        }
        if (thing.isHero()) {
            return 0;
        }
        if (AI.isHostile(thing, Game.hero())) {
            return 0;
        }
        switch (n) {
            case 1: {
                if (thing2.isHero() && n2 == thing.getStat("Side")) {
                    if (thing.getFlag("IsIntelligent")) {
                        Game.message(thing.getTheName() + " shouts angrily!");
                    }
                    AI.turnNasty(thing);
                }
                return 0;
            }
            case 2: {
                if (thing.isHostile(Game.hero())) {
                    AI.reTarget(thing, Game.hero());
                    thing.getMap().areaNotify(thing.x, thing.y, 5, 5, 0, null);
                }
                return 1;
            }
            case 6: {
                if (thing.isVisible(Game.hero()) && thing.getFlag("IsIntelligent")) {
                    if (RPG.test(thing.getStat("IN"), thing2.getStat("SK"))) {
                        Game.message(thing.getTheName() + " shouts angrily!");
                        AI.turnNasty(thing);
                        map.areaNotify(thing.x, thing.y, 10, n, 1, object);
                    } else {
                        Game.message(thing.getTheName() + " doesn't notice");
                    }
                }
                return 0;
            }
        }
        return 0;
    }

    public static Thing findFoe(Thing thing) {
        Map map;
        Thing thing2 = thing.getThing("CurrentFoe");
        if (thing2 != null) {
            if (thing2.place == null) {
                thing2 = null;
            } else if (!thing.canSee(thing2)) {
                thing2 = null;
            }
        }
        if ((thing2 == null || RPG.d(12) == 1) && (thing2 = (map = thing.getMap()) == null ? null : map.findNearestFoe(thing)) != null) {
            thing.set("CurrentFoe", thing2);
        }
        return thing2;
    }

    public static boolean tryMove(Thing thing, int n, int n2) {
        Map map = thing.getMap();
        if (!Tile.isSensibleMove(thing, map, n, n2)) {
            return false;
        }
        return Movement.tryMove(thing, map, n, n2);
    }

    public static void doAttack(Thing thing, int n, int n2) {
        Map map = thing.getMap();
        if (map == null) {
            return;
        }
        if (RPG.d(100) <= thing.getStat("CastChance") && AI.doCasterAction(thing)) {
            return;
        }
        int n3 = RPG.sign(n - thing.x);
        int n4 = RPG.sign(n2 - thing.y);
        if (RPG.r(100) < thing.getStat("RetreatChance") || Being.feelsFear(thing) && thing.getStat("HPS") * 3 <= thing.getStat("HPSMAX")) {
            if (AI.tryMove(thing, thing.x - n3, thing.y - n4)) {
                return;
            }
            if (AI.tryMove(thing, thing.x - RPG.sign(n3 - n4), thing.y - RPG.sign(n4 + n3))) {
                return;
            }
            if (AI.tryMove(thing, thing.x - RPG.sign(n3 + n4), thing.y - RPG.sign(n4 - n3))) {
                return;
            }
        }
        if (AI.tryMove(thing, thing.x + n3, thing.y + n4)) {
            return;
        }
        if (AI.tryMove(thing, thing.x + RPG.sign(n3 - n4), thing.y + RPG.sign(n4 + n3))) {
            return;
        }
        if (AI.tryMove(thing, thing.x + RPG.sign(n3 + n4), thing.y + RPG.sign(n4 - n3))) {
            return;
        }
        if (RPG.d(2) == 1) {
            n3 = RPG.r(3) - 1;
        }
        if (RPG.d(2) == 1) {
            n4 = RPG.r(3) - 1;
        }
        if (!AI.tryMove(thing, thing.x + n3, thing.y + n4)) {
            thing.incStat("APS", -30);
            thing.set("DirectionX", 0);
            thing.set("DirectionY", 0);
        }
    }

    public static boolean doAction(Thing thing) {
        Game.actor = thing;
        String string = thing.getString("AIMode");
        Map map = thing.getMap();
        if (map == null || !(thing.place instanceof Map)) {
            thing.set("APS", 0);
            return true;
        }
        boolean bl = thing.canSee(Game.hero());
        if (!thing.getFlag("IsHostile") && thing.getFlag("IsInhabitant") && map.getFlag("IsHostile")) {
            thing.set("IsHostile", 1);
        }
        if (string == null) {
            string = STATE_INHABITANT;
            thing.set("AIMode", string);
        }
        if (bl && thing.getFlag("Spellcasting") && AI.doCasterAction(thing)) {
            return true;
        }
        if (string.equals("Evade")) {
            return AI.doCritterAction(thing);
        }
        if (string.equals("Guard")) {
            return AI.doGuardAction(thing);
        }
        if (string.equals(STATE_HOSTILE)) {
            Thing thing2 = AI.findFoe(thing);
            if (thing2 == null) {
                thing.set("AIMode", STATE_INHABITANT);
                return true;
            }
            if (RPG.d(3) == 1 && AI.doRangedAttack(thing, thing2)) {
                return true;
            }
            AI.doAttack(thing, thing2.x, thing2.y);
            return true;
        }
        if (string.equals(STATE_INHABITANT)) {
            Thing thing3 = AI.findFoe(thing);
            if (thing3 != null) {
                if (RPG.d(2) == 1) {
                    thing.set("AIMode", STATE_HOSTILE);
                }
                AI.doAttack(thing, thing3.x, thing3.y);
            } else if (RPG.d(4) == 1 && thing.getFlag("IsIntelligent")) {
                AI.doPickup(thing);
            } else {
                int n = thing.getStat("DirectionX");
                int n2 = thing.getStat("DirectionY");
                if (n == 0 && n2 == 0 || RPG.d(2) == 1) {
                    if (RPG.d(3) == 1) {
                        n = RPG.r(3) - 1;
                    }
                    if (RPG.d(3) == 1) {
                        n2 = RPG.r(3) - 1;
                    }
                }
                AI.doAttack(thing, thing.x + n, thing.y + n2);
            }
            return true;
        }
        if (string.equals(STATE_FOLLOWER)) {
            return AI.doFollowAction(thing);
        }
        return false;
    }

    public static void setFollower(Thing thing, Thing thing2) {
        thing.set("Leader", thing2);
        if (thing2.isHero()) {
            thing.set("AIMode", STATE_FOLLOWER);
        }
        thing.set("IsHostile", thing2.getStat("IsHostile"));
        thing.set("IsNeutral", thing2.getStat("IsNeutral"));
        thing.set("Side", thing2.getStat("Side"));
    }

    public static boolean isFollower(Thing thing, Thing thing2) {
        return thing.get("Leader") == thing2;
    }

    private static boolean doFollowAction(Thing thing) {
        int n;
        Thing thing2 = thing.getThing("Leader");
        if (thing2 == null || thing2.isDead()) {
            thing.set("AIMode", STATE_INHABITANT);
            thing.set("APS", 0);
            return true;
        }
        int n2 = RPG.abs(thing.x - thing2.x) + RPG.abs(thing.y - thing2.y);
        Thing thing3 = AI.findFoe(thing2);
        if (thing3 != null && ((n = RPG.abs(thing3.x - thing.x) + RPG.abs(thing3.y - thing.y)) <= 2 || n2 <= n)) {
            AI.doAttack(thing, thing3.x, thing3.y);
            return true;
        }
        if (thing3 != null || RPG.d(6) < n2) {
            AI.doAttack(thing, thing2.x, thing2.y);
            return true;
        }
        return AI.doRandomWalk(thing);
    }

    private static boolean doRandomWalk(Thing thing) {
        int n;
        int n2;
        int n3 = RPG.r(3) - 1;
        int n4 = thing.x + n3;
        if (!AI.tryMove(thing, n4, n2 = thing.y + (n = RPG.r(3) - 1))) {
            thing.incStat("APS", -100);
        }
        if (RPG.d(10) == 1 && thing.getStat("CR") >= 5) {
            AI.doPickup(thing);
        }
        return true;
    }

    private static void doPickup(Thing thing) {
        Map map = thing.getMap();
        Thing[] thingArray = map.getThings(thing.x, thing.y);
        boolean bl = false;
        for (int i = 0; i < thingArray.length; ++i) {
            Thing thing2 = thingArray[i];
            if (!thing2.getFlag("IsItem") || Item.isOwned(thing2)) continue;
            Item.pickup(thing, thing2);
            bl = true;
        }
        if (bl) {
            Being.utiliseItems(thing);
        }
    }

    public static boolean doCritterAction(Thing thing) {
        Thing thing2 = Game.hero();
        Map map = thing.getMap();
        Thing thing3 = AI.findFoe(thing);
        if (thing3 != null && thing3.getStat("HPS") < thing.getStat("HPS")) {
            AI.doAttack(thing, thing3.x, thing3.y);
        }
        int n = RPG.distSquared(thing2.x, thing2.y, thing.x, thing.y);
        int n2 = RPG.r(3) - 1;
        int n3 = RPG.r(3) - 1;
        if (RPG.d(10) > n) {
            n2 = -RPG.sign(thing2.x - thing.x);
        }
        if (RPG.d(10) > n) {
            n3 = -RPG.sign(thing2.y - thing.y);
        }
        int n4 = thing.x + n2;
        int n5 = thing.y + n3;
        return Movement.tryMove(thing, map, n4, n5);
    }

    public static boolean doRangedAttack(Thing thing, Thing thing2) {
        Thing thing3 = thing.getWielded(20);
        Thing thing4 = thing.getWielded(21);
        if (thing3 != null && RangedWeapon.isValidAmmo(thing3, thing4)) {
            RangedWeapon.fireAt(thing3, thing, thing4.remove(1), thing2.getMap(), thing2.x, thing2.y);
            Being.utiliseItems(thing);
            return true;
        }
        if (thing4 != null) {
            Missile.throwAt(thing4.remove(1), thing, thing2.getMap(), thing2.x, thing2.y);
            Being.utiliseItems(thing);
            return true;
        }
        return false;
    }

    public static boolean doCasterAction(Thing thing) {
        Thing[] thingArray = thing.getFlaggedContents("IsSpell");
        int n = thingArray.length;
        if (n <= 0) {
            return false;
        }
        if (thing.isVisible(Game.hero()) || RPG.d(10) == 1) {
            int n2 = RPG.r(n);
            Thing thing2 = thingArray[n2];
            return Spell.castAI(thing, thing2);
        }
        return false;
    }

    public static void setGuard(Thing thing, Map map, int n, int n2) {
        AI.setGuard(thing, map, n - 1, n2 - 1, n + 1, n2 + 1);
    }

    public static void setGuard(Thing thing, Thing thing2) {
        thing.set("GuardPoint", thing2);
        thing.set("AIMode", "Guard");
        thing2.set("Guard", thing);
    }

    public static void setGuard(Thing thing, Map map, int n, int n2, int n3, int n4) {
        Thing thing2 = thing.getThing("GuardPoint");
        if (thing2 == null) {
            thing2 = Lib.create("guard point");
            thing.set("GuardPoint", thing2);
        }
        thing2.set("Guard", thing);
        thing2.set("GuardRadius", RPG.min(Math.abs(n3 - n), Math.abs(n4 - n2)) / 2);
        map.addThing(thing2, (n + n3) / 2, (n2 + n4) / 2);
        thing.set("AIMode", "Guard");
    }

    public static void name(Thing thing, String string) {
        thing.set("Name", string);
        thing.set("NameType", 1);
        thing.set("IsNamed", 1);
        thing.set("IsUnique", 1);
        thing.set("Frequency", 0);
    }

    public static boolean doGuardAction(Thing thing) {
        Map map = thing.getMap();
        if (map == null) {
            return false;
        }
        Thing thing2 = thing.getThing("GuardPoint");
        if (thing2 == null) {
            thing2 = map.getNamedObject(thing.x, thing.y, "guard point");
            if (thing2 == null) {
                Game.warn(thing.name() + " has no guard point!");
                return false;
            }
            thing.set("GuardPoint", thing2);
        }
        int n = thing2.getStat("GuardRadius");
        int n2 = thing2.x - n;
        int n3 = thing2.y - n;
        int n4 = thing2.x + n;
        int n5 = thing2.y + n;
        int n6 = thing2.x;
        int n7 = thing2.y;
        Thing thing3 = AI.findFoe(thing);
        if (thing3 != null && RPG.distSquared(thing.x, thing.y, thing3.x, thing3.y) <= 50) {
            AI.doAttack(thing, thing3.x, thing3.y);
        } else if (thing.x <= n2 || thing.x >= n4 || thing.y <= n3 || thing.y >= n5) {
            AI.doAttack(thing, n6, n7);
        } else {
            boolean bl;
            boolean bl2 = bl = RPG.d(6) == 1 || thing.getStat("DirectionX") == 0 && thing.getStat("DirectionY") == 0;
            if (bl) {
                thing.set("DirectionX", RPG.r(3) - 1);
            }
            if (bl) {
                thing.set("DirectionY", RPG.r(3) - 1);
            }
            AI.doAttack(thing, thing.x + thing.getStat("DirectionX"), thing.y + thing.getStat("DirectionY"));
        }
        return true;
    }

    public static boolean doFriendlyAction(Thing thing) {
        int n;
        int n2;
        int n3 = thing.getStat("TargetX");
        int n4 = thing.getStat("TargetY");
        Map map = thing.getMap();
        if (map.isAngry() && thing.getFlag("IsIntelligent")) {
            thing.set("IsHostile", 1);
        }
        int n5 = RPG.r(3) - 1;
        int n6 = RPG.r(3) - 1;
        if (n3 > 0 && n4 > 0) {
            if (RPG.d(2) == 1) {
                n5 = RPG.sign(n3 - thing.x);
            }
            if (RPG.d(2) == 1) {
                n6 = RPG.sign(n4 - thing.y);
            }
        }
        if (!map.isBlocked(n2 = thing.x + n5, n = thing.y + n6)) {
            thing.moveTo(map, n2, n);
        }
        thing.incStat("APS", -10000 / thing.getStat("MoveSpeed"));
        return true;
    }

    public static void init() {
    }

    public static class AIScript
    extends Script {
        private static final long serialVersionUID = 3257562910623609394L;

        public boolean handle(Thing thing, Event event) {
            int n = event.getStat("Time");
            if (n <= 0) {
                return false;
            }
            int n2 = thing.getStat("APS") + n * thing.getStat("Speed") / 100;
            thing.set("APS", n2);
            if (thing.getFlag("IsBeing") && n2 > 0) {
                for (int i = 0; i < 10; ++i) {
                    AI.doAction(thing);
                    n2 = thing.getStat("APS");
                    if (n2 <= 0) break;
                }
            }
            if (n2 > 0) {
                n2 = 0;
            }
            thing.set("APS", n2);
            Being.recover(thing, n);
            return false;
        }
    }
}

