/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import mikera.tyrant.AI;
import mikera.tyrant.Event;
import mikera.tyrant.Lib;
import mikera.tyrant.Modifier;
import mikera.tyrant.Monster;
import mikera.tyrant.RPG;
import mikera.tyrant.Script;
import mikera.tyrant.Scripts;
import mikera.tyrant.Thing;

public class Artifact {
    public static void init() {
        Artifact.initRings();
        Artifact.initSwords();
        Artifact.initAmulets();
        Artifact.initArmour();
        Artifact.initShields();
        Artifact.initEquipment();
        Artifact.initFootwear();
        Artifact.initWeapons();
        Artifact.initMissiles();
        Artifact.initCrowns();
    }

    public static void initFootwear() {
        Thing thing = Lib.extend("The Seven League Boots", "leather boots");
        thing.set("LevelMin", 1);
        thing.set("Armour", 4);
        thing.add("WieldedModifiers", Modifier.bonus("MoveSpeed", 200));
        thing.set("IsRandomArtifact", 1);
        Artifact.addArtifact(thing);
        thing = Lib.extend("Nitrozac's Boots", "leather boots");
        thing.set("LevelMin", 17);
        thing.set("Image", 364);
        thing.set("IsRandomArtifact", 1);
        thing.set("Armour", 40);
        thing.add("WieldedModifiers", Modifier.bonus("MoveSpeed", 50));
        Artifact.addArtifact(thing);
        thing = Lib.extend("The Winged Sandals", "leather boots");
        thing.set("LevelMin", 27);
        thing.set("Armour", 5);
        thing.add("WieldedModifiers", Modifier.bonus("IsFlying", 1));
        thing.add("WieldedModifiers", Modifier.bonus("Speed", 20));
        thing.set("IsRandomArtifact", 1);
        Artifact.addArtifact(thing);
    }

    public static void initShields() {
        Thing thing = Lib.extend("Jorgen's Buckler", "krithium buckler");
        thing.multiplyStat("Armour", 2.0);
        thing.add("WieldedModifiers", Modifier.bonus("Defence", 1));
        thing.add("WieldedModifiers", Modifier.bonus("Alertness", 1));
        thing.set("LevelMin", 1);
        thing.set("IsRandomArtifact", 1);
        thing.set("Image", 660);
        Artifact.addArtifact(thing);
        thing = Lib.extend("The Black Buckler", "black steel buckler");
        thing.multiplyStat("Armour", 1.7);
        thing.add("WieldedModifiers", Modifier.bonus("Defence", 2));
        thing.add("WieldedModifiers", Modifier.bonus("Luck", 20));
        thing.set("LevelMin", 10);
        thing.set("IsRandomArtifact", 1);
        thing.set("Image", 660);
        Artifact.addArtifact(thing);
        thing = Lib.extend("Gorandil", "parillite large shield");
        thing.multiplyStat("Armour", 1.2);
        thing.add("WieldedModifiers", Modifier.bonus("Defence", 2));
        thing.add("WieldedModifiers", Modifier.bonus("Speed", 10));
        thing.add("WieldedModifiers", Modifier.bonus("Luck", 20));
        thing.set("LevelMin", 35);
        thing.set("IsRandomArtifact", 1);
        thing.set("Image", 399);
        Artifact.addArtifact(thing);
    }

    public static void initArmour() {
        Thing thing = Lib.extend("Korvon's Armour", "steel chain mail");
        thing.set("UName", "finely crafted chain mail");
        thing.multiplyStat("Armour", 5.0);
        thing.add("WieldedModifiers", Modifier.bonus("Defence", 1));
        thing.add("WieldedModifiers", Modifier.bonus("RES:fire", 10));
        thing.set("LevelMin", 1);
        thing.set("IsRandomArtifact", 1);
        Artifact.addArtifact(thing);
        thing = Lib.extend("Kabirion", "mithril plate mail");
        thing.set("UName", "engraved elven plate mail");
        thing.multiplyStat("Armour", 2.0);
        thing.add("WieldedModifiers", Modifier.bonus("Luck", 10));
        thing.set("LevelMin", 10);
        thing.set("IsRandomArtifact", 1);
        Artifact.addArtifact(thing);
        thing = Lib.extend("Kethirion", "krithium horned helm");
        thing.set("UName", "huge dwarvish horned helm");
        thing.multiplyStat("Armour", 3.0);
        thing.add("WieldedModifiers", Modifier.bonus("Luck", 10));
        thing.set("LevelMin", 15);
        thing.set("IsRandomArtifact", 1);
        Artifact.addArtifact(thing);
        thing = Lib.extend("The Tyrant's Armour", "black steel plate armour");
        thing.set("UName", "heavy plated armour");
        thing.multiplyStat("Armour", 3.0);
        thing.add("WieldedModifiers", Modifier.bonus("Defence", 1));
        thing.set("LevelMin", 25);
        Artifact.addArtifact(thing);
        thing = Lib.extend("The Cloak Of The Night", "light cloak");
        thing.set("UName", "flowing dark cloak");
        thing.set("Armour", 10);
        thing.add("WieldedModifiers", Modifier.bonus("Defence", 1));
        thing.add("WieldedModifiers", Modifier.bonus("Stealth", 2));
        thing.set("LevelMin", 5);
        thing.set("IsRandomArtifact", 1);
        Artifact.addArtifact(thing);
        thing = Lib.extend("The Helm Of Aramis", "parillite helmet");
        thing.set("UName", "brightly shining engraved helmet");
        thing.multiplyStat("Armour", 3.0);
        thing.add("WieldedModifiers", Modifier.bonus("Luck", 20));
        thing.add("WieldedModifiers", Modifier.bonus("Healing", RPG.d(6)));
        thing.set("LevelMin", 35);
        thing.set("IsRandomArtifact", 1);
        Artifact.addArtifact(thing);
    }

    public static void initCrowns() {
        Thing thing = Lib.extend("The Crown of Daedor", "base headgear");
        thing.add("WieldedModifiers", Modifier.bonus("TG", 20));
        thing.add("WieldedModifiers", Modifier.bonus("WP", 20));
        thing.add("WieldedModifiers", Modifier.bonus("Luck", 30));
        thing.add("WieldedModifiers", Modifier.bonus("RES:disintegrate", 5));
        thing.set("Armour", 10);
        thing.set("Image", 427);
        thing.set("LevelMin", 30);
        thing.set("IsRandomArtifact", 1);
        Artifact.addArtifact(thing);
        thing = Lib.extend("The Crown of Fire", "base headgear");
        thing.add("WieldedModifiers", Modifier.bonus("RES:fire", 1000));
        thing.add("WieldedModifiers", Modifier.addHandler("OnAction", Monster.breathAttack("fire", "blazing flames", 4, 50, 1)));
        thing.set("Armour", 6);
        thing.set("Image", 428);
        thing.set("LevelMin", 35);
        thing.set("IsRandomArtifact", 1);
        Artifact.addArtifact(thing);
        thing = Lib.extend("The Crown of Ages", "base headgear");
        thing.add("WieldedModifiers", Modifier.bonus("IN", 30));
        thing.add("WieldedModifiers", Modifier.bonus("Speed", 30));
        thing.add("WieldedModifiers", Modifier.bonus("TrueView", 5));
        thing.set("Image", 425);
        thing.set("Armour", 8);
        thing.set("LevelMin", 40);
        thing.set("IsRandomArtifact", 1);
        Artifact.addArtifact(thing);
    }

    public static void initAmulets() {
        Thing thing = Lib.extend("The Emerald Of Life", "base necklace");
        thing.set("UName", "stunning emerald necklace");
        thing.set("Image", 406);
        thing.set("Armour", 40);
        thing.add("WieldedModifiers", Modifier.bonus("RES:disintegrate", 30));
        thing.add("WieldedModifiers", Modifier.bonus("RES:chill", 30));
        thing.add("WieldedModifiers", Modifier.bonus("Healing", 3));
        thing.set("LevelMin", 40);
        Artifact.addArtifact(thing);
    }

    public static void initEquipment() {
        Thing thing = Lib.extend("The Spade Of Aces", "wooden spade");
        thing.set("UName", "well used spade");
        thing.set("SlayingStats", "IsGoblin*2");
        thing.multiplyStat("ASKMul", 2.0);
        thing.multiplyStat("ASTMul", 2.0);
        thing.multiplyStat("DSKMul", 2.0);
        thing.add("WieldedModifiers", Modifier.bonus("Mining", 2));
        thing.set("LevelMin", 25);
        thing.set("DigCost", 100);
        Artifact.addArtifact(thing);
    }

    public static void initSwords() {
        Thing thing = Lib.extend("Orcslayer", "mithril sword");
        thing.set("UName", "glowing elven sword");
        thing.set("SlayingStats", "IsOrc*3");
        thing.multiplyStat("ASKMul", 1.5);
        thing.multiplyStat("ASTMul", 1.5);
        thing.set("LevelMin", 1);
        thing.set("IsRandomArtifact", 1);
        Artifact.addArtifact(thing);
        thing = Lib.extend("Thurgin's Bane", "krithium mace");
        thing.set("UName", "heavy orcish mace");
        thing.set("SlayingStats", "IsDwarf*3");
        thing.multiplyStat("ASKMul", 1.5);
        thing.multiplyStat("ASTMul", 1.5);
        thing.set("LevelMin", 1);
        thing.set("IsRandomArtifact", 1);
        Artifact.addArtifact(thing);
        thing = Lib.extend("Herugrim", "steel sword");
        thing.set("UName", "horse-engraved sword");
        thing.multiplyStat("ASKMul", 2.0);
        thing.multiplyStat("ASTMul", 2.0);
        thing.add("WieldedModifiers", Modifier.bonus("MoveSpeed", 40));
        thing.set("LevelMin", 5);
        thing.set("IsRandomArtifact", 1);
        Artifact.addArtifact(thing);
        thing = Lib.extend("Sting", "mithril dagger");
        thing.set("UName", "gleaming hobbit's dagger");
        thing.set("SlayingStats", "IsGoblinoid*3");
        thing.multiplyStat("ASKMul", 2.0);
        thing.multiplyStat("ASTMul", 2.0);
        thing.multiplyStat("AttackCost", 0.5);
        thing.set("LevelMin", 10);
        thing.set("IsRandomArtifact", 1);
        Artifact.addArtifact(thing);
        thing = Lib.extend("Morglay", "black steel short sword");
        thing.set("UName", "fearsome black shortsword");
        thing.multiplyStat("AttackCost", 0.7);
        thing.set("OnTouch", Scripts.addEffect("Target", "strong poison"));
        thing.set("LevelMin", 5);
        thing.set("IsRandomArtifact", 1);
        Artifact.addArtifact(thing);
        thing = Lib.extend("Purifier", "blue steel two-handed sword");
        thing.set("UName", "brightly shining two-handed sword");
        thing.set("SlayingStats", "IsUndead*3,IsDemonic*3");
        thing.multiplyStat("ASKMul", 1.5);
        thing.multiplyStat("ASTMul", 1.5);
        thing.multiplyStat("AttackCost", 0.8);
        thing.set("IsBlessed", 1);
        thing.set("LevelMin", 20);
        thing.set("IsRandomArtifact", 1);
        thing.set("Image", 173);
        Artifact.addArtifact(thing);
        thing = Lib.extend("Anduril", "elven steel longsword");
        thing.set("UName", "shining elven longsword");
        thing.set("SlayingStats", "IsDemonic*2");
        thing.multiplyStat("ASKMul", 1.5);
        thing.multiplyStat("ASTMul", 1.5);
        thing.add("WieldedModifiers", Modifier.bonus("Bravery", 2));
        thing.add("WieldedModifiers", Modifier.bonus("Luck", 20));
        thing.set("IsBlessed", 1);
        thing.set("LevelMin", 25);
        thing.set("IsRandomArtifact", 1);
        thing.set("Image", 173);
        Artifact.addArtifact(thing);
        thing = Lib.extend("Excalibur", "mithril sword");
        thing.set("UName", "shimmering sword");
        thing.multiplyStat("ASKMul", 3.0);
        thing.multiplyStat("ASTMul", 3.0);
        thing.multiplyStat("AttackCost", 0.8);
        thing.set("IsRandomArtifact", 1);
        thing.set("IsBlessed", 1);
        thing.set("LevelMin", 30);
        thing.set("Image", 170);
        Artifact.addArtifact(thing);
        thing = Lib.extend("Gimbermaal", "black steel two-handed sword");
        thing.set("UName", "huge black two-handed sword");
        thing.set("SlayingStats", "IsHumanoid*2,IsUndead*3");
        thing.multiplyStat("ASKMul", 2.0);
        thing.multiplyStat("ASTMul", 2.0);
        thing.multiplyStat("DSKMul", 2.0);
        thing.set("IsRandomArtifact", 1);
        thing.set("LevelMin", 35);
        thing.set("Image", 173);
        Artifact.addArtifact(thing);
        thing = Lib.extend("Yanthrall's Sword", "parillite longsword");
        thing.set("UName", "gleaming engraved longsword");
        thing.set("SlayingStats", "IsHumanoid*3,IsDemonic*3");
        thing.add("WieldedModifiers", Modifier.bonus("Bravery", 4));
        thing.add("WieldedModifiers", Modifier.bonus("Luck", 30));
        thing.add("WieldedModifiers", Modifier.bonus("Speed", 10));
        thing.multiplyStat("ASKMul", 2.0);
        thing.multiplyStat("ASTMul", 2.0);
        thing.multiplyStat("DSKMul", 2.0);
        thing.multiplyStat("AttackCost", 0.5);
        thing.set("IsBlessed", 1);
        thing.set("LevelMin", 40);
        thing.set("Image", 166);
        Artifact.addArtifact(thing);
    }

    public static void initMissiles() {
        Thing thing = Lib.extend("Cupid's Arrow", "arrow");
        thing.set("Image", 80);
        thing.set("Number", 1);
        thing.set("LevelMin", 1);
        thing.set("OnWeaponHit", new Script(){
            private static final long serialVersionUID = 1L;

            public boolean handle(Thing thing, Event event) {
                Thing thing2 = event.getThing("Target");
                Thing thing3 = event.getThing("Shooter");
                if (thing3 == null) {
                    return true;
                }
                AI.setFollower(thing2, thing3);
                thing3.message(thing2.getTheName() + " seems deeply enamoured with you");
                return true;
            }
        });
        Artifact.addArtifact(thing);
    }

    public static void initWeapons() {
        Thing thing = Lib.extend("The Tyrant's Mace", "black steel two-handed mace");
        thing.set("UName", "malevolent two-handed mace");
        thing.set("SlayingStats", "IsHumanoid*2");
        thing.multiplyStat("ASKMul", 1.2);
        thing.multiplyStat("ASTMul", 1.2);
        thing.multiplyStat("AttackCost", 0.8);
        thing.set("LevelMin", 25);
        thing.set("Image", 164);
        thing.set("WeaponDamageType", "impact");
        Artifact.addArtifact(thing);
        thing = Lib.extend("Death's Scythe", "scythe");
        thing.set("UName", "space distorting black sycthe");
        thing.set("SlayingStats", "IsLiving*3");
        thing.multiplyStat("ASKMul", 3.0);
        thing.multiplyStat("ASTMul", 3.0);
        thing.multiplyStat("DSKMul", 3.0);
        thing.multiplyStat("AttackCost", 0.8);
        thing.set("LevelMin", 35);
        thing.set("Image", 172);
        Artifact.addArtifact(thing);
    }

    public static void initRings() {
        Thing thing = Lib.extend("Fortune", "silver ring");
        thing.set("UName", "strangely plain silver ring");
        thing.add("WieldedModifiers", Modifier.bonus("AG", 10));
        thing.add("WieldedModifiers", Modifier.bonus("Luck", 40));
        thing.set("LevelMin", 1);
        thing.set("IsRandomArtifact", 1);
        Artifact.addArtifact(thing);
        thing = Lib.extend("Narya", "gold ring");
        thing.set("UName", "burning gold ring");
        thing.add("WieldedModifiers", Modifier.bonus("ST", 20));
        thing.add("WieldedModifiers", Modifier.bonus("RES:fire", 1000));
        thing.set("LevelMin", 20);
        thing.set("IsRandomArtifact", 1);
        Artifact.addArtifact(thing);
        thing = Lib.extend("Nenya", "silver ring");
        thing.set("UName", "slippery silver ring");
        thing.add("WieldedModifiers", Modifier.bonus("Swimming", 10));
        thing.add("WieldedModifiers", Modifier.bonus("AG", 20));
        thing.add("WieldedModifiers", Modifier.bonus("RES:water", 1000));
        thing.set("LevelMin", 25);
        thing.set("IsRandomArtifact", 1);
        Artifact.addArtifact(thing);
        thing = Lib.extend("Vilya", "silver ring");
        thing.set("UName", "sparkling silver ring");
        thing.add("WieldedModifiers", Modifier.bonus("IsFlying", 1));
        thing.add("WieldedModifiers", Modifier.bonus("IN", 10));
        thing.add("WieldedModifiers", Modifier.bonus("Speed", 10));
        thing.add("WieldedModifiers", Modifier.bonus("RES:shock", 10));
        thing.set("LevelMin", 30);
        thing.set("IsRandomArtifact", 1);
        Artifact.addArtifact(thing);
        thing = Lib.extend("The One Ring", "gold ring");
        thing.set("IsCursed", 1);
        thing.set("UName", "strangely plain gold ring");
        thing.add("WieldedModifiers", Modifier.bonus("SK", 10));
        thing.add("WieldedModifiers", Modifier.bonus("ST", 10));
        thing.add("WieldedModifiers", Modifier.bonus("AG", 10));
        thing.add("WieldedModifiers", Modifier.bonus("TG", 10));
        thing.add("WieldedModifiers", Modifier.bonus("IN", 10));
        thing.add("WieldedModifiers", Modifier.bonus("WP", 10));
        thing.add("WieldedModifiers", Modifier.bonus("CH", 10));
        thing.add("WieldedModifiers", Modifier.bonus("CR", 10));
        thing.add("WieldedModifiers", Modifier.bonus("Luck", 40));
        thing.set("LevelMin", 35);
        Artifact.addArtifact(thing);
        thing = Lib.extend("The Xing Ring", "gold ring");
        thing.set("UName", "brilliant diamond ring");
        thing.set("Image", 207);
        thing.add("WieldedModifiers", Modifier.linear("IN", 200, 10));
        thing.set("LevelMin", 30);
        thing.set("IsRandomArtifact", 1);
        Artifact.addArtifact(thing);
        thing = Lib.extend("Destiny", "silver ring");
        thing.set("UName", "finely engraved silver ring");
        thing.add("WieldedModifiers", Modifier.linear("WP", 150, 0));
        thing.add("WieldedModifiers", Modifier.bonus("Luck", 100));
        thing.set("LevelMin", 40);
        Artifact.addArtifact(thing);
    }

    private static void addArtifact(Thing thing) {
        Artifact.makeArtifact(thing);
        Lib.addNewArtifact(thing);
    }

    private static void makeArtifact(Thing thing) {
        thing.set("IsUnique", 1);
        thing.set("IsArtifact", 1);
        thing.set("IsDestructible", 0);
        thing.set("IsTheftProof", 1);
        thing.set("Frequency", 0);
        thing.set("DefaultThings", thing.getLocal().get("DefaultThings"));
        thing.set("ValueBase", 10000);
        thing.set("LevelMax", thing.getStat("LevelMin") + 15);
    }
}

