/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import mikera.tyrant.Event;
import mikera.tyrant.Lib;
import mikera.tyrant.Map;
import mikera.tyrant.Outdoors;
import mikera.tyrant.Portal;
import mikera.tyrant.RPG;
import mikera.tyrant.Script;
import mikera.tyrant.Thing;

public class Graveyard {
    public static void makeGraveyard(Map map) {
        Outdoors.buildOutdoors(map, 0, 0, map.width - 1, map.height - 1, 20);
        int n = map.width / 4;
        int n2 = map.height / 4;
        int n3 = n * 3;
        int n4 = n2 * 3;
        Thing thing = Portal.create("stairs down");
        thing.set("ComplexName", "old catacombs");
        thing.set("OnTravel", new Script(){
            private static final long serialVersionUID = 1L;

            public boolean handle(Thing thing, Event event) {
                Map map = thing.getMap();
                map.set("IsHostile", 1);
                return false;
            }
        });
        map.setExit(thing);
        Graveyard.makeGraveyard(map, n, n2, n3, n4);
        if (thing.getMap() == null) {
            map.addThing(thing, n, n2, n3, n4);
        }
        map.setEntrance(Lib.create("invisible portal"));
        map.addThing(map.getEntrance(), 0, map.height - 1, map.width - 1, map.height - 1);
        map.set("IsHostile", 0);
        map.set("Level", 7);
        map.set("WanderingRate", 10);
        map.set("WanderingType", "IsUndead");
        map.set("Description", "Old Graveyard");
    }

    public static void makeGraveyard(Map map, int n, int n2, int n3, int n4) {
        map.clearArea(n, n2, n3, n4);
        map.fillArea(n, n2, n3, n4, 18);
        map.fillArea((n + n3) / 2, n2, (n + n3) / 2, n4, 5);
        map.fillBorder(n, n2, n3, n4, 10);
        map.setTile((n + n3) / 2, n4, map.floor());
        map.addThing(Lib.create("graveyard door"), (n + n3) / 2, n4);
        Graveyard.buildArea(map, n + 1, n2 + 1, (n + n3) / 2 - 1, n4 - 1, true);
        Graveyard.buildArea(map, (n + n3) / 2 + 1, n2 + 1, n3 - 1, n4 - 1, true);
    }

    public static void buildPatch(Map map, int n, int n2, int n3, int n4) {
        for (int i = n; i <= n3; ++i) {
            block10: for (int j = n2; j <= n4; ++j) {
                switch (RPG.d(36)) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        map.addThing("[IsGravestone]", i, j);
                        continue block10;
                    }
                    case 6: {
                        if (RPG.d(2) == 1) {
                            map.addThing("potted flower", i, j);
                            continue block10;
                        }
                        map.addThing("bird bath", i, j);
                        continue block10;
                    }
                    case 7: {
                        map.addThing("stone bench", i, j);
                        continue block10;
                    }
                    case 8: {
                        map.addThing("menhir", i, j);
                        continue block10;
                    }
                    case 9: {
                        map.addThing("small bush", i, j);
                        continue block10;
                    }
                    case 10: {
                        map.addThing("tree", i, j);
                        continue block10;
                    }
                    case 11: 
                    case 12: 
                    case 13: {
                        map.addThing("[IsGravestone]", i, j);
                    }
                }
            }
        }
    }

    public static void buildSpecialArea(Map map, int n, int n2, int n3, int n4) {
        switch (RPG.d(5)) {
            case 1: {
                map.fillArea(n, n2, n3, n4, 17);
                break;
            }
            case 2: {
                map.fillArea(n + 1, n2 + 1, n3 - 1, n4 - 1, 17);
                break;
            }
            case 3: {
                map.fillArea(n + 1, n2 + 1, n3 - 1, n4 - 1, 17);
                map.fillArea(n + 2, n2 + 2, n3 - 2, n4 - 2, 5);
                map.fillArea(n, (n2 + n4) / 2, n3, (n2 + n4) / 2, 5);
                if (n3 - n < 8 || n4 - n2 < 8) break;
                Graveyard.buildTomb(map, n + 3, n2 + 3, n3 - 3, n4 - 3);
                break;
            }
            case 4: 
            case 5: {
                Graveyard.buildTomb(map, n + 1, n2 + 1, n3 - 1, n4 - 1);
            }
        }
    }

    public static void buildTomb(Map map, int n, int n2, int n3, int n4) {
        map.fillArea(n, n2, n3, n4, 5);
        map.fillBorder(n, n2, n3, n4, 10);
        map.setTile((n + n3) / 2, n4, 5);
        map.addThing("graveyard door", (n + n3) / 2, n4);
        Graveyard.decorateTomb(map, n + 1, n2 + 1, n3 - 1, n4 - 1);
    }

    public static void decorateTomb(Map map, int n, int n2, int n3, int n4) {
        int n5 = n3 - n + 1;
        int n6 = n4 - n2 + 1;
        if (n5 >= 3 && n6 >= 3) {
            map.addThing(map.getExit(), n, n2, n3, n4);
        } else {
            for (int i = n; i <= n3; ++i) {
                for (int j = n2; j <= n4; ++j) {
                    if (RPG.d(2) != 1) continue;
                    map.addThing("[IsGravestone]", i, j);
                }
            }
        }
    }

    public static void buildArea(Map map, int n, int n2, int n3, int n4, boolean bl) {
        int n5 = n3 - n + 1;
        int n6 = n4 - n2 + 1;
        if (n5 <= 5 || n6 <= 5) {
            Graveyard.buildPatch(map, n, n2, n3, n4);
        } else if (RPG.d(6) == 1) {
            Graveyard.buildSpecialArea(map, n, n2, n3, n4);
        } else if (bl) {
            int n7 = RPG.rspread(n2 + 1, n4 - 1);
            map.fillArea(n, n7, n3, n7, 5);
            Graveyard.buildArea(map, n, n2, n3, n7 - 1, !bl);
            Graveyard.buildArea(map, n, n7 + 1, n3, n4, !bl);
        } else {
            int n8 = RPG.rspread(n + 1, n3 - 1);
            map.fillArea(n8, n2, n8, n4, 5);
            Graveyard.buildArea(map, n, n2, n8 - 1, n4, !bl);
            Graveyard.buildArea(map, n8 + 1, n2, n3, n4, !bl);
        }
    }
}

