/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant.author;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.UIManager;
import mikera.tyrant.Action;
import mikera.tyrant.ActionMapping;
import mikera.tyrant.BaseObject;
import mikera.tyrant.Game;
import mikera.tyrant.GameHandler;
import mikera.tyrant.GameScreen;
import mikera.tyrant.Hero;
import mikera.tyrant.IActionHandler;
import mikera.tyrant.ImageGadget;
import mikera.tyrant.InventoryScreen;
import mikera.tyrant.Item;
import mikera.tyrant.LevelMap;
import mikera.tyrant.LevelMapPanel;
import mikera.tyrant.Lib;
import mikera.tyrant.Map;
import mikera.tyrant.MapPanel;
import mikera.tyrant.Point;
import mikera.tyrant.QuestApp;
import mikera.tyrant.TPanel;
import mikera.tyrant.Thing;
import mikera.tyrant.author.MapMaker;
import mikera.tyrant.author.ThingEditor;

public class Designer {
    public static final Action POINT = new Action("Point");
    public static final Action LINE = new Action("Line");
    public static final Action CIRCLE = new Action("Circle");
    public static final Action RECTANGLE = new Action("Rectangle");
    public static final Action SWITCH_TO_TILE_PALETTE = new Action("switch to tiles");
    public static final Action SWITCH_TO_THING_PALETTE = new Action("switch to things");
    public static final Action ADD_THING = new Action("Add thing");
    public static final Action ADD_TILE = new Action("Add tile");
    public static final Action UNDO = new Action("undo");
    public static final Action REDO = new Action("redo");
    public static final Action RESIZE = new Action("Resize");
    public static final Action ERASE = new Action("erase");
    public static final Action DELETE = new Action("delete");
    public static final Action FILL = new Action("Fill");
    public static final Action SELECT = new Action("Select");
    protected Action mode = POINT;
    protected MapPanel mapPanel;
    private boolean embedded = false;
    private Point currentPoint;
    private boolean inDrag;
    private int[] oldTiles;
    private Thing[] oldThings;
    protected Map map;
    private InventoryScreen tilesScreen;
    private InventoryScreen thingsScreen;
    private Thing currentThing = (Thing)Lib.get("cave wall");
    private Frame tilePalette;
    private Frame thingPalette;
    private boolean switchPalette = false;
    private Frame frame;
    private IMapUpdater addTile;
    private IMapUpdater addThing;
    private IMapUpdater deleteThing;
    private IMapUpdater currentMapAdder;
    private IActionHandler actionHandler = new MyActionHandler();
    private TPanel statusBar;
    private ActionListener textListener;
    private TextField textField;
    private ImageGadget textLabel;
    private Action lastAction;
    private ThingEditor thingEditor;
    private ImageGadget statusGadget;
    private TPanel statusInfo;
    private Container statusInput;
    private QuestApp questApp;
    private LevelMapPanel levelMapPanel;
    private GameScreen gameScreen;
    private static java.util.Map isThings;
    private static Image overlayImage;
    private static Image plusImage;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel("com.jgoodies.plaf.plastic.PlasticXPLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Designer designer = new Designer();
        designer.go();
        if (stringArray.length >= 1 && stringArray[0].equals("embedded")) {
            designer.embedded = true;
        }
        if (designer.embedded) {
            try {
                Designer designer2 = designer;
                synchronized (designer2) {
                    designer.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Game.warn("Designer main thread completed.");
    }

    private void go() {
        this.createMapUpdaters();
        Game.loadVersionNumber();
        this.createFrame();
        this.frame.requestFocus();
    }

    private void loadImages() {
        MediaTracker mediaTracker = new MediaTracker(this.mapPanel);
        overlayImage = QuestApp.getImage("/images/isOverlay.gif");
        plusImage = QuestApp.getImage("/images/plus.gif");
        mediaTracker.addImage(overlayImage, 12);
        mediaTracker.addImage(plusImage, 12);
        try {
            mediaTracker.waitForID(12);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("Error reading image data");
            interruptedException.printStackTrace();
        }
    }

    private boolean shouldNotAdd(Thing thing, int n, int n2) {
        if (!this.inDrag) {
            return false;
        }
        Thing thing2 = this.map.getObjects(n, n2);
        while (thing2 != null) {
            if (thing2.name().equals(thing.name())) {
                return true;
            }
            thing2 = thing2.next;
        }
        return false;
    }

    private void createMapUpdaters() {
        this.addTile = new IMapUpdater(){

            public void set(Map map, int n, int n2, Thing thing) {
                if (Designer.this.shouldNotAdd(thing, n, n2)) {
                    return;
                }
                map.setTile(n, n2, thing.getStat("TileValue"));
            }
        };
        this.addThing = new IMapUpdater(){

            public void set(Map map, int n, int n2, Thing thing) {
                if (Designer.this.shouldNotAdd(thing, n, n2)) {
                    return;
                }
                map.addThing(thing.cloneType(), n, n2);
            }
        };
        this.deleteThing = new IMapUpdater(){

            public void set(Map map, int n, int n2, Thing thing) {
                Thing[] thingArray = map.getThings(n, n2);
                for (int i = 0; i < thingArray.length; ++i) {
                    thingArray[i].remove();
                }
            }
        };
        this.currentMapAdder = this.addTile;
    }

    protected void doErase(Map map, int n, int n2) {
        System.out.println("Doing erase!");
        this.map.setTile(n, n2, 0);
        this.map.getObjects()[n * map.getWidth() + n2] = null;
    }

    private void createFrame() {
        this.questApp = new QuestApp();
        QuestApp.isapplet = false;
        Game.setDebug(true);
        final Designer designer = this;
        this.frame = new Frame("Tyrant - Designer - v" + Game.VERSION);
        this.frame.setBackground(Color.black);
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                designer.exit();
            }
        });
        this.frame.setLayout(new BorderLayout());
        this.frame.add((Component)this.questApp, "Center");
        this.frame.setSize(this.questApp.getPreferredSize().width, this.questApp.getPreferredSize().height);
        this.frame.addKeyListener(this.questApp.keyadapter);
        this.frame.setMenuBar(this.createMenuBar());
        this.frame.setVisible(true);
        this.questApp.init(new StartBlock());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exit() {
        if (this.embedded) {
            Designer designer = this;
            synchronized (designer) {
                this.notify();
            }
            Game.warn("Disposing designer windows...");
            this.frame.dispose();
            this.thingPalette.dispose();
            this.tilePalette.dispose();
        } else {
            Game.warn("Exiting via System.exit(0)...");
            System.exit(0);
        }
    }

    private void createStatusBar() {
        this.statusBar = new TPanel(null);
        this.statusBar.setLayout(new CardLayout());
        this.statusInfo = new TPanel(null);
        this.statusInfo.setName("info");
        this.statusBar.add((Component)this.statusInfo, "info");
        this.statusInfo.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.weightx = 1.0;
        this.textLabel = ImageGadget.noImage(null);
        this.textLabel.setBackgroundImage(QuestApp.paneltexture);
        this.statusInfo.add((Component)this.textLabel, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 4);
        this.statusGadget = ImageGadget.noImage(null);
        this.statusGadget.setBackgroundImage(QuestApp.paneltexture);
        this.statusInfo.add((Component)this.statusGadget, gridBagConstraints);
        this.statusInput = new TPanel(null);
        this.statusInput.setName("input");
        this.statusBar.add((Component)this.statusInput, "input");
        this.statusInput.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.weightx = 1.0;
        this.textLabel = ImageGadget.noImage(null);
        this.textLabel.setBackgroundImage(QuestApp.paneltexture);
        this.statusInput.add((Component)this.textLabel, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.textField = new TextField(30);
        this.statusInput.add((Component)this.textField, gridBagConstraints);
        this.textListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Designer.this.doTextPerformed();
            }
        };
        this.textField.addActionListener(this.textListener);
        ((CardLayout)this.statusBar.getLayout()).show(this.statusBar, "info");
    }

    protected void doTextPerformed() {
        if (this.lastAction == RESIZE) {
            String string = this.textField.getText();
            if (string == null || string.length() == 0) {
                return;
            }
            String[] stringArray = string.split("x");
            int n = Integer.parseInt(stringArray[0].trim());
            int n2 = Integer.parseInt(stringArray[1].trim());
            this.doResize(n, n2);
            ((CardLayout)this.statusBar.getLayout()).show(this.statusBar, "info");
            this.statusBar.getParent().invalidate();
            this.statusBar.getParent().validate();
        }
    }

    private void doResize(int n, int n2) {
        Map map = new Map(n, n2);
        map.copyArea(0, 0, this.map, 0, 0, this.map.getWidth(), this.map.getHeight());
        this.mapPanel.map = map;
        this.gameScreen.map = map;
        this.map = map;
        LevelMap.reveal(map);
        this.levelMapPanel.getParent().invalidate();
        this.levelMapPanel.getParent().validate();
        this.makeAllVisible();
        this.mapPanel.setPosition(map, n / 2, n2 / 2);
        this.mapPanel.render();
        this.mapPanel.repaint();
        this.oldTiles = null;
        this.oldThings = null;
    }

    private MenuBar createMenuBar() {
        MenuBar menuBar = new MenuBar();
        menuBar.add(this.createMenu("File", new String[]{"Open Map", "Save Map", "Exit"}, new Action[]{Action.LOAD_GAME, Action.SAVE_GAME, Action.EXIT}, new boolean[]{true, true}));
        menuBar.add(this.createMenu("Edit", new String[]{"Undo", "Redo", "Resize"}, new Action[]{UNDO, REDO, RESIZE}, new boolean[]{false, true}));
        menuBar.add(this.createMenu("Mode", new String[]{"Paint", "Erase", "Fill", "Select", "Delete"}, new Action[]{POINT, ERASE, FILL, SELECT, DELETE}, new boolean[]{false, false, true}));
        menuBar.add(this.createMenu("Window", new String[]{"Show Thing editor"}, new Action[]{SELECT}, new boolean[]{false}));
        return menuBar;
    }

    private Menu createMenu(String string, String[] stringArray, Action[] actionArray, boolean[] blArray) {
        final HashMap hashMap = new HashMap();
        this.associateNamesAndActions(hashMap, stringArray, actionArray);
        Menu menu = new Menu(string);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            menu.add(string2);
            if (i >= blArray.length || !blArray[i]) continue;
            menu.addSeparator();
        }
        menu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Action action = (Action)hashMap.get(actionEvent.getActionCommand());
                if (action == null) {
                    return;
                }
                Designer.this.actionHandler.handleAction(null, action, false);
            }
        });
        return menu;
    }

    private void associateNamesAndActions(java.util.Map map, String[] stringArray, Action[] actionArray) {
        for (int i = 0; i < actionArray.length; ++i) {
            map.put(stringArray[i], actionArray[i]);
        }
    }

    private void createTilePalette() {
        this.tilePalette = new Frame("Tiles");
        this.tilePalette.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Designer.this.tilePalette.setVisible(false);
            }
        });
        this.tilePalette.setLayout(new BorderLayout());
        this.tilesScreen = new InventoryScreen(false, true);
        this.tilePalette.add((Component)this.tilesScreen, "Center");
        this.tilesScreen.setUp("Tiles", null, this.tilesAsThings());
        this.tilesScreen.getInventoryPanel().addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                Designer.this.currentThing = (Thing)itemEvent.getItem();
                Designer.this.currentMapAdder = Designer.this.addTile;
                System.out.println("current thing is " + Designer.this.currentThing);
                if (Designer.this.switchPalette) {
                    Designer.this.frame.requestFocus();
                }
            }
        });
        Rectangle rectangle = this.frame.getBounds();
        this.tilePalette.setBounds(rectangle.x + rectangle.width, rectangle.y, 300, rectangle.height);
    }

    private void createThingPalette() {
        this.thingPalette = new Frame("Things");
        this.thingPalette.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Designer.this.thingPalette.setVisible(false);
            }
        });
        this.thingPalette.setLayout(new BorderLayout());
        this.thingsScreen = new InventoryScreen(false, true);
        this.thingPalette.add((Component)this.thingsScreen, "Center");
        this.thingsScreen.setUp("Things", null, this.getThings());
        this.thingsScreen.getInventoryPanel().addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                Designer.this.currentThing = (Thing)itemEvent.getItem();
                Designer.this.currentMapAdder = Designer.this.addThing;
                System.out.println("current thing is " + Designer.this.currentThing);
                if (Designer.this.switchPalette) {
                    Designer.this.frame.requestFocus();
                }
            }
        });
        Rectangle rectangle = this.tilePalette.getBounds();
        this.thingPalette.setBounds(rectangle.x + rectangle.width, rectangle.y, 300, rectangle.height);
    }

    private Thing[] getThings() {
        List list = Lib.instance().getAll();
        ArrayList<Thing> arrayList = new ArrayList<Thing>();
        this.addIsThings(arrayList);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Thing thing = (Thing)iterator.next();
            Item.fullIdentify(thing);
            if (thing.name().startsWith("base ")) continue;
            arrayList.add(thing);
        }
        return arrayList.toArray(new Thing[arrayList.size()]);
    }

    private void addIsThings(List list) {
        list.add(Designer.getFlagged("IsFood"));
        list.add(Designer.getFlagged("IsBeast"));
        list.add(Designer.getFlagged("IsHerb"));
        list.add(Designer.getFlagged("IsScenery"));
        list.add(Designer.getFlagged("IsPotion"));
        list.add(Designer.getFlagged("IsFruitTree"));
        list.add(Designer.getFlagged("IsHostile"));
        list.add(Designer.getFlagged("IsWell"));
        list.add(Designer.getFlagged("IsBandit"));
        list.add(Designer.getFlagged("IsDoor"));
        list.add(Designer.getFlagged("IsMonster"));
        list.add(Designer.getFlagged("IsGoblinoid"));
        list.add(Designer.getFlagged("IsUndead"));
        list.add(Designer.getFlagged("IsDemonic"));
        list.add(Designer.getFlagged("IsUndead"));
        list.add(Designer.getFlagged("IsGravestone"));
        list.add(Designer.getFlagged("IsEquipment"));
        list.add(Designer.getFlagged("IsArmour"));
        list.add(Designer.getFlagged("IsWeapon"));
    }

    public static Thing getFlagged(String string) {
        if (isThings == null) {
            Designer.createAllIs();
        }
        return (Thing)isThings.get(string);
    }

    private static void createAllIs() {
        isThings = new HashMap();
        Iterator iterator = Lib.instance().getAllPropertyNames().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!string.startsWith("Is")) continue;
            Thing thing = new Thing();
            Thing thing2 = new Thing(thing);
            Thing thing3 = null;
            try {
                thing3 = Lib.createType(string, 1);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (thing3 == null) {
                thing3 = Lib.create("strange rock");
            }
            thing2.set("Name", string + "@");
            thing.set("AuthorIsTyped", true);
            thing.set("LevelMin", 1);
            thing.set("ImageSource", thing3.getString("ImageSource"));
            thing.set("Image", thing3.getStat("Image"));
            Lib.add(thing2);
            Designer.pushLocalUp(thing2);
            isThings.put(string, thing2);
        }
    }

    private static void pushLocalUp(Thing thing) {
        BaseObject baseObject = thing.getInherited();
        if (baseObject == null) {
            return;
        }
        Iterator iterator = thing.getLocal().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            Object v = entry.getValue();
            if (string.equals("Name")) continue;
            baseObject.set(string, v);
            iterator.remove();
        }
    }

    private Thing[] tilesAsThings() {
        return Lib.instance().getTiles().toArray(new Thing[Lib.instance().getTiles().size()]);
    }

    protected ActionMapping createActions() {
        ActionMapping actionMapping = new ActionMapping();
        actionMapping.addDefaultMovementActions();
        actionMapping.map('l', LINE);
        actionMapping.map('r', RECTANGLE);
        actionMapping.map('c', CIRCLE);
        actionMapping.map('-', Action.SAVE_GAME);
        actionMapping.map('+', Action.LOAD_GAME);
        actionMapping.map('=', Action.LOAD_GAME);
        actionMapping.map('t', ADD_TILE);
        actionMapping.map('h', ADD_THING);
        actionMapping.map('z', UNDO);
        actionMapping.map('f', FILL);
        actionMapping.map('p', POINT);
        actionMapping.map('s', SELECT);
        return actionMapping;
    }

    private void doRectangle(Point point, boolean bl) {
        this.map.setTiles(this.copy(this.oldTiles));
        this.map.setObjects(this.copy(this.oldThings));
        int n = Math.min(point.x, this.currentPoint.x);
        int n2 = Math.max(point.x, this.currentPoint.x);
        int n3 = Math.min(point.y, this.currentPoint.y);
        int n4 = Math.max(point.y, this.currentPoint.y);
        if (bl) {
            int n5 = Math.max(n2 - n, n4 - n3);
            n2 = n + n5;
            n4 = n3 + n5;
        }
        this.fastDrawLine(n, n3, n2, n3);
        this.fastDrawLine(n2, n3, n2, n4);
        this.fastDrawLine(n2, n4, n, n4);
        this.fastDrawLine(n, n4, n, n3);
        this.makeAllVisible();
    }

    public void doCircleMidpoint(Point point) {
        this.map.setTiles(this.copy(this.oldTiles));
        this.map.setObjects(this.copy(this.oldThings));
        int n = this.currentPoint.x;
        int n2 = this.currentPoint.y;
        int n3 = n - point.x;
        int n4 = n2 - point.y;
        int n5 = (int)Math.sqrt(n3 * n3 + n4 * n4);
        int n6 = 0;
        int n7 = n5;
        int n8 = (5 - n5 * 4) / 4;
        this.circlePoints(n, n2, n6, n7);
        while (n6 < n7) {
            n8 = n8 < 0 ? (n8 += 2 * n6 + 1) : (n8 += 2 * (++n6 - --n7) + 1);
            this.circlePoints(n, n2, n6, n7);
        }
        this.makeAllVisible();
    }

    private void doPoint(Point point) {
        if (this.mode == FILL) {
            this.doFill(point);
            return;
        }
        this.currentMapAdder.set(this.map, point.x, point.y, this.currentThing);
        this.makeAllVisible();
    }

    private void doFillWith(List list, int n) {
        if (this.currentMapAdder == this.addThing) {
            Game.message("Currently you can only fill with tiles.");
            return;
        }
        while (!list.isEmpty()) {
            Point point = (Point)list.remove(list.size() - 1);
            Point[] pointArray = this.orthoginalTiles(point);
            for (int i = 0; i < pointArray.length; ++i) {
                Point point2 = pointArray[i];
                if (this.map.getTile(point2.x, point2.y) != n) continue;
                this.currentMapAdder.set(this.map, point2.x, point2.y, this.currentThing);
                list.add(point2);
            }
            this.currentMapAdder.set(this.map, point.x, point.y, this.currentThing);
        }
    }

    private void doFill(Point point) {
        int n = this.map.getTile(point.x, point.y);
        ArrayList<Point> arrayList = new ArrayList<Point>();
        arrayList.add(point);
        this.doFillWith(arrayList, n);
        this.makeAllVisible();
        this.mapPanel.render();
        this.mapPanel.repaint();
    }

    private Point[] orthoginalTiles(Point point) {
        ArrayList<Point> arrayList = new ArrayList<Point>();
        if (point.y > 0) {
            arrayList.add(new Point(point.x, point.y - 1));
        }
        if (point.x < this.map.getWidth() - 1) {
            arrayList.add(new Point(point.x + 1, point.y));
        }
        if (point.y < this.map.getHeight() - 1) {
            arrayList.add(new Point(point.x, point.y + 1));
        }
        if (point.x > 0) {
            arrayList.add(new Point(point.x - 1, point.y));
        }
        return arrayList.toArray(new Point[arrayList.size()]);
    }

    private void doLine(Point point) {
        this.map.setTiles(this.copy(this.oldTiles));
        this.map.setObjects(this.copy(this.oldThings));
        this.fastDrawLine(this.currentPoint.x, this.currentPoint.y, point.x, point.y);
        this.makeAllVisible();
    }

    private int[] copy(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        return nArray2;
    }

    private Thing[] copy(Thing[] thingArray) {
        Thing[] thingArray2 = new Thing[thingArray.length];
        System.arraycopy(thingArray, 0, thingArray2, 0, thingArray.length);
        return thingArray2;
    }

    private void makeAllVisible() {
        for (int i = 0; i < this.map.getWidth(); ++i) {
            for (int j = 0; j < this.map.getHeight(); ++j) {
                this.map.setVisible(i, j);
            }
        }
        this.levelMapPanel.setMap(this.map);
        LevelMap.reveal(this.map);
        this.levelMapPanel.repaint();
    }

    private void fastDrawLine(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7 = n4 - n2;
        int n8 = n3 - n;
        if (n7 < 0) {
            n7 = -n7;
            n6 = -1;
        } else {
            n6 = 1;
        }
        if (n8 < 0) {
            n8 = -n8;
            n5 = -1;
        } else {
            n5 = 1;
        }
        this.currentMapAdder.set(this.map, n, n2, this.currentThing);
        if ((n8 <<= 1) > (n7 <<= 1)) {
            int n9 = n7 - (n8 >> 1);
            while (n != n3) {
                if (n9 >= 0) {
                    n2 += n6;
                    n9 -= n8;
                }
                n9 += n7;
                this.currentMapAdder.set(this.map, n += n5, n2, this.currentThing);
            }
        } else {
            int n10 = n8 - (n7 >> 1);
            while (n2 != n4) {
                if (n10 >= 0) {
                    n += n5;
                    n10 -= n7;
                }
                n10 += n8;
                this.currentMapAdder.set(this.map, n, n2 += n6, this.currentThing);
            }
        }
    }

    private Map createEmptyMap() {
        Map map = new Map(20, 20);
        map.set("Description", "design");
        map.fillArea(0, 0, map.getWidth(), map.getHeight(), 18);
        return map;
    }

    private final void circlePoints(int n, int n2, int n3, int n4) {
        if (n3 == 0) {
            this.currentMapAdder.set(this.map, n, n2 + n4, this.currentThing);
            this.currentMapAdder.set(this.map, n, n2 - n4, this.currentThing);
            this.currentMapAdder.set(this.map, n + n4, n2, this.currentThing);
            this.currentMapAdder.set(this.map, n - n4, n2, this.currentThing);
        } else if (n3 == n4) {
            this.currentMapAdder.set(this.map, n + n3, n2 + n4, this.currentThing);
            this.currentMapAdder.set(this.map, n - n3, n2 + n4, this.currentThing);
            this.currentMapAdder.set(this.map, n + n3, n2 - n4, this.currentThing);
            this.currentMapAdder.set(this.map, n - n3, n2 - n4, this.currentThing);
        } else if (n3 < n4) {
            this.currentMapAdder.set(this.map, n + n3, n2 + n4, this.currentThing);
            this.currentMapAdder.set(this.map, n - n3, n2 + n4, this.currentThing);
            this.currentMapAdder.set(this.map, n + n3, n2 - n4, this.currentThing);
            this.currentMapAdder.set(this.map, n - n3, n2 - n4, this.currentThing);
            this.currentMapAdder.set(this.map, n + n4, n2 + n3, this.currentThing);
            this.currentMapAdder.set(this.map, n - n4, n2 + n3, this.currentThing);
            this.currentMapAdder.set(this.map, n + n4, n2 - n3, this.currentThing);
            this.currentMapAdder.set(this.map, n - n4, n2 - n3, this.currentThing);
        }
    }

    private void loadMap() {
        Map map = new MapMaker().promptAndLoad();
        if (map != null) {
            this.reloadMap(map);
        }
    }

    public void reloadMap(Map map) {
        this.mapPanel.map = this.map = map;
        this.makeAllVisible();
        this.mapPanel.getParent().invalidate();
        this.mapPanel.getParent().validate();
        this.mapPanel.setPosition(map, 0, 0);
        this.mapPanel.render();
        this.mapPanel.repaint();
        this.oldTiles = null;
        this.oldThings = null;
    }

    private void saveMap() {
        String string = "map.txt";
        FileDialog fileDialog = new FileDialog(new Frame(), "Save map", 1);
        fileDialog.setFile(string);
        fileDialog.setVisible(true);
        if (fileDialog.getFile() == null) {
            return;
        }
        string = fileDialog.getDirectory() + fileDialog.getFile();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            String string2 = new MapMaker().store(this.map);
            fileOutputStream.write(string2.getBytes());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Game.message("Error while saving map, check console");
            return;
        }
        Game.message("Map saved - " + string);
    }

    private void openThingEditor(Point point) {
        if (this.thingEditor == null) {
            this.thingEditor = new ThingEditor();
            this.thingEditor.setDesigner(this);
            this.thingEditor.buildUI();
            this.thingEditor.getFrame().setLocation(this.frame.getLocation().x + this.frame.getSize().width, this.frame.getLocation().y);
            this.thingEditor.getFrame().setVisible(true);
        }
        this.thingEditor.inspect(point == null ? null : this.map.getThings(point.x, point.y));
        this.thingEditor.setVisible(true);
    }

    private void updateMode(String string) {
        this.statusGadget.setText("Mode: " + string);
        this.statusGadget.getParent().invalidate();
        this.statusGadget.getParent().validate();
    }

    private void updateMode(Action action) {
        this.mode = action;
        this.updateMode(action.toString());
    }

    public static Image getOverlayImage() {
        return overlayImage;
    }

    public static Image getPlusImage() {
        return plusImage;
    }

    static /* synthetic */ int[] access$2802(Designer designer, int[] nArray) {
        designer.oldTiles = nArray;
        return nArray;
    }

    static /* synthetic */ Thing[] access$2602(Designer designer, Thing[] thingArray) {
        designer.oldThings = thingArray;
        return thingArray;
    }

    private class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Designer.this.inDrag = false;
            Point point = Designer.this.mapPanel.convertUICoordinatesToMap(mouseEvent);
            Designer.this.currentPoint = point;
            if (Designer.this.mode == SELECT) {
                Designer.this.openThingEditor(point);
                return;
            }
            int[] nArray = Designer.this.map.getTiles();
            Designer.access$2802(Designer.this, new int[nArray.length]);
            Thing[] thingArray = Designer.this.map.getObjects();
            Designer.access$2602(Designer.this, new Thing[thingArray.length]);
            System.arraycopy(nArray, 0, Designer.this.oldTiles, 0, nArray.length);
            for (int i = 0; i < thingArray.length; ++i) {
                Thing thing = thingArray[i];
                if (thing == null) continue;
                ((Designer)Designer.this).oldThings[i] = thing == Game.hero() ? Game.hero() : thing.cloneType();
            }
            if (mouseEvent.getButton() == 1) {
                Designer.this.doPoint(point);
            }
            Designer.this.mapPanel.render();
            Designer.this.mapPanel.repaint();
        }
    }

    private class MyMouseMotionListener
    extends MouseMotionAdapter {
        private int scrollCount;

        private MyMouseMotionListener() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            Point point = Designer.this.mapPanel.convertUICoordinatesToMap(mouseEvent);
            Designer.this.inDrag = true;
            Rectangle rectangle = Designer.this.questApp.getScreen().getMappanel().getBounds();
            if (!rectangle.contains(mouseEvent.getPoint())) {
                if (this.scrollCount++ < 5) {
                    return;
                }
                this.scrollCount = 0;
                int n = 0;
                int n2 = 0;
                System.out.println("outside");
                if (mouseEvent.getY() < 0) {
                    if (mouseEvent.getX() < 0) {
                        System.out.println("NW");
                        n = -1;
                        n2 = -1;
                    } else if ((double)mouseEvent.getX() > rectangle.getWidth()) {
                        System.out.println("NE");
                        n = 1;
                        n2 = -1;
                    } else {
                        System.out.println("N");
                        n2 = -1;
                    }
                } else if ((double)mouseEvent.getY() > rectangle.getHeight()) {
                    if (mouseEvent.getX() < 0) {
                        System.out.println("SW");
                        n = -1;
                        n2 = 1;
                    } else if ((double)mouseEvent.getX() > rectangle.getWidth()) {
                        System.out.println("SE");
                        n = 1;
                        n2 = 1;
                    } else {
                        System.out.println("S");
                        n2 = 1;
                    }
                } else if (mouseEvent.getX() < 0) {
                    System.out.println("W");
                    n = -1;
                } else if ((double)mouseEvent.getX() > rectangle.getWidth()) {
                    System.out.println("E");
                    n = 1;
                }
                Designer.this.mapPanel.scroll(n, n2);
            }
            if (Designer.this.mode == POINT) {
                Designer.this.doPoint(point);
            } else if (Designer.this.mode == LINE) {
                Designer.this.doLine(point);
            } else if (Designer.this.mode == RECTANGLE) {
                Designer.this.doRectangle(point, mouseEvent.isShiftDown());
            } else if (Designer.this.mode == CIRCLE) {
                Designer.this.doCircleMidpoint(point);
            } else if (Designer.this.mode == ERASE) {
                // empty if block
            }
            Designer.this.mapPanel.render();
            Designer.this.mapPanel.repaint();
        }
    }

    private class MyActionHandler
    implements IActionHandler {
        private MyActionHandler() {
        }

        public boolean handleAction(Thing thing, Action action, boolean bl) {
            Designer.this.lastAction = action;
            if (action.isMovementKey()) {
                Point point = GameHandler.convertActionToDirection(action);
                Designer.this.mapPanel.scroll(point.x, point.y);
            } else if (action == POINT) {
                Designer.this.updateMode(POINT);
            }
            if (action == LINE) {
                Designer.this.updateMode(LINE);
            } else if (action == RECTANGLE) {
                Designer.this.updateMode(RECTANGLE);
            } else if (action == CIRCLE) {
                Designer.this.updateMode(CIRCLE);
            } else if (action == Action.SAVE_GAME) {
                Designer.this.saveMap();
            } else if (action == Action.LOAD_GAME) {
                Designer.this.loadMap();
            } else if (action == SWITCH_TO_TILE_PALETTE) {
                Designer.this.tilePalette.setVisible(true);
                Designer.this.tilesScreen.getInventoryPanel().requestFocus();
            } else if (action == ADD_THING) {
                Designer.this.updateMode("Add things");
                Designer.this.mode = POINT;
                Designer.this.thingPalette.setVisible(true);
                Designer.this.thingsScreen.getInventoryPanel().requestFocus();
                Designer.this.currentMapAdder = Designer.this.addThing;
            } else if (action == ADD_TILE) {
                Designer.this.updateMode("Add tiles");
                Designer.this.mode = POINT;
                Designer.this.tilePalette.setVisible(true);
                Designer.this.tilesScreen.getInventoryPanel().requestFocus();
                Designer.this.currentMapAdder = Designer.this.addTile;
            } else if (action == UNDO) {
                Game.message("Undo");
                if (Designer.this.currentMapAdder == Designer.this.addThing) {
                    Designer.this.map.setObjects(Designer.this.copy(Designer.this.oldThings));
                } else {
                    Designer.this.map.setTiles(Designer.this.copy(Designer.this.oldTiles));
                }
                Designer.this.makeAllVisible();
            } else if (action == ERASE) {
                Designer.this.updateMode(ERASE);
            } else if (action == DELETE) {
                Designer.this.updateMode(DELETE);
                Designer.this.currentMapAdder = Designer.this.deleteThing;
            } else if (action == FILL) {
                Game.message("Fill mode, currently only tiles can used for filling");
                Designer.this.updateMode(FILL);
            } else if (action == Action.EXIT) {
                Designer.this.exit();
            } else if (action == RESIZE) {
                Designer.this.textLabel.setText("Enter new size (current size is " + Designer.this.map.getWidth() + "x" + Designer.this.map.getHeight());
                Designer.this.textLabel.getParent().invalidate();
                Designer.this.textLabel.getParent().validate();
                Designer.this.statusBar.setVisible(true);
                ((CardLayout)Designer.this.statusBar.getLayout()).show(Designer.this.statusBar, "input");
                Designer.this.textField.requestFocus();
                Designer.this.statusBar.getParent().invalidate();
                Designer.this.statusBar.getParent().validate();
            } else if (action == SELECT) {
                if (Designer.this.thingEditor == null) {
                    Designer.this.openThingEditor(null);
                }
                Designer.this.updateMode(SELECT);
            }
            Designer.this.mapPanel.render();
            Designer.this.mapPanel.repaint();
            return true;
        }
    }

    private class StartBlock
    implements Runnable {
        private StartBlock() {
        }

        public void run() {
            Game.instance().setHero(Hero.createHero("Designer", "human", "fighter"));
            Game.instance().setDesignerMode(true);
            Designer.this.questApp.setupScreen();
            Designer.this.gameScreen = Designer.this.questApp.getScreen();
            Designer.this.mapPanel = Designer.this.gameScreen.getMappanel();
            Designer.this.loadImages();
            Designer.this.levelMapPanel = Designer.this.gameScreen.getLevelMap();
            ((Designer)Designer.this).questApp.keyhandler = new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    Action action = Designer.this.gameScreen.convertEventToAction(keyEvent);
                    Designer.this.actionHandler.handleAction(null, action, keyEvent.isShiftDown());
                }
            };
            Designer.this.mapPanel.addMouseListener(new MyMouseListener());
            Designer.this.mapPanel.addMouseMotionListener(new MyMouseMotionListener());
            Designer.this.gameScreen.addActionHandler(Designer.this.actionHandler);
            Designer.this.gameScreen.setGameHandler(new GameHandler(this){
                private final /* synthetic */ StartBlock this$1;
                {
                    this.this$1 = startBlock;
                }

                public void calculateVision(Thing thing) {
                    if (Game.instance().lineOfSightDisabled()) {
                        return;
                    }
                    thing.calculateVision();
                    Game.instance().isLineOfSightDisabled(true);
                }
            });
            Designer.this.gameScreen.getGameHandler().setActionMapping(Designer.this.createActions());
            Designer.this.map = Designer.this.createEmptyMap();
            Designer.this.createStatusBar();
            Designer.this.createTilePalette();
            Designer.this.createThingPalette();
            Designer.this.frame.add((Component)Designer.this.statusBar, "South");
            Designer.this.statusBar.setVisible(true);
            Designer.this.tilePalette.setVisible(true);
            Designer.this.thingPalette.setVisible(true);
            Designer.this.frame.invalidate();
            Designer.this.frame.validate();
            Designer.this.map.setAllVisible();
            Designer.this.levelMapPanel.setMap(Designer.this.map);
            Designer.this.mapPanel.render();
            Designer.this.mapPanel.viewPosition(Designer.this.map, Designer.this.map.getWidth() / 2, Designer.this.map.getHeight() / 2);
        }
    }

    public static interface IMapUpdater {
        public void set(Map var1, int var2, int var3, Thing var4);
    }
}

