/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.tools.mapeditor;

import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import net.yura.domination.engine.ColorUtil;

public class ImageUtil {
    public static void floodFill(BufferedImage source, int x, int y, int newColor) {
        int imgWidth = source.getWidth();
        int imgHeight = source.getHeight();
        int oldColor = source.getRGB(x, y);
        LinkedList<Point> queue = new LinkedList<Point>();
        int[] scanLine = new int[imgWidth];
        queue.add(new Point(x, y));
        while (!queue.isEmpty()) {
            int wx;
            Point n = (Point)queue.poll();
            if (source.getRGB(n.x, n.y) != oldColor) continue;
            int ex = n.x + 1;
            source.getRGB(0, n.y, imgWidth, 1, scanLine, 0, imgWidth);
            for (wx = n.x; wx >= 0 && scanLine[wx] == oldColor; --wx) {
                scanLine[wx] = newColor;
            }
            while (ex <= imgWidth - 1 && scanLine[ex] == oldColor) {
                scanLine[ex] = newColor;
                ++ex;
            }
            int length = ex - wx - 1;
            if (length > 0) {
                source.setRGB(wx + 1, n.y, length, 1, scanLine, wx + 1, imgWidth);
            }
            for (int ix = wx + 1; ix < ex; ++ix) {
                if (n.y - 1 >= 0 && source.getRGB(ix, n.y - 1) == oldColor) {
                    queue.add(new Point(ix, n.y - 1));
                }
                if (n.y + 1 >= imgHeight || source.getRGB(ix, n.y + 1) != oldColor) continue;
                queue.add(new Point(ix, n.y + 1));
            }
        }
    }

    public static void smartFill(BufferedImage source, BufferedImage target, int x, int y, int newColor, int tolerance) {
        int imgWidth = source.getWidth();
        int imgHeight = source.getHeight();
        int oldColor = source.getRGB(x, y);
        LinkedList<Point> queue = new LinkedList<Point>();
        int[] sourceScanLine = new int[imgWidth];
        int[] targetScanLine = new int[imgWidth];
        queue.add(new Point(x, y));
        while (!queue.isEmpty()) {
            int wx;
            Point n = (Point)queue.poll();
            if (!ImageUtil.checkColor(target.getRGB(n.x, n.y), newColor, source.getRGB(n.x, n.y), oldColor, tolerance)) continue;
            int ex = n.x + 1;
            source.getRGB(0, n.y, imgWidth, 1, sourceScanLine, 0, imgWidth);
            target.getRGB(0, n.y, imgWidth, 1, targetScanLine, 0, imgWidth);
            for (wx = n.x; wx >= 0 && ImageUtil.checkColor(targetScanLine[wx], newColor, sourceScanLine[wx], oldColor, tolerance); --wx) {
                targetScanLine[wx] = newColor;
            }
            while (ex <= imgWidth - 1 && ImageUtil.checkColor(targetScanLine[ex], newColor, sourceScanLine[ex], oldColor, tolerance)) {
                targetScanLine[ex] = newColor;
                ++ex;
            }
            int length = ex - wx - 1;
            if (length > 0) {
                target.setRGB(wx + 1, n.y, length, 1, targetScanLine, wx + 1, imgWidth);
            }
            for (int ix = wx + 1; ix < ex; ++ix) {
                if (n.y - 1 >= 0 && ImageUtil.checkColor(target.getRGB(ix, n.y - 1), newColor, source.getRGB(ix, n.y - 1), oldColor, tolerance)) {
                    queue.add(new Point(ix, n.y - 1));
                }
                if (n.y + 1 >= imgHeight || !ImageUtil.checkColor(target.getRGB(ix, n.y + 1), newColor, source.getRGB(ix, n.y + 1), oldColor, tolerance)) continue;
                queue.add(new Point(ix, n.y + 1));
            }
        }
    }

    private static boolean checkColor(int target, int newColor, int rgb1, int rgb2, int tolerance) {
        if (target == newColor) {
            return false;
        }
        if (Math.abs(ColorUtil.getRed(rgb1) - ColorUtil.getRed(rgb2)) > tolerance) {
            return false;
        }
        if (Math.abs(ColorUtil.getGreen(rgb1) - ColorUtil.getGreen(rgb2)) > tolerance) {
            return false;
        }
        return Math.abs(ColorUtil.getBlue(rgb1) - ColorUtil.getBlue(rgb2)) <= tolerance;
    }
}

