/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.ui.flashgui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.event.MouseInputListener;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.RiskUIUtil;
import net.yura.domination.engine.RiskUtil;
import net.yura.domination.engine.SwingMEWrapper;
import net.yura.domination.engine.core.Player;
import net.yura.domination.engine.guishared.AboutDialog;
import net.yura.domination.engine.translation.TranslationBundle;
import net.yura.domination.ui.flashgui.FlashBorder;
import net.yura.domination.ui.flashgui.FlashRiskAdapter;
import net.yura.domination.ui.flashgui.JoinDialog;
import net.yura.grasshopper.PopupBug;
import net.yura.lobby.mini.MiniLobbyClient;
import net.yura.me4se.ME4SEPanel;
import net.yura.mobile.gui.ActionListener;
import net.yura.swing.GraphicsUtil;
import net.yura.swing.ImageIcon;
import net.yura.swingme.core.CoreUtil;

public class MainMenu
extends JPanel
implements MouseInputListener,
KeyListener {
    private static final String version = "2";
    private static final String product = "Flash GUI for " + RiskUtil.GAME_NAME;
    private BufferedImage MenuImage;
    private BufferedImage Server;
    private Risk myrisk;
    private FlashRiskAdapter fra;
    private boolean serverRunning;
    private JoinDialog joinDialog;
    private static final int BUTTON_EXIT = 100;
    private static final int BUTTON_NEW = 1;
    private static final int BUTTON_SERVER = 2;
    private static final int BUTTON_LOADGAME = 3;
    private static final int BUTTON_HELP = 4;
    private static final int BUTTON_JOIN = 5;
    private static final int BUTTON_ABOUT = 6;
    private static final int BUTTON_LOBBY = 7;
    private static final int BUTTON_DONATE = 8;
    private JLabel lobby;
    private ResourceBundle resBundle = TranslationBundle.getBundle();
    private Cursor hand;
    private Cursor defaultCursor;
    private Frame window;
    private RootPaneContainer root;
    private int button;
    private int currentButton;
    private int pressedButton;
    private int highlightButton;
    MiniLobbyClient mlc;

    public MainMenu(Risk r, Frame gui, RootPaneContainer root) {
        this.myrisk = r;
        this.window = gui;
        this.root = root;
        this.fra = new FlashRiskAdapter(this, this.myrisk);
        this.MenuImage = RiskUIUtil.getUIImage(this.getClass(), "menu.jpg");
        this.Server = this.MenuImage.getSubimage(400, 490, 60, 60);
        Dimension menuSize = GraphicsUtil.newDimension(400, 550);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setPreferredSize(menuSize);
        this.setMinimumSize(menuSize);
        this.setMaximumSize(menuSize);
        this.highlightButton = 0;
        this.serverRunning = false;
        gui.setFocusTraversalKeysEnabled(false);
        gui.addKeyListener(this);
        this.setLayout(null);
        this.lobby = new JLabel(this.resBundle.getString("mainmenu.globe.playonline"), new ImageIcon(this.getClass().getResource("earth.gif")), 0);
        GraphicsUtil.setBounds(this.lobby, 152, 409, 95, 95);
        this.lobby.setHorizontalTextPosition(0);
        this.lobby.setFont(new Font("Arial", 1, this.getFont().getSize() + 5));
        this.lobby.setVisible(RiskUIUtil.checkForNoSandbox());
        this.lobby.setForeground(Color.WHITE);
        this.add(this.lobby);
        this.hand = Cursor.getPredefinedCursor(12);
        this.defaultCursor = this.getCursor();
        this.showMainMenu();
    }

    public void setServerRunning(boolean s) {
        this.serverRunning = s;
        this.repaint();
    }

    public void hideJoinDialog(boolean a) {
        if (!a) {
            this.joinDialog.exitForm();
            this.joinDialog = null;
        }
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void paintComponent(Graphics g) {
        GraphicsUtil.drawImage(g, this.MenuImage, 0, 0, 400, 550, 0, 0, 400, 550, this);
        if (this.highlightButton == 1) {
            GraphicsUtil.drawImage(g, this.MenuImage, 57, 219, 187, 269, 400, 0, 530, 50, this);
        } else if (this.highlightButton == 2) {
            GraphicsUtil.drawImage(g, this.MenuImage, 212, 219, 342, 269, 400, 50, 530, 100, this);
        } else if (this.highlightButton == 3) {
            GraphicsUtil.drawImage(g, this.MenuImage, 57, 279, 187, 329, 400, 100, 530, 150, this);
        } else if (this.highlightButton == 4) {
            GraphicsUtil.drawImage(g, this.MenuImage, 212, 279, 342, 329, 400, 150, 530, 200, this);
        } else if (this.highlightButton == 5) {
            GraphicsUtil.drawImage(g, this.MenuImage, 57, 339, 187, 389, 400, 200, 530, 250, this);
        } else if (this.highlightButton == 6) {
            GraphicsUtil.drawImage(g, this.MenuImage, 212, 339, 342, 389, 400, 250, 530, 300, this);
        } else if (this.button == 1) {
            GraphicsUtil.drawImage(g, this.MenuImage, 57, 219, 187, 269, 530, 0, 660, 50, this);
        } else if (this.button == 2) {
            GraphicsUtil.drawImage(g, this.MenuImage, 212, 219, 342, 269, 530, 50, 660, 100, this);
        } else if (this.button == 3) {
            GraphicsUtil.drawImage(g, this.MenuImage, 57, 279, 187, 329, 530, 100, 660, 150, this);
        } else if (this.button == 4) {
            GraphicsUtil.drawImage(g, this.MenuImage, 212, 279, 342, 329, 530, 150, 660, 200, this);
        } else if (this.button == 5) {
            GraphicsUtil.drawImage(g, this.MenuImage, 57, 339, 187, 389, 530, 200, 660, 250, this);
        } else if (this.button == 6) {
            GraphicsUtil.drawImage(g, this.MenuImage, 212, 339, 342, 389, 530, 250, 660, 300, this);
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.black);
        GraphicsUtil.drawStringCenteredAt((Graphics)g2, this.resBundle.getString("mainmenu.newgame"), 'N', 122, 247);
        if (this.serverRunning) {
            GraphicsUtil.drawStringCenteredAt((Graphics)g2, this.resBundle.getString("mainmenu.stopserver"), 'S', 277, 247);
            GraphicsUtil.drawImage(g, this.Server, 340, 490, this);
        } else {
            GraphicsUtil.drawStringCenteredAt((Graphics)g2, this.resBundle.getString("mainmenu.startserver"), 'S', 277, 247);
        }
        GraphicsUtil.drawStringCenteredAt((Graphics)g2, this.resBundle.getString("mainmenu.loadgame"), 'L', 122, 309);
        GraphicsUtil.drawStringCenteredAt((Graphics)g2, this.resBundle.getString("mainmenu.help"), 'H', 277, 309);
        GraphicsUtil.drawStringCenteredAt((Graphics)g2, this.resBundle.getString("mainmenu.joingame"), 'J', 122, 369);
        GraphicsUtil.drawStringCenteredAt((Graphics)g2, this.resBundle.getString("mainmenu.about"), 'A', 277, 369);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.highlightButton = 0;
        this.currentButton = this.insideButton(e.getX(), e.getY());
        if (this.currentButton != 0) {
            this.pressedButton = this.currentButton;
            this.button = this.currentButton;
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent e) {
        int thebutton = 0;
        if (this.pressedButton == this.currentButton) {
            thebutton = this.pressedButton;
        }
        if (this.button != 0) {
            this.button = 0;
        }
        this.highlightButton = this.currentButton;
        this.repaint();
        this.activateButton(thebutton);
    }

    private void activateButton(int thebutton) {
        if (thebutton != 0) {
            switch (thebutton) {
                case 1: {
                    this.myrisk.parser("newgame");
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.removeMouseListener(this);
                    this.removeMouseMotionListener(this);
                    break;
                }
                case 2: {
                    if (this.serverRunning) {
                        this.myrisk.parser("killserver");
                        break;
                    }
                    this.myrisk.parser("startserver");
                    break;
                }
                case 3: {
                    String name = RiskUIUtil.getLoadFileName(RiskUIUtil.findParentFrame(this));
                    if (name == null) break;
                    this.myrisk.parser("loadgame " + name);
                    break;
                }
                case 4: {
                    try {
                        RiskUtil.openDocs(TranslationBundle.getBundle().getString("helpfiles.flash"));
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(RiskUIUtil.findParentFrame(this), "Unable to open manual: " + e.getMessage(), "Error", 0);
                    }
                    break;
                }
                case 5: {
                    Frame frame = RiskUIUtil.findParentFrame(this);
                    this.joinDialog = new JoinDialog(frame, true, this.myrisk);
                    Dimension frameSize = frame.getSize();
                    Dimension aboutSize = this.joinDialog.getPreferredSize();
                    int x = frame.getLocation().x + (frameSize.width - aboutSize.width) / 2;
                    int y = frame.getLocation().y + (frameSize.height - aboutSize.height) / 2;
                    if (x < 0) {
                        x = 0;
                    }
                    if (y < 0) {
                        y = 0;
                    }
                    this.joinDialog.setLocation(x, y + 10);
                    this.joinDialog.setVisible(true);
                    break;
                }
                case 7: {
                    if (!this.lobby.isVisible()) break;
                    this.showMiniLobby();
                    break;
                }
                case 6: {
                    Frame frame = RiskUIUtil.findParentFrame(this);
                    RiskUIUtil.openAbout(frame, product, version);
                    break;
                }
                case 100: {
                    this.exit();
                    break;
                }
                case 8: {
                    RiskUIUtil.donate(this);
                }
            }
            this.currentButton = 0;
            this.repaint();
        }
    }

    public void mouseMoved(MouseEvent e) {
        int oldhighlightButton = this.highlightButton;
        int newhighlightButton = this.insideButton(e.getX(), e.getY());
        if (oldhighlightButton != newhighlightButton) {
            this.highlightButton = newhighlightButton;
            this.repaint();
        }
        if (newhighlightButton == 8) {
            if (this.getCursor() == this.defaultCursor) {
                this.setCursor(this.hand);
            }
        } else if (this.getCursor() == this.hand) {
            this.setCursor(this.defaultCursor);
        }
    }

    public void mouseDragged(MouseEvent e) {
        this.currentButton = this.insideButton(e.getX(), e.getY());
        if (this.pressedButton == this.currentButton) {
            if (this.button != this.pressedButton) {
                this.button = this.pressedButton;
                this.repaint();
            }
        } else if (this.button != 0) {
            this.button = 0;
            this.repaint();
        }
    }

    public int insideButton(int x, int y) {
        int W = 116;
        int H = 31;
        int r = this.lobby.getWidth() / 2;
        if (GraphicsUtil.insideButton(x, y, 65, 228, W, H)) {
            return 1;
        }
        if (GraphicsUtil.insideButton(x, y, 220, 228, W, H)) {
            return 2;
        }
        if (GraphicsUtil.insideButton(x, y, 65, 289, W, H)) {
            return 3;
        }
        if (GraphicsUtil.insideButton(x, y, 220, 289, W, H)) {
            return 4;
        }
        if (GraphicsUtil.insideButton(x, y, 65, 350, W, H)) {
            return 5;
        }
        if (GraphicsUtil.insideButton(x, y, 220, 350, W, H)) {
            return 6;
        }
        if (GraphicsUtil.insideButton(x, y, 0, 500, 130, 50)) {
            return 8;
        }
        if (Math.sqrt(Math.pow(x - (this.lobby.getX() + r), 2.0) + Math.pow(y - (this.lobby.getY() + r), 2.0)) < (double)r) {
            return 7;
        }
        return 0;
    }

    public void keyReleased(KeyEvent event) {
        switch (event.getKeyCode()) {
            case 9: {
                this.highlightButton = event.isShiftDown() ? --this.highlightButton : ++this.highlightButton;
                if (this.highlightButton > 7) {
                    this.highlightButton = 1;
                } else if (this.highlightButton < 1) {
                    this.highlightButton = 7;
                }
                this.repaint();
                break;
            }
            case 10: 
            case 32: {
                this.activateButton(this.highlightButton);
                break;
            }
            case 78: {
                this.activateButton(1);
                break;
            }
            case 76: {
                this.activateButton(3);
                break;
            }
            case 27: 
            case 81: {
                this.activateButton(100);
                break;
            }
            case 74: {
                this.activateButton(5);
                break;
            }
            case 65: {
                this.activateButton(6);
                break;
            }
            case 83: {
                this.activateButton(2);
                break;
            }
            case 72: {
                this.activateButton(4);
                break;
            }
            case 79: {
                this.activateButton(7);
            }
        }
    }

    public void keyPressed(KeyEvent event) {
    }

    public void keyTyped(KeyEvent event) {
    }

    private void exit() {
        this.myrisk.deleteRiskListener(this.fra);
    }

    public void hide() {
        this.window.setVisible(false);
    }

    public void show() {
        this.window.setVisible(true);
    }

    void showMainMenu() {
        this.root.setContentPane(this);
        this.window.setTitle(TranslationBundle.getBundle().getString("mainmenu.title"));
        this.window.setResizable(false);
        this.window.pack();
    }

    void showMiniLobby() {
        final ME4SEPanel wrapper = new ME4SEPanel();
        wrapper.getApplicationManager().applet = RiskUIUtil.applet;
        this.mlc = SwingMEWrapper.makeMiniLobbyClient("lobby.yura.net", this.myrisk, this.window);
        wrapper.add((net.yura.mobile.gui.components.Component)this.mlc.getRoot());
        this.mlc.addCloseListener(new ActionListener(){

            public void actionPerformed(String actionCommand) {
                wrapper.destroy();
                MainMenu.this.showMainMenu();
                MainMenu.this.mlc = null;
            }
        });
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)wrapper);
        BufferedImage img = RiskUIUtil.getUIImage(this.getClass(), "graph.jpg");
        panel.setBorder(new FlashBorder(img.getSubimage(100, 0, 740, 50), img.getSubimage(0, 0, 50, 400), img.getSubimage(100, 350, 740, 50), img.getSubimage(50, 0, 50, 400)));
        this.root.setContentPane(panel);
        this.window.setTitle(this.mlc.getTitle());
        this.window.setResizable(true);
        this.window.setSize(GraphicsUtil.scale(500), GraphicsUtil.scale(600));
    }

    Action getOnlineAction() {
        return this.mlc == null ? null : new AbstractAction(this.resBundle.getString("lobby.resign")){

            public void actionPerformed(ActionEvent e) {
                MainMenu.this.mlc.resign();
                this.setEnabled(false);
            }

            public boolean isEnabled() {
                Player player = MainMenu.this.mlc == null ? null : MainMenu.this.myrisk.getGame().getPlayer(MainMenu.this.mlc.whoAmI());
                return super.isEnabled() && player != null && player.isAlive();
            }
        };
    }

    public static void main(String[] argv) {
        RiskUIUtil.parseArgs(argv);
        MainMenu.initGrasshopper();
        Risk r = new Risk();
        MainMenu.newMainMenuFrame(r, 3);
        RiskUIUtil.openFile(argv, r);
        RiskUIUtil.checkForUpdates(r);
    }

    public static MainMenu newMainMenuFrame(Risk r, int a) {
        JFrame gui = new JFrame();
        gui.setIconImage(Toolkit.getDefaultToolkit().getImage(AboutDialog.class.getResource("icon.gif")));
        final MainMenu mm = new MainMenu(r, gui, gui);
        gui.setDefaultCloseOperation(a);
        gui.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                mm.exit();
            }
        });
        RiskUIUtil.center(gui);
        gui.setVisible(true);
        return mm;
    }

    private static void initGrasshopper() {
        if (RiskUIUtil.checkForNoSandbox()) {
            try {
                Preferences.userRoot();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                PopupBug.initSimple(RiskUtil.GAME_NAME, RiskUtil.RISK_VERSION + " FlashGUI", TranslationBundle.getBundle().getLocale().toString());
            }
            catch (Throwable th) {
                System.out.println("Grasshopper not loaded");
            }
            try {
                CoreUtil.setupLogging();
            }
            catch (Throwable th) {
                RiskUtil.printStackTrace(th);
            }
        }
    }
}

