/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.ui.swinggui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import net.yura.domination.engine.ColorUtil;
import net.yura.domination.engine.RiskUIUtil;
import net.yura.domination.engine.RiskUtil;
import net.yura.domination.engine.core.Continent;
import net.yura.domination.engine.core.RiskGame;
import net.yura.domination.engine.guishared.BadgeButton;
import net.yura.domination.engine.guishared.MapMouseListener;
import net.yura.domination.engine.translation.TranslationBundle;
import net.yura.domination.ui.swinggui.CardsDialog;
import net.yura.domination.ui.swinggui.SwingGUIPanel;
import net.yura.domination.ui.swinggui.SwingGUITab;
import net.yura.swing.GraphicsUtil;
import net.yura.swing.ImageIcon;
import net.yura.swing.JTable;

public class GameTab
extends JPanel
implements SwingGUITab,
ActionListener {
    private ResourceBundle resbundle = TranslationBundle.getBundle();
    private SwingGUIPanel swingGUIPanel;
    private JPanel Pix;
    private JPanel guiGame;
    private JLabel gameStatus;
    private JMenu gGame;
    private JToolBar toolbarGUI;
    private boolean serverOn;
    private JButton gNewGame;
    private JButton gLoadGame;
    private JButton gSaveGame;
    private JButton gCloseGame;
    private JButton gJoinGame;
    private JButton gStartServer;
    private JButton gOptions;
    private JMenuItem gmOptions;
    private JMenuItem gmReplay;
    private JMenuItem gmStartServer;
    private JMenuItem gmJoinGame;
    private JMenuItem gmNewGame;
    private JMenuItem gmLoadGame;
    private JMenuItem gmSaveGame;
    private JMenuItem gmCloseGame;
    private JButton showMission;
    private JButton showCards;
    private JButton Undo;
    private JButton autoplace;
    private JPanel gameOptions;
    private JLabel capitalLabel;
    private JTextField country1;
    private JTextField country2;
    private JSlider moveNumber;
    private boolean localGame;
    private JPanel inGameInput;
    private CardLayout inGameCards;
    private JComboBox mapViewComboBox;
    SetupPanel guiSetup;
    JLabel resultsLabel;
    JLabel attacker;
    JLabel armies;
    JSlider slider;
    JButton roll1;
    JButton roll2;
    JButton roll3;
    JPanel defend;
    JPanel roll;
    winnerPanel winner;
    tradeCardsPanel tradeCards;

    public GameTab(SwingGUIPanel swingGUI) {
        this.swingGUIPanel = swingGUI;
        this.setName(this.resbundle.getString("swing.tab.game"));
        this.serverOn = false;
        this.gameStatus = new JLabel("");
        this.Pix = new JPanel(new BorderLayout());
        this.Pix.setOpaque(false);
        JLabel pixlogo = new JLabel("yura.net " + SwingGUIPanel.product + ", " + RiskUtil.GAME_NAME + " IDE", new ImageIcon(this.getClass().getResource("about.jpg")), 0);
        pixlogo.setHorizontalTextPosition(0);
        pixlogo.setVerticalTextPosition(1);
        this.Pix.add((Component)this.swingGUIPanel.lobby, "North");
        this.Pix.add(pixlogo);
        JButton donate = new JButton();
        donate.addActionListener(this);
        donate.setActionCommand("donate");
        donate.setCursor(Cursor.getPredefinedCursor(12));
        URL donateNow = this.getClass().getResource("donate.png");
        if (donateNow != null) {
            donate.setIcon(new ImageIcon(donateNow));
        } else {
            donate.setText("Donate");
        }
        this.Pix.add((Component)donate, "South");
        this.setLayout(new BorderLayout());
        this.add((Component)this.Pix, "Center");
        this.add((Component)this.gameStatus, "South");
        this.gameStatus.setBorder(BorderFactory.createLoweredBevelBorder());
        Insets margin = new Insets(2, 2, 2, 2);
        this.showMission = new JButton(this.resbundle.getString("swing.button.mission"));
        this.showMission.setToolTipText(this.resbundle.getString("game.button.mission"));
        this.showMission.addActionListener(this);
        this.showMission.setActionCommand("showmission");
        this.showMission.setMargin(margin);
        this.showCards = new JButton(this.resbundle.getString("swing.button.cards"));
        this.showCards.setToolTipText(this.resbundle.getString("game.button.cards"));
        this.showCards.addActionListener(this);
        this.showCards.setActionCommand("showcards");
        this.showCards.setMargin(margin);
        this.Undo = new JButton(this.resbundle.getString("swing.button.undo"));
        this.Undo.setToolTipText(this.resbundle.getString("game.button.undo"));
        this.Undo.addActionListener(this);
        this.Undo.setActionCommand("undo");
        this.Undo.setMargin(margin);
        JButton viewContinents = new JButton(this.resbundle.getString("swing.button.continents"));
        viewContinents.addActionListener(this);
        viewContinents.setActionCommand("continents");
        viewContinents.setMargin(margin);
        this.moveNumber = new JSlider();
        this.slider = new JSlider();
        this.armies = new JLabel();
        this.toolbarGUI = new JToolBar();
        this.toolbarGUI.setRollover(true);
        this.autoplace = new JButton(this.resbundle.getString("game.button.go.autoplace"));
        Dimension gameOptionsSize = GraphicsUtil.newDimension(677, 25);
        this.gameOptions = this.makeGameOptionsPanel();
        this.gameOptions.setPreferredSize(gameOptionsSize);
        this.gameOptions.setMinimumSize(gameOptionsSize);
        this.gameOptions.setMaximumSize(gameOptionsSize);
        this.gameOptions.add(viewContinents);
        this.guiSetup = new SetupPanel();
        this.guiGame = new GamePanel();
        this.guiSetup.setOpaque(false);
        this.guiGame.setOpaque(false);
        this.gNewGame = new JButton(this.resbundle.getString("swing.menu.new"));
        this.gLoadGame = new JButton(this.resbundle.getString("swing.menu.load"));
        this.gSaveGame = new JButton(this.resbundle.getString("swing.menu.save"));
        this.gCloseGame = new JButton(this.resbundle.getString("swing.menu.close"));
        this.gOptions = new JButton(this.resbundle.getString("swing.menu.options"));
        this.gJoinGame = new JButton(this.resbundle.getString("swing.menu.joingame"));
        this.gStartServer = new JButton(this.resbundle.getString("swing.menu.startserver"));
        JButton gManual = new JButton(this.resbundle.getString("swing.menu.manual"));
        JButton gAbout = new JButton(this.resbundle.getString("swing.menu.about"));
        JButton gQuit = new JButton(this.resbundle.getString("swing.menu.quit"));
        this.gNewGame.setActionCommand("new game");
        this.gNewGame.addActionListener(this);
        this.gLoadGame.setActionCommand("load game");
        this.gLoadGame.addActionListener(this);
        this.gSaveGame.setActionCommand("save game");
        this.gSaveGame.addActionListener(this);
        this.gCloseGame.setActionCommand("close game");
        this.gCloseGame.addActionListener(this);
        this.gOptions.setActionCommand("options");
        this.gOptions.addActionListener(this);
        gManual.setActionCommand("manual");
        gManual.addActionListener(this);
        gAbout.setActionCommand("about");
        gAbout.addActionListener(this);
        gQuit.setActionCommand("quit");
        gQuit.addActionListener(this);
        this.gStartServer.setActionCommand("start server");
        this.gStartServer.addActionListener(this);
        this.gJoinGame.setActionCommand("join game");
        this.gJoinGame.addActionListener(this);
        this.toolbarGUI.add(this.gNewGame);
        this.toolbarGUI.add(this.gLoadGame);
        this.toolbarGUI.add(this.gSaveGame);
        this.toolbarGUI.add(this.gCloseGame);
        this.toolbarGUI.addSeparator();
        this.toolbarGUI.add(this.gJoinGame);
        this.toolbarGUI.add(this.gStartServer);
        this.toolbarGUI.addSeparator();
        this.toolbarGUI.add(this.gOptions);
        this.toolbarGUI.add(gManual);
        this.toolbarGUI.add(gAbout);
        if (RiskUIUtil.checkForNoSandbox()) {
            this.toolbarGUI.add(gQuit);
        }
        this.toolbarGUI.setFloatable(false);
        this.gGame = new JMenu(this.resbundle.getString("swing.menu.game"));
        this.gGame.setMnemonic('G');
        this.gmNewGame = new JMenuItem(this.resbundle.getString("swing.menu.new"));
        this.gmNewGame.setMnemonic('N');
        this.gmNewGame.setActionCommand("new game");
        this.gmNewGame.addActionListener(this);
        this.gGame.add(this.gmNewGame);
        this.gmLoadGame = new JMenuItem(this.resbundle.getString("swing.menu.load"));
        this.gmLoadGame.setMnemonic('L');
        this.gmLoadGame.setActionCommand("load game");
        this.gmLoadGame.addActionListener(this);
        this.gGame.add(this.gmLoadGame);
        this.gmSaveGame = new JMenuItem(this.resbundle.getString("swing.menu.save"));
        this.gmSaveGame.setMnemonic('S');
        this.gmSaveGame.setActionCommand("save game");
        this.gmSaveGame.addActionListener(this);
        this.gGame.add(this.gmSaveGame);
        this.gmCloseGame = new JMenuItem(this.resbundle.getString("swing.menu.close"));
        this.gmCloseGame.setMnemonic('C');
        this.gmCloseGame.setActionCommand("close game");
        this.gmCloseGame.addActionListener(this);
        this.gGame.add(this.gmCloseGame);
        this.gGame.addSeparator();
        this.gmJoinGame = new JMenuItem(this.resbundle.getString("swing.menu.joingame"));
        this.gmJoinGame.setMnemonic('J');
        this.gmJoinGame.setActionCommand("join game");
        this.gmJoinGame.addActionListener(this);
        this.gGame.add(this.gmJoinGame);
        this.gmStartServer = new JMenuItem(this.resbundle.getString("swing.menu.startserver"));
        this.gmStartServer.setMnemonic('V');
        this.gmStartServer.setActionCommand("start server");
        this.gmStartServer.addActionListener(this);
        this.gGame.add(this.gmStartServer);
        this.gGame.addSeparator();
        this.gmOptions = new JMenuItem(this.resbundle.getString("swing.menu.options"));
        this.gmOptions.setMnemonic('O');
        this.gmOptions.setActionCommand("options");
        this.gmOptions.addActionListener(this);
        this.gGame.add(this.gmOptions);
        this.gmReplay = new JMenuItem("Replay");
        this.gmReplay.setMnemonic('R');
        this.gmReplay.setActionCommand("replay");
        this.gmReplay.addActionListener(this);
        this.gGame.add(this.gmReplay);
        if (RiskUIUtil.checkForNoSandbox()) {
            this.gGame.addSeparator();
            JMenuItem gmQuit = new JMenuItem(this.resbundle.getString("swing.menu.quit"));
            gmQuit.setMnemonic('Q');
            gmQuit.setActionCommand("quit");
            gmQuit.addActionListener(this);
            this.gGame.add(gmQuit);
        }
        this.roll1 = new JButton(this.resbundle.getString("swing.dice.roll1"));
        this.roll2 = new JButton(this.resbundle.getString("swing.dice.roll2"));
        this.roll3 = new JButton(this.resbundle.getString("swing.dice.roll3"));
        this.roll1.setActionCommand("roll 1");
        this.roll2.setActionCommand("roll 2");
        this.roll3.setActionCommand("roll 3");
        this.roll1.addActionListener(this);
        this.roll2.addActionListener(this);
        this.roll3.addActionListener(this);
        this.gOptions.setEnabled(false);
        this.gmOptions.setEnabled(false);
        this.gmReplay.setEnabled(false);
        this.gSaveGame.setEnabled(false);
        this.gCloseGame.setEnabled(false);
        this.gmSaveGame.setEnabled(false);
        this.gmCloseGame.setEnabled(false);
        this.setOpaque(false);
    }

    public JMenu getMenu() {
        return this.gGame;
    }

    public JToolBar getToolBar() {
        return this.toolbarGUI;
    }

    public void actionPerformed(ActionEvent a) {
        String actionCommand = a.getActionCommand();
        if ("showmission".equals(actionCommand)) {
            this.showMission(this.swingGUIPanel.myrisk.getCurrentMission());
        } else if ("showcards".equals(actionCommand)) {
            this.openCards();
        } else if ("undo".equals(actionCommand)) {
            this.swingGUIPanel.pp.setC1(255);
            this.swingGUIPanel.pp.setC2(255);
            this.swingGUIPanel.go("undo");
        } else if ("continents".equals(actionCommand)) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("<html><table>");
            Continent[] continents = this.swingGUIPanel.myrisk.getGame().getContinents();
            for (int c = 0; c < continents.length; ++c) {
                Continent continent = continents[c];
                buffer.append("<tr style=\"background-color: ");
                buffer.append(ColorUtil.getHexForColor(continent.getColor()));
                buffer.append("; color:");
                buffer.append(ColorUtil.getHexForColor(ColorUtil.getTextColorFor(continent.getColor())));
                buffer.append("\"><td>");
                buffer.append(continent.getName());
                buffer.append("</td><td> - </td><td>");
                buffer.append(continent.getArmyValue());
                buffer.append("</td></tr>");
            }
            buffer.append("</table></html>");
            JOptionPane.showMessageDialog(this, buffer.toString(), this.resbundle.getString("swing.button.continents"), -1);
        } else if ("roll 1".equals(actionCommand)) {
            this.swingGUIPanel.go("roll 1");
        } else if ("roll 2".equals(actionCommand)) {
            this.swingGUIPanel.go("roll 2");
        } else if ("roll 3".equals(actionCommand)) {
            this.swingGUIPanel.go("roll 3");
        } else if ("join game".equals(actionCommand)) {
            String result = JOptionPane.showInputDialog(RiskUIUtil.findParentFrame(this), "type the server name", this.swingGUIPanel.myrisk.getRiskConfig("default.host"));
            if (result != null) {
                this.swingGUIPanel.go("join " + result);
            }
        } else if ("new game".equals(actionCommand)) {
            this.swingGUIPanel.setCursor(Cursor.getPredefinedCursor(3));
            this.swingGUIPanel.go("newgame");
        } else if ("load game".equals(actionCommand)) {
            String name = RiskUIUtil.getLoadFileName(RiskUIUtil.findParentFrame(this));
            if (name != null) {
                this.swingGUIPanel.go("loadgame " + name);
            }
        } else if ("save game".equals(actionCommand)) {
            String name = RiskUIUtil.getSaveFileName(RiskUIUtil.findParentFrame(this));
            if (name != null) {
                this.swingGUIPanel.go("savegame " + name);
            }
        } else if ("close game".equals(actionCommand)) {
            this.swingGUIPanel.go("closegame");
        } else if ("options".equals(actionCommand)) {
            Object[] message = new Object[]{new JCheckBox("Auto End Go"), new JCheckBox("Auto Defend")};
            ((JCheckBox)message[0]).setSelected(this.swingGUIPanel.myrisk.getAutoEndGo());
            ((JCheckBox)message[1]).setSelected(this.swingGUIPanel.myrisk.getAutoDefend());
            Object[] options = new String[]{"OK", "cancel"};
            int result = JOptionPane.showOptionDialog(this, message, "Options", 2, -1, null, options, options[0]);
            if (result == 0) {
                this.swingGUIPanel.myrisk.parser("autodefend " + (((JCheckBox)message[1]).isSelected() ? "on" : "off"));
                this.swingGUIPanel.myrisk.parser("autoendgo " + (((JCheckBox)message[0]).isSelected() ? "on" : "off"));
            }
        } else if ("replay".equals(actionCommand)) {
            this.swingGUIPanel.go("replay");
        } else if ("start server".equals(actionCommand)) {
            if (this.serverOn) {
                this.swingGUIPanel.go("killserver");
            } else {
                this.swingGUIPanel.go("startserver");
            }
        } else if ("lobby".equals(actionCommand)) {
            RiskUIUtil.runLobby(this.swingGUIPanel.myrisk);
        } else if ("donate".equals(actionCommand)) {
            RiskUIUtil.donate(this);
        } else {
            this.swingGUIPanel.actionPerformed(a);
        }
    }

    public void showMission(String mission) {
        JOptionPane.showMessageDialog(this, this.resbundle.getString("swing.message.mission") + " " + mission, this.resbundle.getString("swing.title.mission"), 1);
    }

    public void openCards() {
        Frame frame = RiskUIUtil.findParentFrame(this);
        CardsDialog cardsDialog = new CardsDialog(frame, this.swingGUIPanel.pp, true, this.swingGUIPanel.myrisk, this.swingGUIPanel.gameState == 1);
        Dimension frameSize = frame.getSize();
        Dimension aboutSize = cardsDialog.getPreferredSize();
        int x = frame.getLocation().x + (frameSize.width - aboutSize.width) / 2;
        int y = frame.getLocation().y + (frameSize.height - aboutSize.height) / 2;
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        cardsDialog.setLocation(x, y);
        cardsDialog.populate(this.swingGUIPanel.myrisk.getCurrentCards());
        cardsDialog.setVisible(true);
    }

    public void blockInput() {
        this.gSaveGame.setEnabled(false);
        this.gmSaveGame.setEnabled(false);
        this.showMission.setEnabled(false);
        this.showCards.setEnabled(false);
        this.Undo.setEnabled(false);
        this.gOptions.setEnabled(false);
        this.gmOptions.setEnabled(false);
        this.gmReplay.setEnabled(false);
        this.mapViewComboBox.grabFocus();
    }

    public void getInput() {
        if (this.localGame) {
            this.gSaveGame.setEnabled(true);
            this.gmSaveGame.setEnabled(true);
            if (this.swingGUIPanel.myrisk.getGame().getState() != 10) {
                this.Undo.setEnabled(true);
            }
            this.gmReplay.setEnabled(true);
        }
        this.showMission.setEnabled(true);
        this.showCards.setEnabled(true);
        this.gOptions.setEnabled(true);
        this.gmOptions.setEnabled(true);
    }

    public void newGame() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GameTab.this.gNewGame.setEnabled(false);
                GameTab.this.gLoadGame.setEnabled(false);
                GameTab.this.gCloseGame.setEnabled(true);
                GameTab.this.gmNewGame.setEnabled(false);
                GameTab.this.gmLoadGame.setEnabled(false);
                GameTab.this.gmStartServer.setEnabled(false);
                GameTab.this.gmJoinGame.setEnabled(false);
                GameTab.this.gStartServer.setEnabled(false);
                GameTab.this.gJoinGame.setEnabled(false);
                GameTab.this.gmCloseGame.setEnabled(true);
                GameTab.this.remove(GameTab.this.Pix);
                GameTab.this.remove(GameTab.this.guiGame);
                GameTab.this.guiSetup.setupGame();
                GameTab.this.add((Component)GameTab.this.guiSetup, "Center");
                GameTab.this.swingGUIPanel.setCursor(null);
            }
        });
    }

    public void closeGame() {
        this.gNewGame.setEnabled(true);
        this.gLoadGame.setEnabled(true);
        this.gSaveGame.setEnabled(false);
        this.gCloseGame.setEnabled(false);
        this.gmNewGame.setEnabled(true);
        this.gmLoadGame.setEnabled(true);
        this.gmStartServer.setEnabled(true);
        this.gmJoinGame.setEnabled(true);
        this.gStartServer.setEnabled(true);
        this.gJoinGame.setEnabled(true);
        this.gmSaveGame.setEnabled(false);
        this.gmCloseGame.setEnabled(false);
        this.gOptions.setEnabled(false);
        this.gmOptions.setEnabled(false);
        this.gmReplay.setEnabled(false);
        this.remove(this.guiGame);
        this.remove(this.guiSetup);
        this.add((Component)this.Pix, "Center");
        this.swingGUIPanel.pp.stopAni();
    }

    public void startGame() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GameTab.this.gNewGame.setEnabled(false);
                GameTab.this.gLoadGame.setEnabled(false);
                GameTab.this.gCloseGame.setEnabled(true);
                GameTab.this.gmNewGame.setEnabled(false);
                GameTab.this.gmLoadGame.setEnabled(false);
                GameTab.this.gmStartServer.setEnabled(false);
                GameTab.this.gmJoinGame.setEnabled(false);
                GameTab.this.gStartServer.setEnabled(false);
                GameTab.this.gJoinGame.setEnabled(false);
                GameTab.this.gmCloseGame.setEnabled(true);
                GameTab.this.remove(GameTab.this.Pix);
                GameTab.this.remove(GameTab.this.guiSetup);
                GameTab.this.add((Component)GameTab.this.guiGame, "Center");
            }
        });
    }

    public void serverState(boolean s) {
        this.serverOn = s;
        if (this.serverOn) {
            this.gmStartServer.setText(this.resbundle.getString("swing.menu.stopserver"));
            this.gStartServer.setText(this.resbundle.getString("swing.menu.stopserver"));
        } else {
            this.gmStartServer.setText(this.resbundle.getString("swing.menu.startserver"));
            this.gStartServer.setText(this.resbundle.getString("swing.menu.startserver"));
        }
    }

    public void setGameStatus(String state) {
        this.gameStatus.setText(" " + state);
    }

    public JPanel makeGameOptionsPanel() {
        JPanel gameOptionsPanel = new JPanel();
        gameOptionsPanel.setLayout(new FlowLayout(1, 10, 0));
        gameOptionsPanel.setOpaque(false);
        JLabel mapLookLabel = new JLabel(this.resbundle.getString("game.tabs.mapview") + ":");
        this.mapViewComboBox = new JComboBox();
        Dimension mapViewSize = GraphicsUtil.newDimension(120, 20);
        this.mapViewComboBox.setPreferredSize(mapViewSize);
        this.mapViewComboBox.setMinimumSize(mapViewSize);
        this.mapViewComboBox.setMaximumSize(mapViewSize);
        this.mapViewComboBox.addItem(this.resbundle.getString("game.tabs.continents"));
        this.mapViewComboBox.addItem(this.resbundle.getString("game.tabs.ownership"));
        this.mapViewComboBox.addItem(this.resbundle.getString("game.tabs.borderthreat"));
        this.mapViewComboBox.addItem(this.resbundle.getString("game.tabs.cardownership"));
        this.mapViewComboBox.addItem(this.resbundle.getString("game.tabs.troopstrength"));
        this.mapViewComboBox.addItem(this.resbundle.getString("game.tabs.connectedempire"));
        this.mapViewComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent a) {
                GameTab.this.swingGUIPanel.pprepaintCountries();
                ((GameTab)GameTab.this).swingGUIPanel.pp.repaint();
            }
        });
        JLabel playersLabel = new JLabel(this.resbundle.getString("newgame.label.players"));
        Dimension playerPanelSize = GraphicsUtil.newDimension(120, 20);
        playersPanel players = new playersPanel();
        players.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0), 1));
        players.setPreferredSize(playerPanelSize);
        players.setMinimumSize(playerPanelSize);
        players.setMaximumSize(playerPanelSize);
        gameOptionsPanel.add(mapLookLabel);
        gameOptionsPanel.add(this.mapViewComboBox);
        gameOptionsPanel.add(playersLabel);
        gameOptionsPanel.add(players);
        gameOptionsPanel.add(this.showMission);
        gameOptionsPanel.add(this.showCards);
        gameOptionsPanel.add(this.Undo);
        return gameOptionsPanel;
    }

    void showPanel(String name) {
        this.inGameCards.show(this.inGameInput, name);
    }

    void setLocalGame(boolean lg) {
        this.localGame = lg;
    }

    String getSelectedMapView() {
        return (String)this.mapViewComboBox.getSelectedItem();
    }

    class winnerPanel
    extends JPanel {
        JButton continueButton;

        public winnerPanel() {
            this.continueButton = new JButton(GameTab.this.resbundle.getString("game.button.go.continue"));
            this.continueButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent a) {
                    GameTab.this.swingGUIPanel.go("continue");
                }
            });
            this.add(new JLabel(GameTab.this.resbundle.getString("game.over")));
            this.add(this.continueButton);
        }
    }

    class movePanel
    extends JPanel {
        public movePanel() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(3, 3, 3, 3);
            GameTab.this.slider.setMinimumSize(GraphicsUtil.newDimension(300, 50));
            GameTab.this.slider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
            GameTab.this.slider.setPaintTicks(true);
            GameTab.this.slider.setMajorTickSpacing(1);
            GameTab.this.slider.setPaintLabels(true);
            GameTab.this.slider.setSnapToTicks(true);
            GameTab.this.slider.getLabelTable().put(new Integer(11), new JLabel(new Integer(11).toString(), 0));
            GameTab.this.slider.setLabelTable(GameTab.this.slider.getLabelTable());
            GameTab.this.slider.getAccessibleContext().setAccessibleName("slider");
            GameTab.this.slider.getAccessibleContext().setAccessibleDescription("move armies slider");
            GameTab.this.slider.setOpaque(false);
            JLabel label = new JLabel(GameTab.this.resbundle.getString("move.numberofarmies"));
            JButton move1 = new JButton(GameTab.this.resbundle.getString("move.move"));
            move1.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent a) {
                    GameTab.this.swingGUIPanel.go("move " + GameTab.this.slider.getValue());
                }
            });
            JButton moveall = new JButton(GameTab.this.resbundle.getString("move.moveall"));
            moveall.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent a) {
                    GameTab.this.swingGUIPanel.go("move all");
                }
            });
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            this.add((Component)label, c);
            c.gridx = 1;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            this.add((Component)GameTab.this.slider, c);
            c.gridx = 2;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            this.add((Component)move1, c);
            c.gridx = 3;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            this.add((Component)moveall, c);
        }
    }

    class defendPanel
    extends JPanel {
        public defendPanel() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(3, 3, 3, 3);
            c.fill = 1;
        }
    }

    class rollPanel
    extends JPanel {
        public rollPanel() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(3, 3, 3, 3);
            c.fill = 1;
            JButton retreat = new JButton(GameTab.this.resbundle.getString("battle.retreat"));
            retreat.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent a) {
                    GameTab.this.swingGUIPanel.go("retreat");
                }
            });
            c.gridx = 3;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            this.add((Component)retreat, c);
        }
    }

    class tacMovePanel
    extends JPanel {
        public tacMovePanel() {
            this.setLayout(new GridBagLayout());
            Dimension size = GraphicsUtil.newDimension(200, 40);
            Font titleFont = new Font("SansSerif", 0, this.getFont().getSize() - 2);
            GameTab.this.country1 = new JTextField("");
            GameTab.this.country1.setEditable(false);
            GameTab.this.country1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(1), "Source", 4, 2, titleFont, new Color(60, 60, 60)));
            GameTab.this.country1.setPreferredSize(size);
            GameTab.this.country1.setMinimumSize(size);
            GameTab.this.country1.setMaximumSize(size);
            GameTab.this.country2 = new JTextField("");
            GameTab.this.country2.setEditable(false);
            GameTab.this.country2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(1), "Target", 4, 2, titleFont, new Color(60, 60, 60)));
            GameTab.this.country2.setPreferredSize(size);
            GameTab.this.country2.setMinimumSize(size);
            GameTab.this.country2.setMaximumSize(size);
            GameTab.this.country1.setOpaque(false);
            GameTab.this.country2.setOpaque(false);
            GameTab.this.moveNumber.setMinimumSize(GraphicsUtil.newDimension(300, 50));
            GameTab.this.moveNumber.putClientProperty("JSlider.isFilled", Boolean.TRUE);
            GameTab.this.moveNumber.setPaintTicks(true);
            GameTab.this.moveNumber.setMajorTickSpacing(1);
            GameTab.this.moveNumber.setPaintLabels(true);
            GameTab.this.moveNumber.setSnapToTicks(true);
            GameTab.this.moveNumber.getLabelTable().put(new Integer(11), new JLabel(new Integer(11).toString(), 0));
            GameTab.this.moveNumber.setLabelTable(GameTab.this.slider.getLabelTable());
            GameTab.this.moveNumber.getAccessibleContext().setAccessibleName("slider");
            GameTab.this.moveNumber.getAccessibleContext().setAccessibleDescription("move armies slider");
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(3, 3, 3, 3);
            c.anchor = 10;
            JButton moveButton = new JButton(GameTab.this.resbundle.getString("move.move"));
            moveButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent a) {
                    if (!GameTab.this.country1.getText().equals("") && !GameTab.this.country2.getText().equals("")) {
                        int nCountryId = ((GameTab)GameTab.this).swingGUIPanel.myrisk.getGame().getCountryInt(((GameTab)GameTab.this).swingGUIPanel.pp.getC1()).getColor();
                        tacMovePanel.this.showQuestion(((GameTab)GameTab.this).swingGUIPanel.myrisk.hasArmiesInt(nCountryId) - 1);
                        GameTab.this.country1.setText("");
                        GameTab.this.country2.setText("");
                        ((GameTab)GameTab.this).swingGUIPanel.pp.setC1(255);
                        ((GameTab)GameTab.this).swingGUIPanel.pp.setC2(255);
                        ((GameTab)GameTab.this).swingGUIPanel.pp.repaint();
                    }
                }
            });
            JButton noMoveButton = new JButton(GameTab.this.resbundle.getString("game.button.go.nomove"));
            noMoveButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent a) {
                    GameTab.this.swingGUIPanel.go("nomove");
                    GameTab.this.country1.setText("");
                    GameTab.this.country2.setText("");
                    ((GameTab)GameTab.this).swingGUIPanel.pp.setC1(255);
                    ((GameTab)GameTab.this).swingGUIPanel.pp.setC2(255);
                }
            });
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            this.add((Component)GameTab.this.country1, c);
            c.gridx = 1;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            this.add((Component)GameTab.this.country2, c);
            c.gridx = 2;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            this.add((Component)moveButton, c);
            c.gridx = 3;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            this.add((Component)noMoveButton, c);
        }

        public void showQuestion(int n) {
            GameTab.this.moveNumber.setMaximum(n);
            GameTab.this.moveNumber.setMinimum(1);
            GameTab.this.moveNumber.setValue(1);
            Object[] options = new String[]{GameTab.this.resbundle.getString("swing.move.move"), GameTab.this.resbundle.getString("swing.move.moveall"), GameTab.this.resbundle.getString("swing.move.cancel")};
            int a = JOptionPane.showOptionDialog(RiskUIUtil.findParentFrame(this), GameTab.this.moveNumber, GameTab.this.resbundle.getString("swing.move.title"), -1, 3, null, options, options[0]);
            if (a == 0) {
                GameTab.this.swingGUIPanel.go("movearmies " + ((GameTab)GameTab.this).swingGUIPanel.pp.getC1() + " " + ((GameTab)GameTab.this).swingGUIPanel.pp.getC2() + " " + GameTab.this.moveNumber.getValue());
            }
            if (a == 1) {
                GameTab.this.swingGUIPanel.go("movearmies " + ((GameTab)GameTab.this).swingGUIPanel.pp.getC1() + " " + ((GameTab)GameTab.this).swingGUIPanel.pp.getC2() + " " + n);
            }
        }
    }

    class attackPanel
    extends JPanel {
        public attackPanel() {
            this.setLayout(new GridBagLayout());
            Dimension size = GraphicsUtil.newDimension(300, 20);
            GameTab.this.attacker = new JLabel(GameTab.this.resbundle.getString("game.note.selectattacker"));
            GameTab.this.attacker.setPreferredSize(size);
            GameTab.this.attacker.setMinimumSize(size);
            GameTab.this.attacker.setMaximumSize(size);
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(3, 3, 3, 3);
            c.fill = 1;
            JButton endAttackButton = new JButton(GameTab.this.resbundle.getString("game.button.go.endattack"));
            endAttackButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent a) {
                    GameTab.this.swingGUIPanel.go("endattack");
                    GameTab.this.attacker.setText(GameTab.this.resbundle.getString("game.note.selectattacker"));
                    ((GameTab)GameTab.this).swingGUIPanel.pp.setC1(255);
                    ((GameTab)GameTab.this).swingGUIPanel.pp.setC2(255);
                    ((GameTab)GameTab.this).swingGUIPanel.pp.repaint();
                }
            });
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            this.add((Component)GameTab.this.attacker, c);
            c.gridx = 1;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            this.add((Component)endAttackButton, c);
        }
    }

    class placeArmiesPanel
    extends JPanel {
        public placeArmiesPanel() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(3, 3, 3, 3);
            c.fill = 1;
            GameTab.this.autoplace.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent a) {
                    GameTab.this.swingGUIPanel.go("autoplace");
                }
            });
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            this.add((Component)GameTab.this.armies, c);
            c.gridx = 1;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            this.add((Component)GameTab.this.autoplace, c);
        }
    }

    class endgoPanel
    extends JPanel {
        public endgoPanel() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(3, 3, 3, 3);
            c.fill = 1;
            JButton endturn = new JButton("End Go");
            endturn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent a) {
                    GameTab.this.swingGUIPanel.go("endgo");
                }
            });
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            this.add((Component)endturn, c);
        }
    }

    class tradeCardsPanel
    extends JPanel {
        JButton endtrade;

        public tradeCardsPanel() {
            this.endtrade = new JButton(GameTab.this.resbundle.getString("game.button.go.endtrade"));
            this.endtrade.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent a) {
                    GameTab.this.swingGUIPanel.go("endtrade");
                }
            });
            this.add(new JLabel(GameTab.this.resbundle.getString("cards.totradeclick")));
            this.add(this.endtrade);
        }
    }

    class capitalPanel
    extends JPanel {
        public capitalPanel() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(3, 3, 3, 3);
            c.fill = 1;
            JButton endtrade = new JButton(GameTab.this.resbundle.getString("about.okbutton"));
            endtrade.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent a) {
                    int c1Id = ((GameTab)GameTab.this).swingGUIPanel.pp.getC1();
                    ((GameTab)GameTab.this).swingGUIPanel.pp.setC1(255);
                    GameTab.this.swingGUIPanel.go("capital " + c1Id);
                }
            });
            GameTab.this.capitalLabel = new JLabel(GameTab.this.resbundle.getString("core.help.selectcapital"));
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            this.add((Component)GameTab.this.capitalLabel, c);
            c.gridx = 1;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            this.add((Component)endtrade, c);
        }
    }

    class SetupPanel
    extends JPanel
    implements ActionListener {
        private JRadioButton domination;
        private JRadioButton capital;
        private JRadioButton mission;
        private JCheckBox AutoPlaceAll;
        private JCheckBox recycle;
        private JLabel mapPic;
        private JTextField cardsFile;
        private ButtonGroup CardTypeButtonGroup;
        private ButtonGroup GameTypeButtonGroup;
        private JTable players;
        private TableModel dataModel;
        private JButton defaultPlayers;
        private NamedColor[] namedColors;
        private PlayerType[] playerTypes;

        public SetupPanel() {
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(3, 3, 3, 3);
            c.fill = 1;
            JPanel playerOptions = new JPanel();
            playerOptions.setLayout(new GridBagLayout());
            playerOptions.setBorder(BorderFactory.createTitledBorder(GameTab.this.resbundle.getString("newgame.label.players")));
            this.namedColors = new NamedColor[]{new NamedColor(Color.PINK, "pink", GameTab.this.resbundle.getString("color.pink")), new NamedColor(Color.RED, "red", GameTab.this.resbundle.getString("color.red")), new NamedColor(Color.ORANGE, "orange", GameTab.this.resbundle.getString("color.orange")), new NamedColor(Color.YELLOW, "yellow", GameTab.this.resbundle.getString("color.yellow")), new NamedColor(Color.GREEN, "green", GameTab.this.resbundle.getString("color.green")), new NamedColor(Color.CYAN, "cyan", GameTab.this.resbundle.getString("color.cyan")), new NamedColor(Color.BLUE, "blue", GameTab.this.resbundle.getString("color.blue")), new NamedColor(Color.MAGENTA, "magenta", GameTab.this.resbundle.getString("color.magenta")), new NamedColor(Color.WHITE, "white", GameTab.this.resbundle.getString("color.white")), new NamedColor(Color.LIGHT_GRAY, "lightgray", GameTab.this.resbundle.getString("color.lightgray")), new NamedColor(Color.DARK_GRAY, "darkgray", GameTab.this.resbundle.getString("color.darkgray")), new NamedColor(Color.BLACK, "black", GameTab.this.resbundle.getString("color.black"))};
            String[] ais = ((GameTab)GameTab.this).swingGUIPanel.myrisk.getAICommands();
            this.playerTypes = new PlayerType[ais.length + 1];
            this.playerTypes[0] = new PlayerType(GameTab.this.resbundle.getString("newgame.player.type.human"), "human");
            for (int a = 0; a < ais.length; ++a) {
                String displayString;
                try {
                    displayString = GameTab.this.resbundle.getString("newgame.player.type." + ais[a] + "ai");
                }
                catch (MissingResourceException ex) {
                    displayString = "ai " + ais[a];
                }
                this.playerTypes[a + 1] = new PlayerType(displayString, "ai " + ais[a]);
            }
            Object[] names = new String[]{GameTab.this.resbundle.getString("newgame.label.name"), GameTab.this.resbundle.getString("newgame.label.color"), GameTab.this.resbundle.getString("newgame.label.type")};
            this.dataModel = new DefaultTableModel(names, 0, (String[])names){
                final /* synthetic */ String[] val$names;
                {
                    this.val$names = stringArray;
                    super(x0, x1);
                }

                public String getColumnName(int column) {
                    return this.val$names[column];
                }

                public Class getColumnClass(int c) {
                    return this.getValueAt(0, c).getClass();
                }

                public boolean isCellEditable(int row, int col) {
                    return GameTab.this.localGame;
                }

                public void setValueAt(Object aValue, int row, int column) {
                    if (column == 0 && ((String)aValue).length() > 15) {
                        aValue = ((String)aValue).substring(0, 15);
                    }
                    super.setValueAt(aValue, row, column);
                }
            };
            this.players = new JTable(this.dataModel);
            this.players.setSelectionMode(0);
            this.players.getTableHeader().setReorderingAllowed(false);
            DefaultTableCellRenderer colorRenderer = new DefaultTableCellRenderer(){

                public void setValue(Object value) {
                    if (value instanceof NamedColor) {
                        NamedColor c = (NamedColor)value;
                        this.setBackground(c);
                        this.setForeground(RiskUIUtil.getTextColorFor(c));
                        this.setText(c.toString());
                    } else {
                        super.setValue(value);
                    }
                }
            };
            final JComboBox<NamedColor> colorComboBox = new JComboBox<NamedColor>(this.namedColors);
            final JComboBox<PlayerType> typeComboBox = new JComboBox<PlayerType>(this.playerTypes);
            TableColumn colorColumn = this.players.getColumn(GameTab.this.resbundle.getString("newgame.label.color"));
            colorColumn.setCellEditor(new DefaultCellEditor(colorComboBox));
            colorRenderer.setHorizontalAlignment(0);
            colorColumn.setCellRenderer(colorRenderer);
            TableColumn typeColumn = this.players.getColumn(GameTab.this.resbundle.getString("newgame.label.type"));
            typeColumn.setCellEditor(new DefaultCellEditor(typeComboBox));
            JScrollPane scrollpane = new JScrollPane(this.players);
            Dimension psize = GraphicsUtil.newDimension(200, 140);
            scrollpane.setPreferredSize(psize);
            scrollpane.setMinimumSize(psize);
            scrollpane.setMaximumSize(psize);
            colorComboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent a) {
                    Color c = (Color)colorComboBox.getSelectedItem();
                    colorComboBox.setBackground(c);
                    colorComboBox.setForeground(RiskUIUtil.getTextColorFor(c));
                }
            });
            JButton newPlayer = new JButton(GameTab.this.resbundle.getString("newgame.newplayer"));
            newPlayer.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent a) {
                    if (GameTab.this.localGame) {
                        ((DefaultTableModel)SetupPanel.this.dataModel).addRow(new Object[]{GameTab.this.resbundle.getString("newgame.newplayername"), SetupPanel.this.namedColors[0], SetupPanel.this.playerTypes[0]});
                    } else {
                        colorComboBox.setSelectedIndex(0);
                        typeComboBox.setSelectedIndex(0);
                        Object[] message = new Object[]{GameTab.this.resbundle.getString("newgame.label.name"), new JTextField(GameTab.this.resbundle.getString("newgame.newplayername")), GameTab.this.resbundle.getString("newgame.label.color"), colorComboBox, GameTab.this.resbundle.getString("newgame.label.type"), typeComboBox};
                        Object[] options = new String[]{"OK", "Cancel"};
                        int result = JOptionPane.showOptionDialog(RiskUIUtil.findParentFrame(GameTab.this.swingGUIPanel), message, "create new player", 2, 3, null, options, options[0]);
                        if (result == 0) {
                            String type = ((PlayerType)typeComboBox.getSelectedItem()).getType();
                            GameTab.this.swingGUIPanel.go("newplayer " + type + " " + ((NamedColor)colorComboBox.getSelectedItem()).getRealName() + " " + ((JTextField)message[1]).getText());
                        }
                    }
                }
            });
            JButton delPlayer = new JButton(GameTab.this.resbundle.getString("newgame.removeplayer"));
            delPlayer.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent a) {
                    if (SetupPanel.this.players.getSelectedRow() == -1) {
                        return;
                    }
                    if (GameTab.this.localGame) {
                        SetupPanel.this.players.removeEditor();
                        ((DefaultTableModel)SetupPanel.this.dataModel).removeRow(SetupPanel.this.players.getSelectedRow());
                    } else {
                        GameTab.this.swingGUIPanel.go("delplayer " + SetupPanel.this.players.getValueAt(SetupPanel.this.players.getSelectedRow(), 0));
                    }
                }
            });
            this.defaultPlayers = new JButton(GameTab.this.resbundle.getString("newgame.resetplayers"));
            this.defaultPlayers.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent a) {
                    SetupPanel.this.players.removeEditor();
                    SetupPanel.this.resetPlayers(false);
                }
            });
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 3;
            c.gridheight = 1;
            playerOptions.add((Component)scrollpane, c);
            c.gridx = 0;
            c.gridy = 1;
            c.gridwidth = 1;
            c.gridheight = 1;
            playerOptions.add((Component)newPlayer, c);
            c.gridx = 1;
            c.gridy = 1;
            c.gridwidth = 1;
            c.gridheight = 1;
            playerOptions.add((Component)delPlayer, c);
            c.gridx = 2;
            c.gridy = 1;
            c.gridwidth = 1;
            c.gridheight = 1;
            playerOptions.add((Component)this.defaultPlayers, c);
            JPanel mapOptions = new JPanel();
            mapOptions.setLayout(new GridBagLayout());
            mapOptions.setBorder(BorderFactory.createTitledBorder(GameTab.this.resbundle.getString("newgame.label.map")));
            BadgeButton chooseMap = new BadgeButton(GameTab.this.resbundle.getString("newgame.choosemap"));
            chooseMap.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent a) {
                    String name = RiskUIUtil.getNewMap(RiskUIUtil.findParentFrame(GameTab.this.swingGUIPanel));
                    if (name != null) {
                        GameTab.this.swingGUIPanel.setCursor(Cursor.getPredefinedCursor(3));
                        GameTab.this.swingGUIPanel.go("choosemap " + name);
                    }
                }
            });
            JButton defaultMap = new JButton(GameTab.this.resbundle.getString("newgame.defaultmap"));
            defaultMap.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent a) {
                    GameTab.this.swingGUIPanel.go("choosemap " + RiskGame.getDefaultMap());
                }
            });
            this.mapPic = new JLabel();
            this.mapPic.setBorder(BorderFactory.createLoweredBevelBorder());
            Dimension size = GraphicsUtil.newDimension(203, 127);
            this.mapPic.setPreferredSize(size);
            this.mapPic.setMinimumSize(size);
            this.mapPic.setMaximumSize(size);
            JPopupMenu mapPopup = new JPopupMenu();
            mapPopup.add("copy name").addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    StringSelection selection = new StringSelection(SetupPanel.this.mapPic.getToolTipText());
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(selection, selection);
                }
            });
            this.mapPic.setComponentPopupMenu(mapPopup);
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 2;
            c.gridheight = 1;
            mapOptions.add((Component)this.mapPic, c);
            c.gridx = 0;
            c.gridy = 1;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.weightx = 1.0;
            mapOptions.add((Component)chooseMap, c);
            c.gridx = 1;
            c.gridy = 1;
            c.gridwidth = 1;
            c.gridheight = 1;
            mapOptions.add((Component)defaultMap, c);
            c.weightx = 0.0;
            JPanel cardOptions = new JPanel();
            cardOptions.setLayout(new GridBagLayout());
            cardOptions.setBorder(BorderFactory.createTitledBorder(GameTab.this.resbundle.getString("newgame.label.cards")));
            this.cardsFile = new JTextField("");
            this.cardsFile.setEditable(false);
            this.cardsFile.setBackground(mapOptions.getBackground());
            size = GraphicsUtil.newDimension(200, 20);
            this.cardsFile.setPreferredSize(size);
            this.cardsFile.setMinimumSize(size);
            this.cardsFile.setMaximumSize(size);
            JButton chooseCards = new JButton(GameTab.this.resbundle.getString("newgame.choosecards"));
            chooseCards.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent a) {
                    String name = RiskUIUtil.getNewFile(RiskUIUtil.findParentFrame(GameTab.this.swingGUIPanel), "cards");
                    if (name != null) {
                        GameTab.this.swingGUIPanel.go("choosecards " + name);
                    }
                }
            });
            JButton defaultCards = new JButton(GameTab.this.resbundle.getString("newgame.defaultcards"));
            defaultCards.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent a) {
                    GameTab.this.swingGUIPanel.go("choosecards " + RiskGame.getDefaultCards());
                }
            });
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 2;
            c.gridheight = 1;
            cardOptions.add((Component)this.cardsFile, c);
            c.gridx = 0;
            c.gridy = 1;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.weightx = 1.0;
            cardOptions.add((Component)chooseCards, c);
            c.gridx = 1;
            c.gridy = 1;
            c.gridwidth = 1;
            c.gridheight = 1;
            cardOptions.add((Component)defaultCards, c);
            c.weightx = 0.0;
            JPanel GameTypeButtons = new JPanel();
            GameTypeButtons.setLayout(new BoxLayout(GameTypeButtons, 1));
            GameTypeButtons.setBorder(BorderFactory.createTitledBorder(GameTab.this.resbundle.getString("newgame.label.gametype")));
            JPanel cardsOptions = new JPanel();
            cardsOptions.setLayout(new BoxLayout(cardsOptions, 1));
            cardsOptions.setBorder(BorderFactory.createTitledBorder(GameTab.this.resbundle.getString("newgame.label.cardsoptions")));
            this.GameTypeButtonGroup = new ButtonGroup();
            this.CardTypeButtonGroup = new ButtonGroup();
            this.domination = new JRadioButton(GameTab.this.resbundle.getString("newgame.mode.domination"), true);
            this.capital = new JRadioButton(GameTab.this.resbundle.getString("newgame.mode.capital"));
            this.mission = new JRadioButton(GameTab.this.resbundle.getString("newgame.mode.mission"));
            this.domination.setOpaque(false);
            this.capital.setOpaque(false);
            this.mission.setOpaque(false);
            this.domination.addActionListener(this);
            this.capital.addActionListener(this);
            this.mission.addActionListener(this);
            final JRadioButton increasing = new JRadioButton(GameTab.this.resbundle.getString("newgame.cardmode.increasing"), true);
            final JRadioButton fixed = new JRadioButton(GameTab.this.resbundle.getString("newgame.cardmode.fixed"));
            JRadioButton italian = new JRadioButton(GameTab.this.resbundle.getString("newgame.cardmode.italianlike"));
            increasing.setOpaque(false);
            fixed.setOpaque(false);
            italian.setOpaque(false);
            this.GameTypeButtonGroup.add(this.domination);
            this.GameTypeButtonGroup.add(this.capital);
            this.GameTypeButtonGroup.add(this.mission);
            this.CardTypeButtonGroup.add(increasing);
            this.CardTypeButtonGroup.add(fixed);
            this.CardTypeButtonGroup.add(italian);
            GameTypeButtons.add(this.domination);
            GameTypeButtons.add(this.capital);
            GameTypeButtons.add(this.mission);
            cardsOptions.add(increasing);
            cardsOptions.add(fixed);
            cardsOptions.add(italian);
            JPanel GameOptionsButtons = new JPanel();
            GameOptionsButtons.setLayout(new FlowLayout(0));
            GameOptionsButtons.setBorder(BorderFactory.createTitledBorder(GameTab.this.resbundle.getString("newgame.label.startgameoptions")));
            this.AutoPlaceAll = new JCheckBox(GameTab.this.resbundle.getString("newgame.autoplace"));
            GameOptionsButtons.add(this.AutoPlaceAll);
            this.AutoPlaceAll.setOpaque(false);
            this.AutoPlaceAll.setSelected("true".equals(((GameTab)GameTab.this).swingGUIPanel.myrisk.getRiskConfig("default.autoplaceall")));
            this.recycle = new JCheckBox(GameTab.this.resbundle.getString("newgame.recycle"));
            GameOptionsButtons.add(this.recycle);
            this.recycle.setOpaque(false);
            this.recycle.setSelected("true".equals(((GameTab)GameTab.this).swingGUIPanel.myrisk.getRiskConfig("default.recyclecards")));
            JButton startGame = new JButton(GameTab.this.resbundle.getString("newgame.startgame"));
            startGame.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent a) {
                    boolean setupOK = true;
                    String error = "";
                    if (SetupPanel.this.players.getRowCount() >= 2 && SetupPanel.this.players.getRowCount() <= 6) {
                        for (int c = 0; c < SetupPanel.this.players.getRowCount(); ++c) {
                            for (int b = c + 1; b < SetupPanel.this.players.getRowCount(); ++b) {
                                if (((String)SetupPanel.this.players.getValueAt(c, 0)).equals(SetupPanel.this.players.getValueAt(b, 0))) {
                                    setupOK = false;
                                    error = GameTab.this.resbundle.getString("newgame.error.samename");
                                }
                                if (SetupPanel.this.players.getValueAt(c, 1) != SetupPanel.this.players.getValueAt(b, 1)) continue;
                                setupOK = false;
                                error = GameTab.this.resbundle.getString("newgame.error.samecolor");
                            }
                        }
                    } else {
                        setupOK = false;
                        error = GameTab.this.resbundle.getString("newgame.error.2to6players");
                    }
                    if (setupOK) {
                        if (GameTab.this.localGame) {
                            ArrayList<String[]> playerStrings = new ArrayList<String[]>();
                            for (int c = 0; c < SetupPanel.this.players.getRowCount(); ++c) {
                                String name = (String)SetupPanel.this.players.getValueAt(c, 0);
                                String color = ((NamedColor)SetupPanel.this.players.getValueAt(c, 1)).getRealName();
                                String type = ((PlayerType)SetupPanel.this.players.getValueAt(c, 2)).getType();
                                playerStrings.add(new String[]{name, color, type});
                                GameTab.this.swingGUIPanel.go("newplayer " + type + " " + color + " " + name);
                            }
                            RiskUtil.savePlayers(playerStrings, SwingGUIPanel.class);
                        }
                        String type = "";
                        if (SetupPanel.this.domination.isSelected()) {
                            type = "domination";
                        } else if (SetupPanel.this.capital.isSelected()) {
                            type = "capital";
                        } else if (SetupPanel.this.mission.isSelected()) {
                            type = "mission";
                        }
                        type = increasing.isSelected() ? type + " increasing" : (fixed.isSelected() ? type + " fixed" : type + " italianlike");
                        GameTab.this.swingGUIPanel.go("startgame " + type + (SetupPanel.this.AutoPlaceAll.isSelected() ? " autoplaceall" : "") + (SetupPanel.this.recycle.isSelected() ? " recycle" : ""));
                    } else {
                        GameTab.this.swingGUIPanel.showError(error);
                    }
                }
            });
            this.setLayout(new GridBagLayout());
            playerOptions.setOpaque(false);
            GameTypeButtons.setOpaque(false);
            mapOptions.setOpaque(false);
            cardOptions.setOpaque(false);
            GameOptionsButtons.setOpaque(false);
            cardsOptions.setOpaque(false);
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            this.add((Component)playerOptions, c);
            c.gridx = 0;
            c.gridy = 2;
            c.gridwidth = 1;
            c.gridheight = 2;
            this.add((Component)GameTypeButtons, c);
            c.gridx = 1;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            this.add((Component)mapOptions, c);
            c.gridx = 0;
            c.gridy = 1;
            c.gridwidth = 1;
            c.gridheight = 1;
            this.add((Component)cardsOptions, c);
            c.gridx = 1;
            c.gridy = 1;
            c.gridwidth = 1;
            c.gridheight = 1;
            this.add((Component)cardOptions, c);
            c.gridx = 1;
            c.gridy = 2;
            c.gridwidth = 1;
            c.gridheight = 1;
            this.add((Component)GameOptionsButtons, c);
            c.gridx = 1;
            c.gridy = 3;
            c.gridwidth = 1;
            c.gridheight = 1;
            this.add((Component)startGame, c);
        }

        public void showCardsFile(String c, boolean m) {
            this.cardsFile.setText(c);
            if (!m && this.mission.isSelected()) {
                this.domination.setSelected(true);
                this.AutoPlaceAll.setEnabled(true);
            }
            this.mission.setEnabled(m);
        }

        public void showMapImage(Icon p, String tooltip) {
            this.mapPic.setIcon(p);
            this.mapPic.setToolTipText(tooltip);
            GameTab.this.swingGUIPanel.setCursor(null);
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.mission) {
                this.AutoPlaceAll.setEnabled(false);
            } else if (e.getSource() == this.domination) {
                this.AutoPlaceAll.setEnabled(true);
            } else if (e.getSource() == this.capital) {
                this.AutoPlaceAll.setEnabled(true);
            }
        }

        public void resetPlayers(boolean lastUsed) {
            while (this.players.getRowCount() != 0) {
                ((DefaultTableModel)this.dataModel).removeRow(0);
            }
            Properties settings = lastUsed ? RiskUtil.getPlayerSettings(((GameTab)GameTab.this).swingGUIPanel.myrisk, SwingGUIPanel.class) : new Properties(){

                public String getProperty(String key) {
                    return ((GameTab)GameTab.this).swingGUIPanel.myrisk.getRiskConfig(key);
                }
            };
            for (int c = 1; c <= 6; ++c) {
                String name = settings.getProperty("default.player" + c + ".name");
                String color = settings.getProperty("default.player" + c + ".color");
                String type = settings.getProperty("default.player" + c + ".type");
                if ("".equals(name) || "".equals(color) || "".equals(type)) continue;
                try {
                    ((DefaultTableModel)this.dataModel).addRow(new Object[]{name, this.findColor(ColorUtil.getColor(color)), this.findType(((GameTab)GameTab.this).swingGUIPanel.myrisk.getType(type))});
                    continue;
                }
                catch (Exception ex) {
                    System.err.println("unable to add player " + name + " " + color + " " + type);
                    ex.printStackTrace();
                }
            }
        }

        public void setupGame() {
            this.players.removeEditor();
            if (GameTab.this.localGame) {
                this.resetPlayers(true);
                this.defaultPlayers.setEnabled(true);
            } else {
                while (this.players.getRowCount() != 0) {
                    ((DefaultTableModel)this.dataModel).removeRow(0);
                }
                this.defaultPlayers.setEnabled(false);
            }
        }

        public void addPlayer(int t, String name, int color, String ip) {
            if (!GameTab.this.localGame) {
                NamedColor c = this.findColor(color);
                PlayerType type = this.findType(t);
                ((DefaultTableModel)this.dataModel).addRow(new Object[]{name, c, type});
            }
        }

        public NamedColor findColor(int color) {
            for (int a = 0; a < this.namedColors.length; ++a) {
                if (this.namedColors[a].getRGB() != color) continue;
                return this.namedColors[a];
            }
            return null;
        }

        public PlayerType findType(int t) {
            String type = ((GameTab)GameTab.this).swingGUIPanel.myrisk.getType(t);
            for (int a = 0; a < this.playerTypes.length; ++a) {
                if (!this.playerTypes[a].getType().equals(type)) continue;
                return this.playerTypes[a];
            }
            return null;
        }

        public void delPlayer(String name) {
            if (!GameTab.this.localGame) {
                for (int c = 0; c < this.players.getRowCount(); ++c) {
                    if (!this.players.getValueAt(c, 0).equals(name)) continue;
                    ((DefaultTableModel)this.dataModel).removeRow(c);
                    break;
                }
            }
        }

        class NamedColor
        extends Color {
            private String name;
            private String realname;

            public NamedColor(Color color, String rn, String n) {
                super(color.getRGB());
                this.realname = rn;
                this.name = n;
            }

            public String getRealName() {
                return this.realname;
            }

            public String toString() {
                return this.name;
            }
        }

        class PlayerType {
            String displayString;
            String type;

            public PlayerType(String displayString, String type) {
                this.displayString = displayString;
                this.type = type;
            }

            String getType() {
                return this.type;
            }

            public String toString() {
                return this.displayString;
            }
        }
    }

    class GamePanel
    extends JPanel {
        public GamePanel() {
            GameTab.this.resultsLabel = new JLabel("RESULTS");
            GameTab.this.resultsLabel.setHorizontalAlignment(0);
            Dimension mapSize = GraphicsUtil.newDimension(677, 425);
            ((GameTab)GameTab.this).swingGUIPanel.pp.setPreferredSize(mapSize);
            ((GameTab)GameTab.this).swingGUIPanel.pp.setMinimumSize(mapSize);
            ((GameTab)GameTab.this).swingGUIPanel.pp.setMaximumSize(mapSize);
            final MapMouseListener mml = new MapMouseListener(((GameTab)GameTab.this).swingGUIPanel.myrisk, ((GameTab)GameTab.this).swingGUIPanel.pp);
            MouseInputAdapter mapListener = new MouseInputAdapter(){

                public void mouseExited(MouseEvent e) {
                    mml.mouseExited();
                }

                public void mouseReleased(MouseEvent e) {
                    int[] click = mml.mouseReleased(e.getX(), e.getY(), ((GameTab)GameTab.this).swingGUIPanel.gameState);
                    if (click != null) {
                        GamePanel.this.mapClick(click, e);
                    }
                }

                public void mouseMoved(MouseEvent e) {
                    mml.mouseMoved(e.getX(), e.getY(), ((GameTab)GameTab.this).swingGUIPanel.gameState);
                }
            };
            ((GameTab)GameTab.this).swingGUIPanel.pp.addMouseListener(mapListener);
            ((GameTab)GameTab.this).swingGUIPanel.pp.addMouseMotionListener(mapListener);
            Dimension d = GraphicsUtil.newDimension(677, 50);
            GameTab.this.inGameCards = new CardLayout();
            GameTab.this.inGameInput = new JPanel();
            GameTab.this.inGameInput.setLayout(GameTab.this.inGameCards);
            GameTab.this.inGameInput.setPreferredSize(d);
            GameTab.this.inGameInput.setMinimumSize(d);
            GameTab.this.inGameInput.setMaximumSize(d);
            JLabel nothing = new JLabel(GameTab.this.resbundle.getString("game.pleasewaitnetwork"));
            nothing.setHorizontalAlignment(0);
            nothing.setPreferredSize(d);
            nothing.setMinimumSize(d);
            nothing.setMaximumSize(d);
            GameTab.this.resultsLabel.setPreferredSize(d);
            GameTab.this.resultsLabel.setMinimumSize(d);
            GameTab.this.resultsLabel.setMaximumSize(d);
            placeArmiesPanel placeArmies = new placeArmiesPanel();
            placeArmies.setPreferredSize(d);
            placeArmies.setMinimumSize(d);
            placeArmies.setMaximumSize(d);
            GameTab.this.roll = new rollPanel();
            GameTab.this.roll.setPreferredSize(d);
            GameTab.this.roll.setMinimumSize(d);
            GameTab.this.roll.setMaximumSize(d);
            movePanel move = new movePanel();
            move.setPreferredSize(d);
            move.setMinimumSize(d);
            move.setMaximumSize(d);
            attackPanel attack = new attackPanel();
            attack.setPreferredSize(d);
            attack.setMinimumSize(d);
            attack.setMaximumSize(d);
            GameTab.this.defend = new defendPanel();
            GameTab.this.defend.setPreferredSize(d);
            GameTab.this.defend.setMinimumSize(d);
            GameTab.this.defend.setMaximumSize(d);
            tacMovePanel tacMove = new tacMovePanel();
            tacMove.setPreferredSize(d);
            tacMove.setMinimumSize(d);
            tacMove.setMaximumSize(d);
            capitalPanel capital = new capitalPanel();
            capital.setPreferredSize(d);
            capital.setMinimumSize(d);
            capital.setMaximumSize(d);
            GameTab.this.tradeCards = new tradeCardsPanel();
            GameTab.this.tradeCards.setPreferredSize(d);
            GameTab.this.tradeCards.setMinimumSize(d);
            GameTab.this.tradeCards.setMaximumSize(d);
            GameTab.this.winner = new winnerPanel();
            GameTab.this.winner.setPreferredSize(d);
            GameTab.this.winner.setMinimumSize(d);
            GameTab.this.winner.setMaximumSize(d);
            endgoPanel endgo = new endgoPanel();
            endgo.setPreferredSize(d);
            endgo.setMinimumSize(d);
            endgo.setMaximumSize(d);
            GameTab.this.inGameInput.setOpaque(false);
            placeArmies.setOpaque(false);
            GameTab.this.roll.setOpaque(false);
            move.setOpaque(false);
            attack.setOpaque(false);
            GameTab.this.defend.setOpaque(false);
            tacMove.setOpaque(false);
            capital.setOpaque(false);
            GameTab.this.tradeCards.setOpaque(false);
            GameTab.this.winner.setOpaque(false);
            endgo.setOpaque(false);
            GameTab.this.inGameInput.add((Component)nothing, "nothing");
            GameTab.this.inGameInput.add((Component)placeArmies, "placeArmies");
            GameTab.this.inGameInput.add((Component)GameTab.this.roll, "roll");
            GameTab.this.inGameInput.add((Component)move, "move");
            GameTab.this.inGameInput.add((Component)attack, "attack");
            GameTab.this.inGameInput.add((Component)GameTab.this.defend, "defend");
            GameTab.this.inGameInput.add((Component)tacMove, "tacMove");
            GameTab.this.inGameInput.add((Component)capital, "capital");
            GameTab.this.inGameInput.add((Component)GameTab.this.tradeCards, "tradeCards");
            GameTab.this.inGameInput.add((Component)GameTab.this.winner, "winner");
            GameTab.this.inGameInput.add((Component)endgo, "endgo");
            GameTab.this.inGameInput.add((Component)GameTab.this.resultsLabel, "results");
            JPanel ppBorder = new JPanel(new BorderLayout());
            ppBorder.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10), BorderFactory.createLineBorder(Color.BLACK, 1)));
            ppBorder.setOpaque(false);
            ppBorder.add(((GameTab)GameTab.this).swingGUIPanel.pp);
            this.setLayout(new BorderLayout());
            this.add((Component)GameTab.this.gameOptions, "North");
            this.add(ppBorder);
            this.add((Component)GameTab.this.inGameInput, "South");
            this.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        }

        public void mapClick(int[] countries, MouseEvent e) {
            if (((GameTab)GameTab.this).swingGUIPanel.gameState == 2) {
                if (countries.length == 1) {
                    if (e.getModifiers() == 16) {
                        GameTab.this.swingGUIPanel.go("placearmies " + countries[0] + " 1");
                    } else {
                        GameTab.this.swingGUIPanel.go("placearmies " + countries[0] + " 10");
                    }
                }
            } else if (((GameTab)GameTab.this).swingGUIPanel.gameState == 3) {
                if (countries.length == 0) {
                    GameTab.this.attacker.setText(GameTab.this.resbundle.getString("game.note.selectattacker"));
                } else if (countries.length == 1) {
                    GameTab.this.attacker.setText(GameTab.this.resbundle.getString("game.note.attackerisseldefender").replaceAll("\\{0\\}", ((GameTab)GameTab.this).swingGUIPanel.myrisk.getCountryName(countries[0])));
                } else {
                    GameTab.this.swingGUIPanel.go("attack " + countries[0] + " " + countries[1]);
                }
            } else if (((GameTab)GameTab.this).swingGUIPanel.gameState == 6) {
                if (countries.length == 0) {
                    GameTab.this.country1.setText("");
                } else if (countries.length == 1) {
                    GameTab.this.country1.setText(((GameTab)GameTab.this).swingGUIPanel.myrisk.getCountryName(countries[0]));
                    GameTab.this.country2.setText("");
                } else if (countries.length == 2) {
                    GameTab.this.country2.setText(((GameTab)GameTab.this).swingGUIPanel.myrisk.getCountryName(countries[1]));
                }
            } else if (((GameTab)GameTab.this).swingGUIPanel.gameState == 9) {
                if (countries.length == 0) {
                    GameTab.this.capitalLabel.setText(GameTab.this.resbundle.getString("core.help.selectcapital"));
                } else if (countries.length == 1) {
                    GameTab.this.capitalLabel.setText(GameTab.this.resbundle.getString("core.help.selectcapital") + ": " + ((GameTab)GameTab.this).swingGUIPanel.myrisk.getCountryName(countries[0]));
                }
            }
        }
    }

    class playersPanel
    extends JPanel {
        playersPanel() {
        }

        public void paintComponent(Graphics g) {
            int width = this.getWidth();
            int height = this.getHeight();
            int[] colors = ((GameTab)GameTab.this).swingGUIPanel.myrisk.getPlayerColors();
            if (colors.length == 0) {
                return;
            }
            for (int c = 0; c < colors.length; ++c) {
                g.setColor(new Color(colors[c]));
                g.fillRect(width / colors.length * c, 0, width / colors.length, height);
            }
            g.setColor(new Color(ColorUtil.getTextColorFor(colors[0])));
            g.drawRect(2, 2, width / colors.length - 5, height - 5);
            g.setColor(Color.black);
            g.drawLine(width / colors.length - 1, 0, width / colors.length - 1, height - 1);
        }
    }
}

