/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.ui.swinggui;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ServiceLoader;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import net.yura.domination.ui.swinggui.SwingGUIPanel;
import net.yura.domination.ui.swinggui.SwingGUITab;
import net.yura.mobile.gui.plaf.LookAndFeel;

public class PLAF {
    private static final ServiceLoader<LookAndFeel> LOOK_AND_FEEL_LOADER = ServiceLoader.load(LookAndFeel.class);
    private SwingGUIPanel ui;
    private ButtonGroup lookAndFeelRadioGroup;
    private String lookAndFeel;
    Action setLookAndFeelAction = new AbstractAction(){

        public void actionPerformed(ActionEvent ae) {
            ButtonModel model = PLAF.this.lookAndFeelRadioGroup.getSelection();
            String lookAndFeelName = model.getActionCommand();
            try {
                PLAF.this.setLookAndFeel(lookAndFeelName);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                PLAF.this.ui.showError("unable To Change LookAndFeel to " + lookAndFeelName);
            }
        }
    };

    public PLAF(SwingGUIPanel ui) {
        this.ui = ui;
        ui.getJMenuBar().add(this.createLookAndFeelMenu());
    }

    private JMenu createLookAndFeelMenu() {
        JMenu menu = new JMenu("L&F");
        menu.setName("lookAndFeel");
        UIManager.LookAndFeelInfo[] lookAndFeelInfos = UIManager.getInstalledLookAndFeels();
        this.lookAndFeel = UIManager.getLookAndFeel().getClass().getName();
        this.lookAndFeelRadioGroup = new ButtonGroup();
        for (UIManager.LookAndFeelInfo lafInfo : lookAndFeelInfos) {
            menu.add(this.createLookAndFeelItem(lafInfo.getName(), lafInfo.getClassName()));
        }
        LOOK_AND_FEEL_LOADER.iterator();
        for (LookAndFeel laf : LOOK_AND_FEEL_LOADER) {
            menu.add(this.createLookAndFeelItem(laf.toString(), laf.getClass().getName()));
        }
        return menu;
    }

    private JRadioButtonMenuItem createLookAndFeelItem(String lafName, String lafClassName) {
        JRadioButtonMenuItem lafItem = new JRadioButtonMenuItem();
        lafItem.setSelected(lafClassName.equals(this.lookAndFeel));
        lafItem.setHideActionText(true);
        lafItem.setAction(this.setLookAndFeelAction);
        lafItem.setText(lafName);
        lafItem.setActionCommand(lafClassName);
        this.lookAndFeelRadioGroup.add(lafItem);
        return lafItem;
    }

    private void setLookAndFeel(String lookAndFeel) throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        String oldLookAndFeel = this.lookAndFeel;
        if (oldLookAndFeel != lookAndFeel) {
            UIManager.setLookAndFeel(lookAndFeel);
            this.lookAndFeel = lookAndFeel;
            this.updateLookAndFeel();
            this.ui.firePropertyChange("lookAndFeel", oldLookAndFeel, lookAndFeel);
        }
    }

    private void updateLookAndFeel() {
        Window[] windows;
        for (Window window : windows = Window.getWindows()) {
            SwingUtilities.updateComponentTreeUI(window);
            for (Component demoPanel : this.ui.getJTabbedPane().getComponents()) {
                SwingGUITab tab = (SwingGUITab)((Object)demoPanel);
                SwingUtilities.updateComponentTreeUI(tab.getToolBar());
            }
        }
    }
}

