/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Rectangle;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextBox;
import javax.microedition.midlet.ApplicationManager;
import javax.microedition.midlet.MIDlet;
import org.me4se.scm.ScmComponent;
import org.me4se.scm.ScmContainer;

public class Display {
    public static final int LIST_ELEMENT = 1;
    public static final int CHOICE_GROUP_ELEMENT = 2;
    public static final int ALERT = 3;
    public static final int COLOR_BACKGROUND = 0;
    public static final int COLOR_FOREGROUND = 1;
    public static final int COLOR_HIGHLIGHTED_BACKGROUND = 2;
    public static final int COLOR_HIGHLIGHTED_FOREGROUND = 3;
    public static final int COLOR_BORDER = 4;
    public static final int COLOR_HIGHLIGHTED_BORDER = 5;
    private static Map midlets = new WeakHashMap();
    private WeakReference midlet;
    private WeakReference current;
    protected Vector callSerially = new Vector();
    Vibrator vibrator;

    protected Display(MIDlet midlet) {
        this.midlet = new WeakReference<MIDlet>(midlet);
    }

    public void callSerially(Runnable r) {
        EventQueue.invokeLater(r);
    }

    public boolean flashBacklight(int duration) {
        return false;
    }

    public boolean vibrate(int duration) {
        if (this.vibrator != null) {
            this.vibrator.remaining = 0;
        }
        this.vibrator = new Vibrator(duration);
        new Thread(this.vibrator).start();
        return true;
    }

    public static Display getDisplay(MIDlet midlet) {
        Display display = (Display)midlets.get(midlet);
        if (display == null) {
            display = new Display(midlet);
            midlets.put(midlet, display);
        }
        return display;
    }

    public synchronized void setCurrent(Displayable d) {
        if (d instanceof TextBox) {
            return;
        }
        final ApplicationManager manager = ApplicationManager.getInstance();
        if (d == null) {
            if (manager.frame != null) {
                manager.frame.setExtendedState(1);
            }
            return;
        }
        this.current = new WeakReference<Displayable>(d);
        if (manager.currentlyShown == d || manager.active != this.midlet.get()) {
            return;
        }
        while (manager.displayContainer.getComponentCount() > 0) {
            manager.displayContainer.remove(manager.displayContainer.getComponentCount() - 1);
        }
        if (manager.currentlyShown instanceof Canvas) {
            ((Canvas)manager.currentlyShown).hideNotify();
        }
        d.container.setX(ApplicationManager.getIntProperty("screen.x", 0));
        d.container.setY(ApplicationManager.getIntProperty("screen.y", 0));
        if (d instanceof Alert) {
            Alert alert = (Alert)d;
            if (alert.next == null) {
                alert.next = d;
            }
        }
        manager.displayContainer.add(d.container);
        d.display = this;
        manager.currentlyShown = d;
        d._showNotify();
        d.container.repaint();
        new Thread(){

            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                manager.wrapper.requestFocusInWindow();
            }
        }.start();
    }

    public void setCurrent(Alert alert, Displayable next) {
        alert.next = next;
        this.setCurrent(alert);
    }

    public void setCurrentItem(Item item) {
        this.setCurrent(item.form);
        ((ScmComponent)item.lines.elementAt(item.lines.size() == 0 ? 0 : 1)).requestFocus();
    }

    public boolean isColor() {
        return true;
    }

    public int numAlphaLevels() {
        return 256;
    }

    public int numColors() {
        return ApplicationManager.getInstance().colorCount;
    }

    public Displayable getCurrent() {
        return this.current == null ? null : (Displayable)this.current.get();
    }

    public int getColor(int type) {
        switch (type) {
            case 0: {
                return ApplicationManager.getIntProperty("item.background", 0xFFFFFF);
            }
            case 1: {
                return ApplicationManager.getIntProperty("item.foreground", 0);
            }
            case 2: {
                return ApplicationManager.getIntProperty("item.focus.background", 255);
            }
            case 3: {
                return ApplicationManager.getIntProperty("item.focus.foreground", 0);
            }
            case 4: {
                return ApplicationManager.getIntProperty("item.border", 0xFFFFFF);
            }
            case 5: {
                return ApplicationManager.getIntProperty("item.focus.border", 0x8888FF);
            }
        }
        return 0x8888FF;
    }

    public int getBestImageWidth(int imageType) {
        return 0;
    }

    public int getBestImageHeight(int imageType) {
        System.out.println("Display.getBestImageHeight() with no effect!");
        return 0;
    }

    protected static void check() {
        if (ApplicationManager.getInstance().frame != null && !ApplicationManager.getInstance().frame.isVisible()) {
            Frame frame = ApplicationManager.getInstance().frame;
            frame.pack();
            frame.setVisible(true);
        }
    }

    class Vibrator
    implements Runnable {
        int remaining;

        public Vibrator(int duration) {
            this.remaining = duration;
        }

        public void run() {
            ScmContainer shake = ApplicationManager.getInstance().displayContainer;
            Rectangle r = shake.getBounds();
            try {
                while (this.remaining > 0) {
                    Thread.sleep(100L);
                    shake.setBounds(r.x + 3, r.y, r.width - 3, r.height);
                    Thread.sleep(100L);
                    shake.setBounds(r.x, r.y, r.width, r.height);
                    this.remaining -= 200;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

