/*
 * Decompiled with CFR 0.152.
 */
package getfour;

import getfour.GameEndDialog;
import getfour.GetFour;
import getfour.GetFourGUI;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

class GridCanvas
extends Canvas {
    private GetFourGUI getfourgui;
    private GetFour getfour;
    private Color red;
    private Color yellow;
    private final int RECTWIDTH = 88;
    private final int RECTHEIGHT = 66;
    private final int CIRCLEWIDTH = 60;

    GridCanvas(GetFourGUI getFourGUI, GetFour getFour) {
        this.getfourgui = getFourGUI;
        this.getfour = getFour;
        this.addMouseListener(new GridMouseListener());
        this.red = new Color(223, 0, 0);
        this.yellow = new Color(223, 223, 0);
    }

    @Override
    public void paint(Graphics graphics) {
        this.drawGrid();
        this.drawAllDiscs();
    }

    void drawGrid() {
        int n = 0;
        while (true) {
            if (n >= 42) break;
            Graphics graphics = this.getGraphics();
            this.setBackground(Color.black);
            graphics.setColor(Color.gray);
            graphics.fillOval(n % 7 * 88 + 14, (int)Math.ceil(n / 7) * 66 + 3, 60, 60);
            ++n;
        }
    }

    public void drawDisc(int n) {
        Graphics graphics = this.getGraphics();
        if (this.getfour.getNextPlayer() == 1) {
            graphics.setColor(this.red);
        } else {
            graphics.setColor(this.yellow);
        }
        graphics.fillOval((n - 1) * 88 + 14, (GetFour.getFreeRow(this.getfour.getGridArray(), n) - 1) * 66 + 3, 60, 60);
        this.getfour.setDisc(n, GetFour.getFreeRow(this.getfour.getGridArray(), n));
        this.checkAndProcessGameEnd();
    }

    private void checkAndProcessGameEnd() {
        if (GetFour.hasWon(this.getfour.getGridArray())) {
            if (this.getfour.getNextPlayer() == 1) {
                new GameEndDialog(this.getfourgui, "Yellow wins", "Yellow wins the game.", Color.yellow);
            } else {
                new GameEndDialog(this.getfourgui, "Red wins", "Red wins the game.", Color.red);
            }
        } else if (GetFour.isFull(this.getfour.getGridArray())) {
            new GameEndDialog(this.getfourgui, "Draw", "The game is a draw.", Color.white);
        }
    }

    private void drawAllDiscs() {
        Graphics graphics = this.getGraphics();
        int[] nArray = this.getfour.getGridArray();
        int n = 0;
        while (true) {
            if (n >= 42) break;
            if (nArray[n] == 1) {
                graphics.setColor(this.red);
            }
            if (nArray[n] == -1) {
                graphics.setColor(this.yellow);
            }
            if (nArray[n] == 0) {
                graphics.setColor(Color.gray);
            }
            graphics.fillOval(n % 7 * 88 + 14, (int)Math.ceil(n / 7) * 66 + 3, 60, 60);
            ++n;
        }
    }

    public int getColumn(int n) {
        return 1 + (int)Math.ceil(n / 88);
    }

    private class GridMouseListener
    extends MouseAdapter {
        private GridMouseListener() {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            int n = GridCanvas.this.getColumn(mouseEvent.getX());
            if (GridCanvas.this.getfour.getFreeRow(n) != 0 && !GridCanvas.this.getfour.hasWon()) {
                GridCanvas.this.drawDisc(n);
                if (GridCanvas.this.getfourgui.getCurrentMode() != "Human - Human" && !GridCanvas.this.getfour.hasWon() && !GridCanvas.this.getfour.isFull()) {
                    GridCanvas.this.drawDisc(GridCanvas.this.getfour.ai());
                }
            } else if (GridCanvas.this.getfour.hasWon()) {
                GridCanvas.this.getfour.newGame();
            }
        }
    }
}

