/*
 * Decompiled with CFR 0.152.
 */
package getfour;

import getfour.AIException;
import getfour.GetFour;
import getfour.Rating;

class Node {
    private int[] situation;
    private Node prevNode = null;
    private Node[] nextNode = new Node[]{null, null, null, null, null, null, null};
    private boolean maxNode = false;
    private int rating;
    private int nextPlayer;

    Node(Node node, int[] nArray, int n) {
        this.prevNode = node;
        this.situation = nArray;
        this.nextPlayer = n;
        if (!this.isRoot() && !this.prevNode.isMaxNode()) {
            this.maxNode = true;
        }
    }

    int minimax() {
        int n;
        if (this.isLeaf()) {
            this.rating = Rating.rate(this, this.situation, this.nextPlayer);
            return this.rating;
        }
        int[] nArray = new int[]{-11, -11, -11, -11, -11, -11, -11};
        for (n = 0; n < 7; ++n) {
            if (this.nextNode[n] == null) continue;
            nArray[n] = this.nextNode[n].minimax();
        }
        if (this.isMaxNode()) {
            n = -10;
            for (int i = 0; i < 7; ++i) {
                n = Math.max(n, nArray[i]);
            }
            this.rating = n;
            return n;
        }
        n = 10;
        for (int i = 0; i < 7; ++i) {
            if (nArray[i] == -11) continue;
            n = Math.min(n, nArray[i]);
        }
        this.rating = n;
        return n;
    }

    void expand(int n) {
        if (this.isLeaf() && this.getDepth() < n) {
            this.setNextNodes();
            for (int i = 0; i < 7; ++i) {
                if (this.nextNode[i] == null) continue;
                this.nextNode[i].expand(n);
            }
        }
    }

    Node getPrevNode() {
        return this.prevNode;
    }

    boolean isRoot() {
        return this.prevNode == null;
    }

    int getDepth() {
        if (this.isRoot()) {
            return 1;
        }
        return this.prevNode.getDepth() + 1;
    }

    void setRating(int n) {
        this.rating = n;
    }

    int getRating() {
        return this.rating;
    }

    Node getNextNode(int n) throws AIException {
        if (n < 7 && n >= 0) {
            if (this.nextNode[n] != null) {
                return this.nextNode[n];
            }
            Node node = new Node(this, null, 1);
            node.setRating(-11);
            return node;
        }
        throw new AIException("Exception in getNextNode(position: " + n + ").");
    }

    void setNextNodes() {
        if (!this.mustBeLeaf()) {
            for (int i = 0; i < 7; ++i) {
                int[] nArray = (int[])this.situation.clone();
                if (GetFour.getFreeRow(this.situation, i + 1) == 0) continue;
                nArray[(GetFour.getFreeRow((int[])this.situation, (int)(i + 1)) - 1) * 7 + i] = this.nextPlayer;
                this.nextNode[i] = new Node(this, nArray, GetFour.getOpponent(this.nextPlayer));
            }
        }
    }

    private boolean mustBeLeaf() {
        return GetFour.isFull(this.situation) || GetFour.hasWon(this.situation);
    }

    boolean isLeaf() {
        for (int i = 0; i < 7; ++i) {
            if (this.nextNode[i] == null) continue;
            return false;
        }
        return true;
    }

    boolean isMaxNode() {
        return this.maxNode;
    }

    void setRootMaxNode() {
        this.maxNode = true;
    }
}

