/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.thumbnail;

import java.io.File;
import java.io.IOException;
import net.sf.gogui.game.BoardUpdater;
import net.sf.gogui.game.ConstGameTree;
import net.sf.gogui.game.ConstNode;
import net.sf.gogui.go.Board;
import net.sf.gogui.go.ConstBoard;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.thumbnail.ThumbnailPlatform;
import net.sf.gogui.thumbnail.ThumbnailReader;
import net.sf.gogui.util.FileUtil;

public final class ThumbnailUtil {
    public static void expire(int seconds, boolean checkOnly) {
        if (!ThumbnailPlatform.checkThumbnailSupport()) {
            System.err.println("Thumbnails not supported on this platform.");
            return;
        }
        File dir = ThumbnailPlatform.getNormalDir();
        long currentTimeSeconds = System.currentTimeMillis() / 1000L;
        System.err.println("Expiring thumbnails. Time: " + currentTimeSeconds);
        for (File file : dir.listFiles()) {
            ThumbnailUtil.expire(file, currentTimeSeconds, seconds, checkOnly);
        }
    }

    public static void expire(File file, long currentTimeSeconds, long seconds, boolean checkOnly) {
        ThumbnailReader.MetaData metaData;
        if (!file.isFile()) {
            System.err.println("Not a normal file: " + file);
            return;
        }
        if (!FileUtil.hasExtension(file, "png")) {
            System.err.println("Not a thumbnail: " + file);
            return;
        }
        try {
            metaData = ThumbnailReader.read(file);
        }
        catch (IOException e) {
            System.err.println("Could not read meta data: " + file);
            return;
        }
        System.err.println("File: " + file);
        System.err.println("  URI: " + metaData.m_uri);
        System.err.println("  MTime: " + metaData.m_lastModified);
        System.err.println("  MimeType: " + metaData.m_mimeType);
        System.err.println("  Software: " + metaData.m_software);
        System.err.println("  Description: " + metaData.m_description);
        if (metaData.m_lastModified == 0L) {
            System.err.println("  No MTime meta data");
            return;
        }
        long age = currentTimeSeconds - metaData.m_lastModified;
        if (age > seconds) {
            if (checkOnly) {
                System.err.println("  Would expire");
            } else {
                System.err.println("  Expiring");
                if (!file.delete()) {
                    System.err.println("  Could not delete file");
                }
            }
        } else {
            System.err.println("  Not expiring");
        }
        System.err.println();
    }

    public static ConstNode getNode(ConstGameTree tree) {
        ConstNode node = tree.getRootConst();
        while (node.hasChildren() && (node.getSetup(GoColor.BLACK).size() <= 0 || node.getSetup(GoColor.WHITE).size() <= 0)) {
            node = node.getChildConst();
        }
        return node;
    }

    public static ConstBoard getPosition(ConstGameTree tree) {
        Board board = new Board(tree.getBoardSize());
        new BoardUpdater().update(tree, ThumbnailUtil.getNode(tree), board);
        return board;
    }

    private ThumbnailUtil() {
    }
}

