/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.tools.thumbnailer;

import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import net.sf.gogui.thumbnail.ThumbnailCreator;
import net.sf.gogui.util.Options;
import net.sf.gogui.util.StringUtil;
import net.sf.gogui.version.Version;

public final class Main {
    public static void main(String[] args) {
        try {
            String[] options = new String[]{"config:", "help", "scale", "size:", "verbose", "version"};
            Options opt = Options.parse(args, options);
            if (opt.contains("help")) {
                Main.printUsage(System.out);
                return;
            }
            if (opt.contains("version")) {
                System.out.println("gogui-thumbnailer " + Version.get());
                return;
            }
            boolean verbose = opt.contains("verbose");
            boolean scale = opt.contains("scale");
            ArrayList<String> arguments = opt.getArguments();
            if (arguments.isEmpty() || arguments.size() > 2) {
                Main.printUsage(System.err);
                System.exit(1);
            }
            File input = new File(arguments.get(0));
            File output = null;
            if (arguments.size() == 2) {
                output = new File(arguments.get(1));
            }
            int size = opt.getInteger("size", 128, 1);
            ThumbnailCreator thumbnailCreator = new ThumbnailCreator(verbose);
            try {
                thumbnailCreator.create(input, output, size, scale);
            }
            catch (ThumbnailCreator.Error e) {
                System.err.println(e.getMessage());
                System.exit(1);
            }
        }
        catch (Throwable t) {
            StringUtil.printException(t);
            System.exit(1);
        }
    }

    private Main() {
    }

    private static void printUsage(PrintStream out) {
        String helpText = "Usage: gogui-thumbnailer [options] input [output]\nOptions:\n-config    config file\n-help      Print help and exit\n-scale     Scale size for board sizes other than 19x19\n-size      Thumbnail size in pixels\n-verbose   Print logging messages to stderr\n-version   Print version and exit\n";
        out.print(helpText);
    }
}

