/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.BasicBrowserUI;
import ch.randelshofer.quaqua.BrowserCellRenderer;
import ch.randelshofer.quaqua.BrowserPreviewRenderer;
import ch.randelshofer.quaqua.BrowserUI;
import ch.randelshofer.quaqua.DefaultColumnCellRenderer;
import ch.randelshofer.quaqua.QuaquaScrollPaneLayout;
import ch.randelshofer.quaqua.QuaquaUtilities;
import ch.randelshofer.quaqua.util.Images;
import ch.randelshofer.quaqua.util.SizeConstrainedPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Arrays;
import java.util.BitSet;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class JBrowser
extends JComponent
implements Scrollable {
    private static final String uiClassID = "BrowserUI";
    private TreePath expandedPath;
    private int fixedCellWidth = 175;
    private int minimumCellWidth = 150;
    private TreeModel treeModel;
    protected transient TreeSelectionModel selectionModel;
    private transient SelectionModeUpdater selectionModeUpdater = new SelectionModeUpdater();
    private transient TreeSelectionUpdater treeSelectionUpdater = new TreeSelectionUpdater();
    private TreeRootHandler treeRootHandler = new TreeRootHandler();
    private transient ColumnMouseListener columnMouseListener = new ColumnMouseListener();
    private transient ColumnKeyListener columnKeyListener = new ColumnKeyListener();
    private transient ColumnFocusListener columnFocusListener = new ColumnFocusListener();
    private ListCellRenderer cellRenderer;
    private BrowserPreviewRenderer previewRenderer;
    private JScrollPane previewColumn;
    public static final String CELL_RENDERER_PROPERTY = "cellRenderer";
    public static final String PREVIEW_RENDERER_PROPERTY = "previewRenderer";
    public static final String TREE_MODEL_PROPERTY = "model";
    public static final String SELECTION_MODEL_PROPERTY = "selectionModel";
    public static final String FIXED_CELL_WIDTH_PROPERTY = "fixedCellWidth";
    public static final String MINIMUM_CELL_WIDTH_PROPERTY = "minimumCellWidth";
    public static final String COLUMNS_RESIZABLE_PROPERTY = "columnsResizable";
    private Object prototypeCellValue;
    private boolean isShowCellTips;
    private Point cellTipOrigin = new Point(0, 1);
    private boolean dragEnabled;
    private boolean columnsResizable = true;
    static /* synthetic */ Class class$java$awt$event$MouseListener;
    static /* synthetic */ Class class$javax$swing$event$ListSelectionListener;
    static /* synthetic */ Class class$ch$randelshofer$quaqua$DefaultColumnCellRenderer;

    public JBrowser() {
        this(JBrowser.getDefaultTreeModel());
    }

    public JBrowser(Object[] value) {
        this(JBrowser.createTreeModel(value));
        this.expandRoot();
    }

    public JBrowser(Vector value) {
        this(JBrowser.createTreeModel(value));
        this.expandRoot();
    }

    public JBrowser(Hashtable value) {
        this(JBrowser.createTreeModel(value));
        this.expandRoot();
    }

    public JBrowser(TreeNode root) {
        this(root, false);
    }

    public JBrowser(TreeNode root, boolean asksAllowsChildren) {
        this(new DefaultTreeModel(root, asksAllowsChildren));
    }

    public JBrowser(TreeModel newModel) {
        this.initComponents();
        this.selectionModel = new DefaultTreeSelectionModel();
        this.selectionModel.setSelectionMode(1);
        this.selectionModel.addPropertyChangeListener(this.selectionModeUpdater);
        this.selectionModel.addTreeSelectionListener(this.treeSelectionUpdater);
        this.setOpaque(true);
        this.updateUI();
        this.setModel(newModel);
        this.setFocusable(false);
    }

    public BrowserUI getUI() {
        return (BrowserUI)this.ui;
    }

    public void setUI(BrowserUI ui) {
        super.setUI(ui);
    }

    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI((BrowserUI)UIManager.getUI(this));
        } else {
            this.setUI(new BasicBrowserUI());
        }
        this.invalidate();
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void setPrototypeCellValue(Object prototypeCellValue) {
        this.prototypeCellValue = prototypeCellValue;
    }

    public void setDragEnabled(boolean b) {
        if (b && GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        this.dragEnabled = b;
        int n = this.getColumnCount();
        for (int i = 0; i < n; ++i) {
            this.getColumnList(i).setDragEnabled(b);
        }
    }

    public void setTransferHandler(TransferHandler newValue) {
        super.setTransferHandler(newValue);
        int n = this.getColumnCount();
        for (int i = 0; i < n; ++i) {
            this.getColumnList(i).setTransferHandler(newValue);
        }
    }

    public boolean getDragEnabled() {
        return this.dragEnabled;
    }

    protected static TreeModel getDefaultTreeModel() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("JBrowser");
        DefaultMutableTreeNode parent = new DefaultMutableTreeNode("colors");
        root.add(parent);
        parent.add(new DefaultMutableTreeNode("blue"));
        parent.add(new DefaultMutableTreeNode("violet"));
        parent.add(new DefaultMutableTreeNode("red"));
        parent.add(new DefaultMutableTreeNode("yellow"));
        parent = new DefaultMutableTreeNode("sports");
        root.add(parent);
        parent.add(new DefaultMutableTreeNode("basketball"));
        parent.add(new DefaultMutableTreeNode("soccer"));
        parent.add(new DefaultMutableTreeNode("football"));
        parent.add(new DefaultMutableTreeNode("hockey"));
        parent = new DefaultMutableTreeNode("food");
        root.add(parent);
        parent.add(new DefaultMutableTreeNode("hot dogs"));
        parent.add(new DefaultMutableTreeNode("pizza"));
        parent.add(new DefaultMutableTreeNode("ravioli"));
        parent.add(new DefaultMutableTreeNode("bananas"));
        return new DefaultTreeModel(root);
    }

    protected static TreeModel createTreeModel(Object value) {
        DefaultMutableTreeNode root;
        if (value instanceof Object[] || value instanceof Hashtable || value instanceof Vector) {
            root = new DefaultMutableTreeNode("root");
            JTree.DynamicUtilTreeNode.createChildren(root, value);
        } else {
            root = new JTree.DynamicUtilTreeNode((Object)"root", value);
        }
        return new DefaultTreeModel(root, false);
    }

    private void expandRoot() {
        this.selectionModel.clearSelection();
        this.expandPath(new TreePath(this.treeModel.getRoot()));
    }

    public TreePath getClosestPathForLocation(int x, int y) {
        Component c = this.getComponentAt(x, y);
        if (c != null && c instanceof JScrollPane && (c = c.getComponentAt(x -= c.getX(), y -= c.getY())) != null && c instanceof JViewport && (c = c.getComponentAt(x -= c.getX(), y -= c.getY())) != null && c instanceof JList) {
            JList l = (JList)c;
            ColumnListModel m = (ColumnListModel)l.getModel();
            int index = l.locationToIndex(new Point(x -= c.getX(), y -= c.getY()));
            if (index != -1) {
                return m.path.pathByAddingChild(m.getElementAt(index));
            }
        }
        return null;
    }

    public Rectangle getPathBounds(TreePath path) {
        if (path.getPathCount() <= this.getListColumnCount()) {
            JList list = this.getColumnList(path.getPathCount() - 1);
            int index = path.getPathCount() > 1 ? this.treeModel.getIndexOfChild(path.getPathComponent(path.getPathCount() - 2), path.getLastPathComponent()) : this.treeModel.getIndexOfChild(null, path.getLastPathComponent());
            Rectangle bounds = list.getCellBounds(index, index);
            bounds.x += list.getLocation().x + list.getParent().getLocation().x + list.getParent().getParent().getLocation().x;
            bounds.y += list.getLocation().y + list.getParent().getLocation().y + list.getParent().getParent().getLocation().y;
            return bounds;
        }
        return null;
    }

    public void setShowCellTips(boolean newValue) {
        boolean oldValue = this.isShowCellTips;
        if (oldValue != newValue) {
            this.isShowCellTips = newValue;
            String tipText = newValue ? "cell tip" : null;
            int n = this.getColumnCount();
            for (int i = 0; i < n; ++i) {
                this.getColumnList(i).setToolTipText(tipText);
            }
            this.firePropertyChange("showCellTips", oldValue, newValue);
        }
    }

    public boolean isShowCellTips() {
        return this.isShowCellTips;
    }

    public void setShowCellTipOrigin(Point newValue) {
        Point oldValue = this.cellTipOrigin;
        this.cellTipOrigin = newValue == null ? new Point(0, 0) : (Point)newValue.clone();
        this.firePropertyChange("cellTipOrigin", oldValue, newValue);
    }

    public Point getCellTipOrigin() {
        return (Point)this.cellTipOrigin.clone();
    }

    public boolean isPathSelected(TreePath path) {
        TreePath[] selectionPaths = this.getSelectionPaths();
        for (int i = 0; i < selectionPaths.length; ++i) {
            if (!selectionPaths[i].equals(path)) continue;
            return true;
        }
        return false;
    }

    public void addSelectionPath(TreePath path) {
        for (int i = 0; i < path.getPathCount(); ++i) {
            int index;
            JList columnList = this.getColumnList(i);
            if (columnList.isSelectedIndex(index = this.treeModel.getIndexOfChild(i == 0 ? null : path.getPathComponent(i - 1), path.getPathComponent(i)))) continue;
            if (i < path.getPathCount() - 1) {
                columnList.setSelectionInterval(index, index);
                continue;
            }
            columnList.addSelectionInterval(index, index);
        }
    }

    public void ensurePathIsVisible(TreePath path) {
        TreePath selectionPath = this.selectionModel.getSelectionPath();
        if (selectionPath != null && (path.isDescendant(selectionPath) || selectionPath.isDescendant(path))) {
            if (!this.isValid()) {
                this.setSize(this.getPreferredSize());
                this.doLayout();
            }
            for (int i = 0; i < path.getPathCount() - 1 && i < this.getListColumnCount(); ++i) {
                JList columnList = this.getColumnList(i);
                int index0 = columnList.getSelectedIndex();
                Rectangle bounds = columnList.getCellBounds(index0, index0);
                if (index0 == -1 || bounds == null) continue;
                columnList.scrollRectToVisible(bounds);
            }
            Component component = this.getComponent(this.getColumnCount() - 1);
            if (component != null && component.getBounds() != null) {
                this.scrollRectToVisible(component.getBounds());
            }
        }
    }

    public void setSelectionPath(TreePath path) {
        this.selectionModel.setSelectionPath(path);
    }

    public void removeSelectionPath(TreePath path) {
        if (path.getPathCount() <= this.getListColumnCount()) {
            JList columnList = this.getColumnList(path.getPathCount() - 1);
            int index = this.treeModel.getIndexOfChild(path.getPathComponent(path.getPathCount() - 2), path.getLastPathComponent());
            columnList.removeSelectionInterval(index, index);
        }
    }

    public TreePath getPathForLocation(int x, int y) {
        return this.getClosestPathForLocation(x, y);
    }

    public void clearSelection() {
        this.setSelectionPath(new TreePath(this.treeModel.getRoot()));
    }

    public void setFixedCellWidth(int width) {
        int oldValue = this.fixedCellWidth;
        this.fixedCellWidth = width;
        for (int i = 0; i < this.getListColumnCount(); ++i) {
            this.getColumnList(i).setFixedCellWidth(width);
        }
        if (this.previewColumn != null) {
            SizeConstrainedPanel p = (SizeConstrainedPanel)this.previewColumn.getComponent(0);
            p.setPreferredWidth(width);
        }
        if (this.getParent() != null) {
            this.getParent().validate();
        }
        this.firePropertyChange(FIXED_CELL_WIDTH_PROPERTY, oldValue, this.fixedCellWidth);
    }

    public int getFixedCellWidth() {
        return this.fixedCellWidth;
    }

    public void setMinimumCellWidth(int newValue) {
        int oldValue = this.minimumCellWidth;
        this.minimumCellWidth = newValue;
        this.firePropertyChange(MINIMUM_CELL_WIDTH_PROPERTY, oldValue, newValue);
    }

    public int getMinimumCellWidth() {
        return this.minimumCellWidth;
    }

    public void setColumnWidth(int column, int width) {
        JList l = this.getColumnList(column);
        l.setFixedCellWidth(width);
        l.revalidate();
        this.revalidate();
    }

    public int getColumnWidth(int column) {
        return this.getColumnList(column).getFixedCellWidth();
    }

    public int getPreferredColumnWidth(int column) {
        JList l = this.getColumnList(column);
        l.setFixedCellWidth(-1);
        int width = l.getPreferredSize().width;
        l.setFixedCellWidth(this.fixedCellWidth);
        return width;
    }

    public void setPreviewColumnWidth(int width) {
        if (this.previewColumn == null) {
            return;
        }
        SizeConstrainedPanel p = (SizeConstrainedPanel)this.previewColumn.getViewport().getView();
        p.setPreferredWidth(width);
        this.revalidate();
    }

    public int getPreviewColumnWidth() {
        if (this.previewColumn == null) {
            return this.getFixedCellWidth();
        }
        SizeConstrainedPanel p = (SizeConstrainedPanel)this.previewColumn.getViewport().getView();
        return p.getPreferredSize().width;
    }

    public void setColumnsResizable(boolean newValue) {
        boolean oldValue = this.columnsResizable;
        this.columnsResizable = newValue;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component handle;
            Component c = this.getComponent(i);
            if (!(c instanceof JScrollPane) || !((handle = ((JScrollPane)c).getCorner("LOWER_RIGHT_CORNER")) instanceof SizeHandle)) continue;
            handle.setVisible(newValue);
        }
        this.firePropertyChange(COLUMNS_RESIZABLE_PROPERTY, oldValue, newValue);
    }

    public boolean isColumnsResizable() {
        return this.columnsResizable;
    }

    public void setColumnCellRenderer(ListCellRenderer cellRenderer) {
        ListCellRenderer oldValue = this.cellRenderer;
        this.cellRenderer = cellRenderer;
        for (int i = 0; i < this.getListColumnCount(); ++i) {
            this.getColumnList(i).setCellRenderer(cellRenderer);
        }
        this.firePropertyChange(CELL_RENDERER_PROPERTY, oldValue, cellRenderer);
    }

    public ListCellRenderer getColumnCellRenderer() {
        return this.cellRenderer;
    }

    public void setCellRenderer(BrowserCellRenderer cellRenderer) {
        BrowserCellRenderer oldValue = this.getCellRenderer();
        if (cellRenderer != null) {
            this.setColumnCellRenderer(new BrowserCellRendererWrapper(cellRenderer));
        } else {
            this.setColumnCellRenderer(new DefaultColumnCellRenderer(this));
        }
        this.firePropertyChange(CELL_RENDERER_PROPERTY, oldValue, cellRenderer);
    }

    public BrowserCellRenderer getCellRenderer() {
        return this.cellRenderer instanceof BrowserCellRendererWrapper ? ((BrowserCellRendererWrapper)this.cellRenderer).browserCellRenderer : null;
    }

    public void setPreviewRenderer(BrowserPreviewRenderer newValue) {
        BrowserPreviewRenderer oldValue = this.previewRenderer;
        this.previewRenderer = newValue;
        if (newValue == null) {
            if (this.previewColumn != null) {
                this.remove(this.previewColumn);
                this.previewColumn = null;
            }
        } else {
            if (this.previewColumn == null) {
                SizeConstrainedPanel p = new SizeConstrainedPanel();
                p.setPreferredWidth(this.fixedCellWidth);
                this.previewColumn = new JScrollPane(p, 22, 31);
                this.previewColumn.setBorder(null);
                SizeHandle sizeHandle = new SizeHandle(-1);
                sizeHandle.setVisible(this.isColumnsResizable());
                this.previewColumn.setCorner("LOWER_RIGHT_CORNER", sizeHandle);
                this.previewColumn.setLayout(new BrowserScrollPaneLayout());
                this.previewColumn.setFocusable(false);
                this.previewColumn.getHorizontalScrollBar().setFocusable(false);
                this.previewColumn.getVerticalScrollBar().setFocusable(false);
                if (this.getDropTarget() != null) {
                    new DropTarget(this.previewColumn, this.getDropTarget().getDefaultActions(), this.getDropTarget());
                    new DropTarget(p, this.getDropTarget().getDefaultActions(), this.getDropTarget());
                }
            }
            this.updatePreviewColumn();
        }
        this.firePropertyChange(CELL_RENDERER_PROPERTY, oldValue, newValue);
    }

    private int getColumnCount() {
        return this.getComponentCount();
    }

    private int getListColumnCount() {
        int count = this.getComponentCount();
        if (this.previewColumn != null && this.previewColumn.getParent() == this) {
            return count - 1;
        }
        return count;
    }

    public void setDropTarget(DropTarget t) {
        super.setDropTarget(t);
        if (t != null) {
            int n = this.getListColumnCount();
            for (int i = 0; i < n; ++i) {
                new DropTarget(this.getColumnList(i), this.getDropTarget().getDefaultActions(), this.getDropTarget());
            }
        }
        if (this.previewColumn != null) {
            new DropTarget(this.previewColumn, this.getDropTarget().getDefaultActions(), this.getDropTarget());
            new DropTarget((SizeConstrainedPanel)this.previewColumn.getViewport().getView(), this.getDropTarget().getDefaultActions(), this.getDropTarget());
        }
    }

    private JList getColumnList(int column) {
        return (JList)((JScrollPane)this.getComponent(column)).getViewport().getView();
    }

    private ColumnListModel getColumnListModel(int column) {
        return (ColumnListModel)((JList)((JScrollPane)this.getComponent(column)).getViewport().getView()).getModel();
    }

    private TreePath getColumnPath(int column) {
        return ((ColumnListModel)((JList)((JScrollPane)this.getComponent(column)).getViewport().getView()).getModel()).path;
    }

    public int getSelectionCount() {
        return this.selectionModel.getSelectionCount();
    }

    public void setSelectionModel(TreeSelectionModel selectionModel) {
        if (selectionModel == null) {
            throw new IllegalArgumentException();
        }
        TreeSelectionModel oldValue = this.selectionModel;
        if (this.selectionModel != null) {
            this.selectionModel.removeTreeSelectionListener(this.treeSelectionUpdater);
            this.selectionModel.removePropertyChangeListener(this.selectionModeUpdater);
        }
        if (this.accessibleContext != null) {
            this.selectionModel.removeTreeSelectionListener((TreeSelectionListener)((Object)this.accessibleContext));
            selectionModel.addTreeSelectionListener((TreeSelectionListener)((Object)this.accessibleContext));
        }
        this.selectionModel = selectionModel;
        if (selectionModel != null) {
            this.selectionModel.addTreeSelectionListener(this.treeSelectionUpdater);
            this.selectionModel.addPropertyChangeListener(this.selectionModeUpdater);
        }
        this.firePropertyChange(SELECTION_MODEL_PROPERTY, oldValue, this.selectionModel);
    }

    public TreeSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectionMode(int selectionMode) {
        this.selectionModel.setSelectionMode(selectionMode);
    }

    public TreePath getSelectionPath() {
        if (this.getListColumnCount() == 0) {
            return null;
        }
        JList list = this.getColumnList(this.getListColumnCount() - 1);
        ColumnListModel m = this.getColumnListModel(this.getListColumnCount() - 1);
        int i = list.getSelectedIndex();
        Object pathComponent = i == -1 || i >= m.getSize() ? null : list.getSelectedValue();
        return pathComponent == null ? m.path : m.path.pathByAddingChild(pathComponent);
    }

    public TreePath[] getSelectionPaths() {
        return this.getSelectionModel().getSelectionPaths();
    }

    public void setSelectionPaths(TreePath[] paths) {
        this.getSelectionModel().setSelectionPaths(paths);
    }

    public synchronized KeyListener[] getKeyListeners() {
        return (KeyListener[])this.getListeners(KeyListener.class);
    }

    public void updatePreviewColumn() {
        if (this.previewColumn != null) {
            SizeConstrainedPanel p = (SizeConstrainedPanel)this.previewColumn.getViewport().getView();
            TreePath[] paths = this.getSelectionPaths();
            switch (paths == null ? 0 : paths.length) {
                case 0: {
                    this.remove(this.previewColumn);
                    break;
                }
                case 1: {
                    if (this.treeModel.isLeaf(paths[0].getLastPathComponent())) {
                        p.removeAll();
                        p.add(this.previewRenderer.getPreviewRendererComponent(this, paths));
                        this.setPreviewColumnWidth(this.getPreviewColumnWidth());
                        this.add(this.previewColumn);
                        break;
                    }
                    this.remove(this.previewColumn);
                    break;
                }
                default: {
                    p.removeAll();
                    p.add(this.previewRenderer.getPreviewRendererComponent(this, paths));
                    this.setPreviewColumnWidth(this.getFixedCellWidth());
                    this.add(this.previewColumn);
                }
            }
        }
    }

    public void addTreeSelectionListener(TreeSelectionListener tsl) {
        this.listenerList.add(TreeSelectionListener.class, tsl);
    }

    public void removeTreeSelectionListener(TreeSelectionListener tsl) {
        this.listenerList.remove(TreeSelectionListener.class, tsl);
    }

    protected void fireValueChanged(TreeSelectionEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$TreeSelectionListener == null ? JBrowser.class$("javax.swing.event.TreeSelectionListener") : class$javax$swing$event$TreeSelectionListener)) continue;
            ((TreeSelectionListener)listeners[i + 1]).valueChanged(e);
        }
    }

    public TreeModel getModel() {
        return this.treeModel;
    }

    public void setModel(TreeModel newModel) {
        TreeModel oldModel = this.treeModel;
        if (oldModel != null) {
            oldModel.removeTreeModelListener(this.treeRootHandler);
        }
        this.treeModel = newModel;
        if (newModel != null) {
            newModel.addTreeModelListener(this.treeRootHandler);
        }
        for (int i = this.getListColumnCount() - 1; i >= 0; --i) {
            this.removeLastListColumn();
        }
        if (this.treeModel != null) {
            this.expandedPath = null;
            this.expandRoot();
        }
        this.firePropertyChange(TREE_MODEL_PROPERTY, oldModel, this.treeModel);
    }

    private void expandPath(TreePath path) {
        int newColumnCount;
        int oldColumnCount;
        boolean newPathIsLeaf;
        boolean oldPathIsLeaf = this.expandedPath == null || this.treeModel.isLeaf(this.expandedPath.getLastPathComponent());
        boolean bl = newPathIsLeaf = path == null || this.treeModel.isLeaf(path.getLastPathComponent());
        int n = this.expandedPath == null ? 0 : (oldColumnCount = this.expandedPath.getPathCount() - (oldPathIsLeaf ? 1 : 0));
        int n2 = path == null ? 0 : (newColumnCount = path.getPathCount() - (newPathIsLeaf ? 1 : 0));
        if (this.expandedPath == null || !this.expandedPath.equals(path)) {
            TreePath p;
            if (oldColumnCount == newColumnCount) {
                p = null;
                for (int i = 0; i < newColumnCount; ++i) {
                    p = p == null ? new TreePath(path.getPathComponent(0)) : p.pathByAddingChild(path.getPathComponent(i));
                    JList l = this.getColumnList(i);
                    ColumnListModel m = (ColumnListModel)l.getModel();
                    m.setPath(p);
                }
            } else {
                for (int i = this.getListColumnCount() - 1; i >= newColumnCount; --i) {
                    if (this.getColumnList(i).isFocusOwner()) {
                        this.removeColumn(i > 0 ? i - 1 : i);
                        continue;
                    }
                    this.removeColumn(i);
                }
                p = null;
                int n3 = this.getListColumnCount();
                for (int i = 0; i < n3; ++i) {
                    p = p == null ? new TreePath(path.getPathComponent(0)) : p.pathByAddingChild(path.getPathComponent(i));
                    JList l = this.getColumnList(i);
                    ColumnListModel m = (ColumnListModel)l.getModel();
                    m.setPath(p);
                }
                List<Object> components = Arrays.asList(path.getPath());
                for (int i = this.getListColumnCount(); i < newColumnCount; ++i) {
                    this.addColumn(new TreePath(components.subList(0, i + 1).toArray()));
                }
            }
            this.expandedPath = path;
            for (int i = 0; i < path.getPathCount() - 1; ++i) {
                this.getColumnList(i).setSelectedIndex(this.treeModel.getIndexOfChild(path.getPathComponent(i), path.getPathComponent(i + 1)));
            }
        }
    }

    protected void addColumn(TreePath path) {
        int selectionMode;
        JList l = new JList(new ColumnListModel(path, this.treeModel)){

            public String getToolTipText(MouseEvent event) {
                Rectangle cellBounds;
                Point mouseLocation = event.getPoint();
                int index = this.locationToIndex(mouseLocation);
                if (index != -1 && (cellBounds = this.getCellBounds(index, index)).contains(mouseLocation)) {
                    Object value = this.getModel().getElementAt(index);
                    Component renderer = this.getCellRenderer().getListCellRendererComponent(this, value, index, false, false);
                    if (renderer.getPreferredSize().width > this.getWidth()) {
                        return value.toString();
                    }
                }
                return null;
            }

            public Point getToolTipLocation(MouseEvent event) {
                Rectangle cellBounds;
                Point mouseLocation = event.getPoint();
                int index = this.locationToIndex(mouseLocation);
                if (index != -1 && (cellBounds = this.getCellBounds(index, index)).contains(mouseLocation)) {
                    Object value = this.getModel().getElementAt(index);
                    Component renderer = this.getCellRenderer().getListCellRendererComponent(this, value, index, false, false);
                    if (renderer.getPreferredSize().width > this.getWidth()) {
                        Point location = cellBounds.getLocation();
                        location.x += ((JBrowser)JBrowser.this).cellTipOrigin.x;
                        location.y += ((JBrowser)JBrowser.this).cellTipOrigin.y;
                        return location;
                    }
                }
                return null;
            }
        };
        if (this.isShowCellTips) {
            l.setToolTipText("cell tip");
        }
        if (this.getDropTarget() != null) {
            new DropTarget(l, this.getDropTarget().getDefaultActions(), this.getDropTarget());
        }
        if (this.cellRenderer != null) {
            l.setCellRenderer(this.cellRenderer);
        }
        if (this.prototypeCellValue != null) {
            l.setPrototypeCellValue(this.prototypeCellValue);
        }
        l.setSelectionModel(new ColumnSelectionModel());
        switch (this.selectionModel.getSelectionMode()) {
            case 2: {
                selectionMode = 1;
                break;
            }
            case 4: {
                selectionMode = 2;
                break;
            }
            default: {
                selectionMode = 0;
            }
        }
        l.setSelectionMode(selectionMode);
        l.addMouseListener(this.columnMouseListener);
        l.addKeyListener(this.columnKeyListener);
        l.addFocusListener(this.columnFocusListener);
        l.setFixedCellWidth(this.fixedCellWidth);
        l.setDragEnabled(this.getDragEnabled());
        l.setTransferHandler(this.getTransferHandler());
        JScrollPane sp = new JScrollPane(l, 22, 31);
        sp.setBorder(null);
        SizeHandle sizeHandle = new SizeHandle(path.getPathCount() - 1);
        sizeHandle.setVisible(this.isColumnsResizable());
        sp.setCorner("LOWER_RIGHT_CORNER", new SizeHandle(path.getPathCount() - 1));
        sp.setLayout(new BrowserScrollPaneLayout());
        sp.setFocusable(false);
        sp.getVerticalScrollBar().setFocusable(false);
        sp.getHorizontalScrollBar().setFocusable(false);
        this.add((Component)sp, this.getListColumnCount());
    }

    protected void removeLastListColumn() {
        this.removeColumn(this.getListColumnCount() - 1);
    }

    protected void removeColumn(int columnIndex) {
        JList l = this.getColumnList(columnIndex);
        JScrollPane sp = (JScrollPane)this.getComponent(columnIndex);
        sp.remove(l);
        this.remove(sp);
        if (l.hasFocus()) {
            this.putClientProperty("Quaqua.drawFocusBorder", Boolean.FALSE);
            this.repaintParentBorder();
        }
        l.removeMouseListener(this.columnMouseListener);
        l.removeKeyListener(this.columnKeyListener);
        l.removeFocusListener(this.columnFocusListener);
        ((ColumnListModel)l.getModel()).dispose();
    }

    private void initComponents() {
        this.setLayout(new BrowserLayout());
    }

    public Dimension getPreferredScrollableViewportSize() {
        Dimension size = new Dimension();
        if (this.getComponentCount() == 0) {
            JScrollPane dummyColumn = new JScrollPane();
            JList<Object> list = new JList<Object>();
            list.setPrototypeCellValue(this.prototypeCellValue);
            dummyColumn.setViewportView(list);
            size.setSize(dummyColumn.getPreferredSize());
            size.width *= 2;
        } else {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Dimension componentSize = this.getComponent(i).getPreferredSize();
                size.height = Math.max(size.height, componentSize.height);
                size.width += componentSize.width;
            }
        }
        return size;
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        int increment;
        block11: {
            Component[] components;
            block10: {
                components = this.getComponents();
                increment = 0;
                if (direction <= 0) break block10;
                switch (orientation) {
                    case 0: {
                        for (int i = components.length - 1; i >= 0; --i) {
                            Rectangle cbounds = components[i].getBounds();
                            if (cbounds.x + cbounds.width <= visibleRect.x + visibleRect.width) continue;
                            increment = cbounds.x + cbounds.width - visibleRect.x - visibleRect.width;
                        }
                        break block11;
                    }
                    case 1: {
                        increment = 10;
                    }
                }
                break block11;
            }
            switch (orientation) {
                case 0: {
                    for (int i = 0; i < components.length; ++i) {
                        Rectangle cbounds = components[i].getBounds();
                        if (cbounds.x >= visibleRect.x) continue;
                        increment = visibleRect.x - cbounds.x;
                    }
                    break;
                }
                case 1: {
                    increment = 10;
                }
            }
        }
        return increment;
    }

    public boolean getScrollableTracksViewportHeight() {
        return true;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        int increment;
        block13: {
            Component[] components;
            block12: {
                components = this.getComponents();
                increment = 0;
                if (direction <= 0) break block12;
                switch (orientation) {
                    case 0: {
                        for (int i = components.length - 1; i >= 0; --i) {
                            Rectangle cbounds = components[i].getBounds();
                            if (cbounds.x > visibleRect.x) {
                                increment = cbounds.x - visibleRect.x;
                                continue;
                            }
                            if (cbounds.x + cbounds.width <= visibleRect.x + visibleRect.width) continue;
                            increment = cbounds.x - visibleRect.x;
                        }
                        break block13;
                    }
                    case 1: {
                        increment = 10;
                    }
                }
                break block13;
            }
            switch (orientation) {
                case 0: {
                    for (int i = 0; i < components.length; ++i) {
                        Rectangle cbounds = components[i].getBounds();
                        if (cbounds.x + cbounds.width >= visibleRect.x) continue;
                        increment = visibleRect.x - cbounds.x;
                    }
                    if (increment == 0) {
                        increment = visibleRect.x - components[0].getBounds().x;
                    }
                    System.out.println("JBrowser Scroll by block horizontal " + increment);
                    break;
                }
                case 1: {
                    increment = 10;
                }
            }
        }
        return increment;
    }

    public void addNotify() {
        super.addNotify();
        this.configureEnclosingScrollPane();
    }

    protected void configureEnclosingScrollPane() {
    }

    public void removeNotify() {
        this.unconfigureEnclosingScrollPane();
        super.removeNotify();
    }

    protected void unconfigureEnclosingScrollPane() {
    }

    public void requestFocus() {
        TreePath tp = this.getSelectionPath();
        if (tp != null && tp.getPathCount() > 1) {
            this.getColumnList(tp.getPathCount() - 2).requestFocus();
        } else {
            this.getColumnList(this.getListColumnCount() - 1).requestFocus();
        }
    }

    private void repaintParentBorder() {
        Container parent = this.getParent();
        if (parent != null && parent instanceof JViewport) {
            parent = parent.getParent();
            Insets insets = ((JComponent)parent).getInsets();
            Dimension size = parent.getSize();
            parent.repaint(0, 0, size.width, insets.top);
            parent.repaint(0, size.height - insets.bottom, size.width, insets.bottom);
            parent.repaint(0, insets.top, insets.left, size.height - insets.top - insets.bottom);
            parent.repaint(size.width - insets.right, insets.top, insets.right, size.height - insets.top - insets.bottom);
        }
    }

    public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String sValue;
        if (value != null && (sValue = value.toString()) != null) {
            return sValue;
        }
        return "";
    }

    private class BrowserCellRendererWrapper
    extends JPanel
    implements ListCellRenderer {
        private BrowserCellRenderer browserCellRenderer;
        private Component browserCellRendererComponent;
        private JLabel arrowLabel;
        private EmptyBorder noFocusBorder;
        protected Icon expandedIcon = null;
        protected Icon selectedExpandedIcon = null;
        protected Icon expandingIcon = null;

        public BrowserCellRendererWrapper(BrowserCellRenderer treeCellRenderer) {
            this.browserCellRenderer = treeCellRenderer;
            BufferedImage[] iconImages = Images.split(Toolkit.getDefaultToolkit().createImage((class$ch$randelshofer$quaqua$DefaultColumnCellRenderer == null ? (class$ch$randelshofer$quaqua$DefaultColumnCellRenderer = JBrowser.class$("ch.randelshofer.quaqua.DefaultColumnCellRenderer")) : class$ch$randelshofer$quaqua$DefaultColumnCellRenderer).getResource("images/Browser.disclosureIcons.png")), 4, true);
            this.expandedIcon = new ImageIcon(iconImages[0]);
            this.selectedExpandedIcon = new ImageIcon(iconImages[2]);
            this.noFocusBorder = new EmptyBorder(1, 1, 1, 1);
            this.setLayout(new BorderLayout());
            this.arrowLabel = new JLabel(){

                public void validate() {
                }

                public void revalidate() {
                }

                public void repaint(long tm, int x, int y, int width, int height) {
                }

                public void repaint(Rectangle r) {
                }

                protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
                    if (propertyName == "text") {
                        super.firePropertyChange(propertyName, oldValue, newValue);
                    }
                }

                public void firePropertyChange(String propertyName, short oldValue, short newValue) {
                }

                public void firePropertyChange(String propertyName, int oldValue, int newValue) {
                }

                public void firePropertyChange(String propertyName, long oldValue, long newValue) {
                }

                public void firePropertyChange(String propertyName, float oldValue, float newValue) {
                }

                public void firePropertyChange(String propertyName, double oldValue, double newValue) {
                }

                public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
                }
            };
            this.setOpaque(true);
            this.setBorder(this.noFocusBorder);
            this.arrowLabel.putClientProperty("Quaqua.Component.visualMargin", new Insets(0, 0, 0, 0));
            this.arrowLabel.setIcon(this.expandedIcon);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Color foreground;
            boolean isFocused = QuaquaUtilities.isFocused(list);
            boolean isLeaf = JBrowser.this.getModel().isLeaf(value);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                foreground = !isFocused && UIManager.getColor("List.inactiveSelectionForeground") != null ? UIManager.getColor("List.inactiveSelectionForeground") : list.getSelectionForeground();
                this.arrowLabel.setForeground(foreground);
                this.arrowLabel.setIcon(this.selectedExpandedIcon);
            } else {
                this.setBackground(list.getBackground());
                foreground = list.getForeground();
                this.arrowLabel.setForeground(foreground);
                this.arrowLabel.setIcon(this.expandedIcon);
            }
            this.arrowLabel.setVisible(!JBrowser.this.getModel().isLeaf(value));
            boolean isExpanded = false;
            int n = JBrowser.this.expandedPath.getPathCount();
            for (int i = 0; i < n; ++i) {
                if (JBrowser.this.expandedPath.getPathComponent(i) != value) continue;
                isExpanded = true;
                break;
            }
            this.browserCellRendererComponent = this.browserCellRenderer.getBrowserCellRendererComponent(JBrowser.this, value, isSelected, isExpanded, isLeaf, index, isFocused && list.getLeadSelectionIndex() == index);
            this.removeAll();
            this.add(this.browserCellRendererComponent, "Center");
            this.add((Component)this.arrowLabel, "East");
            this.setBorder(cellHasFocus ? UIManager.getBorder("List.focusCellHighlightBorder") : this.noFocusBorder);
            return this;
        }

        public void setFont(Font newValue) {
            super.setFont(newValue);
            if (this.browserCellRendererComponent != null) {
                this.browserCellRendererComponent.setFont(newValue);
            }
        }

        public void revalidate() {
        }

        public void repaint(long tm, int x, int y, int width, int height) {
        }

        public void repaint(Rectangle r) {
        }

        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        }

        public void firePropertyChange(String propertyName, short oldValue, short newValue) {
        }

        public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        }

        public void firePropertyChange(String propertyName, long oldValue, long newValue) {
        }

        public void firePropertyChange(String propertyName, float oldValue, float newValue) {
        }

        public void firePropertyChange(String propertyName, double oldValue, double newValue) {
        }

        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }
    }

    private class TreeRootHandler
    implements TreeModelListener {
        private TreeRootHandler() {
        }

        public void treeNodesChanged(TreeModelEvent e) {
        }

        public void treeNodesInserted(TreeModelEvent e) {
        }

        public void treeNodesRemoved(TreeModelEvent e) {
        }

        public void treeStructureChanged(TreeModelEvent e) {
            if (e.getPath().length == 1) {
                for (int i = JBrowser.this.getListColumnCount() - 1; i >= 0; --i) {
                    JBrowser.this.removeLastListColumn();
                }
                JBrowser.this.expandedPath = null;
                JBrowser.this.expandRoot();
                JBrowser.this.setSelectionPath(e.getTreePath());
            }
        }
    }

    private static class ColumnSelectionModel
    implements ListSelectionModel,
    Cloneable,
    Serializable {
        private static final int MIN = -1;
        private static final int MAX = Integer.MAX_VALUE;
        private int selectionMode = 2;
        private int minIndex = Integer.MAX_VALUE;
        private int maxIndex = -1;
        private int anchorIndex = -1;
        private int leadIndex = -1;
        private int firstAdjustedIndex = Integer.MAX_VALUE;
        private int lastAdjustedIndex = -1;
        private boolean isAdjusting = false;
        private int firstChangedIndex = Integer.MAX_VALUE;
        private int lastChangedIndex = -1;
        private BitSet value = new BitSet(32);
        protected EventListenerList listenerList = new EventListenerList();
        protected boolean leadAnchorNotificationEnabled = true;

        private ColumnSelectionModel() {
        }

        public int getMinSelectionIndex() {
            return this.isSelectionEmpty() ? -1 : this.minIndex;
        }

        public int getMaxSelectionIndex() {
            return this.maxIndex;
        }

        public boolean getValueIsAdjusting() {
            return this.isAdjusting;
        }

        public int getSelectionMode() {
            return this.selectionMode;
        }

        public void setSelectionMode(int selectionMode) {
            switch (selectionMode) {
                case 0: 
                case 1: 
                case 2: {
                    this.selectionMode = selectionMode;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid selectionMode");
                }
            }
        }

        public boolean isSelectedIndex(int index) {
            return index < this.minIndex || index > this.maxIndex ? false : this.value.get(index);
        }

        public boolean isSelectionEmpty() {
            return this.minIndex > this.maxIndex;
        }

        public void addListSelectionListener(ListSelectionListener l) {
            this.listenerList.add(class$javax$swing$event$ListSelectionListener == null ? (class$javax$swing$event$ListSelectionListener = JBrowser.class$("javax.swing.event.ListSelectionListener")) : class$javax$swing$event$ListSelectionListener, l);
        }

        public void removeListSelectionListener(ListSelectionListener l) {
            this.listenerList.remove(class$javax$swing$event$ListSelectionListener == null ? (class$javax$swing$event$ListSelectionListener = JBrowser.class$("javax.swing.event.ListSelectionListener")) : class$javax$swing$event$ListSelectionListener, l);
        }

        public ListSelectionListener[] getListSelectionListeners() {
            return (ListSelectionListener[])this.listenerList.getListeners(class$javax$swing$event$ListSelectionListener == null ? (class$javax$swing$event$ListSelectionListener = JBrowser.class$("javax.swing.event.ListSelectionListener")) : class$javax$swing$event$ListSelectionListener);
        }

        protected void fireValueChanged(boolean isAdjusting) {
            if (this.lastChangedIndex == -1) {
                return;
            }
            int oldFirstChangedIndex = this.firstChangedIndex;
            int oldLastChangedIndex = this.lastChangedIndex;
            this.firstChangedIndex = Integer.MAX_VALUE;
            this.lastChangedIndex = -1;
            this.fireValueChanged(oldFirstChangedIndex, oldLastChangedIndex, isAdjusting);
        }

        protected void fireValueChanged(int firstIndex, int lastIndex) {
            this.fireValueChanged(firstIndex, lastIndex, this.getValueIsAdjusting());
        }

        protected void fireValueChanged(int firstIndex, int lastIndex, boolean isAdjusting) {
            Object[] listeners = this.listenerList.getListenerList();
            ListSelectionEvent e = null;
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != (class$javax$swing$event$ListSelectionListener == null ? JBrowser.class$("javax.swing.event.ListSelectionListener") : class$javax$swing$event$ListSelectionListener)) continue;
                if (e == null) {
                    e = new ListSelectionEvent(this, firstIndex, lastIndex, isAdjusting);
                }
                ((ListSelectionListener)listeners[i + 1]).valueChanged(e);
            }
        }

        private void fireValueChanged() {
            if (this.lastAdjustedIndex == -1) {
                return;
            }
            if (this.getValueIsAdjusting()) {
                this.firstChangedIndex = Math.min(this.firstChangedIndex, this.firstAdjustedIndex);
                this.lastChangedIndex = Math.max(this.lastChangedIndex, this.lastAdjustedIndex);
            }
            int oldFirstAdjustedIndex = this.firstAdjustedIndex;
            int oldLastAdjustedIndex = this.lastAdjustedIndex;
            this.firstAdjustedIndex = Integer.MAX_VALUE;
            this.lastAdjustedIndex = -1;
            this.fireValueChanged(oldFirstAdjustedIndex, oldLastAdjustedIndex);
        }

        public EventListener[] getListeners(Class listenerType) {
            return this.listenerList.getListeners(listenerType);
        }

        private void markAsDirty(int r) {
            this.firstAdjustedIndex = Math.min(this.firstAdjustedIndex, r);
            this.lastAdjustedIndex = Math.max(this.lastAdjustedIndex, r);
        }

        private void set(int r) {
            if (this.value.get(r)) {
                return;
            }
            this.value.set(r);
            this.markAsDirty(r);
            this.minIndex = Math.min(this.minIndex, r);
            this.maxIndex = Math.max(this.maxIndex, r);
        }

        private void clear(int r) {
            if (!this.value.get(r)) {
                return;
            }
            this.value.clear(r);
            this.markAsDirty(r);
            if (r == this.minIndex) {
                ++this.minIndex;
                while (this.minIndex <= this.maxIndex && !this.value.get(this.minIndex)) {
                    ++this.minIndex;
                }
            }
            if (r == this.maxIndex) {
                --this.maxIndex;
                while (this.minIndex <= this.maxIndex && !this.value.get(this.maxIndex)) {
                    --this.maxIndex;
                }
            }
            if (this.isSelectionEmpty()) {
                this.minIndex = Integer.MAX_VALUE;
                this.maxIndex = -1;
            }
        }

        public void setLeadAnchorNotificationEnabled(boolean flag) {
            this.leadAnchorNotificationEnabled = flag;
        }

        public boolean isLeadAnchorNotificationEnabled() {
            return this.leadAnchorNotificationEnabled;
        }

        private void updateLeadAnchorIndices(int anchorIndex, int leadIndex) {
            if (this.leadAnchorNotificationEnabled) {
                if (this.anchorIndex != anchorIndex) {
                    if (this.anchorIndex != -1) {
                        this.markAsDirty(this.anchorIndex);
                    }
                    this.markAsDirty(anchorIndex);
                }
                if (this.leadIndex != leadIndex) {
                    if (this.leadIndex != -1) {
                        this.markAsDirty(this.leadIndex);
                    }
                    this.markAsDirty(leadIndex);
                }
            }
            this.anchorIndex = anchorIndex;
            this.leadIndex = leadIndex;
        }

        private boolean contains(int a, int b, int i) {
            return i >= a && i <= b;
        }

        private void changeSelection(int clearMin, int clearMax, int setMin, int setMax, boolean clearFirst) {
            for (int i = Math.min(setMin, clearMin); i <= Math.max(setMax, clearMax); ++i) {
                boolean shouldClear = this.contains(clearMin, clearMax, i);
                boolean shouldSet = this.contains(setMin, setMax, i);
                if (shouldSet && shouldClear) {
                    if (clearFirst) {
                        shouldClear = false;
                    } else {
                        shouldSet = false;
                    }
                }
                if (shouldSet) {
                    this.set(i);
                }
                if (!shouldClear) continue;
                this.clear(i);
            }
            this.fireValueChanged();
        }

        private void changeSelection(int clearMin, int clearMax, int setMin, int setMax) {
            this.changeSelection(clearMin, clearMax, setMin, setMax, true);
        }

        public void clearSelection() {
            this.removeSelectionInterval(this.minIndex, this.maxIndex);
        }

        public void setSelectionInterval(int index0, int index1) {
            if (index0 == -1 || index1 == -1) {
                return;
            }
            if (this.getSelectionMode() == 0) {
                index0 = index1;
            }
            this.updateLeadAnchorIndices(index0, index1);
            int clearMin = this.minIndex;
            int clearMax = this.maxIndex;
            int setMin = Math.min(index0, index1);
            int setMax = Math.max(index0, index1);
            this.changeSelection(clearMin, clearMax, setMin, setMax);
        }

        public void addSelectionInterval(int index0, int index1) {
            if (index0 == -1 || index1 == -1) {
                return;
            }
            if (this.getSelectionMode() != 2) {
                this.setSelectionInterval(index0, index1);
                return;
            }
            this.updateLeadAnchorIndices(index0, index1);
            int clearMin = Integer.MAX_VALUE;
            int clearMax = -1;
            int setMin = Math.min(index0, index1);
            int setMax = Math.max(index0, index1);
            this.changeSelection(clearMin, clearMax, setMin, setMax);
        }

        public void removeSelectionInterval(int index0, int index1) {
            if (index0 == -1 || index1 == -1) {
                return;
            }
            this.updateLeadAnchorIndices(index0, index1);
            int clearMin = Math.min(index0, index1);
            int clearMax = Math.max(index0, index1);
            int setMin = Integer.MAX_VALUE;
            int setMax = -1;
            if (this.getSelectionMode() != 2 && clearMin > this.minIndex && clearMax < this.maxIndex) {
                clearMax = this.maxIndex;
            }
            this.changeSelection(clearMin, clearMax, setMin, setMax);
        }

        private void setState(int index, boolean state) {
            if (state) {
                this.set(index);
            } else {
                this.clear(index);
            }
        }

        public void insertIndexInterval(int index, int length, boolean before) {
            int insMinIndex = before ? index : index + 1;
            int insMaxIndex = insMinIndex + length - 1;
            for (int i = this.maxIndex; i >= insMinIndex; --i) {
                this.setState(i + length, this.value.get(i));
            }
            boolean wasSelected = this.value.get(index);
            boolean setInsertedValues = false;
            for (int i = insMinIndex; i <= insMaxIndex; ++i) {
                this.setState(i, setInsertedValues);
            }
            if (index <= this.leadIndex) {
                this.leadIndex += length;
            }
            this.fireValueChanged();
        }

        public void removeIndexInterval(int index0, int index1) {
            int rmMinIndex = Math.min(index0, index1);
            int rmMaxIndex = Math.max(index0, index1);
            int gapLength = rmMaxIndex - rmMinIndex + 1;
            for (int i = rmMinIndex; i <= this.maxIndex; ++i) {
                this.setState(i, this.value.get(i + gapLength));
            }
            if (this.leadIndex >= index1) {
                this.leadIndex = this.leadIndex - (index1 - index0) - 1;
            } else if (this.leadIndex >= index0) {
                this.leadIndex = index0;
            }
            this.fireValueChanged();
        }

        public void setValueIsAdjusting(boolean isAdjusting) {
            if (isAdjusting != this.isAdjusting) {
                this.isAdjusting = isAdjusting;
                this.fireValueChanged(isAdjusting);
            }
        }

        public String toString() {
            String s = (this.getValueIsAdjusting() ? "~" : "=") + this.value.toString();
            return this.getClass().getName() + " " + Integer.toString(this.hashCode()) + " " + s;
        }

        public Object clone() throws CloneNotSupportedException {
            ColumnSelectionModel clone = (ColumnSelectionModel)super.clone();
            clone.value = (BitSet)this.value.clone();
            clone.listenerList = new EventListenerList();
            return clone;
        }

        public int getAnchorSelectionIndex() {
            return this.anchorIndex;
        }

        public int getLeadSelectionIndex() {
            return this.leadIndex;
        }

        public void setAnchorSelectionIndex(int anchorIndex) {
            this.updateLeadAnchorIndices(anchorIndex, this.leadIndex);
            this.anchorIndex = anchorIndex;
            this.fireValueChanged();
        }

        public void setLeadSelectionIndex(int leadIndex) {
            int anchorIndex = this.anchorIndex;
            if (anchorIndex == -1 || leadIndex == -1) {
                return;
            }
            if (this.leadIndex == -1) {
                this.leadIndex = leadIndex;
            }
            boolean shouldSelect = this.value.get(this.anchorIndex);
            if (this.getSelectionMode() == 0) {
                anchorIndex = leadIndex;
                shouldSelect = true;
            }
            int oldMin = Math.min(this.anchorIndex, this.leadIndex);
            int oldMax = Math.max(this.anchorIndex, this.leadIndex);
            int newMin = Math.min(anchorIndex, leadIndex);
            int newMax = Math.max(anchorIndex, leadIndex);
            this.updateLeadAnchorIndices(anchorIndex, leadIndex);
            if (shouldSelect) {
                this.changeSelection(oldMin, oldMax, newMin, newMax);
            } else {
                this.changeSelection(newMin, newMax, oldMin, oldMax, false);
            }
        }
    }

    private class ColumnKeyListener
    implements KeyListener {
        private ColumnKeyListener() {
        }

        public void keyReleased(KeyEvent evt) {
            JList columnList = (JList)evt.getComponent();
            ColumnListModel columnModel = (ColumnListModel)columnList.getModel();
            TreePath columnPath = columnModel.path;
            if (evt.getKeyCode() == 37) {
                if (columnPath.getPathCount() > 1) {
                    evt.consume();
                    columnList.clearSelection();
                    JList parentColumnList = JBrowser.this.getColumnList(columnPath.getPathCount() - 2);
                    JBrowser.this.selectionModel.setSelectionPath(columnPath);
                    parentColumnList.requestFocus();
                }
            } else if (evt.getKeyCode() == 39) {
                JList childColumnList = JBrowser.this.getColumnList(JBrowser.this.getListColumnCount() - 1);
                if (childColumnList.getSelectedIndex() == -1 && childColumnList.getModel().getSize() != 0) {
                    evt.consume();
                    childColumnList.setSelectedIndex(0);
                    JBrowser.this.selectionModel.setSelectionPath(((ColumnListModel)childColumnList.getModel()).path.pathByAddingChild(childColumnList.getSelectedValue()));
                }
                childColumnList.requestFocus();
            } else {
                TreePath leadPath;
                int[] selectedIndices = columnList.getSelectedIndices();
                if (selectedIndices.length == 0) {
                    leadPath = columnModel.path;
                    JBrowser.this.selectionModel.setSelectionPath(leadPath);
                    if (JBrowser.this.getListColumnCount() > 1) {
                        JBrowser.this.getColumnList(JBrowser.this.getListColumnCount() - 2).requestFocus();
                    }
                } else if (selectedIndices.length == 1) {
                    leadPath = columnPath.pathByAddingChild(columnList.getSelectedValue());
                    JBrowser.this.selectionModel.setSelectionPath(leadPath);
                } else {
                    leadPath = columnPath.pathByAddingChild(columnModel.getElementAt(columnList.getLeadSelectionIndex()));
                    TreePath[] paths = new TreePath[selectedIndices.length];
                    int leadPathIndex = -1;
                    for (int i = 0; i < selectedIndices.length; ++i) {
                        paths[i] = columnModel.path.pathByAddingChild(columnModel.getElementAt(selectedIndices[i]));
                        if (!paths[i].equals(leadPath)) continue;
                        leadPathIndex = i;
                    }
                    paths[leadPathIndex] = paths[paths.length - 1];
                    paths[paths.length - 1] = leadPath;
                    JBrowser.this.selectionModel.setSelectionPaths(paths);
                }
            }
            if (!evt.isConsumed()) {
                KeyListener[] kl = JBrowser.this.getKeyListeners();
                for (int i = 0; i < kl.length; ++i) {
                    kl[i].keyReleased(evt);
                }
            }
        }

        public void keyTyped(KeyEvent evt) {
            if (!evt.isConsumed()) {
                KeyListener[] kl = JBrowser.this.getKeyListeners();
                for (int i = 0; i < kl.length; ++i) {
                    kl[i].keyTyped(evt);
                }
            }
        }

        public void keyPressed(KeyEvent evt) {
            if (!evt.isConsumed()) {
                KeyListener[] kl = JBrowser.this.getKeyListeners();
                for (int i = 0; i < kl.length; ++i) {
                    kl[i].keyPressed(evt);
                }
            }
        }
    }

    private class ColumnFocusListener
    implements FocusListener {
        private ColumnFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            JBrowser.this.putClientProperty("Quaqua.drawFocusBorder", Boolean.TRUE);
            JBrowser.this.repaintParentBorder();
        }

        public void focusLost(FocusEvent e) {
            JBrowser.this.putClientProperty("Quaqua.drawFocusBorder", Boolean.FALSE);
            JBrowser.this.repaintParentBorder();
        }
    }

    private class ColumnMouseListener
    extends MouseAdapter {
        private ColumnMouseListener() {
        }

        public void mouseReleased(MouseEvent evt) {
            JList columnList = (JList)evt.getComponent();
            EventListener[] listeners = JBrowser.this.getListeners(class$java$awt$event$MouseListener == null ? (class$java$awt$event$MouseListener = JBrowser.class$("java.awt.event.MouseListener")) : class$java$awt$event$MouseListener);
            if (listeners.length > 0) {
                int x = evt.getX();
                int y = evt.getY();
                for (Container c = columnList; c != JBrowser.this; c = c.getParent()) {
                    x += ((Component)c).getX();
                    y += ((Component)c).getY();
                }
                MouseEvent refiredEvent = new MouseEvent(JBrowser.this, evt.getID(), evt.getWhen(), evt.getModifiers(), x, y, evt.getClickCount(), evt.isPopupTrigger());
                for (int i = 0; i < listeners.length; ++i) {
                    ((MouseListener)listeners[i]).mouseReleased(refiredEvent);
                }
            }
            this.updateExpandedState(columnList);
        }

        private void updateExpandedState(JList columnList) {
            ColumnListModel columnModel = (ColumnListModel)columnList.getModel();
            TreePath columnPath = columnModel.path;
            int[] selectedIndices = columnList.getSelectedIndices();
            if (selectedIndices.length == 0) {
                TreePath leadPath = columnModel.path;
                JBrowser.this.selectionModel.setSelectionPath(leadPath);
            } else if (selectedIndices.length == 1) {
                TreePath leadPath = columnPath.pathByAddingChild(columnList.getSelectedValue());
                JBrowser.this.selectionModel.setSelectionPath(leadPath);
            } else {
                TreePath leadPath = columnPath.pathByAddingChild(columnModel.getElementAt(columnList.getLeadSelectionIndex()));
                TreePath[] paths = new TreePath[selectedIndices.length];
                int leadPathIndex = -1;
                for (int i = 0; i < selectedIndices.length; ++i) {
                    paths[i] = columnModel.path.pathByAddingChild(columnModel.getElementAt(selectedIndices[i]));
                    if (!paths[i].equals(leadPath)) continue;
                    leadPathIndex = i;
                }
                if (leadPathIndex != -1) {
                    paths[leadPathIndex] = paths[paths.length - 1];
                    paths[paths.length - 1] = leadPath;
                }
                JBrowser.this.selectionModel.setSelectionPaths(paths);
            }
        }

        public void mouseClicked(MouseEvent evt) {
            JList columnList = (JList)evt.getComponent();
            EventListener[] listeners = JBrowser.this.getListeners(class$java$awt$event$MouseListener == null ? (class$java$awt$event$MouseListener = JBrowser.class$("java.awt.event.MouseListener")) : class$java$awt$event$MouseListener);
            if (listeners.length > 0) {
                int x = evt.getX();
                int y = evt.getY();
                for (Container c = columnList; c != JBrowser.this; c = c.getParent()) {
                    x += ((Component)c).getX();
                    y += ((Component)c).getY();
                }
                MouseEvent refiredEvent = new MouseEvent(JBrowser.this, evt.getID(), evt.getWhen(), evt.getModifiers(), x, y, evt.getClickCount(), evt.isPopupTrigger());
                for (int i = 0; i < listeners.length; ++i) {
                    ((MouseListener)listeners[i]).mouseClicked(refiredEvent);
                }
            }
        }

        public void mousePressed(MouseEvent evt) {
            JList columnList = (JList)evt.getComponent();
            EventListener[] listeners = JBrowser.this.getListeners(class$java$awt$event$MouseListener == null ? (class$java$awt$event$MouseListener = JBrowser.class$("java.awt.event.MouseListener")) : class$java$awt$event$MouseListener);
            if (listeners.length > 0) {
                int x = evt.getX();
                int y = evt.getY();
                for (Container c = columnList; c != JBrowser.this; c = c.getParent()) {
                    x += ((Component)c).getX();
                    y += ((Component)c).getY();
                }
                MouseEvent refiredEvent = new MouseEvent(JBrowser.this, evt.getID(), evt.getWhen(), evt.getModifiers(), x, y, evt.getClickCount(), evt.isPopupTrigger());
                for (int i = 0; i < listeners.length; ++i) {
                    ((MouseListener)listeners[i]).mousePressed(refiredEvent);
                }
            }
        }
    }

    private class SelectionModeUpdater
    implements Serializable,
    PropertyChangeListener {
        private SelectionModeUpdater() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("selectionMode")) {
                int selectionMode;
                switch (JBrowser.this.selectionModel.getSelectionMode()) {
                    case 2: {
                        selectionMode = 1;
                        break;
                    }
                    case 4: {
                        selectionMode = 2;
                        break;
                    }
                    default: {
                        selectionMode = 0;
                    }
                }
                for (int i = 0; i < JBrowser.this.getListColumnCount(); ++i) {
                    JBrowser.this.getColumnList(i).getSelectionModel().setSelectionMode(selectionMode);
                }
            }
        }
    }

    private class TreeSelectionUpdater
    implements Serializable,
    TreeSelectionListener {
        private TreeSelectionUpdater() {
        }

        public void valueChanged(TreeSelectionEvent evt) {
            int lastComponentIndex;
            switch (JBrowser.this.selectionModel.getSelectionCount()) {
                case 0: {
                    JBrowser.this.expandPath(new TreePath(JBrowser.this.treeModel.getRoot()));
                    JBrowser.this.updatePreviewColumn();
                    break;
                }
                case 1: {
                    TreePath selectionPath = JBrowser.this.selectionModel.getSelectionPath();
                    JBrowser.this.expandPath(selectionPath);
                    if (!JBrowser.this.treeModel.isLeaf(selectionPath.getLastPathComponent())) {
                        JBrowser.this.getColumnList(JBrowser.this.getListColumnCount() - 1).clearSelection();
                    }
                    JBrowser.this.updatePreviewColumn();
                    break;
                }
                default: {
                    TreePath leadSelectionPath = JBrowser.this.selectionModel.getLeadSelectionPath();
                    TreePath parentPath = leadSelectionPath.getParentPath();
                    JBrowser.this.expandPath(parentPath);
                    JList list = JBrowser.this.getColumnList(parentPath.getPathCount() - 1);
                    TreePath[] selectionPaths = JBrowser.this.selectionModel.getSelectionPaths();
                    int[] indices = new int[selectionPaths.length];
                    int leadPathIndex = -1;
                    for (int i = 0; i < selectionPaths.length; ++i) {
                        indices[i] = JBrowser.this.treeModel.getIndexOfChild(parentPath.getLastPathComponent(), selectionPaths[i].getLastPathComponent());
                        if (!selectionPaths[i].equals(leadSelectionPath)) continue;
                        leadPathIndex = i;
                    }
                    int swap = indices[leadPathIndex];
                    indices[leadPathIndex] = indices[indices.length - 1];
                    indices[indices.length - 1] = swap;
                    list.setSelectedIndices(indices);
                    JBrowser.this.updatePreviewColumn();
                    break;
                }
            }
            if (JBrowser.this.getParent() != null) {
                JBrowser.this.getParent().validate();
            }
            if ((lastComponentIndex = JBrowser.this.getComponentCount() - 1) >= 0) {
                JBrowser.this.scrollRectToVisible(JBrowser.this.getComponent(lastComponentIndex).getBounds());
                JBrowser.this.getComponent(lastComponentIndex).repaint();
            }
            if (JBrowser.this.listenerList.getListenerCount(class$javax$swing$event$TreeSelectionListener == null ? (class$javax$swing$event$TreeSelectionListener = JBrowser.class$("javax.swing.event.TreeSelectionListener")) : class$javax$swing$event$TreeSelectionListener) != 0) {
                TreeSelectionEvent newE = (TreeSelectionEvent)evt.cloneWithSource(JBrowser.this);
                JBrowser.this.fireValueChanged(newE);
            }
        }
    }

    private class ColumnListModel
    extends AbstractListModel
    implements TreeModelListener {
        private TreePath path;
        private TreeModel model;
        private int size;

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append('{');
            int n = this.getSize();
            for (int i = 0; i < n; ++i) {
                if (i != 0) {
                    buf.append(',');
                }
                buf.append(this.getElementAt(i));
            }
            buf.append("} #");
            buf.append(this.hashCode());
            return buf.toString();
        }

        public ColumnListModel(TreePath path, TreeModel model) {
            this.path = path;
            this.model = model;
            model.addTreeModelListener(this);
            this.updateSize();
        }

        public void setPath(TreePath newValue) {
            if (newValue != this.path) {
                int oldSize = this.getSize();
                this.path = newValue;
                this.updateSize();
                int newSize = this.getSize();
                if (Math.min(oldSize, newSize) > 0) {
                    this.fireContentsChanged(this, Math.min(oldSize, newSize), Math.min(oldSize, newSize));
                }
                if (newSize < oldSize) {
                    this.fireIntervalRemoved(this, newSize, oldSize - 1);
                } else if (newSize > oldSize) {
                    this.fireIntervalAdded(this, oldSize, newSize - 1);
                }
            }
        }

        public void dispose() {
            this.model.removeTreeModelListener(this);
        }

        public int getSize() {
            return this.size;
        }

        private void updateSize() {
            this.size = this.model.getChildCount(this.path.getLastPathComponent());
        }

        public Object getElementAt(int row) {
            return this.model.getChild(this.path.getLastPathComponent(), row);
        }

        public void treeNodesChanged(TreeModelEvent e) {
            if (e.getTreePath().equals(this.path)) {
                int[] indices = e.getChildIndices();
                this.fireContentsChanged(this, indices[0], indices[indices.length - 1]);
            }
        }

        public void treeNodesInserted(TreeModelEvent e) {
            if (e.getTreePath().equals(this.path)) {
                int end;
                this.updateSize();
                int[] indices = e.getChildIndices();
                int start = 0;
                do {
                    int startIndex = indices[start];
                    for (end = start + 1; end < indices.length && indices[end] == startIndex + end - start; ++end) {
                    }
                    this.fireIntervalAdded(this, startIndex, indices[end - 1]);
                } while ((start = end) < indices.length);
            }
        }

        public void treeNodesRemoved(TreeModelEvent e) {
            if (e.getTreePath().equals(this.path)) {
                int end;
                this.updateSize();
                int[] indices = e.getChildIndices();
                int start = 0;
                int offset = 0;
                do {
                    int startIndex = indices[start];
                    for (end = start + 1; end < indices.length && indices[end] == startIndex + end - start; ++end) {
                    }
                    this.fireIntervalRemoved(this, startIndex - offset, indices[end - 1] - offset);
                    offset += indices[end - 1] - startIndex + 1;
                } while ((start = end) < indices.length);
                if (JBrowser.this.selectionModel.getSelectionCount() > 0) {
                    TreePath[] selectionPaths = JBrowser.this.selectionModel.getSelectionPaths();
                    Object[] removedChildren = e.getChildren();
                    for (int i = 0; i < removedChildren.length; ++i) {
                        TreePath removedPath = e.getTreePath().pathByAddingChild(removedChildren[i]);
                        for (int j = 0; j < selectionPaths.length; ++j) {
                            if (!removedPath.isDescendant(selectionPaths[j])) continue;
                            selectionPaths[j] = e.getTreePath();
                        }
                        JBrowser.this.setSelectionPaths(selectionPaths);
                    }
                }
            }
        }

        public void treeStructureChanged(TreeModelEvent e) {
            TreePath changedPath = e.getTreePath();
            if (changedPath.equals(this.path) || this.path.getPathCount() == 1 && changedPath.getPathCount() == 1) {
                int oldSize = this.getSize();
                this.path = changedPath;
                this.updateSize();
                int newSize = this.getSize();
                this.path = changedPath;
                int diff = newSize - oldSize;
                if (diff < 0) {
                    if (newSize > 0) {
                        this.fireContentsChanged(this, 0, newSize - 1);
                    }
                    this.fireIntervalRemoved(this, newSize, oldSize - 1);
                } else if (diff > 0) {
                    if (oldSize > 0) {
                        this.fireContentsChanged(this, 0, oldSize - 1);
                    }
                    this.fireIntervalAdded(this, oldSize, newSize - 1);
                } else {
                    this.fireContentsChanged(this, 0, oldSize - 1);
                }
                JBrowser.this.setSelectionPath(changedPath);
            }
        }
    }

    protected class BrowserLayout
    implements LayoutManager {
        private int preferredWidth = 0;
        private int preferredHeight = 0;
        private boolean sizeUnknown = true;

        protected BrowserLayout() {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        private void setSizes(Container parent) {
            int nComps = parent.getComponentCount();
            Dimension d = null;
            this.preferredWidth = 0;
            this.preferredHeight = 0;
            for (int i = 0; i < nComps; ++i) {
                Component c = parent.getComponent(i);
                if (!c.isVisible()) continue;
                d = c.getPreferredSize();
                this.preferredWidth += d.width;
                this.preferredHeight = Math.max(this.preferredHeight, d.height);
            }
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension dim = new Dimension(0, 0);
            int nComps = parent.getComponentCount();
            this.setSizes(parent);
            Insets insets = parent.getInsets();
            dim.width = this.preferredWidth + insets.left + insets.right;
            dim.height = this.preferredHeight + insets.top + insets.bottom;
            this.sizeUnknown = false;
            return dim;
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        public void layoutContainer(Container parent) {
            Insets insets = parent.getInsets();
            int maxWidth = parent.getWidth() - (insets.left + insets.right);
            int maxHeight = parent.getHeight() - (insets.top + insets.bottom);
            int nComps = parent.getComponentCount();
            int previousWidth = 0;
            int previousHeight = 0;
            int x = insets.left;
            int y = insets.top;
            boolean rowh = false;
            boolean start = false;
            if (this.sizeUnknown) {
                this.setSizes(parent);
            }
            for (int i = 0; i < nComps; ++i) {
                Component c = parent.getComponent(i);
                if (!c.isVisible()) continue;
                Dimension d = c.getPreferredSize();
                d.height = maxHeight;
                c.setBounds(x += previousWidth, y, d.width, d.height);
                previousWidth = d.width;
                previousHeight = d.height;
            }
        }
    }

    protected class BrowserScrollPaneLayout
    extends QuaquaScrollPaneLayout {
        protected BrowserScrollPaneLayout() {
        }

        public void layoutContainer(Container parent) {
            boolean hsbVisible;
            super.layoutContainer(parent);
            boolean cornerVisible = this.lowerRight != null && this.lowerRight.isVisible();
            boolean vsbVisible = this.vsb != null && this.vsb.isVisible();
            boolean bl = hsbVisible = this.hsb != null && this.hsb.isVisible();
            if (cornerVisible && vsbVisible && !hsbVisible) {
                Dimension cornerDim = this.lowerRight.getPreferredSize();
                Dimension vsbDim = this.vsb.getSize();
                this.vsb.setSize(vsbDim.width, vsbDim.height - cornerDim.height);
                this.lowerRight.setBounds(this.vsb.getX(), this.vsb.getY() + this.vsb.getHeight(), vsbDim.width, cornerDim.height);
            }
        }
    }

    protected class SizeHandle
    extends JComponent
    implements MouseListener,
    MouseMotionListener {
        protected int column;
        protected int startMouseX;
        protected int startWidth;

        public SizeHandle(int column) {
            this.column = column;
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        public Dimension getPreferredSize() {
            Icon sizeHandleIcon = JBrowser.this.getUI().getSizeHandleIcon();
            return new Dimension(sizeHandleIcon.getIconWidth(), sizeHandleIcon.getIconHeight());
        }

        public void paintComponent(Graphics g) {
            Icon sizeHandleIcon = JBrowser.this.getUI().getSizeHandleIcon();
            sizeHandleIcon.paintIcon(this, g, 0, 0);
        }

        public void mouseDragged(MouseEvent e) {
            if (this.startMouseX >= 0) {
                int mouseX = this.toScreenX(e.getPoint());
                int difX = mouseX - this.startMouseX;
                if (this.column < 0) {
                    JBrowser.this.setPreviewColumnWidth(Math.max(this.startWidth + difX, JBrowser.this.getMinimumCellWidth()));
                } else {
                    JBrowser.this.setColumnWidth(this.column, Math.max(this.startWidth + difX, JBrowser.this.getMinimumCellWidth()));
                }
            }
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2 && this.column >= 0) {
                JBrowser.this.setColumnWidth(this.column, Math.max(JBrowser.this.minimumCellWidth, JBrowser.this.getPreferredColumnWidth(this.column)));
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            this.startMouseX = this.toScreenX(e.getPoint());
            this.startWidth = this.column < 0 ? JBrowser.this.getPreviewColumnWidth() : JBrowser.this.getColumnWidth(this.column);
        }

        public void mouseReleased(MouseEvent e) {
            if (this.startMouseX >= 0) {
                int mouseX = this.toScreenX(e.getPoint());
                int difX = mouseX - this.startMouseX;
                if (this.column < 0) {
                    JBrowser.this.setPreviewColumnWidth(Math.max(this.startWidth + difX, JBrowser.this.getMinimumCellWidth()));
                } else {
                    JBrowser.this.setColumnWidth(this.column, Math.max(this.startWidth + difX, JBrowser.this.getMinimumCellWidth()));
                }
            }
            this.startMouseX = -1;
        }

        private int toScreenX(Point p) {
            SwingUtilities.convertPointToScreen(p, this);
            return p.x;
        }
    }
}

