/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.Quaqua14PlacardButtonBorder;
import ch.randelshofer.quaqua.Quaqua14SquareButtonBorder;
import ch.randelshofer.quaqua.QuaquaButtonBorder;
import ch.randelshofer.quaqua.QuaquaIconFactory;
import ch.randelshofer.quaqua.border.BackgroundBorderUIResource;
import ch.randelshofer.quaqua.border.CachedImageBevelBorder;
import ch.randelshofer.quaqua.border.ImageBevelBorder;
import ch.randelshofer.quaqua.util.Images;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.swing.border.Border;

public class QuaquaBorderFactory {
    private QuaquaBorderFactory() {
    }

    public static Border create(Image img, Insets borderInsets) {
        return QuaquaBorderFactory.create(img, borderInsets, borderInsets);
    }

    public static Border create(Image img, Insets imageInsets, Insets borderInsets) {
        return QuaquaBorderFactory.create(img, imageInsets, borderInsets, false, true);
    }

    public static Border create(Image img, Insets borderInsets, boolean fillContentArea, boolean isCaching) {
        return QuaquaBorderFactory.create(img, borderInsets, borderInsets, fillContentArea, isCaching);
    }

    public static Border create(Image img, Insets imageInsets, Insets borderInsets, boolean fillContentArea) {
        return QuaquaBorderFactory.create(img, imageInsets, borderInsets, fillContentArea, true);
    }

    public static Border create(Image img, Insets imageInsets, Insets borderInsets, boolean fillContentArea, boolean isCaching) {
        if (isCaching) {
            return new CachedImageBevelBorder.UIResource(img, imageInsets, borderInsets, fillContentArea);
        }
        return new ImageBevelBorder.UIResource(img, imageInsets, borderInsets, fillContentArea);
    }

    public static Border createSquareButtonBorder() {
        return new Quaqua14SquareButtonBorder();
    }

    public static Border createPlacardButtonBorder() {
        return new Quaqua14PlacardButtonBorder();
    }

    public static Border create(String location, Insets borderInsets, boolean fill) {
        return QuaquaBorderFactory.create(QuaquaIconFactory.createImage(location), borderInsets, borderInsets, fill, false);
    }

    public static Border create(String location, Insets imageInsets, Insets borderInsets, boolean fill) {
        return QuaquaBorderFactory.create(QuaquaIconFactory.createImage(location), imageInsets, borderInsets, fill, false);
    }

    public static Border createBackgroundBorder(String location, Insets imageInsets, Insets borderInsets, boolean fill) {
        return new BackgroundBorderUIResource(QuaquaBorderFactory.create(QuaquaIconFactory.createImage(location), imageInsets, borderInsets, fill, false));
    }

    public static Object create(String location, Insets insets, int count, boolean horizontal) {
        return QuaquaBorderFactory.create(location, insets, count, horizontal, true, true);
    }

    public static Object create(String location, Insets insets, int count, boolean horizontal, boolean fill, boolean isCaching) {
        BufferedImage[] images = Images.split(QuaquaIconFactory.createImage(location), count, horizontal);
        Border[] borders = new Border[count];
        for (int i = 0; i < count; ++i) {
            borders[i] = QuaquaBorderFactory.create(images[i], insets, insets, fill, isCaching);
        }
        return borders;
    }

    public static Border createButtonBorder(String type) {
        return new BackgroundBorderUIResource(new QuaquaButtonBorder("push"));
    }
}

