/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.filechooser;

import ch.randelshofer.quaqua.QuaquaManager;
import ch.randelshofer.quaqua.filechooser.FileSystemViewFilter;
import ch.randelshofer.quaqua.filechooser.Files;
import ch.randelshofer.quaqua.filechooser.QuaquaFileView;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.filechooser.FileView;

public abstract class QuaquaFileSystemView
extends FileSystemViewFilter {
    private static QuaquaFileSystemView instance;
    private static QuaquaFileSystemView fileSystemView;

    public abstract File getComputer();

    public abstract File getSystemVolume();

    public FileView createFileView(JFileChooser chooser) {
        return new QuaquaFileView(this);
    }

    public static QuaquaFileSystemView getQuaquaFileSystemView() {
        if (fileSystemView == null) {
            String className;
            int os = QuaquaManager.getOS();
            if (os == -2) {
                className = "ch.randelshofer.quaqua.filechooser.WindowsFileSystemView";
            } else {
                switch (os) {
                    case 2: {
                        className = "ch.randelshofer.quaqua.jaguar.filechooser.OSXJaguarFileSystemView";
                        break;
                    }
                    case 3: {
                        className = "ch.randelshofer.quaqua.panther.filechooser.OSXPantherFileSystemView";
                        break;
                    }
                    case -3: {
                        className = "ch.randelshofer.quaqua.leopard.filechooser.DarwinLeopardFileSystemView";
                        break;
                    }
                    case 5: {
                        className = "ch.randelshofer.quaqua.leopard.filechooser.OSXLeopardFileSystemView";
                        break;
                    }
                    default: {
                        className = "ch.randelshofer.quaqua.tiger.filechooser.OSXTigerFileSystemView";
                    }
                }
            }
            try {
                fileSystemView = (QuaquaFileSystemView)Class.forName(className).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new InternalError(e.getMessage());
            }
        }
        return fileSystemView;
    }

    public Icon getSystemIcon(File f) {
        if (f.equals(this.getComputer())) {
            return UIManager.getIcon("FileView.computerIcon");
        }
        if (Files.canWorkWithAliases()) {
            return Files.getIcon(f, 16);
        }
        return this.target.getSystemIcon(f);
    }

    public String getSystemTypeDescription(File f) {
        if (Files.canWorkWithAliases()) {
            return Files.getKindString(f);
        }
        return this.target.getSystemTypeDescription(f);
    }

    public Boolean isTraversable(File f) {
        if (Files.canWorkWithAliases()) {
            return Files.isTraversable(f);
        }
        return this.target.isTraversable(f);
    }

    public String getSystemDisplayName(File f) {
        if (f.equals(this.getComputer())) {
            return this.getSystemVolume().getName();
        }
        if (Files.canWorkWithAliases()) {
            return Files.getDisplayName(f);
        }
        return this.target.getSystemDisplayName(f);
    }
}

