/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.jaguar;

import ch.randelshofer.quaqua.BasicQuaquaLookAndFeel;
import ch.randelshofer.quaqua.Quaqua14KeyboardFocusManager;
import ch.randelshofer.quaqua.QuaquaManager;
import ch.randelshofer.quaqua.VisualMargin;
import ch.randelshofer.quaqua.color.AlphaColorUIResource;
import java.awt.Color;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.security.AccessControlException;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.InsetsUIResource;
import sun.security.util.SecurityConstants;

public class Quaqua15JaguarLookAndFeel
extends BasicQuaquaLookAndFeel {
    public Quaqua15JaguarLookAndFeel() {
        super("apple.laf.AquaLookAndFeel");
    }

    public String getDescription() {
        return "The Quaqua Jaguar Look and Feel " + QuaquaManager.getVersion() + " for J2SE 5";
    }

    public String getName() {
        return "Quaqua Jaguar";
    }

    public boolean getSupportsWindowDecorations() {
        return true;
    }

    protected void initClassDefaults(UIDefaults table) {
        String basicPrefix = "javax.swing.plaf.basic.Basic";
        String quaquaPrefix = "ch.randelshofer.quaqua.Quaqua";
        String quaqua14JaguarPrefix = "ch.randelshofer.quaqua.jaguar.Quaqua14Jaguar";
        String quaquaJaguarPrefix = "ch.randelshofer.quaqua.jaguar.QuaquaJaguar";
        Object[] uiDefaults = new Object[]{"BrowserUI", quaquaPrefix + "BrowserUI", "ButtonUI", quaquaPrefix + "ButtonUI", "CheckBoxUI", quaquaPrefix + "CheckBoxUI", "ColorChooserUI", quaquaPrefix + "14ColorChooserUI", "FileChooserUI", quaquaJaguarPrefix + "FileChooserUI", "FormattedTextFieldUI", quaquaPrefix + "14" + "FormattedTextFieldUI", "RadioButtonUI", quaquaPrefix + "RadioButtonUI", "ToggleButtonUI", quaquaPrefix + "ToggleButtonUI", "SeparatorUI", quaquaJaguarPrefix + "SeparatorUI", "ScrollBarUI", quaquaPrefix + "ScrollBarUI", "ScrollPaneUI", quaquaPrefix + "ScrollPaneUI", "SplitPaneUI", quaquaPrefix + "SplitPaneUI", "SliderUI", quaquaPrefix + "SliderUI", "SpinnerUI", quaquaPrefix + "14" + "SpinnerUI", "ToolBarSeparatorUI", quaquaPrefix + "ToolBarSeparatorUI", "PopupMenuSeparatorUI", quaquaJaguarPrefix + "SeparatorUI", "TextAreaUI", quaquaPrefix + "TextAreaUI", "TextFieldUI", quaquaPrefix + "TextFieldUI", "PasswordFieldUI", quaquaPrefix + "PasswordFieldUI", "TextPaneUI", quaquaPrefix + "TextPaneUI", "EditorPaneUI", quaquaPrefix + "EditorPaneUI", "TreeUI", quaquaPrefix + "TreeUI", "LabelUI", quaquaPrefix + "LabelUI", "ListUI", quaquaPrefix + "ListUI", "ToolBarUI", quaquaPrefix + "ToolBarUI", "ComboBoxUI", quaquaPrefix + "ComboBoxUI", "TableUI", quaquaPrefix + "TableUI", "TableHeaderUI", quaquaPrefix + "TableHeaderUI", "OptionPaneUI", quaquaPrefix + "OptionPaneUI", "PanelUI", quaquaPrefix + "PanelUI", "ViewportUI", quaquaPrefix + "ViewportUI", "RootPaneUI", quaquaPrefix + "14RootPaneUI"};
        this.putDefaults(table, uiDefaults);
        SecurityManager security = System.getSecurityManager();
        try {
            if (security != null) {
                security.checkPermission(SecurityConstants.ALL_AWT_EVENTS_PERMISSION);
            }
            uiDefaults = new Object[]{"PopupMenuUI", quaquaPrefix + "14" + "PopupMenuUI"};
        }
        catch (SecurityException e) {
            uiDefaults = new Object[]{"PopupMenuUI", quaquaPrefix + "13" + "PopupMenuUI"};
        }
        this.putDefaults(table, uiDefaults);
        if (this.isJaguarTabbedPane()) {
            uiDefaults = new Object[]{"TabbedPaneUI", quaqua14JaguarPrefix + "TabbedPaneUI"};
            this.putDefaults(table, uiDefaults);
        }
        if (!this.isUseScreenMenuBar()) {
            uiDefaults = new Object[]{"MenuBarUI", quaquaPrefix + "MenuBarUI", "MenuUI", quaquaPrefix + "MenuUI", "MenuItemUI", quaquaPrefix + "MenuItemUI", "CheckBoxMenuItemUI", quaquaPrefix + "MenuItemUI", "RadioButtonMenuItemUI", quaquaPrefix + "MenuItemUI"};
            this.putDefaults(table, uiDefaults);
        }
    }

    protected boolean isJaguarTabbedPane() {
        String property;
        try {
            property = QuaquaManager.getProperty("Quaqua.tabLayoutPolicy");
            if (property == null) {
                property = QuaquaManager.getProperty("Quaqua.TabbedPane.design", "auto");
            }
        }
        catch (AccessControlException e) {
            property = "auto";
        }
        return property.equals("auto") || property.equals("jaguar") || property.equals("wrap");
    }

    private boolean isBrushedMetal() {
        String property;
        try {
            property = QuaquaManager.getProperty("apple.awt.brushMetalLook", "false");
        }
        catch (AccessControlException e) {
            property = "false";
        }
        return property.equals("true");
    }

    private boolean isUseScreenMenuBar() {
        String property;
        try {
            property = QuaquaManager.getProperty("apple.laf.useScreenMenuBar", "false");
        }
        catch (AccessControlException e) {
            property = "false";
        }
        return property.equals("true");
    }

    protected void initSystemColorDefaults(UIDefaults table) {
        super.initSystemColorDefaults(table);
        boolean isBrushedMetal = this.isBrushedMetal();
        Object controlBackground = isBrushedMetal ? table.get("control") : this.makeTextureColor(0xF4F4F4, "/ch/randelshofer/quaqua/jaguar/images/Panel.texture.png");
        Object toolBarBackground = isBrushedMetal ? table.get("ToolBar.background") : this.makeTextureColor(0xF4F4F4, "/ch/randelshofer/quaqua/jaguar/images/ToolBar.texture.png");
        Object menuBackground = isBrushedMetal ? table.get("menu") : this.makeTextureColor(0xF4F4F4, "/ch/randelshofer/quaqua/jaguar/images/MenuBar.texture.png");
        Object[] uiDefaults = new Object[]{"window", controlBackground, "control", controlBackground, "menu", menuBackground, "listHighlight", table.get("textHighlight"), "listHighlightText", table.get("textHighlightText"), "listHighlightBorder", new ColorUIResource(0x808080)};
        this.putDefaults(table, uiDefaults);
    }

    protected void initDesignDefaults(UIDefaults table) {
        boolean isBrushedMetal = this.isBrushedMetal();
        Object toolBarBackground = isBrushedMetal ? table.get("ToolBar.background") : this.makeTextureColor(0xF4F4F4, "/ch/randelshofer/quaqua/jaguar/images/ToolBar.texture.png");
        Object[] uiDefaults = new Object[]{"Frame.titlePaneBorders", this.makeImageBevelBorders("/ch/randelshofer/quaqua/jaguar/images/Frame.titlePaneBorders.png", new Insets(0, 0, 22, 0), 2, true), "Frame.titlePaneBorders.small", this.makeImageBevelBorders("/ch/randelshofer/quaqua/jaguar/images/Frame.titlePaneBorders.small.png", new Insets(0, 0, 16, 0), 2, true), "Frame.titlePaneBorders.mini", this.makeImageBevelBorders("/ch/randelshofer/quaqua/jaguar/images/Frame.titlePaneBorders.mini.png", new Insets(0, 0, 12, 0), 2, true), "Frame.titlePaneBorders.vertical", this.makeImageBevelBorders("/ch/randelshofer/quaqua/jaguar/images/Frame.titlePaneBorders.vertical.png", new Insets(0, 0, 0, 22), 2, false), "Frame.titlePaneBorders.vertical.small", this.makeImageBevelBorders("/ch/randelshofer/quaqua/jaguar/images/Frame.titlePaneBorders.vertical.small.png", new Insets(0, 0, 0, 16), 2, false), "Frame.titlePaneBorders.vertical.mini", this.makeImageBevelBorders("/ch/randelshofer/quaqua/jaguar/images/Frame.titlePaneBorders.vertical.mini.png", new Insets(0, 0, 0, 12), 2, false), "Separator.foreground", new ColorUIResource(139, 139, 139), "Separator.highlight", new ColorUIResource(243, 243, 243), "Separator.shadow", new ColorUIResource(213, 213, 213), "Separator.border", new VisualMargin(), "ToolBar.background", toolBarBackground};
        this.putDefaults(table, uiDefaults);
        uiDefaults = this.isUseScreenMenuBar() ? new Object[]{"CheckBoxMenuItem.checkIcon", Quaqua15JaguarLookAndFeel.makeButtonStateIcon("/ch/randelshofer/quaqua/images/CheckBoxMenuItem.icons.png", 6), "Menu.checkIcon", LookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/MenuItem.checkIcon.png"), "Menu.submenuPopupOffsetY", new Integer(-4), "MenuItem.checkIcon", LookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/MenuItem.checkIcon.png"), "PopupMenu.border", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaMenuBorder"), "RadioButtonMenuItem.checkIcon", Quaqua15JaguarLookAndFeel.makeButtonStateIcon("/ch/randelshofer/quaqua/images/RadioButtonMenuItem.icons.png", 6)} : new Object[]{"CheckBoxMenuItem.checkIcon", Quaqua15JaguarLookAndFeel.makeButtonStateIcon("/ch/randelshofer/quaqua/images/CheckBoxMenuItem.icons.png", 6), "CheckBoxMenuItem.border", new BorderUIResource.EmptyBorderUIResource(1, 1, 1, 1), "Menu.checkIcon", LookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/MenuItem.checkIcon.png"), "Menu.margin", new InsetsUIResource(0, 8, 0, 8), "Menu.menuPopupOffsetX", new Integer(0), "Menu.menuPopupOffsetY", new Integer(0), "Menu.submenuPopupOffsetX", new Integer(0), "Menu.submenuPopupOffsetY", new Integer(-4), "Menu.useMenuBarBackgroundForTopLevel", Boolean.TRUE, "Menu.border", new BorderUIResource.EmptyBorderUIResource(1, 1, 1, 1), "MenuBar.border", new BorderUIResource.MatteBorderUIResource(0, 0, 1, 0, new Color(128, 128, 128)), "MenuBar.margin", new InsetsUIResource(1, 8, 1, 8), "MenuBar.shadow", null, "MenuItem.checkIcon", LookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/MenuItem.checkIcon.png"), "MenuItem.border", new BorderUIResource.EmptyBorderUIResource(1, 1, 1, 1), "PopupMenu.border", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaMenuBorder"), "RadioButtonMenuItem.checkIcon", Quaqua15JaguarLookAndFeel.makeButtonStateIcon("/ch/randelshofer/quaqua/images/RadioButtonMenuItem.icons.png", 6), "RadioButtonMenuItem.border", new BorderUIResource.EmptyBorderUIResource(1, 1, 1, 1)};
        this.putDefaults(table, uiDefaults);
        uiDefaults = this.isJaguarTabbedPane() ? new Object[]{"TabbedPane.tabInsets", new InsetsUIResource(1, 10, 4, 9), "TabbedPane.selectedTabPadInsets", new InsetsUIResource(2, 2, 2, 1), "TabbedPane.tabAreaInsets", new InsetsUIResource(4, 16, 0, 16), "TabbedPane.contentBorderInsets", new InsetsUIResource(5, 6, 6, 6)} : new Object[]{"TabbedPane.background", new AlphaColorUIResource(0, 0, 0, 0)};
        this.putDefaults(table, uiDefaults);
    }

    protected void installKeyboardFocusManager() {
        try {
            KeyboardFocusManager.setCurrentKeyboardFocusManager(new Quaqua14KeyboardFocusManager());
        }
        catch (SecurityException ex) {
            System.err.print("Warning: " + this + " couldn't install QuaquaKeyboardFocusManager.");
        }
    }
}

