/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gtp;

import java.io.File;
import net.sf.gogui.go.ConstPointList;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.go.PointList;
import net.sf.gogui.gtp.AnalyzeDefinition;
import net.sf.gogui.gtp.AnalyzeType;

public class AnalyzeCommand {
    private final AnalyzeDefinition m_definition;
    private GoColor m_colorArg;
    private File m_fileArg;
    private File m_fileOpenArg;
    private File m_fileSaveArg;
    private String m_optStringArg;
    private String m_stringArg;
    private GoPoint m_pointArg;
    private PointList m_pointListArg = new PointList();

    public AnalyzeCommand(AnalyzeDefinition definition) {
        this.m_definition = definition;
    }

    public String getLabel() {
        return this.m_definition.getLabel();
    }

    public GoColor getColorArg() {
        return this.m_colorArg;
    }

    public GoPoint getPointArg() {
        return this.m_pointArg;
    }

    public PointList getPointListArg() {
        return this.m_pointListArg;
    }

    public AnalyzeType getType() {
        return this.m_definition.getType();
    }

    public String getResultTitle() {
        StringBuilder buffer = new StringBuilder(this.getLabel());
        if (this.needsColorArg() && this.m_colorArg != null) {
            if (this.m_colorArg == GoColor.BLACK) {
                buffer.append(" Black");
            } else {
                assert (this.m_colorArg == GoColor.WHITE);
                buffer.append(" White");
            }
        }
        if (this.needsPointArg() && this.m_pointArg != null) {
            buffer.append(' ');
            buffer.append(this.m_pointArg);
        } else if (this.needsPointListArg()) {
            for (GoPoint p : this.m_pointListArg) {
                buffer.append(' ');
                buffer.append(p);
            }
        }
        if (this.needsStringArg() && this.m_stringArg != null) {
            buffer.append(' ');
            buffer.append(this.m_stringArg);
        }
        return buffer.toString();
    }

    public boolean isPointArgMissing() {
        if (this.needsPointArg()) {
            return this.m_pointArg == null;
        }
        if (this.needsPointListArg()) {
            return this.m_pointListArg.isEmpty();
        }
        return false;
    }

    public boolean isTextType() {
        return this.m_definition.isTextType();
    }

    public boolean needsColorArg() {
        return this.m_definition.needsColorArg();
    }

    public boolean needsFileArg() {
        return this.m_definition.needsFileArg();
    }

    public boolean needsFileOpenArg() {
        return this.m_definition.needsFileOpenArg();
    }

    public boolean needsFileSaveArg() {
        return this.m_definition.needsFileSaveArg();
    }

    public boolean needsOnlyPointArg() {
        return this.m_definition.needsOnlyPointArg();
    }

    public boolean needsOnlyPointAndColorArg() {
        return this.m_definition.needsOnlyPointAndColorArg();
    }

    public boolean needsPointArg() {
        return this.m_definition.needsPointArg();
    }

    public boolean needsPointListArg() {
        return this.m_definition.needsPointListArg();
    }

    public boolean needsStringArg() {
        return this.m_definition.needsStringArg();
    }

    public boolean needsOptStringArg() {
        return this.m_definition.needsOptStringArg();
    }

    public String replaceWildCards(GoColor toMove) {
        String command = this.m_definition.getCommand();
        String toMoveString = toMove == GoColor.BLACK ? "b" : "w";
        String result = command.replace("%m", toMoveString);
        if (this.needsPointArg() && this.m_pointArg != null) {
            result = result.replace("%p", this.m_pointArg.toString());
        }
        if (this.needsPointListArg()) {
            String pointList = GoPoint.toString(this.m_pointListArg);
            result = this.getType() == AnalyzeType.EPLIST && this.m_pointListArg.size() > 0 ? result + ' ' + pointList : result.replace("%P", pointList);
        }
        if (this.needsFileArg()) {
            String fileArg = this.m_fileArg.toString();
            if (fileArg.indexOf(32) >= 0) {
                fileArg = "\"" + fileArg + "\"";
            }
            result = result.replace("%f", fileArg);
        }
        if (this.needsFileOpenArg()) {
            String fileOpenArg = this.m_fileOpenArg.toString();
            if (fileOpenArg.indexOf(32) >= 0) {
                fileOpenArg = "\"" + fileOpenArg + "\"";
            }
            result = result.replace("%r", fileOpenArg);
        }
        if (this.needsFileSaveArg()) {
            String fileSaveArg = this.m_fileSaveArg.toString();
            if (fileSaveArg.indexOf(32) >= 0) {
                fileSaveArg = "\"" + fileSaveArg + "\"";
            }
            result = result.replace("%w", fileSaveArg);
        }
        if (this.needsStringArg()) {
            assert (this.m_stringArg != null);
            result = result.replace("%s", this.m_stringArg);
        }
        if (this.needsOptStringArg()) {
            assert (this.m_optStringArg != null);
            result = result.replace("%o", this.m_optStringArg);
        }
        if (this.needsColorArg()) {
            String colorString = "empty";
            if (this.m_colorArg == GoColor.BLACK) {
                colorString = "b";
            } else if (this.m_colorArg == GoColor.WHITE) {
                colorString = "w";
            }
            result = result.replace("%c", colorString);
        }
        return result;
    }

    public void setColorArg(GoColor color) {
        assert (this.needsColorArg());
        this.m_colorArg = color;
    }

    public void setFileArg(File file) {
        assert (this.needsFileArg());
        this.m_fileArg = file;
    }

    public void setFileOpenArg(File file) {
        assert (this.needsFileOpenArg());
        this.m_fileOpenArg = file;
    }

    public void setFileSaveArg(File file) {
        assert (this.needsFileSaveArg());
        this.m_fileSaveArg = file;
    }

    public void setPointArg(GoPoint point) {
        this.m_pointArg = point;
    }

    public void setPointListArg(ConstPointList pointList) {
        this.m_pointListArg = new PointList(pointList);
    }

    public void setStringArg(String value) {
        assert (this.needsStringArg());
        this.m_stringArg = value;
    }

    public void setOptStringArg(String value) {
        assert (this.needsOptStringArg());
        this.m_optStringArg = value;
    }
}

