/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gtp;

import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.Scanner;
import net.sf.gogui.gtp.AnalyzeDefinition;
import net.sf.gogui.gtp.AnalyzeType;
import net.sf.gogui.gtp.ParameterType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnalyzeUtil {
    public static String getParameterCommand(String command, String key, String value) {
        return command + " " + key + " " + value;
    }

    public static boolean hasParameterCommands(ArrayList<AnalyzeDefinition> analyzeCommands) {
        for (AnalyzeDefinition definition : analyzeCommands) {
            if (definition.getType() != AnalyzeType.PARAM) continue;
            return true;
        }
        return false;
    }

    public static Result parseParameterLine(String line) {
        if ((line = line.trim()).startsWith("[") && line.endsWith("]")) {
            return null;
        }
        Scanner scanner = new Scanner(line);
        Result result = new Result();
        try {
            result.m_typeInfo = scanner.next("^\\[[^\\]]*\\]");
            line = line.substring(result.m_typeInfo.length()).trim();
            result.m_typeInfo = result.m_typeInfo.substring(1, result.m_typeInfo.length() - 1);
        }
        catch (NoSuchElementException e) {
            result.m_typeInfo = "string";
        }
        int pos = line.indexOf(32);
        if (pos < 0) {
            result.m_key = line.trim();
            result.m_value = "";
        } else {
            result.m_key = line.substring(0, pos).trim();
            result.m_value = line.substring(pos + 1).trim();
        }
        result.m_type = result.m_typeInfo.equals("bool") ? ParameterType.BOOL : (result.m_typeInfo.startsWith("list/") ? ParameterType.LIST : ParameterType.STRING);
        return result;
    }

    private AnalyzeUtil() {
    }

    public static final class Result {
        public ParameterType m_type;
        public String m_typeInfo;
        public String m_key;
        public String m_value;
    }
}

