/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gtp;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import net.sf.gogui.go.Move;
import net.sf.gogui.gtp.GtpClientBase;
import net.sf.gogui.gtp.GtpError;
import net.sf.gogui.util.ProcessUtil;
import net.sf.gogui.util.StringUtil;

public final class GtpClient
extends GtpClientBase {
    private InvalidResponseCallback m_invalidResponseCallback;
    private boolean m_autoNumber;
    private boolean m_anyCommandsResponded;
    private boolean m_isProgramDead;
    private boolean m_wasKilled;
    private final boolean m_log;
    private int m_commandNumber;
    private IOCallback m_callback;
    private PrintWriter m_out;
    private Process m_process;
    private String m_fullResponse;
    private String m_response;
    private String m_logPrefix;
    private final String m_program;
    private BlockingQueue<Message> m_queue;
    private TimeoutCallback m_timeoutCallback;
    private InputThread m_inputThread;
    private ErrorThread m_errorThread;

    public GtpClient(String program, File workingDirectory, boolean log, IOCallback callback) throws ExecFailed {
        if (workingDirectory != null && !workingDirectory.isDirectory()) {
            throw new ExecFailed(program, "Invalid working directory \"" + workingDirectory + "\"");
        }
        this.m_log = log;
        this.m_callback = callback;
        this.m_wasKilled = false;
        if (program.indexOf("%SRAND") >= 0) {
            int randMax = Short.MAX_VALUE;
            int rand = (int)(Math.random() * (double)(randMax + 1));
            program = program.replaceAll("%SRAND", Integer.toString(rand));
        }
        this.m_program = program;
        if (StringUtil.isEmpty(program)) {
            throw new ExecFailed(program, "Command for invoking Go program must be not empty.");
        }
        Runtime runtime = Runtime.getRuntime();
        try {
            File file;
            String[] cmdArray = StringUtil.splitArguments(program);
            if (cmdArray.length > 0 && (file = new File(cmdArray[0])).exists()) {
                cmdArray[0] = file.getAbsolutePath();
            }
            this.m_process = runtime.exec(cmdArray, null, workingDirectory);
        }
        catch (IOException e) {
            throw new ExecFailed(program, e);
        }
        this.init(this.m_process.getInputStream(), this.m_process.getOutputStream(), this.m_process.getErrorStream());
    }

    public GtpClient(InputStream in, OutputStream out, boolean log, IOCallback callback) throws GtpError {
        this.m_log = log;
        this.m_callback = callback;
        this.m_program = "-";
        this.m_process = null;
        this.init(in, out, null);
    }

    public void close() {
        this.m_out.close();
    }

    public void destroyProcess() {
        if (this.m_process != null) {
            this.m_wasKilled = true;
            this.m_process.destroy();
        }
    }

    public boolean getAnyCommandsResponded() {
        return this.m_anyCommandsResponded;
    }

    public String getResponse() {
        return this.m_response;
    }

    public String getFullResponse() {
        return this.m_fullResponse;
    }

    public String getProgramCommand() {
        return this.m_program;
    }

    public boolean isProgramDead() {
        return this.m_isProgramDead;
    }

    public String send(String command) throws GtpError {
        return this.send(command, -1L, null);
    }

    public void queryName(long timeout, TimeoutCallback timeoutCallback) throws GtpError {
        this.m_name = this.send("name", timeout, timeoutCallback);
    }

    public String send(String command, long timeout, TimeoutCallback timeoutCallback) throws GtpError {
        assert (!command.trim().equals(""));
        assert (!command.trim().startsWith("#"));
        this.m_timeoutCallback = timeoutCallback;
        this.m_fullResponse = "";
        this.m_response = "";
        ++this.m_commandNumber;
        if (this.m_autoNumber) {
            command = Integer.toString(this.m_commandNumber) + " " + command;
        }
        if (this.m_log) {
            this.logOut(command);
        }
        this.m_out.println(command);
        this.m_out.flush();
        try {
            if (this.m_out.checkError()) {
                this.throwProgramDied();
            }
            if (this.m_callback != null) {
                this.m_callback.sentCommand(command);
            }
            this.readResponse(timeout);
            return this.m_response;
        }
        catch (GtpError e) {
            e.setCommand(command);
            throw e;
        }
    }

    public void sendPlay(Move move, long timeout, TimeoutCallback timeoutCallback) throws GtpError {
        this.send(this.getCommandPlay(move), timeout, timeoutCallback);
    }

    public void sendComment(String comment) {
        assert (comment.trim().startsWith("#"));
        if (this.m_log) {
            this.logOut(comment);
        }
        if (this.m_callback != null) {
            this.m_callback.sentCommand(comment);
        }
        this.m_out.println(comment);
        this.m_out.flush();
    }

    public void setAutoNumber(boolean enable) {
        this.m_autoNumber = enable;
    }

    public void setInvalidResponseCallback(InvalidResponseCallback callback) {
        this.m_invalidResponseCallback = callback;
    }

    public void setIOCallback(IOCallback callback) {
        this.m_callback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogPrefix(String prefix) {
        GtpClient gtpClient = this;
        synchronized (gtpClient) {
            this.m_logPrefix = prefix;
        }
    }

    public void waitForExit() {
        if (this.m_process == null) {
            return;
        }
        try {
            this.m_process.waitFor();
            this.m_errorThread.join();
            this.m_inputThread.join();
        }
        catch (InterruptedException e) {
            this.printInterrupted();
        }
    }

    public void waitForExit(int timeout, TimeoutCallback timeoutCallback) {
        if (this.m_process == null) {
            return;
        }
        while (!ProcessUtil.waitForExit(this.m_process, timeout)) {
            if (timeoutCallback.askContinue()) continue;
            this.m_process.destroy();
            return;
        }
        try {
            this.m_errorThread.join(timeout);
            this.m_inputThread.join(timeout);
        }
        catch (InterruptedException e) {
            this.printInterrupted();
        }
    }

    public boolean wasKilled() {
        return this.m_wasKilled;
    }

    private void init(InputStream in, OutputStream out, InputStream err) {
        this.m_out = new PrintWriter(out);
        this.m_isProgramDead = false;
        this.m_queue = new ArrayBlockingQueue<Message>(10);
        this.m_inputThread = new InputThread(in, this.m_queue);
        if (err != null) {
            this.m_errorThread = new ErrorThread(err, this.m_queue);
            this.m_errorThread.start();
        }
        this.m_inputThread.start();
    }

    private synchronized void logError(String text) {
        System.err.print(text);
    }

    private synchronized void logIn(String msg) {
        if (this.m_logPrefix != null) {
            System.err.print(this.m_logPrefix);
        }
        System.err.print("<< ");
        System.err.println(msg);
    }

    private synchronized void logOut(String msg) {
        if (this.m_logPrefix != null) {
            System.err.print(this.m_logPrefix);
        }
        System.err.print(">> ");
        System.err.println(msg);
    }

    private void printInterrupted() {
        System.err.println("GtpClient: InterruptedException");
        Thread.dumpStack();
    }

    private String readResponse(long timeout) throws GtpError {
        Message message = this.waitForMessage(timeout);
        String response = message.m_text;
        if (response == null) {
            this.m_isProgramDead = true;
            this.throwProgramDied();
        }
        this.m_anyCommandsResponded = true;
        boolean error = response.charAt(0) != '=';
        this.m_fullResponse = response;
        if (this.m_callback != null) {
            this.m_callback.receivedResponse(error, this.m_fullResponse);
        }
        assert (response.length() >= 3);
        int index = response.indexOf(32);
        int length = response.length();
        this.m_response = index < 0 ? response.substring(1, length - 2) : response.substring(index + 1, length - 2);
        if (error) {
            throw new GtpError(this.m_response);
        }
        return this.m_response;
    }

    private void throwProgramDied() throws GtpError {
        this.m_isProgramDead = true;
        String name = this.m_name;
        if (name == null) {
            name = "The Go program";
        }
        if (this.m_wasKilled) {
            throw new GtpError(name + " terminated.");
        }
        throw new GtpError(name + " terminated unexpectedly.");
    }

    private Message waitForMessage(long timeout) throws GtpError {
        Message message = null;
        if (timeout < 0L) {
            try {
                message = this.m_queue.take();
            }
            catch (InterruptedException e) {
                this.printInterrupted();
                this.destroyProcess();
                this.throwProgramDied();
            }
        } else {
            message = null;
            while (message == null) {
                try {
                    message = this.m_queue.poll(timeout, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    this.printInterrupted();
                }
                if (message != null) continue;
                assert (this.m_timeoutCallback != null);
                if (this.m_timeoutCallback.askContinue()) continue;
                this.destroyProcess();
                this.throwProgramDied();
            }
        }
        return message;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ErrorThread
    extends Thread {
        private final Reader m_in;

        public ErrorThread(InputStream in, BlockingQueue<Message> queue) {
            this.m_in = new InputStreamReader(in);
            GtpClient.this.m_queue = queue;
        }

        @Override
        public void run() {
            try {
                char[] buffer = new char[4096];
                while (true) {
                    int n;
                    try {
                        n = this.m_in.read(buffer);
                    }
                    catch (IOException e) {
                        return;
                    }
                    if (n <= 0) {
                        return;
                    }
                    String text = new String(buffer, 0, n);
                    if (GtpClient.this.m_callback != null) {
                        GtpClient.this.m_callback.receivedStdErr(text);
                    }
                    if (!GtpClient.this.m_log) continue;
                    GtpClient.this.logError(text);
                }
            }
            catch (Throwable t) {
                StringUtil.printException(t);
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InputThread
    extends Thread {
        private final BufferedReader m_in;
        private final BlockingQueue<Message> m_queue;
        private final StringBuilder m_buffer = new StringBuilder(1024);

        InputThread(InputStream in, BlockingQueue<Message> queue) {
            this.m_in = new BufferedReader(new InputStreamReader(in));
            this.m_queue = queue;
        }

        @Override
        public void run() {
            try {
                this.mainLoop();
            }
            catch (Throwable t) {
                StringUtil.printException(t);
            }
        }

        private void appendBuffer(String line) {
            this.m_buffer.append(line);
            this.m_buffer.append('\n');
        }

        private boolean isResponseStart(String line) {
            if (line.length() < 1) {
                return false;
            }
            char c = line.charAt(0);
            return c == '=' || c == '?';
        }

        private void mainLoop() throws InterruptedException {
            while (true) {
                String line;
                if ((line = this.readLine()) == null) {
                    this.putMessage(null);
                    return;
                }
                this.appendBuffer(line);
                if (!this.isResponseStart(line)) {
                    if (!line.trim().equals("")) {
                        if (GtpClient.this.m_callback != null) {
                            GtpClient.this.m_callback.receivedInvalidResponse(line);
                        }
                        if (GtpClient.this.m_invalidResponseCallback != null) {
                            GtpClient.this.m_invalidResponseCallback.show(line);
                        }
                    }
                    this.m_buffer.setLength(0);
                    continue;
                }
                do {
                    line = this.readLine();
                    this.appendBuffer(line);
                    if (line != null) continue;
                    this.putMessage(null);
                    return;
                } while (!line.equals(""));
                this.putMessage();
            }
        }

        private void putMessage() {
            Thread.yield();
            this.putMessage(this.m_buffer.toString());
            this.m_buffer.setLength(0);
        }

        private void putMessage(String text) {
            try {
                this.m_queue.put(new Message(text));
            }
            catch (InterruptedException e) {
                GtpClient.this.printInterrupted();
            }
        }

        private String readLine() {
            try {
                String line = this.m_in.readLine();
                if (GtpClient.this.m_log && line != null) {
                    GtpClient.this.logIn(line);
                }
                return line;
            }
            catch (IOException e) {
                return null;
            }
        }
    }

    private static final class Message {
        public String m_text;

        public Message(String text) {
            this.m_text = text;
        }
    }

    public static interface IOCallback {
        public void receivedInvalidResponse(String var1);

        public void receivedResponse(boolean var1, String var2);

        public void receivedStdErr(String var1);

        public void sentCommand(String var1);
    }

    public static interface InvalidResponseCallback {
        public void show(String var1);
    }

    public static interface TimeoutCallback {
        public boolean askContinue();
    }

    public static class ExecFailed
    extends GtpError {
        public String m_program;

        public ExecFailed(String program, String message) {
            super(message);
            this.m_program = program;
        }

        public ExecFailed(String program, IOException e) {
            this(program, e.getMessage());
        }
    }
}

