/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.gogui.gui.Bookmark;
import net.sf.gogui.gui.I18n;
import net.sf.gogui.gui.MessageDialogs;
import net.sf.gogui.gui.ObjectListEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BookmarkEditor
implements ObjectListEditor.ItemEditor<Bookmark> {
    private JPanel m_panelLeft;
    private JPanel m_panelRight;
    private JTextField m_name;
    private JTextField m_file;
    private JTextField m_move;
    private JTextField m_variation;

    @Override
    public Bookmark editItem(Component parent, Bookmark object, MessageDialogs messageDialogs) {
        return this.editItem(parent, I18n.i18n("TIT_BOOKMARKEDITOR"), object, false, messageDialogs);
    }

    public Bookmark editItem(Component parent, String title, Bookmark bookmark, boolean selectName, MessageDialogs messageDialogs) {
        JPanel panel = new JPanel(new BorderLayout(2, 0));
        this.m_panelLeft = new JPanel(new GridLayout(0, 1, 0, 5));
        panel.add((Component)this.m_panelLeft, "West");
        this.m_panelRight = new JPanel(new GridLayout(0, 1, 0, 5));
        panel.add((Component)this.m_panelRight, "Center");
        this.m_name = this.createEntry("LB_BOOKMARKEDITOR_NAME", 25, bookmark.m_name);
        String file = "";
        if (bookmark.m_file != null) {
            file = bookmark.m_file.toString();
        }
        this.m_file = this.createEntry("LB_BOOKMARKEDITOR_FILE", 25, file);
        String move = "";
        if (bookmark.m_move > 0) {
            move = Integer.toString(bookmark.m_move);
        }
        this.m_move = this.createEntry("LB_BOOKMARKEDITOR_MOVE", 10, move);
        this.m_variation = this.createEntry("LB_BOOKMARKEDITOR_VARIATION", 10, bookmark.m_variation);
        JOptionPane optionPane = new JOptionPane(panel, -1, 2);
        JDialog dialog = optionPane.createDialog(parent, title);
        boolean done = false;
        while (!done) {
            if (selectName) {
                this.m_name.selectAll();
            }
            dialog.addWindowListener(new WindowAdapter(){

                public void windowActivated(WindowEvent e) {
                    BookmarkEditor.this.m_name.requestFocusInWindow();
                }
            });
            dialog.setVisible(true);
            Object value = optionPane.getValue();
            if (!(value instanceof Integer) || (Integer)value != 0) {
                return null;
            }
            done = this.validate(parent, messageDialogs);
        }
        String newName = this.m_name.getText().trim();
        File newFile = new File(this.m_file.getText());
        int newMove = this.getMove();
        String newVariation = this.m_variation.getText().trim();
        Bookmark newBookmark = new Bookmark(newName, newFile, newMove, newVariation);
        dialog.dispose();
        return newBookmark;
    }

    @Override
    public String getItemLabel(Bookmark object) {
        return object.m_name;
    }

    @Override
    public Bookmark cloneItem(Bookmark object) {
        return new Bookmark(object);
    }

    private JTextField createEntry(String labelText, int cols, String text) {
        Box boxLabel = Box.createHorizontalBox();
        boxLabel.add(Box.createHorizontalGlue());
        JLabel label = new JLabel(I18n.i18n(labelText));
        label.setAlignmentY(0.5f);
        boxLabel.add(label);
        this.m_panelLeft.add(boxLabel);
        JPanel fieldPanel = new JPanel(new FlowLayout(0, 0, 0));
        JTextField field = new JTextField(cols);
        field.setText(text);
        fieldPanel.add(field);
        this.m_panelRight.add(fieldPanel);
        return field;
    }

    private int getMove() {
        String text = this.m_move.getText().trim();
        if (text.equals("")) {
            return 0;
        }
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private boolean validate(Component parent, MessageDialogs messageDialogs) {
        if (this.m_name.getText().trim().equals("")) {
            messageDialogs.showError(parent, I18n.i18n("MSG_BOOKMARKEDITOR_EMPTYNAME"), I18n.i18n("MSG_BOOKMARKEDITOR_EMPTYNAME_2"), false);
            return false;
        }
        if (this.getMove() < 0) {
            messageDialogs.showError(parent, I18n.i18n("MSG_BOOKMARKEDITOR_INVALIDMOVE"), I18n.i18n("MSG_BOOKMARKEDITOR_INVALIDMOVE_2"), false);
            return false;
        }
        File file = new File(this.m_file.getText().trim());
        if (!file.exists()) {
            messageDialogs.showError(parent, I18n.i18n("MSG_BOOKMARKEDITOR_FILENOTEXIST"), I18n.i18n("MSG_BOOKMARKEDITOR_FILENOTEXIST_2"), false);
            return false;
        }
        return true;
    }
}

