/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.Border;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import net.sf.gogui.gui.I18n;
import net.sf.gogui.gui.MessageDialogs;
import net.sf.gogui.util.Platform;
import net.sf.gogui.util.ProgressShow;

public class GuiUtil {
    public static final int PAD = 5;
    public static final int SMALL_PAD = 2;
    private static final Font MONOSPACED_FONT;
    private static final Border EMPTY_BORDER;
    private static final Border SMALL_EMPTY_BORDER;
    private static final Dimension FILLER_DIMENSION;
    private static final Dimension SMALL_FILLER_DIMENSION;
    private static URL s_iconURL;

    public static void addStyle(JTextPane pane, String name, Color foreground, Color background) {
        StyledDocument doc = pane.getStyledDocument();
        StyleContext context = StyleContext.getDefaultStyleContext();
        Style defaultStyle = context.getStyle("default");
        Style style = doc.addStyle(name, defaultStyle);
        StyleConstants.setForeground(style, foreground);
        StyleConstants.setBackground(style, background);
    }

    public static void copyToClipboard(String text) {
        StringSelection selection = new StringSelection(text);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        ClipboardOwner owner = new ClipboardOwner(){

            public void lostOwnership(Clipboard clipboard, Transferable contents) {
            }
        };
        clipboard.setContents(selection, owner);
    }

    public static Object createComboBoxItem(final String item) {
        return new Object(){

            public String toString() {
                return item;
            }
        };
    }

    public static Border createEmptyBorder() {
        return EMPTY_BORDER;
    }

    public static Box.Filler createFiller() {
        return new Box.Filler(FILLER_DIMENSION, FILLER_DIMENSION, FILLER_DIMENSION);
    }

    public static Border createSmallEmptyBorder() {
        return SMALL_EMPTY_BORDER;
    }

    public static Box.Filler createSmallFiller() {
        return new Box.Filler(SMALL_FILLER_DIMENSION, SMALL_FILLER_DIMENSION, SMALL_FILLER_DIMENSION);
    }

    public static String getClipboardText() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable content = clipboard.getContents(null);
        if (content == null || !content.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            return null;
        }
        try {
            return (String)content.getTransferData(DataFlavor.stringFlavor);
        }
        catch (UnsupportedFlavorException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String getMessageCss() {
        if (Platform.isMac()) {
            return "<head><style type=\"text/css\">b { font: 13pt \"Lucida Grande\" }p { font: 11pt \"Lucida Grande\"; margin-top: 8px }</style></head>";
        }
        return "<head><style type=\"text/css\">p { margin-top: 8px }</style></head>";
    }

    public static int getDefaultMonoFontSize() {
        return MONOSPACED_FONT.getSize();
    }

    public static ImageIcon getIcon(String icon, String name) {
        String resource = "net/sf/gogui/images/" + icon + ".png";
        URL url = GuiUtil.class.getClassLoader().getResource(resource);
        return new ImageIcon(url, name);
    }

    public static void initLookAndFeel(String laf) {
        if (laf == null || !laf.equals("com.sun.java.swing.plaf.gtk.GTKLookAndFeel") && !laf.equals("gtk")) {
            UIManager.put("FileChooser.readOnly", Boolean.TRUE);
        }
        if ("".equals(laf) || "default".equals(laf)) {
            return;
        }
        boolean showError = true;
        if (laf == null) {
            showError = false;
            if (Platform.isWindows()) {
                laf = "system";
            } else if (Platform.isMac()) {
                laf = "quaqua";
            } else if (Platform.isUnix()) {
                laf = "system";
            } else {
                return;
            }
        }
        if ("cross".equals(laf)) {
            laf = UIManager.getCrossPlatformLookAndFeelClassName();
        } else if ("gtk".equals(laf)) {
            laf = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
        } else if ("motif".equals(laf)) {
            laf = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
        } else if ("quaqua".equals(laf)) {
            laf = "ch.randelshofer.quaqua.QuaquaLookAndFeel";
        } else if ("system".equals(laf)) {
            laf = UIManager.getSystemLookAndFeelClassName();
        } else if ("windows".equals(laf)) {
            laf = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
        }
        try {
            UIManager.setLookAndFeel(laf);
            if (laf.equals("ch.randelshofer.quaqua.QuaquaLookAndFeel")) {
                Object icon = LookAndFeel.makeIcon(GuiUtil.class, "gogui-64x64.png");
                UIManager.put("OptionPane.errorIcon", icon);
                UIManager.put("OptionPane.informationIcon", icon);
                UIManager.put("OptionPane.questionIcon", icon);
                UIManager.put("OptionPane.warningIcon", icon);
            }
        }
        catch (ClassNotFoundException e) {
            GuiUtil.handleLookAndFeelError(showError, laf);
        }
        catch (InstantiationException e) {
            GuiUtil.handleLookAndFeelError(showError, laf);
        }
        catch (IllegalAccessException e) {
            GuiUtil.handleLookAndFeelError(showError, laf);
        }
        catch (UnsupportedLookAndFeelException e) {
            GuiUtil.handleLookAndFeelError(showError, laf);
        }
    }

    public static String insertLineBreaks(String message) {
        int MAX_CHAR_PER_LINE = 72;
        int length = message.length();
        if (length < 72) {
            return message;
        }
        StringBuilder buffer = new StringBuilder();
        int startLine = 0;
        int lastWhiteSpace = -1;
        for (int pos = 0; pos < length; ++pos) {
            char c = message.charAt(pos);
            if (pos - startLine > 72) {
                int endLine;
                int n = endLine = lastWhiteSpace > startLine ? lastWhiteSpace : pos;
                if (buffer.length() > 0) {
                    buffer.append("<br>");
                }
                buffer.append(message.substring(startLine, endLine));
                startLine = endLine;
            }
            if (!Character.isWhitespace(c)) continue;
            lastWhiteSpace = pos;
        }
        if (buffer.length() > 0) {
            buffer.append("<br>");
        }
        buffer.append(message.substring(startLine));
        return buffer.toString();
    }

    public static void invokeAndWait(Runnable runnable) {
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (InterruptedException e) {
            System.err.println("Thread interrupted");
        }
        catch (InvocationTargetException e) {
            System.err.println("InvocationTargetException");
        }
    }

    public static boolean isActiveWindow(Window window) {
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        return manager.getActiveWindow() == window;
    }

    public static boolean isNormalSizeMode(JFrame window) {
        int mask;
        int state = window.getExtendedState();
        return (state & (mask = 7)) == 0;
    }

    public static void paintImmediately(JComponent component) {
        component.paintImmediately(component.getVisibleRect());
    }

    public static void removeKeyBinding(JComponent component, String key) {
        int condition = 1;
        InputMap inputMap = component.getInputMap(condition);
        inputMap.put(KeyStroke.getKeyStroke(key), new Object());
    }

    public static void runProgress(Frame owner, String message, ProgressRunnable runnable) throws Throwable {
        assert (SwingUtilities.isEventDispatchThread());
        JDialog dialog = new JDialog(owner, message, true);
        dialog.setDefaultCloseOperation(0);
        dialog.setResizable(false);
        JProgressBar progressBar = new JProgressBar(0, 100);
        progressBar.setStringPainted(true);
        JPanel panel = new JPanel();
        panel.setBorder(GuiUtil.createSmallEmptyBorder());
        panel.add(progressBar);
        dialog.getContentPane().add(panel);
        dialog.pack();
        dialog.setLocationRelativeTo(owner);
        ProgressThread thread = new ProgressThread(dialog, runnable, progressBar);
        thread.start();
        dialog.setVisible(true);
        if (thread.getThrowable() != null) {
            throw thread.getThrowable();
        }
    }

    public static void setAntiAlias(Graphics graphics) {
        if (graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
    }

    public static void setEditableFalse(JTextField field) {
        field.setEditable(false);
        field.setFocusable(false);
    }

    public static void setGoIcon(Frame frame) {
        URL url = s_iconURL;
        if (url != null) {
            frame.setIconImage(new ImageIcon(url).getImage());
        }
    }

    public static void setTextAndMnemonic(AbstractButton button, String text) {
        int pos = text.indexOf(38);
        text = text.replace("&", "");
        button.setText(text);
        if (pos >= 0 && pos < text.length()) {
            String mnemonic = text.substring(pos, pos + 1).toUpperCase();
            KeyStroke keyStroke = KeyStroke.getKeyStroke(mnemonic);
            int code = keyStroke.getKeyCode();
            button.setMnemonic(code);
            button.setDisplayedMnemonicIndex(pos);
        }
    }

    public static void setMacBevelButton(JButton button) {
        button.putClientProperty("Quaqua.Button.style", "bevel");
        button.putClientProperty("JButton.buttonType", "bevel");
    }

    public static void setMonospacedFont(JComponent component) {
        if (MONOSPACED_FONT != null) {
            component.setFont(MONOSPACED_FONT);
        }
    }

    public static void addStyle(JTextPane textPane, String name, Color foreground) {
        GuiUtil.addStyle(textPane, name, foreground, null, false);
    }

    public static void addStyle(JTextPane textPane, String name, Color foreground, Color background, boolean bold) {
        StyledDocument doc = textPane.getStyledDocument();
        StyleContext context = StyleContext.getDefaultStyleContext();
        Style def = context.getStyle("default");
        Style style = doc.addStyle(name, def);
        if (foreground != null) {
            StyleConstants.setForeground(style, foreground);
        }
        if (background != null) {
            StyleConstants.setBackground(style, background);
        }
        StyleConstants.setBold(style, bold);
    }

    public static void setStyle(JTextPane textPane, int start, int length, String name) {
        Style style;
        StyledDocument doc = textPane.getStyledDocument();
        if (name == null) {
            StyleContext context = StyleContext.getDefaultStyleContext();
            style = context.getStyle("default");
        } else {
            style = doc.getStyle(name);
        }
        doc.setCharacterAttributes(start, length, style, true);
    }

    public static void setUnlimitedSize(JComponent component) {
        Dimension size = new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
        component.setMaximumSize(size);
    }

    private static void handleLookAndFeelError(boolean showError, String laf) {
        if (!showError) {
            return;
        }
        MessageDialogs messageDialogs = new MessageDialogs();
        messageDialogs.showWarning(null, I18n.i18n("MSG_LAF_ERROR"), MessageFormat.format(I18n.i18n("MSG_LAF_ERROR_2"), laf), false);
    }

    static {
        ClassLoader loader = ClassLoader.getSystemClassLoader();
        s_iconURL = loader.getResource("net/sf/gogui/images/gogui-48x48-notrans.png");
        MONOSPACED_FONT = Font.decode("Monospaced");
        EMPTY_BORDER = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        SMALL_EMPTY_BORDER = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        FILLER_DIMENSION = new Dimension(5, 5);
        SMALL_FILLER_DIMENSION = new Dimension(2, 2);
    }

    private static class ProgressThread
    extends Thread
    implements ProgressShow {
        private int m_percent;
        private final Dialog m_dialog;
        private final JProgressBar m_progressBar;
        private final ProgressRunnable m_runnable;
        private Throwable m_throwable;

        public ProgressThread(Dialog dialog, ProgressRunnable runnable, JProgressBar progressBar) {
            this.m_dialog = dialog;
            this.m_runnable = runnable;
            this.m_progressBar = progressBar;
        }

        public Throwable getThrowable() {
            return this.m_throwable;
        }

        public void run() {
            block5: {
                long startTime = System.currentTimeMillis();
                try {
                    this.m_runnable.run(this);
                }
                catch (Throwable t) {
                    this.m_throwable = t;
                }
                long timeDiff = System.currentTimeMillis() - startTime;
                if (timeDiff < 1000L) {
                    try {
                        Thread.sleep(1000L - timeDiff);
                    }
                    catch (InterruptedException e) {
                        if ($assertionsDisabled) break block5;
                        throw new AssertionError();
                    }
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProgressThread.this.m_dialog.dispose();
                }
            });
        }

        public void showProgress(int percent) {
            this.m_percent = percent;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProgressThread.this.m_progressBar.setValue(ProgressThread.this.m_percent);
                }
            });
        }
    }

    public static interface ProgressRunnable {
        public void run(ProgressShow var1) throws Throwable;
    }
}

